/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class DistributionChangePlugin
extends AbstractFormPlugin {
    private static final String OP_DOCONFIRM = "doconfirm";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        String parentViewType = (String)frmShowParameter.getCustomParam("parentformtype");
        String entityNumber = (String)frmShowParameter.getCustomParam("EntityNumber");
        DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = docEntry.getDynamicObjectType().getProperties();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(0);
        if (!StringUtils.equals((CharSequence)parentViewType, (CharSequence)"1")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("salesorderdelivery");
            if (entryGrid == null) {
                return;
            }
            int[] rowIndexes = entryGrid.getSelectRows();
            if (rowIndexes.length == 0) {
                return;
            }
            long id = CommonUtil.formatObejctToLong((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue());
            String billNo = (String)this.getView().getParentView().getModel().getValue("billno");
            DynamicObject doSaleOrg = (DynamicObject)this.getView().getParentView().getModel().getValue("bizorgid");
            DynamicObject doSaleBranch = (DynamicObject)this.getView().getParentView().getModel().getValue("salebranchid");
            Date bizDate = (Date)this.getView().getParentView().getModel().getValue("bizdate");
            for (int rowIndex : rowIndexes) {
                DynamicObject data = this.getView().getParentView().getModel().getEntryRowEntity("salesorderdelivery", rowIndex);
                DynamicObject doParent = (DynamicObject)data.getParent();
                DynamicObject doAuxAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)doParent, (String)"auxattrid");
                long billEntryId = DynamicObjectUtils.getPkValue((DynamicObject)doParent);
                long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)doParent, (String)"oversalepolicyid");
                long overSalePolicyEntryId = DynamicObjectUtils.getLong((DynamicObject)doParent, (String)"oversalepolicyentryid");
                HashMap<String, Long> map = new HashMap<String, Long>(0);
                map.put("deliverymodeid", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverymode"));
                map.put("deliverystatusid", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverystatus"));
                params.add(map);
                this.setFieldValue(id, billNo, properties, docEntry, data, bizDate, doSaleOrg, doSaleBranch, doAuxAttr, overSalePolicyId, overSalePolicyEntryId, billEntryId);
            }
        } else {
            Object detailIds = frmShowParameter.getCustomParam("subEntryPrimaryKeyValue");
            if (detailIds instanceof JSONArray) {
                ArrayList<Object> lstDetailId = new ArrayList<Object>(0);
                JSONArray arrayDetailId = (JSONArray)detailIds;
                lstDetailId.addAll((Collection<Object>)arrayDetailId);
                if (lstDetailId.size() == 0) {
                    return;
                }
                DynamicObject[] delivery = this.queryDelivery(lstDetailId, entityNumber);
                if (delivery.length == 0) {
                    return;
                }
                for (DynamicObject dataItem : delivery) {
                    DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataItem, (String)"goodsentryentity");
                    if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) continue;
                    for (DynamicObject doGoodsEntry : docGoodsEntry) {
                        this.setFieldValue(lstDetailId, dataItem, doGoodsEntry, docEntry, properties, params);
                    }
                }
            }
        }
        this.setEntryControl(params, docEntry);
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)frmShowParameter.getCustomParam("EntityNumber");
        if (StringUtils.equals((CharSequence)OP_DOCONFIRM, (CharSequence)operate.getOperateKey())) {
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) {
                args.setCancel(true);
                args.setCancelMessage("\u914d\u9001\u8c03\u6574\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return;
            }
            for (int i = 0; i < docEntry.getRowCount(); ++i) {
                String bizDateStr;
                boolean isDelivery;
                DynamicObject data = (DynamicObject)docEntry.get(i);
                String seq = DynamicObjectUtils.getString((DynamicObject)data, (String)"seq");
                boolean isNegativeSell = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"deliveryisnegativesell");
                String deliveryTimeFormat = "";
                Date deliveryTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"deliverdeliverytime");
                if (deliveryTime != null) {
                    deliveryTimeFormat = DateUtil.getDateFormat((Date)deliveryTime, (String)"yyyy-MM-dd");
                }
                String newDeliveryTimeFormat = "";
                Date newDeliveryTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"newdeliverytime");
                if (newDeliveryTime != null) {
                    newDeliveryTimeFormat = DateUtil.getDateFormat((Date)newDeliveryTime, (String)"yyyy-MM-dd");
                }
                if (isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"deliverisdelivery")) {
                    if (StringUtils.isEmpty((CharSequence)newDeliveryTimeFormat)) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u914d\u9001\u65f6\u95f4", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    Object newDistrictId = DynamicObjectUtils.get((DynamicObject)data, (String)"newdistrictid");
                    if (newDistrictId == null) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u914d\u9001\u533a\u57df", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    String newAddress = DynamicObjectUtils.getString((DynamicObject)data, (String)"newaddress");
                    if (StringUtils.isEmpty((CharSequence)newAddress)) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u8be6\u7ec6\u5730\u5740", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    String newFullAddress = DynamicObjectUtils.getString((DynamicObject)data, (String)"newfulladdress");
                    if (StringUtils.isEmpty((CharSequence)newFullAddress)) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u5b8c\u6574\u5730\u5740", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    String newConsignee = DynamicObjectUtils.getString((DynamicObject)data, (String)"newconsignee");
                    if (StringUtils.isEmpty((CharSequence)newConsignee)) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u6536\u8d27\u4eba", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    String newPhoneNumber = DynamicObjectUtils.getString((DynamicObject)data, (String)"newphonenumber");
                    if (StringUtils.isEmpty((CharSequence)newPhoneNumber)) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u624b\u673a\u53f7", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                }
                boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"deliverisinstall");
                Date newInstallTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"newinstalltime");
                if (isInstall && newInstallTime == null) {
                    args.setCancel(true);
                    String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8bf7\u7ef4\u62a4\u65b0\u5b89\u88c5\u65f6\u95f4", seq);
                    args.setCancelMessage(message);
                    this.getView().showErrorNotification(message);
                    return;
                }
                String installTimeStr = "";
                if (newInstallTime != null) {
                    installTimeStr = DateUtil.getDateFormat((Date)newInstallTime, (String)"yyyy-MM-dd");
                }
                if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"ocpos_saleorder")) {
                    if (!StringUtils.isEmpty((CharSequence)installTimeStr) && !StringUtils.isEmpty((CharSequence)newDeliveryTimeFormat) && newDeliveryTimeFormat.compareTo(installTimeStr) > 0) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b89\u88c5\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u914d\u9001\u65f6\u95f4", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    Date bizDate = DynamicObjectUtils.getDate((DynamicObject)data, (String)"bizdate");
                    if (bizDate != null && !StringUtils.isEmpty((CharSequence)newDeliveryTimeFormat) && (bizDateStr = DateUtil.getDateFormat((Date)bizDate, (String)"yyyy-MM-dd")).compareTo(newDeliveryTimeFormat) > 0) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u914d\u9001\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u5355\u65f6\u95f4", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                } else if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"ocpos_saleorder_return")) {
                    if (!StringUtils.isEmpty((CharSequence)installTimeStr) && !StringUtils.isEmpty((CharSequence)newDeliveryTimeFormat) && newDeliveryTimeFormat.compareTo(installTimeStr) < 0) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b89\u88c5\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u914d\u9001\u65f6\u95f4", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                    Date nowDate = TimeServiceHelper.now();
                    if (nowDate != null && !StringUtils.isEmpty((CharSequence)newDeliveryTimeFormat) && (bizDateStr = DateUtil.getDateFormat((Date)nowDate, (String)"yyyy-MM-dd")).compareTo(newDeliveryTimeFormat) > 0) {
                        args.setCancel(true);
                        String message = String.format("\u8ba2\u5355\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\uff0c\u914d\u9001\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4", seq);
                        args.setCancelMessage(message);
                        this.getView().showErrorNotification(message);
                        return;
                    }
                }
                if (isNegativeSell && deliveryTimeFormat.compareTo(newDeliveryTimeFormat) != 0) {
                    String exparrDateFormat;
                    Date exparrDate;
                    long itemId;
                    long overSalePolicyEntryId;
                    long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"oversalepolicyid");
                    DynamicObject overSalePolicy = this.querySingleOverSalePolicy(overSalePolicyId, overSalePolicyEntryId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"oversalepolicyentryid"), itemId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"delivergoodsid"));
                    if (overSalePolicy != null && (exparrDate = DynamicObjectUtils.getDate((DynamicObject)overSalePolicy, (String)"policyentity.exparrdate")) != null && newDeliveryTimeFormat.compareTo(exparrDateFormat = DateUtil.getDateFormat((Date)exparrDate, (String)"yyyy-MM-dd")) >= 0) {
                        return;
                    }
                    List<JSONObject> overSaleParams = this.getOverSaleParams(data, i);
                    HashMap deliveryInfo = new HashMap(0);
                    List overSaleData = SaleOrderDeliveryInfoHelper.getOverSaleData(overSaleParams);
                    if (!CollectionUtils.isEmpty((Collection)overSaleData)) {
                        Object objDelivery;
                        HashMap result;
                        Date date;
                        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"deliversaleqty");
                        boolean isOverSale = SaleOrderDeliveryInfoHelper.matchingOverSalePolicy((List)overSaleData, deliveryInfo, (BigDecimal)saleQty, (Date)(date = DynamicObjectUtils.getDate((DynamicObject)data, (String)"newdeliverytime")), (String)"1", result = new HashMap(3));
                        if (isOverSale) continue;
                        isOverSale = SaleOrderDeliveryInfoHelper.matchingOverSalePolicy((List)overSaleData, deliveryInfo, (BigDecimal)saleQty, (Date)date, (String)"2", result);
                        if (!isOverSale) {
                            args.setCancel(true);
                            String message = "\u672a\u5339\u914d\u5230\u5546\u54c1\u8d1f\u5356\u653f\u7b56\uff0c\u8bf7\u7ef4\u62a4\u8d1f\u5356\u653f\u7b56\u3002";
                            args.setCancelMessage(message);
                            NotificationUtil.showDefaultTipNotify((String)message, (IFormView)this.getView());
                        }
                        if ((objDelivery = result.getOrDefault("deliveryData", null)) != null) {
                            Map deliveryData = objDelivery;
                            Long newOverSalePolicyId = deliveryData.getOrDefault("oversalepolicyid", 0L);
                            Long newOverSalePolicyEntryId = deliveryData.getOrDefault("oversalepolicyentryid", 0L);
                            this.getView().getModel().setValue("newoversalepolicyid", (Object)newOverSalePolicyId, i);
                            this.getView().getModel().setValue("newoversalepolicyentryid", (Object)newOverSalePolicyEntryId, i);
                        }
                        return;
                    }
                    args.setCancel(true);
                    String message = "\u672a\u5339\u914d\u5230\u5546\u54c1\u8d1f\u5356\u653f\u7b56\uff0c\u8bf7\u7ef4\u62a4\u8d1f\u5356\u653f\u7b56\u3002";
                    args.setCancelMessage(message);
                    NotificationUtil.showDefaultTipNotify((String)message, (IFormView)this.getView());
                    return;
                }
                if (!isDelivery) continue;
                Map<String, Object> params = this.getDeliveryParams(data, i);
                List distRulesParams = SaleOrderDeliveryInfoHelper.getDistributionRuleParams(params);
                List distributionRules = SaleOrderDeliveryInfoHelper.getDistributionRules((List)distRulesParams);
                if (CollectionUtils.isEmpty((Collection)distributionRules)) {
                    args.setCancel(true);
                    String message = String.format("\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\u5f53\u524d\u5730\u5740\u8d85\u51fa\u914d\u9001\u8303\u56f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u9001\u8c03\u6574\u3002", seq);
                    args.setCancelMessage(message);
                    NotificationUtil.showDefaultTipNotify((String)message, (IFormView)this.getView());
                    return;
                }
                long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"inventoryorgid");
                long wareHouseId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"erpstockid");
                boolean isExist = distributionRules.stream().noneMatch(x -> x.getLongValue("stockOrgId") == invOrgId && x.getLongValue("warehouseId") == wareHouseId);
                if (!isExist) continue;
                args.setCancel(true);
                String message = String.format("\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\u5f53\u524d\u5730\u5740\u8d85\u51fa\u914d\u9001\u8303\u56f4\uff0c\u65e0\u6cd5\u8fdb\u884c\u914d\u9001\u8c03\u6574\u3002", seq);
                args.setCancelMessage(message);
                NotificationUtil.showDefaultTipNotify((String)message, (IFormView)this.getView());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equals((CharSequence)key, (CharSequence)OP_DOCONFIRM) && result != null && result.isSuccess()) {
            FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
            String parentViewType = (String)frmShowParameter.getCustomParam("parentformtype");
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (StringUtils.equals((CharSequence)parentViewType, (CharSequence)"1")) {
                this.saveDeliveryToList(docEntry);
            } else {
                this.saveDeliveryToForm(docEntry);
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (CommonUtil.checkChanged((ChangeData)changeData[0])) {
            return;
        }
        DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)docEntry)) {
            return;
        }
        int rowIndex = changeData[0].getRowIndex();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"newdistrictid") || StringUtils.equals((CharSequence)key, (CharSequence)"newaddress")) {
            String address = (String)this.getModel().getValue("newaddress", rowIndex);
            String adminDivisionId = (String)this.getModel().getValue("newdistrictid", rowIndex);
            if (StringUtils.isNotBlank((CharSequence)adminDivisionId) && !StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0")) {
                DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)adminDivisionId, (String)"bd_admindivision");
                String fullName = DynamicObjectUtils.getString((DynamicObject)adminDivision, (String)"fullname");
                String fullAddress = "";
                if (StringUtils.isNotBlank((CharSequence)fullName)) {
                    fullAddress = fullName.replaceAll("_", "") + address;
                }
                this.getModel().setValue("newfulladdress", (Object)fullAddress, rowIndex);
                DynamicObject data = (DynamicObject)docEntry.get(rowIndex);
                String seq = DynamicObjectUtils.getString((DynamicObject)data, (String)"seq");
                Map<String, Object> params = this.getDeliveryParams(data, rowIndex);
                List distRulesParams = SaleOrderDeliveryInfoHelper.getDistributionRuleParams(params);
                List distributionRules = SaleOrderDeliveryInfoHelper.getDistributionRules((List)distRulesParams);
                if (CollectionUtils.isEmpty((Collection)distributionRules)) {
                    NotificationUtil.showDefaultTipNotify((String)String.format("\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\u5f53\u524d\u5730\u5740\u8d85\u51fa\u914d\u9001\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u914d\u9001\u5730\u5740\u3002", seq), (IFormView)this.getView());
                    return;
                }
                long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"inventoryorgid");
                long wareHouseId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"erpstockid");
                List lstRule = distributionRules.stream().filter(x -> x.getLongValue("stockOrgId") == invOrgId && x.getLongValue("warehouseId") == wareHouseId).collect(Collectors.toList());
                if (lstRule.size() == 0) {
                    NotificationUtil.showDefaultTipNotify((String)String.format("\u914d\u9001\u660e\u7ec6\u7b2c%s\u884c\u5f53\u524d\u5730\u5740\u8d85\u51fa\u914d\u9001\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u914d\u9001\u5730\u5740\u3002", seq), (IFormView)this.getView());
                    return;
                }
                lstRule.sort(Comparator.comparingInt(o -> o.getIntValue("priority")));
                JSONObject rule = (JSONObject)lstRule.get(0);
                if (rule != null) {
                    long distributionModelId = rule.getLongValue("distributionModeId");
                    this.getModel().setItemValueByID("newdeliverymode", (Object)distributionModelId, rowIndex);
                }
            }
        }
    }

    public void setEntryControl(List<Map<String, Object>> params, DynamicObjectCollection docEntry) {
        if (params == null || params.size() == 0) {
            return;
        }
        List returnRules = SaleOrderReturnRuleHelper.matchReturnRule(params);
        if (CollectionUtils.isEmpty((Collection)returnRules)) {
            return;
        }
        for (int i = 0; i < docEntry.size(); ++i) {
            long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docEntry.get(i)), (String)"deliverymode");
            long deliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docEntry.get(i)), (String)"deliverystatus");
            String signStatus = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)docEntry.get(i)), (String)"signstatus");
            boolean isSign = StringUtils.equals((CharSequence)signStatus, (CharSequence)"D");
            Map returnRule = returnRules.stream().filter(x -> CommonUtil.formatObejctToLong(x.get("distributionmode")) == deliveryModeId && CommonUtil.formatObejctToLong(x.get("deliverstates")) == deliveryStatusId).findFirst().orElse(null);
            if (returnRule == null) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdeliverytime"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newinstalltime"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdistrictid"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newaddress"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newfulladdress"});
                continue;
            }
            boolean isChangeAppoint = CommonUtil.formatObjectToBoolean(returnRule.get("ischangeappoint"));
            boolean isChangeAddr = CommonUtil.formatObjectToBoolean(returnRule.get("ischangeaddr"));
            if (isChangeAppoint) {
                if (!isSign) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"newdeliverytime"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdeliverytime"});
                }
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"newinstalltime"});
            } else {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdeliverytime"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newinstalltime"});
            }
            if (isChangeAddr) {
                if (!isSign) {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"newdistrictid"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"newaddress"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"newfulladdress"});
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdistrictid"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newaddress"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"newfulladdress"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"newdistrictid"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"newaddress"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"newfulladdress"});
        }
    }

    private Map<String, Object> getDeliveryParams(DynamicObject data, int rowIndex) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        params.put("index", rowIndex);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"salebranchid");
        params.put("saleOrgId", DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg"));
        params.put("saleChannelID", DynamicObjectUtils.getPkValue((DynamicObject)branch));
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"delivergoodsid");
        params.put("itemId", DynamicObjectUtils.getPkValue((DynamicObject)goods));
        params.put("adminDivisionId", DynamicObjectUtils.getString((DynamicObject)data, (String)"newdistrictid"));
        params.put("materialId", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverymaterial"));
        params.put("baseUnitID", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverybaseunit"));
        params.put("baseUnitQty", DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"deliverybaseunitqty"));
        params.put("unitId", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverunitid"));
        params.put("unitQty", DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"deliversaleqty"));
        params.put("deliveryDate", DynamicObjectUtils.getDate((DynamicObject)data, (String)"newdeliverytime"));
        params.put("auxPtyID", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"auxattrid"));
        params.put("bizdate", DynamicObjectUtils.getDate((DynamicObject)data, (String)"bizdate"));
        return params;
    }

    private List<JSONObject> getOverSaleParams(DynamicObject data, int rowIndex) {
        ArrayList<JSONObject> overSaleParams = new ArrayList<JSONObject>(0);
        Date date = DynamicObjectUtils.getDate((DynamicObject)data, (String)"newdeliverytime");
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        zonedDateTime = zonedDateTime.plus(Period.of(5000, 3, 8));
        JSONObject overSaleParam = new JSONObject();
        overSaleParam.put("saleOrgId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"bizorgid"));
        overSaleParam.put("saleChannelID", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"salebranchid"));
        overSaleParam.put("itemId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"delivergoodsid"));
        overSaleParam.put("materialId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverymaterial"));
        overSaleParam.put("baseUnitID", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverybaseunit"));
        overSaleParam.put("baseUnitQty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"deliverybaseunitqty"));
        overSaleParam.put("unitId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverunitid"));
        overSaleParam.put("unitQty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"deliversaleqty"));
        overSaleParam.put("distributionModeId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverymode"));
        overSaleParam.put("deliveryDate", (Object)Date.from(zonedDateTime.toInstant()));
        overSaleParam.put("bizdate", DynamicObjectUtils.get((DynamicObject)data, (String)"bizdate"));
        overSaleParam.put("stockOrgId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"inventoryorgid"));
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"erpstockid");
        long channelStockId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverstockid");
        if (stockId != 0L) {
            overSaleParam.put("stockId", (Object)stockId);
        } else {
            overSaleParam.put("stockId", (Object)channelStockId);
        }
        overSaleParam.put("invtypeid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverystocktype"));
        overSaleParam.put("customerKey", (Object)rowIndex);
        overSaleParams.add(overSaleParam);
        return overSaleParams;
    }

    private void saveDeliveryToForm(DynamicObjectCollection docEntry) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl("salesorderdelivery");
        if (entryGrid == null) {
            return;
        }
        int[] rowIndexes = entryGrid.getSelectRows();
        if (rowIndexes.length == 0) {
            return;
        }
        ArrayList<DynamicObject> lstChangeRecord = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstDelivery = new ArrayList<DynamicObject>(0);
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        for (int rowIndex : rowIndexes) {
            DynamicObject doEntry;
            long id;
            DynamicObject doGoodsEntry;
            DynamicObject subItem = this.getView().getParentView().getModel().getEntryRowEntity("salesorderdelivery", rowIndex);
            if (subItem == null || (doGoodsEntry = (DynamicObject)subItem.getParent()) == null || (id = DynamicObjectUtils.getPkValue((DynamicObject)subItem)) == 0L || (doEntry = (DynamicObject)docEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"deliverydetailid") == id).findFirst().orElse(null)) == null) continue;
            this.insertOrderChangeRecord(lstChangeRecord, dataEntity, doEntry, subItem);
            this.updateDeliveryInfo(subItem, doEntry);
            lstDelivery.add(subItem);
        }
        if (!CollectionUtils.isEmpty(lstDelivery)) {
            SaveServiceHelper.update((DynamicObject[])lstDelivery.toArray(new DynamicObject[0]));
            this.updateRetailDeliveryInfo(lstDelivery);
        }
        this.getView().returnDataToParent(lstChangeRecord);
        this.getView().getParentView().updateView("salesorderdelivery");
    }

    private void saveDeliveryToList(DynamicObjectCollection docEntry) {
        List<Object> lstDetailIds = docEntry.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"deliverydetailid")).collect(Collectors.toList());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("EntityNumber");
        if (lstDetailIds.size() > 0) {
            DynamicObject[] docDelivery = this.queryDelivery(lstDetailIds, entityNumber);
            if (docDelivery == null || docDelivery.length == 0) {
                return;
            }
            ArrayList<DynamicObject> lstChangeRecord = new ArrayList<DynamicObject>(0);
            ArrayList<DynamicObject> lstDelivery = new ArrayList<DynamicObject>(0);
            for (DynamicObject delivery : docDelivery) {
                DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)delivery, (String)"goodsentryentity");
                if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) continue;
                for (DynamicObject doGoodsEntry : docGoodsEntry) {
                    DynamicObjectCollection docSubEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderdelivery");
                    if (CollectionUtils.isEmpty((Collection)docSubEntry)) continue;
                    for (DynamicObject doSubEntry : docSubEntry) {
                        long id = DynamicObjectUtils.getPkValue((DynamicObject)doSubEntry);
                        DynamicObject doEntry = docEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == id).findFirst().orElse(null);
                        if (doEntry == null || lstDelivery.contains(doSubEntry)) continue;
                        this.insertOrderChangeRecord(lstChangeRecord, delivery, doEntry, doSubEntry);
                        this.updateDeliveryInfo(doSubEntry, doEntry);
                        lstDelivery.add(doSubEntry);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(lstDelivery)) {
                SaveServiceHelper.update((DynamicObject[])lstDelivery.toArray(new DynamicObject[0]));
                this.updateRetailDeliveryInfo(lstDelivery);
                this.getView().returnDataToParent(lstChangeRecord);
            }
        }
    }

    public void updateDeliveryInfo(DynamicObject subItem, DynamicObject doEntry) {
        subItem.set("deliverymode", doEntry.get("newdeliverymode"));
        subItem.set("deliverdeliverytime", doEntry.get("newdeliverytime"));
        subItem.set("districtid", doEntry.get("newdistrictid"));
        subItem.set("address", doEntry.get("newaddress"));
        subItem.set("fulladdress", doEntry.get("newfulladdress"));
        subItem.set("deliverinstalltime", doEntry.get("newinstalltime"));
        subItem.set("consignee", doEntry.get("newconsignee"));
        subItem.set("deliverphonenumber", doEntry.get("newphonenumber"));
    }

    private void updateRetailDeliveryInfo(List<DynamicObject> lstDelivery) {
        List<Object> lstDetailId = lstDelivery.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] deliveryData = this.queryRetailDelivery(lstDetailId);
        if (deliveryData == null || deliveryData.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> lstData = new ArrayList<DynamicObject>(0);
        for (DynamicObject data : deliveryData) {
            DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)data, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) continue;
            for (DynamicObject entry : docEntry) {
                DynamicObjectCollection docSubItem = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)"ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)docSubItem)) continue;
                for (DynamicObject subItem : docSubItem) {
                    long srcDeliveryEntryId = DynamicObjectUtils.getLong((DynamicObject)subItem, (String)"srcdeliveryentryid");
                    DynamicObject dataItem = lstDelivery.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcDeliveryEntryId).findFirst().orElse(null);
                    if (dataItem == null) continue;
                    subItem.set("deliverymode", dataItem.get("deliverymode"));
                    subItem.set("deliverytime", dataItem.get("deliverdeliverytime"));
                    subItem.set("districtid", dataItem.get("districtid"));
                    subItem.set("detailaddress", dataItem.get("address"));
                    subItem.set("fulladdress", dataItem.get("fulladdress"));
                    subItem.set("installtime", dataItem.get("deliverinstalltime"));
                    subItem.set("consignee", dataItem.get("consignee"));
                    subItem.set("deliverphonenumber", dataItem.get("deliverphonenumber"));
                    lstData.add(subItem);
                }
            }
        }
        if (!CollectionUtils.isEmpty(lstData)) {
            SaveServiceHelper.update((DynamicObject[])lstData.toArray(new DynamicObject[0]));
            this.updateDeliveryOrderEntry(lstData);
        }
    }

    private void updateDeliveryOrderEntry(List<DynamicObject> lstData) {
        List<Object> lstDetailId = lstData.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] deliveryData = this.queryDeliveryOrderEntry(lstDetailId);
        if (deliveryData == null || deliveryData.length <= 0) {
            return;
        }
        ArrayList<DynamicObject> lstOrderData = new ArrayList<DynamicObject>(0);
        for (DynamicObject data : deliveryData) {
            DynamicObjectCollection docEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)data, (String)"entryentity");
            if (CollectionUtils.isEmpty((Collection)docEntry)) continue;
            DynamicObject dataBill = null;
            for (DynamicObject entry : docEntry) {
                long srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)entry, (String)"srcbillentryid");
                DynamicObject dataItem = lstData.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
                if (dataItem == null) continue;
                dataBill = dataItem;
                entry.set("installdate", dataItem.get("installtime"));
                entry.set("datefield", dataItem.get("deliverytime"));
            }
            if (dataBill != null) {
                data.set("distributionmode", dataBill.get("deliverymode"));
                data.set("address", dataBill.get("districtid"));
                data.set("detailaddress", dataBill.get("detailaddress"));
                data.set("alladdress", dataBill.get("fulladdress"));
                data.set("consignee", dataBill.get("consignee"));
                data.set("consigneephone", dataBill.get("deliverphonenumber"));
            }
            lstOrderData.add(data);
        }
        if (!CollectionUtils.isEmpty(lstOrderData)) {
            SaveServiceHelper.update((DynamicObject[])lstOrderData.toArray(new DynamicObject[0]));
        }
    }

    public void setFieldValue(List<Object> lstDetailId, DynamicObject dataItem, DynamicObject doGoodsEntry, DynamicObjectCollection docEntry, DataEntityPropertyCollection properties, List<Map<String, Object>> params) {
        DynamicObjectCollection docSubEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderdelivery");
        if (CollectionUtils.isEmpty((Collection)docSubEntry)) {
            return;
        }
        long id = DynamicObjectUtils.getLong((DynamicObject)dataItem, (String)"id");
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataItem, (String)"billno");
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataItem, (String)"bizdate");
        DynamicObject doSaleOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataItem, (String)"bizorgid");
        DynamicObject doSaleBranch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataItem, (String)"salebranchid");
        DynamicObject doAuxAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"auxattrid");
        long billEntryId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry);
        long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"oversalepolicyid");
        long overSalePolicyEntryId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"oversalepolicyentryid");
        for (DynamicObject data : docSubEntry) {
            if (!lstDetailId.contains(data.getPkValue())) continue;
            HashMap<String, Long> map = new HashMap<String, Long>(0);
            map.put("deliverymodeid", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverymode"));
            map.put("deliverystatusid", DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"deliverystatus"));
            params.add(map);
            this.setFieldValue(id, billNo, properties, docEntry, data, bizDate, doSaleOrg, doSaleBranch, doAuxAttr, overSalePolicyId, overSalePolicyEntryId, billEntryId);
        }
    }

    private void setFieldValue(Long id, String billNo, DataEntityPropertyCollection properties, DynamicObjectCollection docEntry, DynamicObject data, Date bizDate, DynamicObject doSaleOrg, DynamicObject doSaleBranch, DynamicObject doAuxAttr, long overSalePolicyId, long overSalePolicyEntryId, long billEntryId) {
        DynamicObject entryItem = docEntry.addNew();
        entryItem.set("id", (Object)id);
        entryItem.set("billno", (Object)billNo);
        entryItem.set("bizdate", (Object)bizDate);
        entryItem.set("bizorgid", (Object)doSaleOrg);
        entryItem.set("salebranchid", (Object)doSaleBranch);
        entryItem.set("auxattrid", (Object)doAuxAttr);
        entryItem.set("goodsentryid", (Object)billEntryId);
        entryItem.set("oversalepolicyid", (Object)overSalePolicyId);
        entryItem.set("oversalepolicyentryid", (Object)overSalePolicyEntryId);
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (DynamicObjectUtils.contain((DynamicObject)data, (String)key)) {
                entryItem.set(key, data.get(key));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"deliverydetailid")) {
                entryItem.set(key, data.get("Id"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newdeliverymode")) {
                entryItem.set(key, data.get("deliverymode"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newdeliverytime")) {
                entryItem.set(key, data.get("deliverdeliverytime"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newdistrictid")) {
                entryItem.set(key, data.get("districtid"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newaddress")) {
                entryItem.set(key, data.get("address"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newaddress")) {
                entryItem.set(key, data.get("address"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newfulladdress")) {
                entryItem.set(key, data.get("fulladdress"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newinstalltime")) {
                entryItem.set(key, data.get("deliverinstalltime"));
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"newconsignee")) {
                entryItem.set(key, data.get("consignee"));
            }
            if (!StringUtils.equals((CharSequence)key, (CharSequence)"newphonenumber")) continue;
            entryItem.set(key, data.get("deliverphonenumber"));
        }
    }

    private DynamicObject[] queryDelivery(List<Object> lstDetailId, String entityNumber) {
        QFilter filter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", (Object)lstDetailId.toArray());
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType(entityNumber + "." + "goodsentryentity" + "." + "salesorderdelivery");
        List lstFields = type.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        StringBuilder selectFields = new StringBuilder("Id").append(",");
        selectFields.append("billno").append(',');
        selectFields.append("bizdate").append(',');
        selectFields.append("bizorgid").append(',');
        selectFields.append("salebranchid").append(',');
        selectFields.append("goodsentryentity").append('.').append("Id").append(',');
        selectFields.append("goodsentryentity").append('.').append("seq").append(',');
        selectFields.append("goodsentryentity").append('.').append("goodsid").append(',');
        selectFields.append("goodsentryentity").append('.').append("materielid").append(',');
        selectFields.append("goodsentryentity").append('.').append("saleqty").append(',');
        selectFields.append("goodsentryentity").append('.').append("unit").append(',');
        selectFields.append("goodsentryentity").append('.').append("baseunitqty").append(',');
        selectFields.append("goodsentryentity").append('.').append("baseunit").append(',');
        selectFields.append("goodsentryentity").append('.').append("auxattrid").append(',');
        selectFields.append("goodsentryentity").append('.').append("oversalepolicyid").append(',');
        selectFields.append("goodsentryentity").append('.').append("oversalepolicyentryid");
        for (String fieldName : lstFields) {
            if (fieldName.contains("_id")) continue;
            selectFields.append(',').append("salesorderdelivery").append('.').append(fieldName);
        }
        return BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields.toString(), (QFilter[])filter.toArray());
    }

    private DynamicObject[] queryRetailDelivery(List<Object> lstDetailId) {
        QFilter filter = new QFilter("entryentity.ribilldelivery.srcdeliveryentryid", "in", (Object)lstDetailId.toArray());
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("ocococ_retailbill.entryentity.ribilldelivery");
        List lstFields = type.getProperties().stream().map(IMetadata::getName).collect(Collectors.toList());
        StringBuilder selectFields = new StringBuilder();
        for (String fieldName : lstFields) {
            if (fieldName.contains("_id")) continue;
            if (selectFields.length() > 0) {
                selectFields.append(',');
            }
            selectFields.append("ribilldelivery").append('.').append(fieldName);
        }
        return BusinessDataServiceHelper.load((String)"ocococ_retailbill", (String)selectFields.toString(), (QFilter[])filter.toArray());
    }

    private DynamicObject[] queryDeliveryOrderEntry(List<Object> lstSrcEntryId) {
        QFilter filter = new QFilter("entryentity.srcbillentryid", "in", (Object)lstSrcEntryId.toArray());
        DynamicObjectType dynamicObjectType = (DynamicObjectType)ORM.create().getDataEntityType("ocococ_deliveryorder");
        DynamicObjectCollection docDeliveryData = QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)"id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)docDeliveryData)) {
            return null;
        }
        Object[] lstDeliveryId = docDeliveryData.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).toArray();
        return BusinessDataServiceHelper.load((Object[])lstDeliveryId, (DynamicObjectType)dynamicObjectType);
    }

    private DynamicObject querySingleOverSalePolicy(long policyId, long policyEntryId, long itemId) {
        QFilter filter = new QFilter("id", "=", (Object)policyId);
        filter.and("policyentity.id", "=", (Object)policyEntryId);
        filter.and("policyentity.item", "=", (Object)itemId);
        String selectFields = "id,number,name,policyentity.item,policyentity.exparrdate";
        return QueryServiceHelper.queryOne((String)"ococic_oversalepolicy", (String)selectFields, (QFilter[])filter.toArray());
    }

    private void insertOrderChangeRecord(List<DynamicObject> lstChangeRecord, DynamicObject dataEntity, DynamicObject orderChangeRecord, DynamicObject deliveryItem) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("EntityNumber");
        DynamicObject changeRecord = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_changerecord");
        if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"ocpos_saleorder")) {
            changeRecord.set("changetype", (Object)"1");
        } else if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"ocpos_saleorder_return")) {
            changeRecord.set("changetype", (Object)"0");
        }
        changeRecord.set("createtime", (Object)new Date());
        changeRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        changeRecord.set("billno", (Object)CodeRuleUtil.getCodeRule((String)"ocpos_changerecord"));
        changeRecord.set("billstatus", (Object)StatusEnum.AUDIT.getValue());
        changeRecord.set("salebillno", (Object)dataEntity.getString("billno"));
        changeRecord.set("delivergoodsid", deliveryItem.get("delivergoodsid"));
        changeRecord.set("deliversaleqty", (Object)deliveryItem.getInt("deliversaleqty"));
        changeRecord.set("deliverunitid", deliveryItem.get("deliverunitid"));
        changeRecord.set("deliverisdelivery", (Object)deliveryItem.getBoolean("deliverisdelivery"));
        changeRecord.set("deliverdeliverytime", deliveryItem.get("deliverdeliverytime"));
        changeRecord.set("fulladdress", deliveryItem.get("fulladdress"));
        changeRecord.set("deliverisinstall", (Object)deliveryItem.getBoolean("deliverisinstall"));
        changeRecord.set("deliveryisnegativesell", (Object)deliveryItem.getBoolean("deliveryisnegativesell"));
        changeRecord.set("consignee", (Object)deliveryItem.getString("consignee"));
        changeRecord.set("deliverphonenumber", (Object)deliveryItem.getString("deliverphonenumber"));
        changeRecord.set("installtime", deliveryItem.get("deliverinstalltime"));
        changeRecord.set("districtid", deliveryItem.get("districtid"));
        changeRecord.set("inventoryorg", deliveryItem.get("inventoryorgid"));
        changeRecord.set("erpstock", deliveryItem.get("erpstockid"));
        changeRecord.set("deliverydetailid", deliveryItem.get("Id"));
        changeRecord.set("deliverymode", orderChangeRecord.get("deliverymode"));
        changeRecord.set("newdeliverymode", orderChangeRecord.get("newdeliverymode"));
        changeRecord.set("newdeliverytime", orderChangeRecord.get("newdeliverytime"));
        changeRecord.set("newdistrictid", orderChangeRecord.get("newdistrictid"));
        changeRecord.set("newfulladdress", (Object)orderChangeRecord.getString("newfulladdress"));
        changeRecord.set("newinstalltime", orderChangeRecord.get("newinstalltime"));
        changeRecord.set("newconsignee", (Object)orderChangeRecord.getString("newconsignee"));
        changeRecord.set("newphonenumber", (Object)orderChangeRecord.getString("newphonenumber"));
        changeRecord.set("adjustorg", orderChangeRecord.get("bizorgid"));
        changeRecord.set("adjustbranch", orderChangeRecord.get("salebranchid"));
        changeRecord.set("oversalepolicyid", orderChangeRecord.get("newoversalepolicyid"));
        changeRecord.set("oversalepolicyentryid", orderChangeRecord.get("newoversalepolicyentryid"));
        lstChangeRecord.add(changeRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{changeRecord});
    }
}

