/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.operate.Operations;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class InitImportDataFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOG = LogFactory.getLog(InitImportDataFormPlugin.class, (String)"ocpos");
    private static final String CHAR_WELL = " # ";
    private static long billTypeId;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Image label = (Image)this.getView().getControl("btn_upload");
        label.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        billTypeId = CommonUtil.formatObejctToLong(customParams.get("basebilltype"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.reset(this.getView());
        String billFormName = this.getBillFormName();
        Label title = (Label)this.getView().getControl("title");
        title.setText(billFormName);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String url;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)op.getOperateKey(), (CharSequence)"confirm") && StringUtils.isBlank((CharSequence)(url = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("path"))))) {
            this.getView().showErrorNotification("\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u518d\u64cd\u4f5c\u3002");
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        super.afterDoOperation(e);
        switch (opKey = e.getOperateKey()) {
            case "downloadtpl": {
                this.downloadExcelTpl();
                break;
            }
            case "confirm": {
                this.importData();
                break;
            }
            case "reset": {
                this.reset(this.getView());
                break;
            }
        }
    }

    public void upload(UploadEvent e) {
        IFormView view;
        String url;
        block20: {
            Object[] urls = e.getUrls();
            if (urls == null || urls.length <= 0) {
                return;
            }
            url = CommonUtil.formatStringToEmpty((Object)urls[0]);
            FileService service = FileServiceFactory.getAttachmentFileService();
            view = this.getView();
            try (InputStream inputStream = service.getInputStream(url);){
                final ArrayList dataIndexes = new ArrayList();
                ExcelReader reader = new ExcelReader();
                reader.read(inputStream, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getRowNum() == 0) {
                            String billFormId = (String)view.getFormShowParameter().getCustomParam("BillFormId");
                            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
                            if (entityType instanceof QueryEntityType) {
                                QueryEntityType queryEntityType = (QueryEntityType)entityType;
                                String entityName = row.get(Integer.valueOf(0));
                                if (StringUtils.isEmpty((CharSequence)entityName)) {
                                    entityName = row.get(Integer.valueOf(1));
                                }
                                if (entityName.split(InitImportDataFormPlugin.CHAR_WELL).length < 2 || !entityName.split(InitImportDataFormPlugin.CHAR_WELL)[1].equalsIgnoreCase(queryEntityType.getMainEntityType().getName())) {
                                    InitImportDataFormPlugin.this.reset(view);
                                    throw new KDBizException("\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002");
                                }
                            } else {
                                String entityName = row.get(Integer.valueOf(0));
                                if (StringUtils.isEmpty((CharSequence)entityName)) {
                                    entityName = row.get(Integer.valueOf(1));
                                }
                                if (entityName.split(InitImportDataFormPlugin.CHAR_WELL).length < 2 || !entityName.split(InitImportDataFormPlugin.CHAR_WELL)[1].equalsIgnoreCase(billFormId)) {
                                    InitImportDataFormPlugin.this.reset(view);
                                    throw new KDBizException("\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002");
                                }
                            }
                        } else if (row.getRowNum() > 1 && !row.isEmpty()) {
                            dataIndexes.add(row.getRowNum());
                        }
                    }
                });
                int validRowCount = dataIndexes.size();
                if (validRowCount > 1) {
                    for (int i = validRowCount - 1; i > 0; --i) {
                        if ((Integer)dataIndexes.get(i) - (Integer)dataIndexes.get(i - 1) > 1) continue;
                        dataIndexes.remove(i);
                    }
                    break block20;
                }
                this.reset(view);
                view.showMessage("\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", MessageTypes.Default);
                return;
            }
            catch (KDBizException ex) {
                this.reset(view);
                view.showErrorNotification(ex.getMessage());
                return;
            }
            catch (Throwable ex) {
                LOG.error(ex);
                this.reset(view);
                view.showMessage("\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", "\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", MessageTypes.Default);
                return;
            }
        }
        this.update(view, url);
    }

    private void downloadExcelTpl() {
        String url = this.getUrl();
        this.getView().download(url);
        this.getView().sendFormAction(this.getView());
    }

    private void importData() {
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        customParams.put("Type", "new");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        customParams.put("ServiceAppId", parameter.getServiceAppId());
        String billFormId = (String)parameter.getCustomParam("BillFormId");
        customParams.put("BillFormId", billFormId);
        String billFormName = this.getBillFormName();
        customParams.put("ListName", billFormName);
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        customParams.put("OpSave", ops.getSave());
        String url = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("path"));
        customParams.put("Url", url);
        customParams.put("ImportPlugin", "kd.occ.ocpos.opplugin.saleorder.InitImportOp");
        customParams.put("OperateKey", "import");
        FormShowParameter showParameter = FormShowUtils.openNewForm((String)"", (String)"bos_importing", (ShowType)ShowType.InCurrentForm, (OperationStatus)OperationStatus.ADDNEW, customParams);
        showParameter.setParentPageId(parameter.getParentPageId());
        showParameter.setCloseCallBack(parameter.getCloseCallBack());
        this.getView().showForm(showParameter);
    }

    private void reset(IFormView view) {
        view.setEnable(Boolean.FALSE, new String[]{"btn_confirm"});
        view.setEnable(Boolean.TRUE, new String[]{"btn_upload"});
        view.setVisible(Boolean.FALSE, new String[]{"pnl_file"});
        view.getModel().setValue("name", null);
        view.getModel().setValue("path", null);
    }

    private void update(IFormView view, String url) {
        view.setEnable(Boolean.TRUE, new String[]{"btn_confirm"});
        view.setEnable(Boolean.FALSE, new String[]{"btn_upload"});
        view.setVisible(Boolean.TRUE, new String[]{"pnl_file"});
        view.getModel().setValue("name", (Object)url.substring(url.lastIndexOf(47) + 1));
        view.getModel().setValue("path", (Object)url);
    }

    private String getUrl() {
        long templateId = this.getTemplateId();
        String fileName = this.getFileName();
        String formId = this.getFormId();
        String ctxPath = RequestContext.get().getClientFullContextPath();
        try {
            return ctxPath + (ctxPath.endsWith("/") ? "" : "/") + "form/export.do?templateid=" + templateId + "&formid=" + formId + "&plugin=&filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()) + "&extenddata=" + null + "&routeappid=" + this.getView().getFormShowParameter().getServiceAppId() + "&a=t";
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private String getBillFormName() {
        String billFormName = billTypeId == BillTypeEnum.RETURN.getId() ? "\u521d\u59cb\u5316\u96f6\u552e\u9000\u8d27" : (billTypeId == BillTypeEnum.RESERVE.getId() ? "\u521d\u59cb\u5316\u9884\u8ba2\u5f00\u5355" : "\u521d\u59cb\u5316\u96f6\u552e\u5f00\u5355");
        return billFormName;
    }

    private String getFileName() {
        String billFormName = this.getBillFormName();
        Date date = TimeServiceHelper.today();
        String dateFormat = new SimpleDateFormat("MMdd").format(date);
        return String.format("\u9884\u7f6e_%s\u5f15\u5165\u6a21\u677f_%s.xlsx", billFormName, dateFormat);
    }

    private String getFormId() {
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return "ocpos_saleorder_return";
        }
        return "ocpos_saleorder";
    }

    private long getTemplateId() {
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return 1174660894622487552L;
        }
        return 1168092927243617280L;
    }
}

