/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocdbd.common.enums.UserStatusEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;

public class IntegralSendPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_NEWENTRY = "newentry";

    public void afterCreateNewData(EventObject e) {
        List<DynamicObject> lstSelectGoods;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONObject doMember = (JSONObject)parameter.getCustomParam("insmember");
        DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("sendintegralentity");
        if (docEntry == null) {
            return;
        }
        docEntry.clear();
        List<DynamicObject> lstGoodsData = this.getEntryData(parameter, "goodsentryentity", "ocpos_saleorder.goodsentryentity");
        List<DynamicObject> lstIntegralEntryData = this.getEntryData(parameter, "sendintegralentity", "ocpos_saleorder.sendintegralentity");
        if (lstIntegralEntryData != null && lstIntegralEntryData.size() > 0) {
            Object[] memberPkValue = lstIntegralEntryData.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"insmember")).toArray();
            QFilter filter = new QFilter("id", "in", (Object)memberPkValue);
            DynamicObject[] members = BusinessDataServiceHelper.load((String)"ocdbd_user", (String)"id,number,name,mobile", (QFilter[])filter.toArray());
            for (DynamicObject doIntegralEntry : lstIntegralEntryData) {
                long oMemberId = DynamicObjectUtils.getPkValue((DynamicObject)doIntegralEntry, (String)"insmember");
                DynamicObject oMemPointType = DynamicObjectUtils.getDynamicObject((DynamicObject)doIntegralEntry, (String)"insmempointtype");
                if (oMemberId == 0L || ObjectUtils.isEmpty((Object)oMemPointType)) continue;
                DynamicObject doEntry = docEntry.addNew();
                DynamicObject oMember = Arrays.stream(members).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == oMemberId).findFirst().orElse(null);
                doEntry.set("insmember", (Object)oMember);
                doEntry.set("insmempointtype", (Object)oMemPointType);
                doEntry.set("insintegral", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doIntegralEntry, (String)"insintegral"));
                doEntry.set("insgoodsseq", (Object)DynamicObjectUtils.getString((DynamicObject)doIntegralEntry, (String)"insgoodsseq"));
                doEntry.set("inssalegoods", (Object)DynamicObjectUtils.getString((DynamicObject)doIntegralEntry, (String)"insgoodsname"));
            }
        }
        String bizType = (String)parameter.getCustomParam("biztype");
        if (BizTypeEnum.CHANGE.getValue().equals(bizType)) {
            docEntry.clear();
        }
        this.getView().updateView("sendintegralentity");
        long lMemberId = 0L;
        if (doMember != null) {
            lMemberId = (Long)doMember.get((Object)"id");
        }
        if ((lstSelectGoods = this.getEntryData(parameter, "goodsselectentity", "ocpos_saleorder.goodsentryentity")) != null && lstSelectGoods.size() > 0) {
            this.createIntegralSendEntry(docEntry, lstSelectGoods, lMemberId);
        } else {
            this.createIntegralSendEntry(docEntry, lstGoodsData, lMemberId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        BasedataEdit bEdit = (BasedataEdit)this.getView().getControl("insmember");
        if (!ObjectUtils.isEmpty((Object)bEdit)) {
            bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"insmember")) {
            DynamicObject bizOrg = (DynamicObject)this.getView().getParentView().getModel().getValue("bizorgid");
            long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)bizOrg);
            DynamicObject split = UserServiceHelper.getUserSplitByNumberOrOrgId(null, (Long)bizOrgId);
            QFilter filter = new QFilter("splitid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)split));
            filter.and("userstatus", "=", (Object)UserStatusEnum.NORMAL.getValue());
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            StringBuilder sbMsg = new StringBuilder();
            DynamicObjectCollection docSendIntegralEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("sendintegralentity");
            if (docSendIntegralEntry != null && docSendIntegralEntry.size() > 0) {
                for (DynamicObject doSendIntegralEntry : docSendIntegralEntry) {
                    String seq = String.valueOf(doSendIntegralEntry.get("seq"));
                    if (ObjectUtils.isEmpty((Object)doSendIntegralEntry.get("insmember"))) {
                        sbMsg.append(String.format("\u8d60\u9001\u79ef\u5206\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4f1a\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", seq));
                    }
                    if (ObjectUtils.isEmpty((Object)doSendIntegralEntry.get("inssalegoods"))) {
                        sbMsg.append(String.format("\u8d60\u9001\u79ef\u5206\u660e\u7ec6\u7b2c%s\u884c\uff0c\u9500\u552e\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", seq));
                    }
                    if (doSendIntegralEntry.getBigDecimal("insintegral").compareTo(BigDecimal.ZERO) <= 0) {
                        sbMsg.append(String.format("\u8d60\u9001\u79ef\u5206\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8d60\u9001\u79ef\u5206\u4e0d\u80fd\u5c0f\u4e8e0\u3002\r\n", seq));
                    }
                    if (!ObjectUtils.isEmpty((Object)doSendIntegralEntry.get("insmempointtype"))) continue;
                    sbMsg.append(String.format("\u8d60\u9001\u79ef\u5206\u660e\u7ec6\u7b2c%s\u884c\uff0c\u79ef\u5206\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", seq));
                }
                if (StringUtils.isEmpty((CharSequence)sbMsg.toString())) {
                    this.getView().returnDataToParent((Object)docSendIntegralEntry);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(sbMsg.toString());
                }
            } else {
                this.getView().returnDataToParent((Object)docSendIntegralEntry);
                this.getView().close();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowIndex;
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_NEWENTRY, (CharSequence)op.getOperateKey()) && (rowIndex = this.getView().getModel().getEntryCurrentRowIndex("sendintegralentity")) >= 0) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            List<DynamicObject> lstGoodsEntryData = this.getEntryData(parameter, "goodsselectentity", "ocpos_saleorder.goodsentryentity");
            if (lstGoodsEntryData == null || lstGoodsEntryData.size() == 0) {
                lstGoodsEntryData = this.getEntryData(parameter, "goodsentryentity", "ocpos_saleorder.goodsentryentity");
            }
            if (lstGoodsEntryData != null && lstGoodsEntryData.size() > 0) {
                StringBuilder sbGoodsName = new StringBuilder();
                ArrayList<String> lstSeq = new ArrayList<String>(lstGoodsEntryData.size());
                for (DynamicObject doGoodsEntry : lstGoodsEntryData) {
                    DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                    if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                    if (sbGoodsName.length() > 0) {
                        sbGoodsName.append(',');
                    }
                    sbGoodsName.append(DynamicObjectUtils.getString((DynamicObject)doGoods, (String)"name"));
                    lstSeq.add(DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq"));
                }
                this.getView().getModel().setValue("insgoodsseq", (Object)String.join((CharSequence)",", lstSeq), rowIndex);
                this.getView().getModel().setValue("inssalegoods", (Object)sbGoodsName.toString(), rowIndex);
            }
        }
    }

    private void createIntegralSendEntry(DynamicObjectCollection docEntry, List<DynamicObject> lstGoodsEntry, long lMemberId) {
        if (lstGoodsEntry != null && lstGoodsEntry.size() > 0) {
            ArrayList<String> lstSeq = new ArrayList<String>(lstGoodsEntry.size());
            StringBuilder sbGoodsName = new StringBuilder();
            for (DynamicObject doGoodsEntry : lstGoodsEntry) {
                DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                lstSeq.add(DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq"));
                if (sbGoodsName.length() > 0) {
                    sbGoodsName.append(',');
                }
                sbGoodsName.append(DynamicObjectUtils.getString((DynamicObject)doGoods, (String)"name"));
            }
            String goodsSeq = String.join((CharSequence)",", lstSeq);
            if (docEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)x.getString("insgoodsseq"), (CharSequence)goodsSeq))) {
                return;
            }
            int rowIndex = this.getModel().createNewEntryRow("sendintegralentity");
            if (lMemberId > 0L) {
                this.getView().getModel().setValue("insmember", (Object)lMemberId, rowIndex);
            }
            this.getView().getModel().setValue("inssalegoods", (Object)sbGoodsName, rowIndex);
            this.getView().getModel().setValue("insgoodsseq", (Object)String.join((CharSequence)",", lstSeq), rowIndex);
        }
    }

    private List<DynamicObject> getEntryData(FormShowParameter frmShowParameter, String paramName, String entryKey) {
        DynamicObjectType entryDyt;
        String entryData = frmShowParameter.getCustomParam(paramName).toString();
        Object[] objEntry = DynamicObjectSerializeUtil.deserialize((String)entryData, (DynamicObjectType)(entryDyt = (DynamicObjectType)ORM.create().getDataEntityType(entryKey)));
        if (objEntry == null || objEntry.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> lstEntry = new ArrayList<DynamicObject>(0);
        for (Object item : objEntry) {
            if (!(item instanceof DynamicObject)) continue;
            lstEntry.add((DynamicObject)item);
        }
        return lstEntry;
    }
}

