/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormRuleUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocdbd.business.helper.RetailChainHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderItemF7Filter;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.saleorder.LocCodeUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ItemsInfoEditFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ItemsInfoEditFormPlugin.class);
    private static final String[] F7FIELD_KEYS = new String[]{"goodsid", "barcode", "goodssaler", "saledepartment", "inventoryorgid", "erpstockid", "supplier"};
    private static final String KEY_DEPOSIT_TIP_CALLBACK = "depositChange";
    private static final String KEY_DEPOSIT_SCALE_TIP_CALLBACK = "depositScaleChange";
    private static final String KEY_FINAL_PAYMENT_TIP_CALLBACK = "finalPaymentChange";
    private static final String KEY_FINAL_PAYMENT_SCALE_TIP_CALLBACK = "finalPaymentScaleChange";
    private static final String BAR_RAN = "bar_returnandnew";
    private static boolean isFromBarcode = false;
    private static boolean isNeedInitMode;
    private boolean isFromGoods = false;
    private boolean isFromDelivery = false;
    private final List<String> notNeedInv = new ArrayList<String>();

    public ItemsInfoEditFormPlugin() {
        this.notNeedInv.add("deliverytime");
        this.notNeedInv.add("channelstocktypeid");
    }

    public void afterCreateNewData(EventObject e) {
        long modeId;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.initBaseFields(customParams);
        this.initItemsFields(dataEntity, customParams);
        this.initStockType(customParams);
        this.initSaleFields(dataEntity, customParams);
        this.initDeliveryFields(customParams);
        BigDecimal giftValue = CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("giftvalue", BigDecimal.ZERO));
        if (giftValue.compareTo(BigDecimal.ZERO) == 0) {
            this.updateGiftValue();
        } else {
            dataEntity.set("giftvalue", (Object)giftValue);
            this.getView().updateView("giftvalue");
        }
        boolean isNew = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("type", Boolean.FALSE));
        if (isNew) {
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty");
            this.updateAmtByQty(dataEntity, saleQty);
        }
        isNeedInitMode = (modeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode")) == 0L;
        this.updateInv(dataEntity, "");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMustInput();
        this.setEnable();
        this.setVisible();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List allFieldKeys = this.getModel().getDataEntityType().getAllFields().values().stream().map(IMetadata::getName).collect(Collectors.toList());
        for (String f7FieldKey : F7FIELD_KEYS) {
            BasedataEdit bEdit;
            if (!allFieldKeys.contains(f7FieldKey) || ObjectUtils.isEmpty((Object)(bEdit = (BasedataEdit)this.getView().getControl(f7FieldKey)))) continue;
            bEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        TextEdit serialNumberEdit = (TextEdit)this.getView().getControl("deliveryserialnumber");
        serialNumberEdit.addButtonClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (fieldKey = e.getProperty().getName()) {
            case "itemsale": {
                this.saleContentChanged(changeData);
                break;
            }
            case "goodsid": {
                this.goodsChanged(dataEntity, changeData);
                break;
            }
            case "barcode": {
                this.barCodeChanged(dataEntity, changeData);
                break;
            }
            case "goodssaler": {
                this.salerChanged(changeData);
                break;
            }
            case "isselfpickup": {
                this.isSelfPickupChanged(dataEntity, changeData);
                break;
            }
            case "isinstall": {
                this.setMustInputAboutInstall(changeData.getNewValue());
                break;
            }
            case "supplier": {
                this.supplierChanged(dataEntity, changeData);
                break;
            }
            case "isdelivery": 
            case "deliverytime": 
            case "admindivisionid": 
            case "inventoryorgid": 
            case "erpstockid": 
            case "channelstocktypeid": {
                this.invPropertyChanged(dataEntity, changeData, fieldKey);
                break;
            }
            case "saleqty": 
            case "finalpayment": 
            case "finalpaymentscale": 
            case "deposit": 
            case "depositscale": 
            case "isbook": 
            case "discountprice": 
            case "discountrate": 
            case "manualdiscount": 
            case "promotiondiscount": 
            case "coupondiscount": 
            case "integraldistamount": 
            case "expectfinalamount": 
            case "notincomedisamount": 
            case "stddiscountamount": 
            case "giftdiscountamount": 
            case "ticketshareamount": {
                this.amtPropertyChanged(dataEntity, changeData, fieldKey);
                break;
            }
            case "deliveryserialnumber": {
                this.serialNumberChanged(changeData);
                break;
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Object source = e.getSource();
        if (source instanceof FieldEdit) {
            String fieldKey;
            FieldEdit fieldEdit = (FieldEdit)source;
            switch (fieldKey = fieldEdit.getKey()) {
                case "deposit": {
                    this.beforeDepositFieldPostBack(e);
                    break;
                }
                case "depositscale": {
                    this.beforeDepositScaleFieldPostBack(e);
                    break;
                }
                case "saleqty": {
                    this.beforeQtyFieldPostBack(e);
                    break;
                }
                case "manualdiscount": {
                    this.beforeManualDiscountFieldPostBack(e);
                    break;
                }
                case "finalpayment": {
                    this.beforeFinalPaymentFieldPostBack(e);
                    break;
                }
                case "notincomedisamount": 
                case "stddiscountamount": 
                case "ticketshareamount": {
                    this.beforeAboutBalAmountFieldPostBack(e, fieldKey);
                    break;
                }
                case "finalpaymentscale": 
                case "balamount": {
                    this.beforeFinalPaymentScaleFieldPostBack(e, fieldKey);
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "itemsale": {
                this.beforeSaleContentF7Select(e, dataEntity);
                break;
            }
            case "goodsid": 
            case "barcode": {
                this.beforeItemsInfoF7Select(e, dataEntity, key);
                break;
            }
            case "goodssaler": {
                this.beforeSalerF7Select(e, dataEntity);
                break;
            }
            case "saledepartment": {
                this.beforeSaleDeptF7Select(e, dataEntity);
                break;
            }
            case "inventoryorgid": {
                this.beforeInvOrgF7Select(e, dataEntity);
                break;
            }
            case "erpstockid": {
                this.beforeErpStockF7Select(e, dataEntity);
                break;
            }
            case "supplier": {
                this.beforeSupplierF7Select(e, dataEntity);
                break;
            }
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"deliveryserialnumber")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
            long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"auxattrid");
            long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
            long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
            HashMap<String, Object> customParams = new HashMap<String, Object>(0);
            customParams.put("material", materialId);
            customParams.put("auxpty", auxPtyId);
            customParams.put("stockorg", stockOrgId);
            customParams.put("stock", stockId);
            customParams.put("ismul", Boolean.FALSE);
            customParams.put("locksnmainfiles", this.getExistId());
            customParams.put("snmainfile", this.getSrcSnMainFileIds());
            FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_snmainfile_query", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocpos_snmainfile_query"));
            this.getView().showForm(parameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "savedata": 
            case "saveandnew": {
                OperationResult result = e.getOperationResult();
                if (ObjectUtils.isEmpty((Object)result) || !result.isSuccess()) break;
                this.updateCache(key);
                this.returnData(dataEntity, key);
                break;
            }
            case "cleardata": {
                this.returnDataToParent(dataEntity);
                break;
            }
            case "searchinventory": {
                this.showQueryInventory(dataEntity);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object returnData = this.getView().getReturnData();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isPresent = dataEntity.getBoolean("ispresent");
        if (!ObjectUtils.isEmpty((Object)returnData)) {
            this.getView().returnDataToParent(returnData);
        } else if (isPresent) {
            this.returnData(dataEntity, "savedata");
        } else {
            boolean isNew = (Boolean)this.getView().getFormShowParameter().getCustomParam("type");
            if (isNew) {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                int index = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("index"));
                map.put("index", index);
                map.put("status", "CANCEL");
                map.put("data", null);
                this.getView().returnDataToParent(map);
            }
        }
        this.clearCache();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key = messageBoxClosedEvent.getCallBackId();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (key) {
            case "finalPaymentChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, "finalpayment", dataEntity.getBigDecimal("finalpayment"));
                    this.getView().updateView();
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_finalpayment");
                    dataEntity.set("finalpayment", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView();
                }
                this.getPageCache().remove("PageCache_finalpayment");
                break;
            }
            case "finalPaymentScaleChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, "finalpaymentscale", dataEntity.getBigDecimal("finalpaymentscale"));
                    this.getView().updateView();
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_finalpaymentscale");
                    dataEntity.set("finalpaymentscale", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView();
                }
                this.getPageCache().remove("PageCache_finalpaymentscale");
                break;
            }
            case "depositChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, "deposit", dataEntity.getBigDecimal("deposit"));
                    this.getView().updateView();
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_deposit");
                    dataEntity.set("deposit", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView();
                }
                this.getPageCache().remove("PageCache_deposit");
                break;
            }
            case "depositScaleChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.updateAmt(dataEntity, "depositscale", dataEntity.getBigDecimal("depositscale"));
                    this.getView().updateView();
                } else if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.No)) {
                    String oldChangeValue = this.getPageCache().get("PageCache_depositscale");
                    dataEntity.set("depositscale", (Object)CommonUtil.formatObjectToDecimal((Object)oldChangeValue));
                    this.getView().updateView();
                }
                this.getPageCache().remove("PageCache_depositscale");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocpos_snmainfile_query") && returnData instanceof JSONObject) {
            DynamicObject stock;
            JSONObject data = (JSONObject)returnData;
            DynamicObject stockOrg = (DynamicObject)this.getModel().getValue("inventoryorgid");
            if (stockOrg == null) {
                long stockOrgId = data.getLongValue("inventoryorgid");
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"inventoryorgid", (Object)stockOrgId);
            }
            if ((stock = (DynamicObject)this.getModel().getValue("erpstockid")) == null) {
                long stockId = data.getLongValue("erpstockid");
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"erpstockid", (Object)stockId);
            }
            this.getModel().beginInit();
            long snMainFileId = data.getLongValue("snmainfile");
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"snmainfile", (Object)snMainFileId);
            this.getView().updateView("snmainfile");
            String sn = data.getString("deliveryserialnumber");
            this.getModel().setValue("deliveryserialnumber", (Object)sn);
            this.getView().updateView("deliveryserialnumber");
            String lotNum = data.getString("deliverylotnum");
            this.getModel().setValue("deliverylotnum", (Object)lotNum);
            this.getView().updateView("deliverylotnum");
            this.getModel().endInit();
        }
    }

    private void initBaseFields(Map<String, Object> customParams) {
        Object index = customParams.getOrDefault("index", 0);
        this.getModel().setValue("index", index);
        if (customParams.containsKey("id")) {
            Object id = customParams.getOrDefault("id", 0L);
            this.getModel().setValue("id", id);
        }
        Object notConfirm = customParams.getOrDefault("notconfirm", Boolean.FALSE);
        this.getModel().setValue("notconfirm", notConfirm);
        Object changeType = customParams.get("changeitemtype");
        this.getModel().setValue("changeitemtype", changeType);
        Object saleOption = customParams.get("saleoption");
        this.getModel().setValue("saleoption", saleOption);
        Object branchId = customParams.getOrDefault("salebranchid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"salebranchid", (Object)branchId);
        Object bizOrgId = customParams.getOrDefault("bizorgid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"bizorgid", (Object)bizOrgId);
        Object bizDate = customParams.getOrDefault("bizdate", null);
        this.getModel().setValue("bizdate", bizDate);
        Object billTypeId = customParams.getOrDefault("basebilltype", 0L);
        this.getModel().setValue("basebilltype", billTypeId);
        Object srcBillId = customParams.getOrDefault("sourcebillid", 0L);
        this.getModel().setValue("sourcebillid", srcBillId);
        Object isInitBill = customParams.getOrDefault("isinitbill", Boolean.FALSE);
        this.getModel().setValue("isinitbill", isInitBill);
        Object bizType = customParams.getOrDefault("biztype", null);
        this.getModel().setValue("biztype", bizType);
    }

    private void initItemsFields(DynamicObject dataEntity, Map<String, Object> customParams) {
        Object saleContentId = customParams.getOrDefault("itemsale", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"itemsale", (Object)saleContentId);
        Object goodsId = customParams.getOrDefault("goodsid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsid", (Object)goodsId);
        Object barCodeId = customParams.getOrDefault("barcode", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"barcode", (Object)barCodeId);
        this.updateGoodsClass(goodsId);
        FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"goodsid", null, (Object)goodsId, (int)0);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
        FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"materielid", null, (Object)materialId, (int)0);
        long materialInvId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materialinv");
        FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"materialinv", null, (Object)materialInvId, (int)0);
        String operationModel = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
        this.updateOperationModel(operationModel);
        long taxRateId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("taxrateid", 0L));
        BigDecimal taxRate = CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("taxrate", BigDecimal.ZERO));
        if (taxRateId != 0L && taxRate.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"taxrateid", (Object)taxRateId);
            this.getModel().setValue("taxrate", (Object)taxRate);
        } else {
            taxRateId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"taxrateid");
            FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"taxrateid", null, (Object)taxRateId, (int)0);
        }
        this.initSupplier(customParams);
        FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"barcode", null, (Object)barCodeId, (int)0);
        long saleAttrId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("saleattr", 0L));
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saleattr", (Object)saleAttrId);
    }

    private void initSaleFields(DynamicObject dataEntity, Map<String, Object> customParams) {
        long snMainFileId;
        Object currencyId = customParams.getOrDefault("currencyid", 1L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"currencyid", (Object)currencyId);
        Object salerId = customParams.getOrDefault("goodssaler", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodssaler", (Object)salerId);
        Object saleDeptId = customParams.getOrDefault("saledepartment", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saledepartment", (Object)saleDeptId);
        this.initSaleUnit(customParams);
        Object saleQty = customParams.getOrDefault("saleqty", BigDecimal.ONE);
        this.getModel().setValue("saleqty", saleQty);
        boolean isBook = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("isbook", Boolean.FALSE));
        this.getModel().setValue("isbook", (Object)isBook);
        String bookType = CommonUtil.formatStringToEmpty((Object)customParams.getOrDefault("booktype", ""));
        if (StringUtils.isBlank((CharSequence)bookType) && isBook) {
            bookType = "1";
        }
        this.getModel().setValue("booktype", (Object)bookType);
        BigDecimal deposit = CommonUtil.formatObjectToDecimal((Object)customParams.getOrDefault("deposit", BigDecimal.ZERO));
        this.getModel().setValue("deposit", (Object)deposit);
        Object depositScale = customParams.getOrDefault("depositscale", BigDecimal.ZERO);
        this.getModel().setValue("depositscale", depositScale);
        Object expectTakeOrderDate = customParams.getOrDefault("expecttakeorderdate", null);
        this.getModel().setValue("expecttakeorderdate", expectTakeOrderDate);
        Object bookPayType = customParams.getOrDefault("bookpaytype", null);
        this.getModel().setValue("bookpaytype", bookPayType);
        Object surplusPrePayAmount = customParams.getOrDefault("surpluspreamount", BigDecimal.ZERO);
        this.getModel().setValue("surpluspreamount", surplusPrePayAmount);
        this.initSaleAmt(dataEntity, customParams);
        this.initQty(dataEntity, saleQty, customParams);
        String saleOption = dataEntity.getString("saleoption");
        if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            this.getModel().setValue("amount", customParams.get("amount"));
        }
        if ((snMainFileId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("snmainfile", 0L))) > 0L) {
            this.getModel().setValue("snmainfile", (Object)snMainFileId);
            Object serialNum = customParams.getOrDefault("deliveryserialnumber", "");
            this.getModel().setValue("deliveryserialnumber", serialNum);
        } else {
            this.getModel().setValue("snmainfile", null);
            this.getModel().setValue("deliveryserialnumber", null);
        }
        Object lotNum = customParams.getOrDefault("deliverylotnum", "");
        this.getModel().setValue("deliverylotnum", lotNum);
        boolean isPresent = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("ispresent", Boolean.FALSE));
        this.getModel().setValue("ispresent", (Object)isPresent);
        if (isPresent) {
            this.getModel().setValue("discountprice", (Object)BigDecimal.ZERO);
            this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO);
            this.getModel().setValue("balamount", (Object)BigDecimal.ZERO);
        }
        Object isGiftModify = customParams.getOrDefault("isgiftmodify", Boolean.FALSE);
        this.getModel().setValue("isgiftmodify", isGiftModify);
        Object finalPayment = customParams.getOrDefault("finalpayment", BigDecimal.ZERO);
        this.getModel().setValue("finalpayment", finalPayment);
        Object finalScale = customParams.getOrDefault("finalpaymentscale", BigDecimal.ZERO);
        this.getModel().setValue("finalpaymentscale", finalScale);
        Object srcEntryId = customParams.getOrDefault("srcbillentryid", 0L);
        this.getModel().setValue("srcbillentryid", srcEntryId);
        Object mustRetQty = customParams.getOrDefault("mustretqty", BigDecimal.ZERO);
        this.getModel().setValue("mustretqty", mustRetQty);
        Object srcMustRetQty = customParams.getOrDefault("srcmustretqty", BigDecimal.ZERO);
        this.getModel().setValue("srcmustretqty", srcMustRetQty);
        Object returnType = customParams.getOrDefault("returntype", "");
        this.getModel().setValue("returntype", returnType);
        Object returnReasonId = customParams.getOrDefault("returnreason", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"returnreason", (Object)returnReasonId);
        Object isAllowBook = customParams.getOrDefault("isallowbook", Boolean.TRUE);
        this.getModel().setValue("isallowbook", isAllowBook);
    }

    private void initDeliveryFields(Map<String, Object> customParams) {
        Object isDelivery = customParams.getOrDefault("isdelivery", Boolean.FALSE);
        this.getModel().setValue("isdelivery", isDelivery);
        Object deliveryTime = customParams.getOrDefault("deliverytime", null);
        this.getModel().setValue("deliverytime", deliveryTime);
        long deliveryModeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("deliverymode", 0L));
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)deliveryModeId);
        Object isSelfPickup = customParams.getOrDefault("isselfpickup", Boolean.FALSE);
        if (deliveryModeId == 926601071999218688L || deliveryModeId == 926601157210585088L) {
            isSelfPickup = Boolean.FALSE;
        }
        this.getModel().setValue("isselfpickup", isSelfPickup);
        Object selfPickupTime = customParams.getOrDefault("selfpickuptime", null);
        this.getModel().setValue("selfpickuptime", selfPickupTime);
        Object consignee = customParams.getOrDefault("customername", "");
        this.getModel().setValue("customername", consignee);
        Object mobile = customParams.getOrDefault("customerphone", "");
        this.getModel().setValue("customerphone", mobile);
        Object adminDivision = customParams.getOrDefault("admindivisionid", null);
        if (adminDivision != null && StringUtils.isNotBlank((CharSequence)adminDivision.toString())) {
            this.getModel().setValue("admindivisionid", adminDivision);
        }
        Object address = customParams.getOrDefault("customeraddress", "");
        this.getModel().setValue("customeraddress", address);
        Object isInstall = customParams.getOrDefault("isinstall", Boolean.FALSE);
        this.getModel().setValue("isinstall", isInstall);
        Object installTime = customParams.getOrDefault("installtime", null);
        this.getModel().setValue("installtime", installTime);
        String keeperType = CommonUtil.formatStringToEmpty((Object)customParams.get("keepertype"));
        if (StringUtils.isBlank((CharSequence)keeperType)) {
            keeperType = "bos_org";
        }
        this.getModel().setValue("keepertype", (Object)keeperType);
        Object keeperId = customParams.getOrDefault("keeperid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"keeperid", (Object)keeperId);
        String ownerType = CommonUtil.formatStringToEmpty((Object)customParams.get("ownertype"));
        if (StringUtils.isBlank((CharSequence)ownerType)) {
            ownerType = "bos_org";
        }
        this.getModel().setValue("ownertype", (Object)ownerType);
        Object ownerId = customParams.getOrDefault("ownerid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"ownerid", (Object)ownerId);
        Object inventoryOrgId = customParams.getOrDefault("inventoryorgid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"inventoryorgid", (Object)inventoryOrgId);
        Object erpStockId = customParams.getOrDefault("erpstockid", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"erpstockid", (Object)erpStockId);
        Object srcDeliveryId = customParams.getOrDefault("srcdeliveryentryid", 0L);
        this.getModel().setValue("srcdeliveryentryid", srcDeliveryId);
        long deliveryStatusId = this.getDeliveryStatusId(customParams);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"shippingstatus", (Object)deliveryStatusId);
        Object wbSrcDeliveryStatusId = customParams.getOrDefault("wbsrcdeliverstatus", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"wbsrcdeliverstatus", (Object)wbSrcDeliveryStatusId);
        Object srcDeliveryStatusId = customParams.getOrDefault("srcdeliverystatus", 0L);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"srcdeliverystatus", (Object)srcDeliveryStatusId);
    }

    private void initSupplier(Map<String, Object> customParams) {
        long supplierId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("supplier", 0L));
        if (supplierId != 0L) {
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"supplier", (Object)supplierId);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)1098521642067513344L);
        }
    }

    private void initSaleUnit(Map<String, Object> customParams) {
        long unitId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("unit", 0L));
        DynamicObject goods = (DynamicObject)this.getModel().getValue("goodsid");
        long retailUnitId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"retailunit");
        long defUnitId = unitId == 0L ? retailUnitId : unitId;
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"unit", (Object)defUnitId);
    }

    private void initQty(DynamicObject dataEntity, Object saleQty, Map<String, Object> customParams) {
        boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
        if (!isChangeReturnOrReturn) {
            this.initOtherQty(dataEntity, CommonUtil.formatObjectToDecimal((Object)saleQty));
        } else {
            Object baseQty = customParams.getOrDefault("baseunitqty", BigDecimal.ZERO);
            this.getModel().setValue("baseunitqty", baseQty);
            Object stockQty = customParams.getOrDefault("stockunitqty", BigDecimal.ZERO);
            this.getModel().setValue("stockunitqty", stockQty);
        }
    }

    private void initSaleAmt(DynamicObject dataEntity, Map<String, Object> customParams) {
        Object isCheckPresent = customParams.getOrDefault("ischeckpresent", Boolean.FALSE);
        this.getModel().setValue("ischeckpresent", isCheckPresent);
        boolean isNew = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("type", Boolean.FALSE));
        if (isNew) {
            this.updateRetailPrice(dataEntity);
            BigDecimal sumAmount = CommonUtil.formatObjectToDecimal((Object)customParams.get("sumamount"));
            this.getModel().setValue("sumamount", (Object)sumAmount);
            BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"retailprice");
            this.getModel().setValue("retailprice", (Object)retailPrice);
            FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"retailprice", (Object)BigDecimal.ZERO, (Object)retailPrice, (int)0);
            this.getModel().setValue("discountrate", (Object)100);
        } else {
            BigDecimal retailPrice = CommonUtil.formatObjectToDecimal((Object)customParams.get("retailprice"));
            this.getModel().setValue("retailprice", (Object)retailPrice);
            boolean isControlPrice = CommonUtil.formatObjectToBoolean((Object)customParams.get("iscontrolprice"));
            this.getModel().setValue("iscontrolprice", (Object)isControlPrice);
            Object policyTypeName = customParams.getOrDefault("pricetypename", "");
            this.getModel().setValue("pricetypename", policyTypeName);
            Object policyTypeId = customParams.getOrDefault("priority", 0L);
            this.getModel().setValue("pricetype", policyTypeId);
            Object saleAttr = customParams.getOrDefault("saleattr", 0L);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saleattr", (Object)saleAttr);
            BigDecimal discountPrice = CommonUtil.formatObjectToDecimal((Object)customParams.get("discountprice"));
            this.getModel().setValue("discountprice", (Object)discountPrice);
            BigDecimal realPrice = CommonUtil.formatObjectToDecimal((Object)customParams.get("realprice"));
            this.getModel().setValue("realprice", (Object)realPrice);
            BigDecimal discountRate = CommonUtil.formatObjectToDecimal((Object)customParams.get("discountrate"));
            this.getModel().setValue("discountrate", (Object)discountRate);
            this.initOtherAmt(dataEntity, customParams);
        }
    }

    private void initOtherAmt(DynamicObject dataEntity, Map<String, Object> customParams) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key;
            if (!(property instanceof AmountProp) || !customParams.containsKey(key = property.getName())) continue;
            Object amt = customParams.getOrDefault(key, BigDecimal.ZERO);
            this.getModel().setValue(key, amt);
        }
    }

    private void initStockType(Map<String, Object> customParams) {
        long stockTypeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("channelstocktypeid", 0L));
        if (stockTypeId == 0L) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
            if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.RESERVE.getId() || billTypeId == BillTypeEnum.STORE.getId() || billTypeId == BillTypeEnum.CVTSALE.getId() && DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm")) {
                stockTypeId = this.getDefInvTypeFromAppParam(dataEntity, false);
            } else if (billTypeId == BillTypeEnum.CHANGE.getId()) {
                String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
                String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
                stockTypeId = (StringUtils.equals((CharSequence)changeType, (CharSequence)"1") || StringUtils.equals((CharSequence)changeType, (CharSequence)"2")) && StringUtils.equals((CharSequence)saleOption, (CharSequence)"1") ? this.getDefInvTypeFromAppParam(dataEntity, false) : this.getDefInvTypeFromAppParam(dataEntity, true);
            } else {
                stockTypeId = 688884005529250816L;
            }
        }
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"channelstocktypeid", (Object)stockTypeId);
    }

    private void initSaleQty(DynamicObject dataEntity) {
        this.getModel().beginInit();
        BigDecimal saleQty = BigDecimal.ONE;
        if (CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity)) {
            saleQty = BigDecimal.ONE.negate();
        }
        this.getModel().setValue("saleqty", (Object)saleQty);
        this.getModel().endInit();
        this.getView().updateView("saleqty");
        ChangeData changeData = new ChangeData(0, dataEntity, (Object)BigDecimal.ZERO, (Object)saleQty);
        this.saleQtyChanged(dataEntity, changeData);
    }

    private void updateRetailPrice(DynamicObject dataEntity) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"barcode");
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isEnablePricePolicy = SystemParamUtil.getisEnablePricePolicy((long)bizOrgId, (long)branchId);
        Map policyResult = CommonUtils.getRetailPrice((IFormView)this.getView(), (DynamicObject)dataEntity, (long)goodsId, (long)barCodeId, (boolean)isEnablePricePolicy);
        BigDecimal retailPrice = CommonUtil.formatObjectToDecimal(policyResult.get("retailprice"));
        boolean isControlPrice = CommonUtil.formatObjectToBoolean(policyResult.get("iscontrolprice"));
        Object policyTypeName = policyResult.get("pricetypename");
        Object policyTypeId = policyResult.get("pricetype");
        Object saleAttr = policyResult.get("saleattr");
        dataEntity.set("retailprice", (Object)retailPrice);
        this.getView().updateView("retailprice");
        this.getModel().setValue("iscontrolprice", (Object)isControlPrice);
        this.getModel().setValue("pricetypename", policyTypeName);
        this.getModel().setValue("pricetype", policyTypeId);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saleattr", saleAttr);
        this.getView().setEnable(Boolean.valueOf(!isControlPrice), new String[]{"iscontrolprice"});
    }

    private void amtPropertyChanged(DynamicObject dataEntity, ChangeData changeData, String fieldKey) {
        BigDecimal newValue = CommonUtil.formatObjectToDecimal((Object)changeData.getNewValue());
        String oldChangeValue = "";
        boolean isCalculateAmt = false;
        switch (fieldKey) {
            case "saleqty": {
                isCalculateAmt = true;
                this.saleQtyChanged(dataEntity, changeData);
                break;
            }
            case "deposit": {
                oldChangeValue = this.getPageCache().get("PageCache_" + fieldKey);
                isCalculateAmt = true;
                this.depositChanged(dataEntity, changeData);
                break;
            }
            case "finalpayment": 
            case "finalpaymentscale": 
            case "depositscale": {
                oldChangeValue = this.getPageCache().get("PageCache_" + fieldKey);
                isCalculateAmt = true;
                break;
            }
            case "isbook": {
                isCalculateAmt = true;
                this.isBookChanged(dataEntity, changeData);
                break;
            }
            case "discountprice": 
            case "discountrate": 
            case "manualdiscount": 
            case "promotiondiscount": 
            case "coupondiscount": 
            case "integraldistamount": 
            case "expectfinalamount": 
            case "notincomedisamount": 
            case "stddiscountamount": 
            case "giftdiscountamount": 
            case "ticketshareamount": {
                isCalculateAmt = true;
                break;
            }
        }
        if (isCalculateAmt && StringUtils.isBlank((CharSequence)oldChangeValue)) {
            if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"saleqty")) {
                this.updateAmtByQty(dataEntity, newValue);
            } else {
                this.updateAmt(dataEntity, fieldKey, newValue);
            }
            this.getView().updateView();
        }
    }

    private void invPropertyChanged(DynamicObject dataEntity, ChangeData changeData, String fieldKey) {
        boolean isUpdateInv = false;
        switch (fieldKey) {
            case "isdelivery": {
                isUpdateInv = true;
                this.isDeliveryChanged(dataEntity, changeData);
                break;
            }
            case "inventoryorgid": {
                this.invOrgChanged(dataEntity, changeData);
                break;
            }
            case "erpstockid": {
                this.stockChanged(dataEntity, changeData);
                break;
            }
            case "channelstocktypeid": {
                isUpdateInv = true;
                this.stockTypeChanged(dataEntity);
                break;
            }
            case "deliverytime": 
            case "admindivisionid": {
                isUpdateInv = true;
                break;
            }
        }
        if (isUpdateInv && !this.isFromGoods) {
            isNeedInitMode = true;
            this.updateInv(dataEntity, fieldKey);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"isdelivery")) {
            this.setEnableAboutSelf(dataEntity);
        }
    }

    private void saleContentChanged(ChangeData changeData) {
        DynamicObject saleContent = (DynamicObject)changeData.getNewValue();
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)saleContent, (String)"barcodeid");
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"barcode", (Object)barCodeId);
    }

    private void goodsChanged(DynamicObject dataEntity, ChangeData changeData) {
        DynamicObject goods = (DynamicObject)changeData.getNewValue();
        if (goods != null) {
            List<DynamicObject> lstBarCode;
            boolean isItemsRight;
            this.isFromGoods = true;
            if (!isFromBarcode && !(isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)dataEntity, (DynamicObject)goods))) {
                this.getModel().beginInit();
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsid", (Object)0L);
                this.getView().updateView("goodsid");
                this.getModel().endInit();
                return;
            }
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
            this.setMustInputAboutSerialNumber(dataEntity);
            if (!isFromBarcode && !CollectionUtils.isEmpty(lstBarCode = this.getBarCodeByGoodsId(dataEntity))) {
                DynamicObject barCode = lstBarCode.get(0);
                dataEntity.set("barcode", (Object)barCode);
                long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)barCode);
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"barcode", null, (Object)barCodeId, (int)0);
            }
            isFromBarcode = false;
            String operationModel = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
            this.updateOperationModel(operationModel);
            long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"barcode");
            if (barCodeId != 0L) {
                this.updateGoodsClass(goodsId);
                long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
                long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
                boolean isEnablePricePolicy = SystemParamUtil.getisEnablePricePolicy((long)bizOrgId, (long)branchId);
                CommonUtils.setRetailPrice((IFormView)this.getView(), (DynamicObject)dataEntity, (long)goodsId, (long)barCodeId, (int)0, (boolean)isEnablePricePolicy);
                this.getView().updateView();
                BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"retailprice");
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)dataEntity, (String)"retailprice", (Object)BigDecimal.ZERO, (Object)retailPrice, (int)0);
                this.updateGiftValue();
                this.initSaleQty(dataEntity);
            }
            this.resetIsBook(dataEntity);
            this.getView().setEnable(Boolean.TRUE, new String[]{"isselfpickup"});
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"supplier", (Object)0L);
            isNeedInitMode = true;
            boolean isDelivery = this.getIsDelivery(goods);
            this.getModel().setValue("isdelivery", (Object)isDelivery);
            this.getModel().setValue("inventoryorgid", null);
            this.getModel().setValue("erpstockid", null);
            this.updateInv(dataEntity, "");
        }
    }

    private void barCodeChanged(DynamicObject dataEntity, ChangeData changeData) {
        DynamicObject barCode = (DynamicObject)changeData.getNewValue();
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
        boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)dataEntity, (DynamicObject)goods);
        if (!isItemsRight) {
            dataEntity.set("barcode", null);
            return;
        }
        isFromBarcode = true;
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsid", (Object)goodsId);
    }

    private void salerChanged(ChangeData changeData) {
        DynamicObject saler = (DynamicObject)changeData.getNewValue();
        long deptId = 0L;
        if (!ObjectUtils.isEmpty((Object)saler)) {
            DynamicObject dept = (DynamicObject)CommonUtils.getDeptObj((DynamicObject)saler);
            deptId = DynamicObjectUtils.getPkValue((DynamicObject)dept);
        }
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"saledepartment", (Object)deptId);
    }

    private void saleQtyChanged(DynamicObject dataEntity, ChangeData changeData) {
        BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)changeData.getNewValue());
        this.initOtherQty(dataEntity, saleQty);
        if (saleQty.compareTo(BigDecimal.ZERO) > 0) {
            this.updateAmtByQty(dataEntity, saleQty);
            this.updateGiftValue(dataEntity, saleQty);
            isNeedInitMode = true;
            if (!this.isFromGoods) {
                this.updateInv(dataEntity, "");
            }
        }
    }

    private void isBookChanged(DynamicObject dataEntity, ChangeData changeData) {
        boolean isBook = CommonUtil.formatObjectToBoolean((Object)changeData.getNewValue());
        this.isBookChanged(dataEntity, isBook);
    }

    private void isBookChanged(DynamicObject dataEntity, boolean isBook) {
        if (isBook) {
            this.clearOverSaleFields(dataEntity);
            dataEntity.set("booktype", (Object)"1");
            this.getView().updateView("booktype");
            this.setMustInputAboutBook(dataEntity, Boolean.TRUE);
        } else {
            this.setMustInputAboutBook(dataEntity, Boolean.FALSE);
        }
        this.setMustInputAboutSerialNumber(dataEntity);
        boolean isBookNeedInv = this.checkModeAndStock(dataEntity);
        if (!(isBook && !isBookNeedInv || this.isFromGoods)) {
            isNeedInitMode = true;
            this.updateInv(dataEntity, "");
        }
    }

    private void depositChanged(DynamicObject dataEntity, ChangeData changeData) {
        BigDecimal balAmount;
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
        if (!isBook) {
            return;
        }
        BigDecimal newDeposit = CommonUtil.formatObjectToDecimal((Object)changeData.getNewValue());
        if (newDeposit.compareTo(balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"balamount")) == 0) {
            this.getModel().setValue("bookpaytype", (Object)"0");
        } else {
            this.getModel().setValue("bookpaytype", (Object)"1");
        }
    }

    private void invOrgChanged(DynamicObject dataEntity, ChangeData changeData) {
        DynamicObject stockOrg = (DynamicObject)changeData.getNewValue();
        this.stockOrgChanged(dataEntity, stockOrg);
    }

    private void stockOrgChanged(DynamicObject dataEntity, DynamicObject stockOrg) {
        boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
        if (!isSelfPickup) {
            this.setMustInputAboutStock(stockOrg);
        }
        dataEntity.set("keepertype", (Object)"bos_org");
        dataEntity.set("keeperid", (Object)stockOrg);
        dataEntity.set("ownertype", (Object)"bos_org");
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)stockOrg);
        dataEntity.set("ownerid", (Object)InventoryUtils.getDefaultOwner((long)stockOrgId));
        this.getView().updateView();
        this.getModel().setValue("deliveryserialnumber", null);
    }

    public void stockChanged(DynamicObject dataEntity, ChangeData changeData) {
        this.getModel().setValue("data", null);
        DynamicObject stock = (DynamicObject)changeData.getNewValue();
        if (stock == null) {
            this.clearOverSaleFields(dataEntity);
            return;
        }
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (bizOrgId == 0L) {
            return;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)bizOrgId, (long)branchId);
        List invOrgIds = InventoryUtils.getInvOrgIds((long)bizOrgId, (String)invQueryRange);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock);
        List invOrgIdsByStock = InventoryUtils.getInvOrgIdsByStock((long)stockId);
        invOrgIds.retainAll(invOrgIdsByStock);
        if (!CollectionUtils.isEmpty((Collection)invOrgIds)) {
            long stockOrgId = (Long)invOrgIds.get(0);
            if (stockOrgId != invOrgId) {
                this.getModel().setValue("inventoryorgid", (Object)stockOrgId);
            }
            isNeedInitMode = true;
            this.updateInv(dataEntity, "erpstockid");
        }
    }

    public void stockTypeChanged(DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
            if (!isNotConfirm) {
                return;
            }
        } else if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                return;
            }
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            if (!StringUtils.equals((CharSequence)changeType, (CharSequence)"2")) {
                return;
            }
        } else if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        boolean isEnablePricePolicy = SystemParamUtil.getisEnablePricePolicy((long)orgId, (long)branchId);
        if (!isEnablePricePolicy) {
            return;
        }
        this.updateGiftValue();
        this.updateRetailPrice(dataEntity);
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"retailprice");
        this.getModel().setValue("discountprice", (Object)retailPrice);
    }

    private void supplierChanged(DynamicObject dataEntity, ChangeData changeData) {
        DynamicObject supplier = (DynamicObject)changeData.getNewValue();
        if (ObjectUtils.isEmpty((Object)supplier)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isdelivery"});
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)0L);
            this.getModel().setValue("isdelivery", (Object)Boolean.FALSE);
            return;
        }
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)1098521642067513344L);
        this.getModel().setValue("isdelivery", (Object)Boolean.TRUE);
        this.getView().setEnable(Boolean.FALSE, new String[]{"isdelivery"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"deliverytime", "customername", "customerphone", "admindivisionid", "customeraddress"});
        String operationModel = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isselfpickup"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isselfpickup"});
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long supplierId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"supplier");
        List list = RetailChainHelper.queryRetailChain((long)goodsId, (long)branchId, (long)supplierId);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            DynamicObject retailChain = BusinessDataServiceHelper.loadSingle(list.get(0), (String)"ocdbd_retailchain");
            long purOrgId = DynamicObjectUtils.getPkValue((DynamicObject)retailChain, (String)"purchaseorg");
            long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)retailChain, (String)"inventoryorgid");
            if (invOrgId == 0L) {
                invOrgId = InventoryUtils.getDefaultInvOrgIdByPur((long)purOrgId);
            }
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"inventoryorgid", (Object)invOrgId);
            long erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)retailChain, (String)"warehouse");
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"erpstockid", (Object)erpStockId);
        }
    }

    private void isDeliveryChanged(DynamicObject dataEntity, ChangeData changeData) {
        boolean isDelivery = CommonUtil.formatObjectToBoolean((Object)changeData.getNewValue());
        this.isFromDelivery = true;
        this.setMustInputAboutDelivery(changeData.getNewValue());
        this.setMustInputAboutSerialNumber(dataEntity);
        if (isDelivery) {
            this.getModel().setValue("selfpickuptime", null);
            this.clearInventoryInfo(dataEntity);
            this.getModel().setValue("isselfpickup", (Object)Boolean.FALSE);
        } else {
            this.getModel().setValue("deliverytime", null);
            boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
            if (!isSelfPickup) {
                this.clearInventoryInfo(dataEntity);
            }
        }
    }

    private void isSelfPickupChanged(DynamicObject dataEntity, ChangeData changeData) {
        boolean isSelfPickup = CommonUtil.formatObjectToBoolean((Object)changeData.getNewValue());
        this.setMustInputAboutSelfPickup(isSelfPickup);
        this.setMustInputAboutSerialNumber(dataEntity);
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        if (isSelfPickup) {
            isNeedInitMode = true;
            if (isDelivery) {
                this.getModel().setValue("isdelivery", (Object)Boolean.FALSE);
                this.updateModeWithoutRule(dataEntity);
            } else if (!this.isFromDelivery) {
                this.updateInv(dataEntity, "");
            }
        } else {
            if (!isDelivery) {
                isNeedInitMode = true;
                this.updateInv(dataEntity, "");
            } else {
                dataEntity.set("selfpickuptime", null);
                this.getView().updateView("selfpickuptime");
            }
            DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
            this.setMustInputAboutStock(stockOrg);
        }
        this.setEnableAboutSelf(dataEntity);
    }

    private void serialNumberChanged(ChangeData changeData) {
        String newValue = CommonUtil.formatStringToEmpty((Object)changeData.getNewValue());
        if (StringUtils.isBlank((CharSequence)newValue)) {
            this.getModel().setValue("snmainfile", null);
            this.getModel().setValue("deliverylotnum", null);
        }
    }

    private void setMustInput() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object isDelivery = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"isdelivery");
        this.setMustInputAboutDelivery(isDelivery);
        Object isInstall = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"isinstall");
        this.setMustInputAboutInstall(isInstall);
        Object isBook = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"isbook");
        this.setMustInputAboutBook(dataEntity, isBook);
        Object isSelfPickup = this.getModel().getValue("isselfpickup");
        this.setMustInputAboutSelfPickup(isSelfPickup);
        Object invOrg = this.getModel().getValue("inventoryorgid");
        this.setMustInputAboutStock(invOrg);
        this.setMustInputAboutSerialNumber(dataEntity);
        FormViewUtil.setMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"distributionmode"});
    }

    private void setMustInputAboutDelivery(Object value) {
        boolean isDelivery = CommonUtil.formatObjectToBoolean((Object)value);
        FormViewUtil.setMustInput((boolean)isDelivery, (IFormView)this.getView(), (String[])new String[]{"admindivisionid", "customeraddress", "deliverytime", "customername", "customerphone"});
    }

    private void setMustInputAboutInstall(Object value) {
        boolean isInstall = CommonUtil.formatObjectToBoolean((Object)value);
        FormViewUtil.setMustInput((boolean)isInstall, (IFormView)this.getView(), (String[])new String[]{"installtime"});
    }

    private void setMustInputAboutSelfPickup(Object value) {
        boolean isSelfPickup = CommonUtil.formatObjectToBoolean((Object)value);
        FormViewUtil.setMustInput((boolean)isSelfPickup, (IFormView)this.getView(), (String[])new String[]{"selfpickuptime", "inventoryorgid"});
    }

    private void setMustInputAboutBook(DynamicObject dataEntity, Object value) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        boolean isBook = CommonUtil.formatObjectToBoolean((Object)value);
        FormViewUtil.setMustInput((boolean)isBook, (IFormView)this.getView(), (String[])new String[]{"expecttakeorderdate", "booktype"});
    }

    private void setMustInputAboutStock(Object value) {
        boolean invOrgIsBlank = ObjectUtils.isEmpty((Object)value);
        FormViewUtil.setMustInput((!invOrgIsBlank ? 1 : 0) != 0, (IFormView)this.getView(), (String[])new String[]{"erpstockid"});
    }

    private void setMustInputAboutSerialNumber(DynamicObject dataEntity) {
        DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"materialinv");
        boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
        boolean isSerialNumberMustInput = isEnableSerial && !isDelivery && !isSelfPickup && !isBook;
        String saleOption = dataEntity.getString("saleoption");
        if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            return;
        }
        FormViewUtil.setMustInput((boolean)isSerialNumberMustInput, (IFormView)this.getView(), (String[])new String[]{"deliveryserialnumber"});
    }

    private void setEnable() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        this.setEnableAboutIsBook(billTypeId);
        DynamicObject supplier = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"supplier");
        this.getView().setEnable(Boolean.valueOf(supplier == null), new String[]{"isdelivery"});
        String operationModel = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
        if (supplier != null && StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isselfpickup"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isselfpickup"});
        }
        this.setEnableAboutSelf(dataEntity);
        boolean isControlPrice = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"iscontrolprice");
        this.getView().setEnable(Boolean.valueOf(!isControlPrice), new String[]{"iscontrolprice"});
    }

    private void setEnableAboutIsBook(long billTypeId) {
        if (billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.RESERVE.getId()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"isbook"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"isbook"});
        }
    }

    private void setEnableAboutSelf(DynamicObject dataEntity) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        this.getView().setEnable(Boolean.valueOf(!isDelivery), new String[]{"selfpickuptime"});
        boolean isSelfPickUp = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
        FormViewUtil.setMustInput((boolean)isSelfPickUp, (IFormView)this.getView(), (String[])new String[]{"selfpickuptime"});
    }

    private void setVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.STORE.getId() || billTypeId == BillTypeEnum.RESERVE.getId()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_RAN});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_RAN});
        }
    }

    private void showQueryInventory(DynamicObject dataEntity) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        params.put("owner", branchId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        params.put("itemIdSet", Collections.singletonList(goodsId));
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)saleOrgId, (long)branchId);
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        if (StringUtils.equals((CharSequence)invQueryRange, (CharSequence)"0") && stockOrgId == 0L) {
            stockOrgId = InventoryUtils.getDefaultInvOrgId((long)saleOrgId);
        }
        params.put("stockOrgId", stockOrgId);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        params.put("currency", currencyId);
        params.put("extQTyShow", Boolean.TRUE);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_valiableinv_stand", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, params);
        this.getView().showForm(parameter);
    }

    private void returnDataToParent(DynamicObject dataEntity, Object deliveryData, String opKey) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(3);
        int index = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"index");
        returnData.put("index", index);
        returnData.put("status", "SUCCESS");
        returnData.put("data", dataEntity);
        returnData.put("deliveryData", deliveryData);
        returnData.put("operation", opKey);
        this.getView().setReturnData(returnData);
        this.getView().close();
    }

    private void returnDataToParent(DynamicObject dataEntity) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        int index = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"index");
        map.put("index", index);
        map.put("status", "FAILURE");
        map.put("data", null);
        this.getView().setReturnData(map);
        this.getView().close();
    }

    private void updateCache(String value) {
        IPageCache cache = this.getPageCache();
        cache.put("operation", value);
    }

    private void clearCache() {
        IPageCache cache = this.getPageCache();
        cache.remove("operation");
    }

    private void clearInventoryInfo(DynamicObject dataEntity) {
        dataEntity.set("inventoryorgid", null);
        this.getView().updateView("inventoryorgid");
        dataEntity.set("erpstockid", null);
        this.getView().updateView("erpstockid");
        this.stockOrgChanged(dataEntity, null);
    }

    private void resetIsBook(DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        boolean isReserveBill = billTypeId == BillTypeEnum.RESERVE.getId();
        dataEntity.set("isbook", (Object)isReserveBill);
        this.getView().updateView();
        this.isBookChanged(dataEntity, isReserveBill);
    }

    private void updateAmt(DynamicObject dataEntity, String fieldKey, BigDecimal value) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
        if (!isChangeReturnOrReturn) {
            SaleAmountHelper.updateSaleAmountFields((DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)fieldKey, (BigDecimal)value);
        } else {
            SaleAmountHelper.updateReturnAmountFields((DynamicObject)dataEntity, (DynamicObject)dataEntity, (long)billTypeId, (String)fieldKey, (BigDecimal)value);
        }
        this.getView().updateView();
    }

    private void updateAmtByQty(DynamicObject dataEntity, BigDecimal value) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            SaleAmountHelper.updateCvtAmountFieldsByQty((DynamicObject)dataEntity, (long)billTypeId, (DynamicObject)dataEntity);
        } else {
            boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
            if (isChangeReturnOrReturn) {
                SaleAmountHelper.updateReturnAmountFieldsByQty((DynamicObject)dataEntity, (long)billTypeId, (DynamicObject)dataEntity);
            } else {
                SaleAmountHelper.updateSaleAmountFields((DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"saleqty", (BigDecimal)value);
            }
        }
        this.getView().updateView();
    }

    private void updateOperationModel(String operationModel) {
        if (StringUtils.isBlank((CharSequence)operationModel)) {
            this.getModel().setValue("operationmodel", (Object)"1");
        }
    }

    private void updateGiftValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
        if (!isPresent) {
            return;
        }
        BigDecimal giftPrice = SaleAmountHelper.getGiftPrice((DynamicObject)dataEntity, null, (boolean)false);
        dataEntity.set("giftprice", (Object)giftPrice);
        this.getView().updateView("giftprice");
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty");
        dataEntity.set("giftvalue", (Object)giftPrice.multiply(saleQty));
        this.getView().updateView("giftvalue");
    }

    private void updateGiftValue(DynamicObject dataEntity, BigDecimal saleQty) {
        BigDecimal giftPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"giftprice");
        this.getModel().setValue("giftvalue", (Object)giftPrice.multiply(saleQty));
    }

    private void beforeManualDiscountFieldPostBack(BeforeFieldPostBackEvent e) {
        BigDecimal fieldValue;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String tip = SaleAmountHelper.manualDiscountChanged((DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"manualdiscount", (BigDecimal)(fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue())));
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView("manualdiscount");
            e.setCancel(true);
        }
    }

    private void beforeQtyFieldPostBack(BeforeFieldPostBackEvent e) {
        BigDecimal saleQty;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isReturnRow = this.isReturnRowData(dataEntity);
        if (isReturnRow) {
            long srcDeliveryId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"srcdeliveryentryid");
            QFilter filter = new QFilter("goodsentryentity.salesorderdelivery.id", "=", (Object)srcDeliveryId);
            String selectFields = String.join((CharSequence)",", "goodsentryentity.salesorderdelivery.deliverisdelivery", "goodsentryentity.salesorderdelivery.deliverystatus.id");
            DynamicObject data = QueryServiceHelper.queryOne((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray());
            if (data != null) {
                boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"goodsentryentity.salesorderdelivery.deliverisdelivery");
                long deliveryStatusId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"goodsentryentity.salesorderdelivery.deliverystatus.id");
                if (isDelivery && deliveryStatusId != DeliveryStatus.SALE_OUTBOUND && deliveryStatusId != DeliveryStatus.SALE_SIGNED) {
                    NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u5546\u54c1\u975e\u51fa\u5e93\u7b7e\u6536\u72b6\u6001\uff0c\u65e0\u6cd5\u505a\u90e8\u5206\u9000/\u6362\u8d27\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (IFormView)this.getView());
                    e.setCancel(true);
                    this.getView().updateView("saleqty");
                    return;
                }
            }
        }
        if (!this.checkQtyScope(dataEntity, saleQty = CommonUtil.formatObjectToDecimal((Object)e.getValue()))) {
            e.setCancel(true);
            this.getView().updateView("saleqty");
            return;
        }
        boolean inventory = this.checkInventory(dataEntity, saleQty);
        if (!inventory) {
            e.setCancel(true);
            this.getView().updateView("saleqty");
        }
    }

    private void beforeDepositFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        boolean isReturnRow = this.isReturnRowData(dataEntity);
        if (isReturnRow) {
            return;
        }
        String tip = SaleAmountHelper.depositChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"deposit", (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView("deposit");
            e.setCancel(true);
        }
    }

    private void beforeDepositScaleFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        boolean isReturnRow = this.isReturnRowData(dataEntity);
        if (isReturnRow) {
            return;
        }
        String tip = SaleAmountHelper.depositScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"depositscale", (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView("depositscale");
            e.setCancel(true);
        }
    }

    private void beforeFinalPaymentScaleFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.finalPaymentScaleChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)fieldKey, (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey);
            e.setCancel(true);
        }
    }

    private void beforeFinalPaymentFieldPostBack(BeforeFieldPostBackEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = SaleAmountHelper.finalPaymentChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"finalpayment", (BigDecimal)fieldValue);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView("finalpayment");
            e.setCancel(true);
        }
    }

    private void beforeAboutBalAmountFieldPostBack(BeforeFieldPostBackEvent e, String fieldKey) {
        BigDecimal fieldValue;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String tip = SaleAmountHelper.checkBalAmount((DynamicObject)dataEntity, (String)fieldKey, (BigDecimal)(fieldValue = CommonUtil.formatObjectToDecimal((Object)e.getValue())));
        if (!StringUtils.isBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            this.getView().updateView(fieldKey);
            e.setCancel(true);
        }
    }

    public void beforeSaleContentF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (branchId == 0L || bizOrgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f00\u5355\u95e8\u5e97\u6216\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        if (SystemParamUtil.getIsEnableUserScopes((long)bizOrgId, (long)branchId)) {
            DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"goodssaler");
            long salerId = DynamicObjectUtils.getPkValue((DynamicObject)saler, (String)"sysuser");
            long saleDeptId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saledepartment");
            if (salerId == 0L || saleDeptId == 0L) {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u542f\u7528\u4e86\u4eba\u5458\u53ef\u9500\u8303\u56f4\u63a7\u5236\uff0c\u8bf7\u5148\u5f55\u5165\u9500\u552e\u5458\u548c\u9500\u552e\u90e8\u95e8\u4fe1\u606f\u3002", (IFormView)this.getView());
                e.setCancel(true);
                return;
            }
        }
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        HashMap<String, Long> customParams = new HashMap<String, Long>(3);
        customParams.put("channelid", branchId);
        customParams.put("currencyid", currencyId);
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        parameter.setBillFormId("ocpos_salecontent");
        parameter.setCustomParams(customParams);
        parameter.setCaption("\u5546\u54c1\u5217\u8868");
        parameter.setFormId("ocpos_goods_listf7");
        parameter.setMultiSelect(false);
        parameter.setShowApproved(false);
        parameter.setShowFilter(false);
        parameter.setShowQuickFilter(false);
        parameter.setShowTitle(true);
        QFilter filter = PosItemUtil.getSaleContentFilter((long)branchId, (long)currencyId, (String)"");
        ListFilterParameter filterParameter = new ListFilterParameter(Collections.singletonList(filter), null);
        parameter.setListFilterParameter(filterParameter);
    }

    private void updateGoodsClass(Object goodsId) {
        try {
            DynamicObject classStandardApply = CommonUtils.getClassstdApply((String)"1");
            if (ObjectUtils.isEmpty((Object)classStandardApply)) {
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsclass", (Object)0L);
                return;
            }
            QFilter filter = new QFilter("id", "=", goodsId);
            filter.and("itemclassentity.classstandardid", "=", (Object)DynamicObjectUtils.getLong((DynamicObject)classStandardApply, (String)"classstandardid"));
            String selectField = "itemclassentity.goodsclasssid";
            DynamicObject classObj = QueryServiceHelper.queryOne((String)"ocdbd_iteminfo", (String)selectField, (QFilter[])filter.toArray());
            long classId = DynamicObjectUtils.getLong((DynamicObject)classObj, (String)selectField);
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsclass", (Object)classId);
        }
        catch (Exception ex) {
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"goodsclass", (Object)0L);
        }
    }

    private boolean isReturnRowData(DynamicObject dataEntity) {
        return CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
    }

    private void updateInv(DynamicObject dataEntity, String key) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        if (goodsId <= 0L) {
            return;
        }
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty");
        if (saleQty.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3") || StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                return;
            }
        }
        this.getView().showLoading(new LocaleString("\u5339\u914d\u5e93\u5b58\u4e2d..."));
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
        String operationMode = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
        boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
        long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"itemtypeid");
        boolean isService = itemsTypeId == 870946434386494464L;
        boolean isAmt = itemsTypeId == 870946349007286272L;
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        boolean isVenderSell = distributionModeId == 1098521642067513344L;
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        if (isVenderSell) {
            this.getView().hideLoading();
            return;
        }
        if (isBook || isJoint || isService || isAmt || isInitBill) {
            boolean isNeedInv = this.checkModeAndStock(dataEntity);
            if (isNeedInv || !this.notNeedInv.contains(key)) {
                this.updateMode(dataEntity, isJoint, isService, isAmt);
            }
            this.getView().hideLoading();
            return;
        }
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        if (isDelivery) {
            this.updateInvWithDelivery(dataEntity);
        } else {
            this.updateInvWithoutDelivery(dataEntity);
        }
        this.getView().hideLoading();
    }

    private boolean checkInventory(DynamicObject dataEntity, BigDecimal saleQty) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return true;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3") || StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                return true;
            }
        }
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
        String operationMode = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
        boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
        long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"itemtypeid");
        boolean isService = itemsTypeId == 870946434386494464L;
        boolean isAmt = itemsTypeId == 870946349007286272L;
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        boolean isVendorSell = distributionModeId == 1098521642067513344L;
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        if (isVendorSell || isBook || isJoint || isService || isAmt || isInitBill) {
            return true;
        }
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        if (isDelivery) {
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
            Map<String, Object> params = this.getDeliveryParams(dataEntity, saleQty, true);
            Map deliveryInfo = SaleOrderDeliveryInfoHelper.getDeliveryInfo(params, (boolean)isPresent);
            if (CollectionUtils.isEmpty((Map)deliveryInfo)) {
                NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38\u3002", (IFormView)this.getView());
                return false;
            }
            boolean isSuccess = CommonUtil.formatObjectToBoolean(deliveryInfo.get("isSuccess"));
            if (!isSuccess) {
                String errorMsg = CommonUtil.formatStringToEmpty(deliveryInfo.get("errorMsg"));
                NotificationUtil.showDefaultTipNotify((String)errorMsg, (IFormView)this.getView());
                return false;
            }
        } else {
            boolean isRight = this.initInvWithoutDelivery(dataEntity);
            if (!isRight) {
                return true;
            }
            DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"channelstocktypeid");
            DynamicObject invOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
            DynamicObject stock = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"erpstockid");
            if (invType == null || invOrg == null || stock == null) {
                return true;
            }
            List<JSONObject> params = this.getInventoryParams(dataEntity, saleQty, true);
            List inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(params);
            if (CollectionUtils.isEmpty((Collection)inventoryInfo)) {
                NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
                return false;
            }
            JSONObject inventoryItem = (JSONObject)inventoryInfo.get(0);
            String invStatus = inventoryItem.getString("invstatus");
            if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
                return false;
            }
        }
        return true;
    }

    private void updateInvWithDelivery(DynamicObject dataEntity) {
        boolean isPresent;
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        if (StringUtils.isBlank((CharSequence)adminDivisionId) || StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0") || StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"1000001")) {
            this.updateModeWithoutRule(dataEntity);
            return;
        }
        Map<String, Object> params = this.getDeliveryParams(dataEntity, BigDecimal.ZERO, false);
        Map deliveryInfo = SaleOrderDeliveryInfoHelper.getDeliveryInfo(params, (boolean)(isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent")));
        if (CollectionUtils.isEmpty((Map)deliveryInfo)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u67e5\u8be2\u5f02\u5e38\u3002", (IFormView)this.getView());
            this.clearMode(dataEntity);
        } else {
            boolean isSuccess = CommonUtil.formatObjectToBoolean(deliveryInfo.get("isSuccess"));
            if (!isSuccess) {
                String errorMsg = CommonUtil.formatStringToEmpty(deliveryInfo.get("errorMsg"));
                NotificationUtil.showDefaultTipNotify((String)errorMsg, (IFormView)this.getView());
                this.clearMode(dataEntity);
            } else {
                Map deliveryData = (Map)deliveryInfo.get("deliveryData");
                this.updateInvWithDelivery(dataEntity, deliveryData);
            }
        }
    }

    private void updateInvWithDelivery(DynamicObject dataEntity, Map<String, Object> deliveryData) {
        Object returnData = deliveryData.get("data");
        BigDecimal canOverSaleBaseQty = BigDecimal.ZERO;
        long distributionModeId = 0L;
        long stockOrgId = 0L;
        long stockId = 0L;
        if (returnData != null) {
            Object data;
            this.getModel().setValue("data", (Object)JSONObject.toJSONString((Object)returnData));
            if (returnData instanceof JSONObject) {
                data = (JSONObject)returnData;
                distributionModeId = data.getLongValue("distributionModeId");
                stockOrgId = data.getLongValue("stockorgid");
                stockId = data.getLongValue("stockid");
                canOverSaleBaseQty = data.getBigDecimal("canoversalebaseqty");
            } else if (returnData instanceof List && !CollectionUtils.isEmpty((Collection)(data = (List)returnData))) {
                distributionModeId = ((JSONObject)data.get(0)).getLongValue("distributionmodeid");
                stockOrgId = ((JSONObject)data.get(0)).getLongValue("stockorgid");
                stockId = ((JSONObject)data.get(0)).getLongValue("warehouseid");
                canOverSaleBaseQty = ((JSONObject)data.get(0)).getBigDecimal("availablebaseqty");
            }
        }
        Object overSalePolicyId = deliveryData.get("oversalepolicyid");
        this.getModel().setValue("oversalepolicyid", overSalePolicyId);
        long overSalePolicyEntryId = CommonUtil.formatObejctToLong((Object)deliveryData.get("oversalepolicyentryid"));
        boolean isNegativeSell = CommonUtil.formatObjectToBoolean((Object)deliveryData.get("isnegativesell"));
        if (isNegativeSell) {
            DynamicObject doParentEntity = this.getView().getParentView().getModel().getDataEntity(true);
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doParentEntity, (String)"goodsentryentity");
            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
            BigDecimal baseQty = DynamicObjectUtil.getBigDecimal((DynamicObject)dataEntity, (String)"baseunitqty");
            int seq = 0;
            int rowIndex = DynamicObjectUtil.getInt((DynamicObject)dataEntity, (String)"index");
            if (docGoodsEntry.getRowCount() > rowIndex) {
                seq = DynamicObjectUtil.getInt((DynamicObject)((DynamicObject)docGoodsEntry.get(rowIndex)), (String)"seq");
            }
            int finalSeq = seq;
            List lstGoods = docGoodsEntry.stream().filter(x -> DynamicObjectUtil.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId && DynamicObjectUtil.getLong((DynamicObject)x, (String)"oversalepolicyentryid") == overSalePolicyEntryId && DynamicObjectUtil.getBoolean((DynamicObject)x, (String)"isnegativesell") && DynamicObjectUtil.getInt((DynamicObject)x, (String)"seq") != finalSeq).collect(Collectors.toList());
            BigDecimal totalBaseQty = BigDecimal.ZERO;
            for (DynamicObject goods : lstGoods) {
                totalBaseQty = totalBaseQty.add(DynamicObjectUtil.getBigDecimal((DynamicObject)goods, (String)"baseunitqty"));
            }
            if (canOverSaleBaseQty.compareTo(totalBaseQty = totalBaseQty.add(baseQty)) < 0) {
                isNegativeSell = false;
            }
            if (isNegativeSell) {
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
                this.buildLotNum(dataEntity, true, isPresent);
            }
        } else {
            dataEntity.set("deliverylotnum", null);
        }
        this.getModel().beginInit();
        this.getModel().setValue("isnegativesell", (Object)isNegativeSell);
        this.getModel().setValue("oversalepolicyentryid", (Object)overSalePolicyEntryId);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)distributionModeId);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"inventoryorgid", (Object)stockOrgId);
        DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"erpstockid", (Object)stockId);
        if (stockOrgId != invOrgId) {
            DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
            this.stockOrgChanged(dataEntity, stockOrg);
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    private void updateInvWithoutDelivery(DynamicObject dataEntity) {
        this.updateModeWithoutRule(dataEntity);
        this.clearOverSaleFields(dataEntity);
        boolean isRight = this.initInvWithoutDelivery(dataEntity);
        if (!isRight) {
            return;
        }
        DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"channelstocktypeid");
        DynamicObject invOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
        DynamicObject stock = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"erpstockid");
        if (invType == null || invOrg == null || stock == null) {
            return;
        }
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty");
        List<JSONObject> params = this.getInventoryParams(dataEntity, saleQty, false);
        log.info("\u5e93\u5b58\u4f20\u53c2\uff1a" + JSONObject.toJSONString(params));
        List inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(params);
        log.info("\u5e93\u5b58\u8fd4\u53c2\uff1a" + JSONObject.toJSONString((Object)inventoryInfo));
        if (CollectionUtils.isEmpty((Collection)inventoryInfo)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
        } else {
            JSONObject inventoryItem = (JSONObject)inventoryInfo.get(0);
            String invStatus = inventoryItem.getString("invstatus");
            if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\u3002", (IFormView)this.getView());
                return;
            }
            List detail = inventoryItem.getJSONArray("invdetailinfolist").toJavaList(JSONObject.class);
            if (!CollectionUtils.isEmpty((Collection)detail)) {
                ((JSONObject)detail.get(0)).put("availableqty", (Object)((JSONObject)detail.get(0)).getBigDecimal("availableqty"));
                this.getModel().setValue("data", (Object)JSONObject.toJSONString((Object)detail));
            }
        }
    }

    private void clearMode(DynamicObject dataEntity) {
        dataEntity.set("distributionmode", null);
        this.getView().updateView("distributionmode");
    }

    private void clearOverSaleFields(DynamicObject dataEntity) {
        this.getModel().setValue("isnegativesell", (Object)Boolean.FALSE);
        this.getModel().setValue("oversalepolicyid", (Object)0L);
        this.getModel().setValue("oversalepolicyentryid", (Object)0L);
        long modeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"snmainfile");
        if (modeId != 1098521642067513344L && snMainFileId == 0L) {
            this.getModel().setValue("deliverylotnum", null);
        }
    }

    private void updateMode(DynamicObject dataEntity, boolean isJoint, boolean isService, boolean isAmt) {
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3") || StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                return;
            }
        }
        if (isJoint || isService || isAmt) {
            this.updateModeWithoutRule(dataEntity);
        } else {
            this.updateModeWithRule(dataEntity);
        }
    }

    private void updateModeWithRule(DynamicObject dataEntity) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        if (!isDelivery) {
            this.updateModeWithoutRule(dataEntity);
            return;
        }
        List<JSONObject> params = this.getDistributionRuleParams(dataEntity);
        log.info("\u5171\u4eab\u89c4\u5219\u4f20\u53c2\uff1a" + JSONObject.toJSONString(params));
        List distributionRules = SaleOrderDeliveryInfoHelper.getDistributionRules(params);
        log.info("\u5171\u4eab\u89c4\u5219\u8fd4\u53c2\uff1a" + JSONObject.toJSONString((Object)distributionRules));
        if (CollectionUtils.isEmpty((Collection)distributionRules)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002", (IFormView)this.getView());
            this.clearMode(dataEntity);
            return;
        }
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        long wareHouseId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        JSONObject distributionRule = invOrgId != 0L && wareHouseId != 0L ? (JSONObject)distributionRules.stream().filter(x -> x.getLongValue("stockOrgId") == invOrgId && x.getLongValue("warehouseId") == wareHouseId).findFirst().orElse(null) : (JSONObject)distributionRules.get(0);
        if (distributionRule != null) {
            this.getModel().beginInit();
            long distributionModeId = distributionRule.getLongValue("distributionModeId");
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)distributionModeId);
            long stockOrgId = distributionRule.getLongValue("stockOrgId");
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"inventoryorgid", (Object)stockOrgId);
            long stockId = distributionRule.getLongValue("warehouseId");
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"erpstockid", (Object)stockId);
            this.getModel().endInit();
            this.getView().updateView();
            if (stockOrgId != invOrgId) {
                DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
                this.stockOrgChanged(dataEntity, stockOrg);
            }
        } else {
            NotificationUtil.showDefaultTipNotify((String)"\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002", (IFormView)this.getView());
            this.clearMode(dataEntity);
        }
    }

    private void updateModeWithoutRule(DynamicObject dataEntity) {
        if (isNeedInitMode) {
            String operationMode = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
            boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
            this.updateModeWithoutRule(dataEntity, isJoint);
            this.initInvWithoutDelivery(dataEntity);
            isNeedInitMode = false;
        }
    }

    private void updateModeWithoutRule(DynamicObject dataEntity, boolean isJoint) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isdelivery");
        this.getModel().beginInit();
        if (isDelivery) {
            DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)(isJoint ? 926600963786061824L : 926596489101228032L));
        } else {
            boolean isSelfPickUp = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isselfpickup");
            if (isSelfPickUp) {
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)1188335265681326080L);
            } else {
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)(isJoint ? 926601157210585088L : 926601071999218688L));
            }
        }
        this.getModel().endInit();
        this.getView().updateView("distributionmode");
    }

    private void returnData(DynamicObject dataEntity, String key) {
        boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
        if (!isChangeReturnOrReturn) {
            boolean isAmt;
            boolean isSuccess = true;
            Object deliveryData = null;
            long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
            boolean isVenderSell = distributionModeId == 1098521642067513344L;
            boolean isOverSale = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isnegativesell");
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isbook");
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
            boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
            String operationMode = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"operationmodel");
            boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
            long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"itemtypeid");
            boolean isService = itemsTypeId == 870946434386494464L;
            boolean bl = isAmt = itemsTypeId == 870946349007286272L;
            if (isBook) {
                isSuccess = this.checkDeposit(dataEntity);
            } else {
                if (!isPresent) {
                    isSuccess = this.checkFinalAmt(dataEntity);
                }
                if (isVenderSell) {
                    isSuccess = isSuccess && this.checkVenderSellInv(dataEntity, false, isPresent);
                } else if (isOverSale) {
                    isSuccess = isSuccess && this.checkVenderSellInv(dataEntity, true, isPresent);
                } else if (!(isInitBill || isJoint || isService || isAmt)) {
                    String returnData = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"data");
                    deliveryData = JSONObject.parse((String)returnData);
                }
            }
            if (isSuccess) {
                this.returnDataToParent(dataEntity, deliveryData, key);
            }
        } else {
            this.returnDataToParent(dataEntity, null, key);
        }
    }

    private void beforeItemsInfoF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, String key) {
        IFormView view = this.getView();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (branchId == 0L || orgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f00\u5355\u95e8\u5e97\u6216\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u5e38\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        boolean isEnableUserScopes = SystemParamUtil.getIsEnableUserScopes((long)orgId, (long)branchId);
        long saleManId = 0L;
        long saleDeptId = 0L;
        if (isEnableUserScopes) {
            DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"goodssaler");
            saleManId = DynamicObjectUtils.getPkValue((DynamicObject)saler, (String)"sysuser");
            saleDeptId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saledepartment");
            if (saleManId == 0L || saleDeptId == 0L) {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u4e1a\u52a1\u7ec4\u7ec7\u542f\u7528\u4e86\u4eba\u5458\u53ef\u9500\u8303\u56f4\u63a7\u5236\uff0c\u8bf7\u5148\u5f55\u5165\u9500\u552e\u5458\u548c\u9500\u552e\u90e8\u95e8\u4fe1\u606f\u3002", (IFormView)view);
                e.setCancel(true);
                return;
            }
        }
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        SaleOrderItemF7Filter.beforeItemF7Filter((BeforeF7SelectEvent)e, (IFormView)view, (long)orgId, (long)branchId, (long)currencyId, (String)key, (boolean)isEnableUserScopes, (long)saleDeptId, (long)saleManId, (long)goodsId);
    }

    private void beforeSalerF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f00\u95e8\u95e8\u5e97\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        QFilter filter = F7Util.getSalerFilter((long)branchId);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeSaleDeptF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"goodssaler");
        if (saler == null) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u5458\u4fe1\u606f\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        QFilter filter = F7Util.getSaleDeptFilter((DynamicObject)saler);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeInvOrgF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        QFilter filter;
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (orgId == 0L || branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e1a\u52a1\u7ec4\u7ec7\u6216\u5f00\u5355\u95e8\u5e97\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)orgId, (long)branchId);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        if (stockId == 0L) {
            filter = F7Util.getStockOrgFilter((long)orgId, (String)invQueryRange);
        } else {
            List invOrgIds = InventoryUtils.getInvOrgIds((long)orgId, (String)invQueryRange);
            List invOrgIdsByStock = InventoryUtils.getInvOrgIdsByStock((long)stockId);
            invOrgIds.retainAll(invOrgIdsByStock);
            filter = new QFilter("id", "in", (Object)invOrgIds);
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeErpStockF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (orgId == 0L || branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e1a\u52a1\u7ec4\u7ec7\u6216\u5f00\u5355\u95e8\u5e97\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)orgId, (long)branchId);
        List invOrgIds = InventoryUtils.getInvOrgIds((long)orgId, (String)invQueryRange);
        if (CollectionUtils.isEmpty((Collection)invOrgIds)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        log.info("\u5e93\u5b58\u7ec4\u7ec7id\u96c6\u5408\uff1a" + JSONObject.toJSONString((Object)invOrgIds));
        List lstStockId = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{invOrgIds});
        log.info("\u4ed3\u5e93id\u96c6\u5408\uff1a" + JSONObject.toJSONString((Object)lstStockId));
        QFilter filter = new QFilter("id", "in", (Object)lstStockId);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void beforeSupplierF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        List supplierIds = RetailChainHelper.queryFranChiser((long)goodsId, (long)branchId);
        QFilter filter = new QFilter("id", "in", (Object)supplierIds);
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private boolean initInvWithoutDelivery(DynamicObject dataEntity) {
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        if (invOrgId == 0L || stockId == 0L) {
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
            DynamicObject stock = InventoryUtils.getDefaultChannelStock((DynamicObject)branch);
            DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpstockorgid");
            DynamicObject erpStock = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpwarehouseid");
            if (stock == null || stockOrg == null || erpStock == null) {
                NotificationUtil.showDefaultTipNotify((String)"\u5f53\u524d\u95e8\u5e97\u672a\u627e\u5230\u9ed8\u8ba4\u53d1\u8d27\u6e20\u9053\u4ed3\u5e93\uff0c\u8bf7\u5148\u7ef4\u62a4\u6216\u662f\u76f4\u63a5\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7\u548c\u4ed3\u5e93\u3002", (IFormView)this.getView());
                return false;
            }
            dataEntity.set("deliverdeliverybranchid", (Object)branch);
            dataEntity.set("deliverstockid", (Object)stock);
            dataEntity.set("inventoryorgid", (Object)stockOrg);
            dataEntity.set("erpstockid", (Object)erpStock);
            this.getView().updateView();
            long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)stockOrg);
            if (stockOrgId != invOrgId) {
                this.stockOrgChanged(dataEntity, stockOrg);
            }
        }
        return true;
    }

    private boolean checkQtyScope(DynamicObject dataEntity, BigDecimal saleQty) {
        boolean isReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)dataEntity);
        if (!isReturn) {
            BigDecimal srcMustRetQty;
            if (saleQty.compareTo(BigDecimal.ZERO) <= 0) {
                NotificationUtil.showDefaultTipNotify((String)"\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002", (IFormView)this.getView());
                return false;
            }
            long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
            boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
            if (billTypeId == BillTypeEnum.CVTSALE.getId() && !notConfirm && (srcMustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"srcmustretqty")).compareTo(BigDecimal.ZERO) > 0 && saleQty.abs().compareTo(srcMustRetQty) > 0) {
                String strMustQty = srcMustRetQty.stripTrailingZeros().toPlainString();
                NotificationUtil.showDefaultTipNotify((String)String.format("\u8f6c\u9500\u6570\u91cf\u5e94\u4e3a\u6b63\u6570, \u4e14\u6700\u591a\u53ef\u8f6c\u9500%s\u3002", strMustQty), (IFormView)this.getView());
                return false;
            }
        } else {
            boolean isNegative;
            if (saleQty.compareTo(BigDecimal.ZERO) >= 0) {
                NotificationUtil.showDefaultTipNotify((String)"\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e0\u3002", (IFormView)this.getView());
                return false;
            }
            BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"mustretqty");
            boolean isPositive = mustRetQty.compareTo(BigDecimal.ZERO) > 0 && saleQty.abs().compareTo(mustRetQty) > 0;
            boolean bl = isNegative = mustRetQty.compareTo(BigDecimal.ZERO) < 0 && saleQty.compareTo(mustRetQty) < 0;
            if (isPositive || isNegative) {
                String strMustQty = mustRetQty.abs().stripTrailingZeros().toPlainString();
                NotificationUtil.showDefaultTipNotify((String)String.format("\u9000\u8d27\u6570\u91cf\u5e94\u4e3a\u8d1f\u6570, \u4e14\u6700\u591a\u53ef\u9000%s\u3002", strMustQty), (IFormView)this.getView());
                return false;
            }
        }
        return true;
    }

    private boolean checkVenderSellInv(DynamicObject dataEntity, boolean isNegativeSell, boolean isPresent) {
        String lotNum = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"deliverylotnum");
        DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"materialinv");
        boolean isEnableLot = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enablelot");
        if (isEnableLot && StringUtils.isBlank((CharSequence)lotNum)) {
            return this.buildLotNum(dataEntity, isNegativeSell, isPresent);
        }
        return true;
    }

    private boolean checkModeAndStock(DynamicObject dataEntity) {
        long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        return deliveryModeId == 0L || stockId == 0L;
    }

    private boolean buildLotNum(DynamicObject dataEntity, boolean isNegativeSell, boolean isPresent) {
        long branchId;
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long locCodeRuleId = SystemParamUtil.getLocCodeRuleId((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")));
        if (locCodeRuleId == 0L) {
            if (isNegativeSell) {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u5546\u54c1\u652f\u6301\u8d1f\u5356\uff0c\u8bf7\u5148\u7ef4\u62a4\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u91cc\u7684\u6279\u53f7\u89c4\u5219\u3002", (IFormView)this.getView());
            } else {
                NotificationUtil.showDefaultTipNotify((String)"\u8be5\u5546\u54c1\u4e3a\u5382\u5bb6\u5e26\u8d27\u5b89\u88c5\u5546\u54c1\u4e14\u542f\u7528\u4e86\u6279\u53f7\u653f\u7b56\uff0c\u8bf7\u5148\u7ef4\u62a4\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u91cc\u7684\u6279\u53f7\u89c4\u5219\u3002", (IFormView)this.getView());
            }
            return false;
        }
        DynamicObject parentEntity = isPresent ? this.getView().getParentView().getParentView().getModel().getDataEntity(true) : this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"materielid");
        try {
            String locCodeNum = LocCodeUtils.gernateLotCodeRule((DynamicObject)parentEntity, (DynamicObject)material, (long)locCodeRuleId);
            if (StringUtils.isBlank((CharSequence)locCodeNum)) {
                String tip = isNegativeSell ? "\u8d1f\u5356\u6279\u53f7\u751f\u6210\u5931\u8d25\u3002" : "\u6279\u53f7\u751f\u6210\u5931\u8d25\u3002";
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                return false;
            }
            dataEntity.set("deliverylotnum", (Object)locCodeNum);
            return true;
        }
        catch (Exception ex) {
            String tip = isNegativeSell ? "\u8d1f\u5356\u6279\u53f7\u751f\u6210\u5931\u8d25:" : "\u6279\u53f7\u751f\u6210\u5931\u8d25:";
            log.info(tip + ":" + ExceptionUtils.getStackTrace((Throwable)ex));
            NotificationUtil.showDefaultTipNotify((String)(tip + "\u8bf7\u68c0\u67e5\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u6240\u914d\u7f6e\u6279\u53f7\u89c4\u5219\u5bf9\u5e94\u7684\u6279\u53f7\u5c5e\u6027\u3002"), (IFormView)this.getView());
            return false;
        }
    }

    private boolean checkDeposit(DynamicObject dataEntity) {
        BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"deposit");
        String tip = SaleAmountHelper.depositChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"deposit", (BigDecimal)deposit);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            this.getView().showErrorNotification(tip);
            return false;
        }
        return true;
    }

    private boolean checkFinalAmt(DynamicObject dataEntity) {
        BigDecimal finalAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"finalpayment");
        String tip = SaleAmountHelper.finalPaymentChanged((IFormView)this.getView(), (DynamicObject)dataEntity, (DynamicObject)dataEntity, (String)"finalpayment", (BigDecimal)finalAmt);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            this.getView().showErrorNotification(tip);
            return false;
        }
        return true;
    }

    private long getDefInvTypeFromAppParam(DynamicObject dataEntity, boolean isSale) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        if (!isSale) {
            return SystemParamUtil.getSaleOrderDefInvTypeId((long)orgId, (long)branchId);
        }
        return CommonUtil.formatObejctToLong((Object)SystemParamUtil.getChangeDefectDefInvType((long)orgId, (long)branchId));
    }

    private long getDeliveryStatusId(Map<String, Object> customParams) {
        String saleOption;
        long deliveryStatusId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("deliverystatus", 0L));
        if (deliveryStatusId != 0L) {
            return deliveryStatusId;
        }
        long billTypeId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault("basebilltype", 0L));
        deliveryStatusId = billTypeId == BillTypeEnum.RETURN.getId() ? DeliveryStatus.RETURN_WAIT_PICK : (billTypeId == BillTypeEnum.CHANGE.getId() ? (StringUtils.equals((CharSequence)(saleOption = CommonUtil.formatStringToEmpty((Object)customParams.get("saleoption"))), (CharSequence)"1") ? DeliveryStatus.SALE_WAIT_DELIVERY.longValue() : DeliveryStatus.RETURN_WAIT_PICK.longValue()) : DeliveryStatus.SALE_WAIT_DELIVERY);
        return deliveryStatusId;
    }

    private List<DynamicObject> getBarCodeByGoodsId(DynamicObject dataEntity) {
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        QFilter filter = PosItemUtil.getSaleContentFilter((long)branchId, (long)currencyId, (String)"");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        filter.and("itemid", "=", (Object)goodsId);
        Map saleContents = BusinessDataServiceHelper.loadFromCache((String)"ocdbd_itemsalecontent", (QFilter[])filter.toArray());
        return saleContents.values().stream().map(x -> DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"barcodeid")).collect(Collectors.toList());
    }

    private List<JSONObject> getInventoryParams(DynamicObject dataEntity, BigDecimal saleQty, boolean isPostBack) {
        JSONObject inventoryParam = new JSONObject();
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        inventoryParam.put("saleOrgId", (Object)bizOrgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        inventoryParam.put("saleChannelID", (Object)branchId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        inventoryParam.put("itemId", (Object)goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
        inventoryParam.put("materialId", (Object)materialId);
        long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"auxattrid");
        inventoryParam.put("auxPtyID", (Object)auxAttrId);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"unit");
        inventoryParam.put("unitId", (Object)unitId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"baseunit");
        inventoryParam.put("baseUnitID", (Object)baseUnitId);
        inventoryParam.put("unitQty", (Object)saleQty);
        if (isPostBack) {
            BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
            inventoryParam.put("baseUnitQty", (Object)baseQty);
        } else {
            inventoryParam.put("baseUnitQty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"baseunitqty"));
        }
        long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channelstocktypeid");
        inventoryParam.put("invtypeid", (Object)invTypeId);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        inventoryParam.put("stockOrgId", (Object)invOrgId);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        inventoryParam.put("warehouseId", (Object)stockId);
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        inventoryParam.put("distributionModeId", (Object)distributionModeId);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        inventoryParam.put("adminDivisionId", (Object)adminDivisionId);
        int index = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"index");
        inventoryParam.put("customerKey", (Object)index);
        return Collections.singletonList(inventoryParam);
    }

    private List<JSONObject> getDistributionRuleParams(DynamicObject dataEntity) {
        ArrayList<JSONObject> lstRuleParam = new ArrayList<JSONObject>(0);
        JSONObject distRulesParam = new JSONObject();
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        distRulesParam.put("saleOrgId", (Object)bizOrgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        distRulesParam.put("saleChannelId", (Object)branchId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        distRulesParam.put("itemId", (Object)goodsId);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        distRulesParam.put("adminDivisionId", (Object)adminDivisionId);
        lstRuleParam.add(distRulesParam);
        return lstRuleParam;
    }

    public List<JSONObject> getOverSaleParams(DynamicObject dataEntity, BigDecimal saleQty, Date deliveryTime) {
        ArrayList<JSONObject> overSaleParams = new ArrayList<JSONObject>(0);
        JSONObject overSaleParam = new JSONObject();
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        overSaleParam.put("saleOrgId", (Object)orgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        overSaleParam.put("saleChannelID", (Object)branchId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
        overSaleParam.put("itemId", (Object)goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
        overSaleParam.put("materialId", (Object)materialId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"baseunit");
        overSaleParam.put("baseUnitID", (Object)baseUnitId);
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"baseunitqty");
        overSaleParam.put("baseUnitQty", (Object)baseUnitQty);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"unit");
        overSaleParam.put("unitId", (Object)unitId);
        overSaleParam.put("unitQty", (Object)saleQty);
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"distributionmode");
        overSaleParam.put("distributionModeId", (Object)distributionModeId);
        overSaleParam.put("deliveryDate", (Object)deliveryTime);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        overSaleParam.put("bizdate", (Object)bizDate);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        overSaleParam.put("stockOrgId", (Object)invOrgId);
        long stockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid");
        overSaleParam.put("stockId", (Object)stockId);
        long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channelstocktypeid");
        overSaleParam.put("invtypeid", (Object)invTypeId);
        int index = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"index");
        overSaleParam.put("customerKey", (Object)index);
        overSaleParams.add(overSaleParam);
        return overSaleParams;
    }

    private Map<String, Object> getDeliveryParams(DynamicObject dataEntity, BigDecimal qty, boolean isBeforePostback) {
        long erpStockId;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        int index = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)"index");
        params.put("index", index);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        params.put("saleOrgId", bizOrgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        params.put("saleChannelID", branchId);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"goodsid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        params.put("itemId", goodsId);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
        params.put("adminDivisionId", adminDivisionId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
        params.put("materialId", materialId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"baseunit");
        params.put("baseUnitID", baseUnitId);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"unit");
        params.put("unitId", unitId);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty");
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"baseunitqty");
        if (isBeforePostback) {
            params.put("unitQty", qty);
            params.put("baseUnitQty", UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materialId, (Long)unitId, (Long)baseUnitId));
        } else {
            params.put("unitQty", saleQty);
            params.put("baseUnitQty", baseUnitQty);
        }
        Date deliveryDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"deliverytime");
        params.put("deliveryDate", deliveryDate);
        long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"auxattrid");
        params.put("auxPtyID", auxAttrId);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        params.put("bizdate", bizDate);
        long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channelstocktypeid");
        params.put("invtypeid", invTypeId);
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        if (invOrgId > 0L) {
            params.put("stockOrgId", invOrgId);
        }
        if ((erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"erpstockid")) > 0L) {
            params.put("warehouseId", erpStockId);
        }
        return params;
    }

    private String getExistId() {
        Set curSnMainFileIds;
        List lockSnMainFileIds = (List)this.getView().getFormShowParameter().getCustomParam("locksnmainfiles");
        if (CollectionUtils.isEmpty((Collection)lockSnMainFileIds)) {
            return "";
        }
        int index = CommonUtil.formatObjectToInt((Object)this.getModel().getValue("index"));
        DynamicObject pEntryEntity = this.getView().getParentView().getModel().getEntryRowEntity("goodsentryentity", index);
        DynamicObjectCollection pDeliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)pEntryEntity, (String)"salesorderdelivery");
        if (!CollectionUtils.isEmpty((Collection)pDeliveryEntities) && !CollectionUtils.isEmpty(curSnMainFileIds = pDeliveryEntities.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"snmainfile")).collect(Collectors.toSet()))) {
            lockSnMainFileIds.removeAll(curSnMainFileIds);
        }
        if (CollectionUtils.isEmpty((Collection)lockSnMainFileIds)) {
            return "";
        }
        return StringUtils.join((Object[])lockSnMainFileIds.toArray(), (String)",");
    }

    private String getSrcSnMainFileIds() {
        Set srcSnMainFileIds;
        long srcEntryId;
        QFilter qFilter;
        DynamicObjectCollection srcMainFiles;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"ispresent");
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"basebilltype");
        if (!(isPresent || billTypeId != BillTypeEnum.CVTSALE.getId() && billTypeId != BillTypeEnum.GUIDE.getId() && billTypeId != BillTypeEnum.GROUP.getId() || CollectionUtils.isEmpty((Collection)(srcMainFiles = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"goodsentryentity.salesorderdelivery.snmainfile.id", (QFilter[])(qFilter = new QFilter("goodsentryentity.id", "=", (Object)(srcEntryId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"srcbillentryid")))).toArray()))) || CollectionUtils.isEmpty(srcSnMainFileIds = srcMainFiles.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsentryentity.salesorderdelivery.snmainfile.id")).collect(Collectors.toSet())))) {
            return StringUtils.join((Object[])srcSnMainFileIds.toArray(), (String)",");
        }
        return "";
    }

    public boolean getIsDelivery(DynamicObject goods) {
        return DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isdelivery");
    }

    private void initOtherQty(DynamicObject dataEntity, BigDecimal saleQty) {
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"materielid");
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"unit");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"baseunit");
        if (materialId != 0L && unitId != 0L && baseUnitId != 0L) {
            BigDecimal baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)saleQty, (Long)materialId, (Long)unitId, (Long)baseUnitId);
            dataEntity.set("baseunitqty", (Object)baseQty);
            this.getView().updateView("baseunitqty");
            long stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"stockunit");
            if (stockUnitId != 0L) {
                BigDecimal stockQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)stockUnitId);
                dataEntity.set("stockunitqty", (Object)stockQty);
                this.getView().updateView("stockunitqty");
            }
        }
    }
}

