/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderItemF7Filter;
import kd.occ.ocpos.business.saleorder.SnServiceHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class ManualSendGoodsPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_ACTION_ID = "itemsInfoEdit";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.initBaseData(parameter);
        this.initEntryData();
    }

    public void registerListener(EventObject e) {
        BasedataEdit barcodeEdit;
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        BasedataEdit goodsEdit = (BasedataEdit)this.getView().getControl("goodsid");
        if (!ObjectUtils.isEmpty((Object)goodsEdit)) {
            goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!ObjectUtils.isEmpty((Object)(barcodeEdit = (BasedataEdit)this.getView().getControl("barcode")))) {
            barcodeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        switch (key) {
            case "goodsid": 
            case "barcode": {
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                this.beforeItemsInfoF7Select(e, dataEntity, key, index);
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entityName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"goodsentryentity")) {
            RowDataEntity[] rowEntities = e.getRowDataEntities();
            if (rowEntities == null || rowEntities.length <= 0) {
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
            Object[] selGoodsEntity = this.getSaleGoodsRow();
            for (RowDataEntity rowEntity : rowEntities) {
                int index = rowEntity.getRowIndex();
                DynamicObject entryRow = (DynamicObject)entryEntity.get(index);
                this.fillData(entryEntity, entryRow, selGoodsEntity, index, false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        Object newValue = changeData.getNewValue();
        int index = changeData.getRowIndex();
        DynamicObject entryEntity = changeData.getDataEntity();
        DynamicObject dataEntity = (DynamicObject)entryEntity.getParent();
        switch (key = e.getProperty().getName()) {
            case "goodsid": {
                this.clearEntryValue(index);
                if (newValue == null) {
                    return;
                }
                DynamicObject goods = (DynamicObject)newValue;
                boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)goods);
                if (!isItemsRight) {
                    entryEntity.set("goodsid", null);
                    return;
                }
                entryEntity.set("saleqty", (Object)BigDecimal.ONE);
                entryEntity.set("retailprice", (Object)BigDecimal.ZERO);
                this.showItemsInfoInput(this.buildCustomParamsAboutGoods(entryEntity, dataEntity, goods, index));
                break;
            }
            case "barcode": {
                this.clearEntryValue(index);
                if (newValue == null) {
                    return;
                }
                DynamicObject barCode = (DynamicObject)newValue;
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
                boolean isItemsRight = CommonUtils.checkItemsInfo((AbstractFormPlugin)this, (DynamicObject)dataEntity, (DynamicObject)entryEntity, (DynamicObject)goods);
                if (!isItemsRight) {
                    entryEntity.set("barcode", null);
                    return;
                }
                entryEntity.set("saleqty", (Object)BigDecimal.ONE);
                entryEntity.set("retailprice", (Object)BigDecimal.ZERO);
                this.showItemsInfoInput(this.buildCustomParamsAboutBarCode(entryEntity, dataEntity, barCode, index));
                break;
            }
            case "saleqty": {
                BigDecimal saleQty = (BigDecimal)newValue;
                String tip = this.checkSaleQty(entryEntity, dataEntity, saleQty);
                if (StringUtils.isBlank((CharSequence)tip)) {
                    DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
                    DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"barcode");
                    if (ObjectUtils.isEmpty((Object)goods) || ObjectUtils.isEmpty((Object)barCode)) break;
                    this.showItemsInfoInput(this.buildCustomParamsAboutOther(entryEntity, dataEntity, index));
                    break;
                }
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                entryEntity.set("saleqty", changeData.getOldValue());
                this.getView().updateView("saleqty", index);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)KEY_ACTION_ID)) {
            Object returnData = e.getReturnData();
            if (ObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            if (returnData instanceof Map) {
                Map returnMap = (Map)returnData;
                String status = CommonUtil.formatStringToEmpty(returnMap.get("status"));
                int index = CommonUtil.formatObjectToInt(returnMap.get("index"));
                if (StringUtils.equals((CharSequence)status, (CharSequence)"SUCCESS")) {
                    DynamicObject dataEntity = this.getModel().getDataEntity(true);
                    DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
                    this.addNewEntryRow(entryEntity, index, returnMap);
                    this.setSaleQtyEnable(entryEntity);
                    this.addBlankRow(dataEntity, entryEntity, returnMap);
                } else {
                    this.clearEntryValue(index);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"nogiftvaluecontrol") && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            DynamicObjectCollection entryEntities = this.getModel().getEntryEntity("goodsentryentity");
            this.returnData(entryEntities);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"btnok")) {
            ArrayList<String> messages = new ArrayList<String>(4);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
            entryEntities.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == 0L);
            if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
                ArrayList<Integer> lstSeq = new ArrayList<Integer>(entryEntities.size());
                for (DynamicObject entryEntity : entryEntities) {
                    BigDecimal giftPrice;
                    int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
                    BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
                    if (ObjectUtils.isEmpty((Object)saleQty)) {
                        messages.add(String.format("\u8d60\u9001\u5217\u8868\u7b2c%d\u884c\uff0c\u8d60\u9001\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq));
                    }
                    if (saleQty.compareTo(BigDecimal.ZERO) <= 0) {
                        messages.add(String.format("\u8d60\u9001\u5217\u8868\u7b2c%d\u884c\uff0c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002", seq));
                    }
                    if ((giftPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"giftprice")).compareTo(BigDecimal.ZERO) != 0) continue;
                    lstSeq.add(seq);
                }
                if (CollectionUtils.isEmpty(messages)) {
                    boolean isNext;
                    if (!CollectionUtils.isEmpty(lstSeq) && !(isNext = this.noGiftValueControlJudge(dataEntity, lstSeq))) {
                        return;
                    }
                    this.returnData(entryEntities);
                } else {
                    FormShowUtils.showOperationResult(messages);
                }
            } else {
                this.getView().returnDataToParent(null);
                this.getView().close();
            }
        }
    }

    private void returnData(DynamicObjectCollection entryEntities) {
        ArrayList<Map<String, Object>> lstData = new ArrayList<Map<String, Object>>();
        for (DynamicObject entryEntity : entryEntities) {
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
            if (isBook) {
                Map<String, Object> map = this.returnToParent(entryEntity, null);
                lstData.add(map);
                continue;
            }
            String returnData = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"data");
            Map<String, Object> map = this.returnToParent(entryEntity, JSONObject.parse((String)returnData));
            lstData.add(map);
        }
        this.getView().returnDataToParent(lstData);
        this.getView().close();
    }

    private boolean noGiftValueControlJudge(DynamicObject dataEntity, List<Integer> lstSeq) {
        boolean isNext;
        String noGiftValueControl;
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        switch (noGiftValueControl = SystemParamUtil.getNoGiftValueControl((long)orgId, (long)branchId)) {
            case "2": {
                isNext = false;
                ConfirmCallBackListener listener = new ConfirmCallBackListener("nogiftvaluecontrol", (IFormPlugin)this);
                String tip = String.format("\u7b2c%s\u884c\u8d60\u54c1\u65e0\u6cd5\u83b7\u53d6\u8d60\u54c1\u4ef7\u503c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8d60\u9001\uff1f", StringUtils.join((Object[])lstSeq.toArray(), (String)","));
                this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener);
                break;
            }
            case "3": {
                isNext = false;
                String tip = String.format("\u7b2c%s\u884c\u8d60\u54c1\u65e0\u6cd5\u83b7\u53d6\u8d60\u54c1\u4ef7\u503c\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d60\u9001\u3002", StringUtils.join((Object[])lstSeq.toArray(), (String)","));
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                break;
            }
            default: {
                isNext = true;
            }
        }
        return isNext;
    }

    public void beforeItemsInfoF7Select(BeforeF7SelectEvent e, DynamicObject dataEntity, String key, int index) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        if (branchId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u5f00\u5355\u95e8\u5e97\u5f02\u5e38\u3002", (IFormView)this.getView());
            e.setCancel(true);
            return;
        }
        DynamicObject goods = (DynamicObject)this.getModel().getValue("goodsid", index);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        SaleOrderItemF7Filter.beforeItemF7Filter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (long)orgId, (long)branchId, (long)currencyId, (String)key, (boolean)false, (long)0L, (long)0L, (long)goodsId);
    }

    private void initBaseData(FormShowParameter parameter) {
        Map customParams = parameter.getCustomParams();
        Long branchId = customParams.getOrDefault("salebranchid", 0L);
        this.getModel().setItemValueByID("salebranchid", (Object)branchId);
        Long bizOrgId = customParams.getOrDefault("bizorgid", 0L);
        this.getModel().setItemValueByID("bizorgid", (Object)bizOrgId);
        Long billTypeId = customParams.getOrDefault("basebilltype", 0L);
        this.getModel().setItemValueByID("basebilltype", (Object)billTypeId);
        if (CommonUtil.formatObejctToLong((Object)billTypeId) == BillTypeEnum.CHANGE.getId()) {
            String changeItemType = customParams.getOrDefault("changeitemtype", "");
            this.getModel().setValue("changeitemtype", (Object)changeItemType);
        }
        Long currencyId = customParams.getOrDefault("currencyid", 1L);
        this.getModel().setItemValueByID("currencyid", (Object)currencyId);
        Object bizDate = customParams.getOrDefault("bizdate", null);
        this.getModel().setValue("bizdate", bizDate);
        Boolean isInitBill = customParams.getOrDefault("isinitbill", Boolean.FALSE);
        this.getModel().setValue("isinitbill", (Object)isInitBill);
    }

    private void initEntryData() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
        if (entryEntity == null) {
            return;
        }
        entryEntity.clear();
        int index = this.getModel().createNewEntryRow("goodsentryentity");
        DynamicObject entryRow = (DynamicObject)entryEntity.get(index);
        Object[] selGoodsEntity = this.getSaleGoodsRow();
        this.fillData(entryEntity, entryRow, selGoodsEntity, index, true);
    }

    private void fillData(DynamicObjectCollection entryEntity, DynamicObject entryRow, Object[] entryData, int index, boolean isInit) {
        DynamicObject dataEntity;
        long billTypeId;
        List<Integer> lstSeq = this.fillSaleGoods(entryRow, entryData, index);
        String goodsSeq = StringUtils.join((Object[])lstSeq.toArray(), (char)',');
        if (isInit && entryEntity.stream().anyMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"sendgoodsseq"), (CharSequence)goodsSeq))) {
            return;
        }
        int seq = lstSeq.get(0);
        DynamicObject entryItem = Arrays.stream(entryData).filter(x -> DynamicObjectUtils.getInt((DynamicObject)((DynamicObject)x), (String)"seq") == seq).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)entryItem)) {
            DynamicObjectCollection deliveryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery");
            if (!CollectionUtils.isEmpty((Collection)deliveryData)) {
                DynamicObject deliveryItem = (DynamicObject)deliveryData.get(0);
                String districtId = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"districtid");
                entryRow.set("admindivisionid", (Object)districtId);
                this.getView().updateView("admindivisionid", index);
                String address = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"address");
                entryRow.set("customeraddress", (Object)address);
                this.getView().updateView("customeraddress", index);
                String consignee = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"consignee");
                entryRow.set("customername", (Object)consignee);
                this.getView().updateView("customername", index);
                String phone = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"deliverphonenumber");
                entryRow.set("customerphone", (Object)phone);
                this.getView().updateView("customerphone", index);
                String fullAddress = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"fulladdress");
                entryRow.set("fulladdress", (Object)fullAddress);
                this.getView().updateView("fulladdress", index);
            }
            DynamicObject saleMan = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodssaler");
            entryRow.set("goodssaler", (Object)saleMan);
            this.getView().updateView("goodssaler", index);
            DynamicObject saleDept = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"saledepartment");
            entryRow.set("saledepartment", (Object)saleDept);
            this.getView().updateView("saledepartment", index);
            entryRow.set("keepertype", (Object)"bos_org");
            this.getView().updateView("keepertype", index);
            entryRow.set("ownertype", (Object)"bos_org");
            this.getView().updateView("ownertype", index);
        }
        if ((billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)(dataEntity = this.getModel().getDataEntity(true)), (String)"basebilltype")) == BillTypeEnum.RESERVE.getId()) {
            entryRow.set("isbook", (Object)Boolean.TRUE);
            this.getView().updateView("isbook", index);
        }
        entryRow.set("sendgoodsseq", (Object)goodsSeq);
        this.getView().updateView("sendgoodsseq", index);
        this.setGoodsTotalValue(entryRow, index);
    }

    private Object[] getSaleGoodsRow() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityId = this.getView().getParentView().getEntityId();
        DynamicObjectType entityType = (DynamicObjectType)ORM.create().getDataEntityType(entityId + "." + "goodsentryentity");
        String strSelGoodsEntity = (String)parameter.getCustomParam("goodsselectentity");
        Object[] selGoodsEntity = DynamicObjectSerializeUtil.deserialize((String)strSelGoodsEntity, (DynamicObjectType)entityType);
        if (selGoodsEntity.length == 0) {
            String strAllGoodsEntity = (String)parameter.getCustomParam("goodsentryentity");
            selGoodsEntity = DynamicObjectSerializeUtil.deserialize((String)strAllGoodsEntity, (DynamicObjectType)entityType);
        }
        return selGoodsEntity;
    }

    private Object[] getGoodsEntities() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityId = this.getView().getParentView().getEntityId();
        DynamicObjectType entityType = (DynamicObjectType)ORM.create().getDataEntityType(entityId + "." + "goodsentryentity");
        String strAllGoodsEntity = (String)parameter.getCustomParam("goodsentryentity");
        return DynamicObjectSerializeUtil.deserialize((String)strAllGoodsEntity, (DynamicObjectType)entityType);
    }

    private List<Integer> fillSaleGoods(DynamicObject entryRow, Object[] entryData, int index) {
        ArrayList<Integer> lstSeq = new ArrayList<Integer>();
        StringBuilder sbGoodsName = new StringBuilder();
        for (Object item : entryData) {
            DynamicObject entryItem = (DynamicObject)item;
            DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid");
            if (ObjectUtils.isEmpty((Object)goods)) continue;
            if (sbGoodsName.length() > 0) {
                sbGoodsName.append(',');
            }
            sbGoodsName.append(DynamicObjectUtils.getString((DynamicObject)goods, (String)"name"));
            lstSeq.add(DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"seq"));
        }
        entryRow.set("salegoods", (Object)sbGoodsName.toString());
        this.getView().updateView("salegoods", index);
        entryRow.set("isallowbook", (Object)Boolean.TRUE);
        this.getView().updateView("isallowbook", index);
        return lstSeq;
    }

    private void clearEntryValue(int index) {
        this.getModel().deleteEntryRow("goodsentryentity", index);
        this.getModel().insertEntryRow("goodsentryentity", index);
    }

    private void showItemsInfoInput(Map<String, Object> customParams) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        customParams.put("changeitemtype", dataEntity.get("changeitemtype"));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)"ocpos_itemsinfoedit", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        List<Long> lockSnMainFileIds = this.getLockSnMainFileIds();
        if (!CollectionUtils.isEmpty(lockSnMainFileIds)) {
            parameter.setCustomParam("locksnmainfiles", lockSnMainFileIds);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ACTION_ID));
        this.getView().showForm(parameter);
    }

    private void addNewEntryRow(DynamicObjectCollection entryEntity, int index, Map<String, Object> returnMap) {
        DynamicObject entryRow = CollectionUtils.isEmpty((Collection)entryEntity) ? entryEntity.addNew() : (DynamicObject)entryEntity.get(index);
        DynamicObject data = (DynamicObject)returnMap.get("data");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String key = property.getName();
            if (!DynamicObjectUtils.contain((DynamicObject)data, (String)key) || StringUtils.equals((CharSequence)key, (CharSequence)"sendgoodsseq")) continue;
            entryRow.set(key, data.get(key));
        }
        Object[] selGoodsEntity = this.getSaleGoodsRow();
        this.fillSaleGoods(entryRow, selGoodsEntity, index);
        Object returnInfo = returnMap.get("deliveryData");
        if (returnInfo instanceof List) {
            this.fillDeliveryDataAboutStock(entryRow, returnInfo, data);
        } else {
            this.fillDeliveryData(entryRow, data);
        }
        this.getView().updateView("goodsentryentity", index);
    }

    private void addBlankRow(DynamicObject dataEntity, DynamicObjectCollection entryEntity, Map<String, Object> returnMap) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        String opSource = CommonUtil.formatStringToEmpty((Object)returnMap.get("operation"));
        if (!StringUtils.equals((CharSequence)opSource, (CharSequence)"saveandnew")) {
            return;
        }
        int newIndex = this.getModel().createNewEntryRow("goodsentryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("goodsentryentity");
        entryGrid.getEntryState().setFocusRow(newIndex);
        DynamicObject newEntryRow = (DynamicObject)entryEntity.get(newIndex);
        Map<String, Object> customParams = this.buildCustomParamsAboutOther(newEntryRow, dataEntity, newIndex);
        this.showItemsInfoInput(customParams);
    }

    private void fillDeliveryDataAboutStock(DynamicObject entryRow, Object returnData, DynamicObject data) {
        List result = (List)returnData;
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        for (JSONObject resultJson : result) {
            long invTypeId;
            long stockId;
            long stockOrgId;
            long channelWarehouseId;
            long deliveryChannelId;
            long distributionModeId = resultJson.getLongValue("distributionmodeid");
            if (distributionModeId != 0L) {
                DynamicObject distributionMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
                entryRow.set("distributionmode", (Object)distributionMode);
            }
            if ((deliveryChannelId = resultJson.getLongValue("deliverychannelid")) != 0L) {
                DynamicObject deliveryChannel = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_channel");
                entryRow.set("deliverdeliverybranchid", (Object)deliveryChannel);
            }
            if ((channelWarehouseId = resultJson.getLongValue("channelwarehouseid")) != 0L) {
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)channelWarehouseId, (String)"ococic_warehouse");
                entryRow.set("deliverstockid", (Object)stock);
            }
            if ((stockOrgId = resultJson.getLongValue("stockorgid")) != 0L) {
                DynamicObject stockOrg = BusinessDataServiceHelper.loadSingle((Object)stockOrgId, (String)"bos_org");
                entryRow.set("inventoryorgid", (Object)stockOrg);
            }
            if ((stockId = resultJson.getLongValue("warehouseid")) != 0L) {
                DynamicObject erpStock = BusinessDataServiceHelper.loadSingle((Object)stockId, (String)"bd_warehouse");
                entryRow.set("erpstockid", (Object)erpStock);
            }
            invTypeId = (invTypeId = resultJson.getLongValue("invtypeid")) == 0L ? 688884005529250816L : invTypeId;
            DynamicObject invType = BusinessDataServiceHelper.loadSingle((Object)invTypeId, (String)"bd_invtype");
            entryRow.set("channelstocktypeid", (Object)invType);
            DynamicObject shippingStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"shippingstatus");
            entryRow.set("shippingstatus", (Object)shippingStatus);
            long keeperId = resultJson.getLongValue("keeperid");
            String keeperType = DynamicObjectUtils.getString((DynamicObject)entryRow, (String)"keepertype");
            if (keeperId != 0L && StringUtils.equals((CharSequence)keeperType, (CharSequence)"bos_org")) {
                DynamicObject keeper = BusinessDataServiceHelper.loadSingle((Object)keeperId, (String)"bos_org");
                entryRow.set("keeperid", (Object)keeper);
            }
            long ownerId = resultJson.getLongValue("ownerid");
            String ownerType = DynamicObjectUtils.getString((DynamicObject)entryRow, (String)"ownertype");
            if (ownerId == 0L || !StringUtils.equals((CharSequence)ownerType, (CharSequence)"bos_org")) continue;
            DynamicObject owner = BusinessDataServiceHelper.loadSingle((Object)ownerId, (String)"bos_org");
            entryRow.set("ownerid", (Object)owner);
        }
    }

    private void fillDeliveryData(DynamicObject entryRow, DynamicObject data) {
        DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"distributionmode");
        entryRow.set("distributionmode", (Object)distributionMode);
        DynamicObject shippingStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_OUTBOUND, (String)"ococic_deliverstatus");
        entryRow.set("shippingstatus", (Object)shippingStatus);
        DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"channelstocktypeid");
        entryRow.set("channelstocktypeid", (Object)invType);
        SaleOrderDeliveryInfoHelper.setStock((IFormView)this.getView(), (DynamicObject)data, (DynamicObject)entryRow);
        DynamicObject keeper = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"keeperid");
        entryRow.set("keeperid", (Object)keeper);
        String keeperType = DynamicObjectUtils.getString((DynamicObject)data, (String)"keepertype");
        entryRow.set("keepertype", (Object)keeperType);
        DynamicObject owner = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"ownerid");
        entryRow.set("ownerid", (Object)owner);
        String ownerType = DynamicObjectUtils.getString((DynamicObject)data, (String)"ownertype");
        entryRow.set("ownertype", (Object)ownerType);
        DynamicObject supplier = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"supplier");
        entryRow.set("supplier", (Object)supplier);
    }

    private void setSaleQtyEnable(DynamicObjectCollection entryEntity) {
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        for (DynamicObject entryRow : entryEntity) {
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryRow, (String)"seq");
            int index = seq > 0 ? seq - 1 : 0;
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryRow, (String)"materialinv");
            boolean isEnableSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            this.getView().setEnable(Boolean.valueOf(!isEnableSerial), index, new String[]{"saleqty"});
        }
    }

    private String checkSaleQty(DynamicObject entryEntity, DynamicObject dataEntity, BigDecimal newValue) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        BigDecimal srcMustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"srcmustretqty");
        String tip = null;
        if (newValue.compareTo(BigDecimal.ZERO) <= 0) {
            tip = "\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002";
        } else if (billTypeId == BillTypeEnum.CVTSALE.getId() && srcMustRetQty.compareTo(BigDecimal.ZERO) > 0 && newValue.abs().compareTo(srcMustRetQty) > 0) {
            String strMustQty = srcMustRetQty.stripTrailingZeros().toPlainString();
            tip = String.format("\u8f6c\u9500\u6570\u91cf\u5e94\u4e3a\u6b63\u6570, \u4e14\u6700\u591a\u53ef\u8f6c\u9500%s\u3002", strMustQty);
        }
        return tip;
    }

    private Map<String, Object> buildCustomParams(DynamicObject entryEntity, DynamicObject dataEntity, int index) {
        Map customParams = SaleOrderDeliveryInfoHelper.buildCustomParams((DynamicObject)dataEntity, (int)index);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
        if (BillTypeEnum.CHANGE.getId() == billTypeId && StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
            customParams.put("amount", entryEntity.get("amount"));
        }
        customParams.put("saleoption", saleOption);
        this.buildCustomParamsAboutContact(entryEntity, customParams);
        BigDecimal sumAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"sumamount");
        customParams.put("sumamount", sumAmount);
        boolean isCheckPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ischeckpresent");
        customParams.put("ischeckpresent", isCheckPresent);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutSale((DynamicObject)entryEntity, (Map)customParams);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutAmt((DynamicObject)entryEntity, (Map)customParams);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutBook((DynamicObject)entryEntity, (Map)customParams);
        this.buildCustomParamsAboutInv(entryEntity, customParams);
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        customParams.put("isinitbill", isInitBill);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutGoods(DynamicObject entryEntity, DynamicObject dataEntity, DynamicObject goods, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutGoods(customParams, (DynamicObject)goods);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        long barCodeId = SaleOrderDeliveryInfoHelper.getBarCodeIdByGoods((long)branchId, (long)currencyId, (long)goodsId);
        customParams.put("barcode", barCodeId);
        this.buildCustomParamsAboutItems(customParams, goods);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutBarCode(DynamicObject entryEntity, DynamicObject dataEntity, DynamicObject barCode, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutBarCode(customParams, (DynamicObject)barCode);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
        this.buildCustomParamsAboutItems(customParams, goods);
        return customParams;
    }

    private Map<String, Object> buildCustomParamsAboutOther(DynamicObject entryEntity, DynamicObject dataEntity, int index) {
        Map<String, Object> customParams = this.buildCustomParams(entryEntity, dataEntity, index);
        SaleOrderDeliveryInfoHelper.buildCustomParamsAboutOther((DynamicObject)entryEntity, customParams);
        this.buildCustomParamsAboutOtherDelivery(entryEntity, customParams);
        customParams.put("type", false);
        return customParams;
    }

    private void buildCustomParamsAboutContact(DynamicObject entryEntity, Map<String, Object> customParams) {
        String customerName = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"customername");
        customParams.put("customername", customerName);
        String customerPhone = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"customerphone");
        customParams.put("customerphone", customerPhone);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"admindivisionid");
        customParams.put("admindivisionid", adminDivisionId);
        String address = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"customeraddress");
        customParams.put("customeraddress", address);
    }

    private void buildCustomParamsAboutInv(DynamicObject entryEntity, Map<String, Object> customParams) {
        String keeperType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"keepertype");
        customParams.put("keepertype", keeperType);
        long keeperId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"keeperid");
        customParams.put("keeperid", keeperId);
        String ownerType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"ownertype");
        customParams.put("ownertype", ownerType);
        long ownerId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"ownerid");
        customParams.put("ownerid", ownerId);
        long inventoryOrgId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"inventoryorgid");
        customParams.put("inventoryorgid", inventoryOrgId);
        long erpStockId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"erpstockid");
        customParams.put("erpstockid", erpStockId);
        long stockTypeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"channelstocktypeid");
        customParams.put("channelstocktypeid", stockTypeId);
    }

    public void buildCustomParamsAboutItems(Map<String, Object> customParams, DynamicObject goods) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isdelivery");
        customParams.put("isdelivery", isDelivery);
        customParams.put("deliverytime", null);
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isinstall");
        customParams.put("isinstall", isInstall);
        customParams.put("installtime", null);
        customParams.put("type", true);
    }

    public void buildCustomParamsAboutOtherDelivery(DynamicObject entryEntity, Map<String, Object> customParams) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isdelivery");
        customParams.put("isdelivery", isDelivery);
        Date deliveryTime = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"deliverytime");
        customParams.put("deliverytime", deliveryTime);
        long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"distributionmode");
        customParams.put("deliverymode", deliveryModeId);
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isinstall");
        customParams.put("isinstall", isInstall);
        Date installTime = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"installtime");
        customParams.put("installtime", installTime);
        boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isselfpickup");
        customParams.put("isselfpickup", isSelfPickup);
        Date selfPickupTime = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"selfpickuptime");
        customParams.put("selfpickuptime", selfPickupTime);
        long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"snmainfile");
        customParams.put("snmainfile", snMainFileId);
        String serialNum = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"deliveryserialnumber");
        customParams.put("deliveryserialnumber", serialNum);
        String lotNum = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"deliverylotnum");
        customParams.put("deliverylotnum", lotNum);
    }

    private Map<String, Object> returnToParent(DynamicObject data, Object deliveryData) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(0);
        int index = DynamicObjectUtils.getInt((DynamicObject)data, (String)"index");
        returnData.put("index", index);
        returnData.put("status", "SUCCESS");
        returnData.put("data", data);
        returnData.put("salesorderdelivery", deliveryData);
        return returnData;
    }

    private List<Long> getLockSnMainFileIds() {
        DynamicObject parentDataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        List lockSnMainFileIds = SnServiceHelper.getLockSnMainFileIdsFromDr((DynamicObject)parentDataEntity);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List lockSnMainFileIdsFromSend = SnServiceHelper.getLockSnMainFileIdsFromSend((DynamicObject)dataEntity);
        lockSnMainFileIds.removeAll(lockSnMainFileIdsFromSend);
        lockSnMainFileIds.addAll(lockSnMainFileIdsFromSend);
        return lockSnMainFileIds;
    }

    private void setGoodsTotalValue(DynamicObject entryRow, int index) {
        Object[] entryEntities = this.getGoodsEntities();
        boolean isReserve = Arrays.stream(entryEntities).anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)((DynamicObject)x), (String)"isbook") && !DynamicObjectUtils.getBoolean((DynamicObject)((DynamicObject)x), (String)"ispresent"));
        if (!isReserve) {
            this.updateTotalValue(entryRow, BigDecimal.ZERO, Boolean.FALSE, index);
            return;
        }
        BigDecimal totalValue = BigDecimal.ZERO;
        for (Object item : entryEntities) {
            DynamicObject entryEntity = (DynamicObject)item;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            if (isPresent) continue;
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
            if (isBook) {
                BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
                totalValue = totalValue.add(deposit);
                continue;
            }
            BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"balamount");
            totalValue = totalValue.add(balAmount);
        }
        this.updateTotalValue(entryRow, totalValue, Boolean.TRUE, index);
    }

    private void updateTotalValue(DynamicObject entryRow, BigDecimal totalValue, Boolean isCheckPresent, int index) {
        entryRow.set("sumamount", (Object)totalValue);
        this.getView().updateView("sumamount", index);
        entryRow.set("ischeckpresent", (Object)isCheckPresent);
        this.getView().updateView("ischeckpresent", index);
    }
}

