/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;

public class PosRegisterFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long branchId = customParams.getOrDefault("branch", 0L);
        this.queryPos(branchId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"register") && ((selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()) == null || selectRows.length <= 0)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u6ce8\u518c\u7684POS\u673a\u3002", (IFormView)this.getView());
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"register")) {
            this.registerPos();
        }
    }

    private void queryPos(Object branchId) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("branch", "=", branchId);
        filter.and("registerstatus", "=", (Object)"0");
        filter.and("machinetype", "=", (Object)"A");
        DynamicObjectCollection poss = QueryServiceHelper.query((String)"ocdbd_pos", (String)"id", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)poss)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        for (DynamicObject pos : poss) {
            long posId = DynamicObjectUtils.getPkValue((DynamicObject)pos);
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().setValue("number", (Object)posId, index);
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private void registerPos() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length <= 0) {
            return;
        }
        int index = selectRows[0];
        DynamicObject pos = (DynamicObject)this.getModel().getValue("number", index);
        String macAddress = (String)this.getView().getFormShowParameter().getCustomParam("macaddress");
        pos.set("macaddress", (Object)macAddress);
        pos.set("registerstatus", (Object)"1");
        pos.set("modifier", (Object)RequestContext.get().getCurrUserId());
        pos.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{pos});
        this.getView().returnDataToParent((Object)DynamicObjectUtils.getPkValue((DynamicObject)pos));
        this.getView().close();
    }
}

