/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormRuleUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class PromoteSendPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Optional.ofNullable(entryGrid).ifPresent(g -> g.setColumnProperty("operationcolumnap", "isFixed", (Object)true));
        DynamicObject doBill = this.getView().getParentView().getModel().getDataEntity(true);
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        Map customParams = frmShowParameter.getCustomParams();
        long promoteBillId = CommonUtil.formatObejctToLong(customParams.get("promotebillid"));
        long promoteRuleId = CommonUtil.formatObejctToLong(customParams.get("promoteruleid"));
        String goodsSeq = CommonUtil.formatStringToEmpty(customParams.get("goodsseq"));
        boolean isAllowBook = CommonUtil.formatObjectToBoolean((Object)customParams.getOrDefault("isallowbook", Boolean.TRUE));
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return;
        }
        if (promoteBillId > 0L && !ObjectUtils.isEmpty((Object)doBill)) {
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doBill, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                return;
            }
            DynamicObject doPromote = BusinessDataServiceHelper.loadSingle((Object)promoteBillId, (String)"ocdpm_promote");
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)doBill, (String)"salebranchid");
            DynamicObject stock = InventoryUtils.getDefaultChannelStock((DynamicObject)branch);
            DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpstockorgid");
            DynamicObject erpStock = DynamicObjectUtils.getDynamicObject((DynamicObject)stock, (String)"erpwarehouseid");
            DynamicObject defOwner = InventoryUtils.getDefaultOwner((long)DynamicObjectUtils.getPkValue((DynamicObject)stockOrg));
            DynamicObject invStatus = BusinessDataServiceHelper.loadSingle((Object)691928582720825344L, (String)"bd_invstatus");
            DynamicObjectCollection docSendEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            String promoteType = (String)frmShowParameter.getCustomParam("promotiontype");
            DynamicObject doPromoteRule = null;
            if (promoteRuleId > 0L) {
                doPromoteRule = BusinessDataServiceHelper.loadSingle((Object)promoteRuleId, (String)"ocdpm_promote_rule");
            }
            String[] goodsSeqArray = goodsSeq.split(",");
            if (!PromotionEnum.noLadPromotion().contains(promoteType)) {
                HashMap mapQtyAmount = new HashMap(0);
                String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
                if (StringUtils.equals((CharSequence)itemGroup, (CharSequence)"1")) {
                    ArrayList<String> lstExeSeq = new ArrayList<String>(0);
                    for (String seq : goodsSeqArray) {
                        DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seq, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                        if (ObjectUtils.isEmpty((Object)doGoodsEntry)) continue;
                        List lstGoodsEntry = SaleorderPromotionHelper.getSameGoodsList((DynamicObject)doGoodsEntry, (String[])goodsSeqArray, (DynamicObjectCollection)docGoodsEntry);
                        String exeGoodsSeq = StringUtils.join((Object[])lstGoodsEntry.stream().map(x -> DynamicObjectUtils.getString((DynamicObject)x, (String)"seq")).toArray(), (String)",");
                        String exeGoodsName = StringUtils.join((Object[])lstGoodsEntry.stream().map(x -> DynamicObjectUtils.getString((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"goodsid"), (String)"name")).toArray(), (String)",");
                        if (lstExeSeq.contains(exeGoodsSeq)) continue;
                        lstExeSeq.add(exeGoodsSeq);
                        doPromoteRule = SaleorderPromotionHelper.getPromoteRule((DynamicObject)doPromote, (String)promoteType, (DynamicObject)doPromoteRule, (DynamicObject)doGoodsEntry, (DynamicObjectCollection)docGoodsEntry, (String[])goodsSeqArray, mapQtyAmount);
                        this.createNewSendEntity(doBill, doPromoteRule, docSendEntry, branch, exeGoodsSeq, exeGoodsName, stock, stockOrg, erpStock, defOwner, invStatus, isAllowBook, promoteType);
                    }
                } else {
                    String goodsName = this.getGoodsName(goodsSeqArray, docGoodsEntry);
                    doPromoteRule = SaleorderPromotionHelper.getPromoteRule((DynamicObject)doPromote, (String)promoteType, (DynamicObject)doPromoteRule, null, (DynamicObjectCollection)docGoodsEntry, (String[])goodsSeqArray, mapQtyAmount);
                    this.createNewSendEntity(doBill, doPromoteRule, docSendEntry, branch, goodsSeq, goodsName, stock, stockOrg, erpStock, defOwner, invStatus, isAllowBook, promoteType);
                }
            } else {
                String goodsName = this.getGoodsName(goodsSeqArray, docGoodsEntry);
                DynamicObject[] docPromoteRule = this.queryPromoteRule(promoteBillId);
                if (docPromoteRule != null && docPromoteRule.length > 0) {
                    for (DynamicObject doPromRule : docPromoteRule) {
                        this.createNewSendEntity(doBill, doPromRule, docSendEntry, branch, goodsSeq, goodsName, stock, stockOrg, erpStock, defOwner, invStatus, isAllowBook, promoteType);
                    }
                }
            }
            for (int i = 0; i < docSendEntry.getRowCount(); ++i) {
                long materialId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)docSendEntry.get(i)), (String)"materielid");
                FormRuleUtils.raiseFormRules((IFormView)this.getView(), (DynamicObject)((DynamicObject)docSendEntry.get(i)), (String)"materielid", null, (Object)materialId, (int)i);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject doBill = this.getView().getParentView().getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doBill, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RESERVE.getId()) {
            DynamicObjectCollection docSendEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            int rowCount = docSendEntry.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isbook"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"expecttakeorderdate"});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
        BasedataEdit bInventoryOrg = (BasedataEdit)this.getView().getControl("inventoryorgid");
        bInventoryOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bErpStock = (BasedataEdit)this.getView().getControl("erpstockid");
        bErpStock.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        DynamicObjectCollection sendGoodsEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selRow = entryGrid.getSelectRows();
            boolean isCheckData = this.checkData(selRow, sendGoodsEntities);
            if (!isCheckData) {
                return;
            }
            ArrayList<DynamicObject> selGoodsRow = new ArrayList<DynamicObject>(0);
            if (selRow.length > 0 && !CollectionUtils.isEmpty((Collection)sendGoodsEntities)) {
                ArrayList<String> lstErrMsg = new ArrayList<String>();
                ArrayList<String> lstSeq = new ArrayList<String>();
                for (int rowIndex : selRow) {
                    DynamicObject mode;
                    boolean isRight = true;
                    DynamicObject sendGoodsEntity = (DynamicObject)sendGoodsEntities.get(rowIndex);
                    String seq = DynamicObjectUtils.getString((DynamicObject)sendGoodsEntity, (String)"seq");
                    DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)sendGoodsEntity, (String)"channelstocktypeid");
                    if (invType == null) {
                        lstErrMsg.add(String.format("\u8d60\u54c1\u5217\u8868\u7b2c%s\u884c\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq));
                        isRight = false;
                    }
                    if ((mode = DynamicObjectUtils.getDynamicObject((DynamicObject)sendGoodsEntity, (String)"distributionmode")) == null) {
                        lstErrMsg.add(String.format("\u8d60\u54c1\u5217\u8868\u7b2c%s\u884c\uff0c\u914d\u9001\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq));
                        isRight = false;
                    }
                    boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)sendGoodsEntity, (String)"isdelivery");
                    Date deliveryTime = DynamicObjectUtils.getDate((DynamicObject)sendGoodsEntity, (String)"deliverytime");
                    if (isDelivery && ObjectUtils.isEmpty((Object)deliveryTime)) {
                        lstErrMsg.add(String.format("\u8d60\u54c1\u5217\u8868\u7b2c%s\u884c\uff0c\u914d\u9001\u5546\u54c1\u5fc5\u987b\u5f55\u5165\u914d\u9001\u65f6\u95f4\u3002", seq));
                        isRight = false;
                    }
                    if (!isRight) continue;
                    BigDecimal promoteGiftValue = DynamicObjectUtils.getBigDecimal((DynamicObject)sendGoodsEntity, (String)"promotegiftvalue");
                    if (promoteGiftValue.compareTo(BigDecimal.ZERO) == 0) {
                        lstSeq.add(seq);
                    }
                    selGoodsRow.add((DynamicObject)sendGoodsEntities.get(rowIndex));
                }
                if (!CollectionUtils.isEmpty(lstErrMsg)) {
                    int size = lstErrMsg.size();
                    if (size == 1) {
                        NotificationUtil.showDefaultTipNotify((String)((String)lstErrMsg.get(0)), (IFormView)this.getView());
                    } else if (size > 1) {
                        FormShowParameter parameter = FormShowUtils.showOperationResult(lstErrMsg);
                        this.getView().showForm(parameter);
                    }
                    return;
                }
                boolean isSuccess = this.checkInventoryInfoWithDelivery(selGoodsRow, false);
                if (!isSuccess) {
                    this.getView().showMessage("\u672a\u5339\u914d\u5230\u6240\u9009\u5546\u54c1\u7684\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
                    return;
                }
                isSuccess = this.checkInventoryInfoWithoutDelivery(selGoodsRow, false);
                if (isSuccess) {
                    boolean isNext;
                    if (!CollectionUtils.isEmpty(lstSeq) && !(isNext = this.noGiftValueControlJudge(lstSeq, "nogiftvaluecontrol"))) {
                        return;
                    }
                    this.getView().setReturnData((Object)Boolean.TRUE);
                    this.returnToParent(selGoodsRow);
                }
            } else {
                this.getView().showMessage("\u8bf7\u52fe\u9009\u8d60\u9001\u5546\u54c1\u3002");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"matchinv")) {
            DynamicObjectCollection sendGoodsEntities = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            int[] selRows = entryGrid.getSelectRows();
            if (Arrays.stream(selRows).noneMatch(x -> x == rowIndex)) {
                return;
            }
            selRows = new int[]{rowIndex};
            boolean isCheckData = this.checkData(selRows, sendGoodsEntities);
            if (!isCheckData) {
                return;
            }
            ArrayList<DynamicObject> selGoodsRow = new ArrayList<DynamicObject>(0);
            if (!CollectionUtils.isEmpty((Collection)sendGoodsEntities)) {
                boolean isSuccess;
                ArrayList<String> lstErrMsg = new ArrayList<String>();
                ArrayList<String> lstSeq = new ArrayList<String>();
                boolean isRight = true;
                boolean isDelivery = false;
                DynamicObject sendGoodsEntity = (DynamicObject)sendGoodsEntities.get(rowIndex);
                String seq = DynamicObjectUtils.getString((DynamicObject)sendGoodsEntity, (String)"seq");
                DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)sendGoodsEntity, (String)"channelstocktypeid");
                if (invType == null) {
                    lstErrMsg.add(String.format("\u8d60\u54c1\u5217\u8868\u7b2c%s\u884c\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", seq));
                    isRight = false;
                }
                if (isRight) {
                    BigDecimal promoteGiftValue = DynamicObjectUtils.getBigDecimal((DynamicObject)sendGoodsEntity, (String)"promotegiftvalue");
                    if (promoteGiftValue.compareTo(BigDecimal.ZERO) == 0) {
                        lstSeq.add(seq);
                    }
                    DynamicObject sendGoodsEntry = (DynamicObject)sendGoodsEntities.get(rowIndex);
                    isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)sendGoodsEntry, (String)"isdelivery");
                    selGoodsRow.add(sendGoodsEntry);
                }
                if (!CollectionUtils.isEmpty(lstErrMsg)) {
                    int size = lstErrMsg.size();
                    if (size == 1) {
                        NotificationUtil.showDefaultTipNotify((String)((String)lstErrMsg.get(0)), (IFormView)this.getView());
                    } else if (size > 1) {
                        FormShowParameter parameter = FormShowUtils.showOperationResult(lstErrMsg);
                        this.getView().showForm(parameter);
                    }
                    return;
                }
                if (isDelivery) {
                    isSuccess = this.checkInventoryInfoWithDelivery(selGoodsRow, true);
                    if (!isSuccess) {
                        this.getView().showMessage("\u672a\u5339\u914d\u5230\u6240\u9009\u5546\u54c1\u7684\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
                        return;
                    }
                } else {
                    isSuccess = this.checkInventoryInfoWithoutDelivery(selGoodsRow, true);
                }
                if (isSuccess && !CollectionUtils.isEmpty(lstSeq)) {
                    this.noGiftValueControlJudge(lstSeq, "ispromgiftdistrule");
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (StringUtils.equals((CharSequence)e.getCallBackId(), (CharSequence)"nogiftvaluecontrol") && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selRow = entryGrid.getSelectRows();
            ArrayList<DynamicObject> selGoodsRow = new ArrayList<DynamicObject>(0);
            for (int index : selRow) {
                DynamicObject giftEntity = this.getModel().getEntryRowEntity("entryentity", index);
                if (giftEntity == null) continue;
                selGoodsRow.add(giftEntity);
            }
            if (!CollectionUtils.isEmpty(selGoodsRow)) {
                this.getView().setReturnData((Object)Boolean.TRUE);
                this.returnToParent(selGoodsRow);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObjectCollection docSendGoodsEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)docSendGoodsEntry) && ObjectUtils.isEmpty((Object)this.getView().getReturnData())) {
            String promoteSeq = DynamicObjectUtils.getString((DynamicObject)((DynamicObject)docSendGoodsEntry.get(0)), (String)"promoteseq");
            this.getView().returnDataToParent((Object)promoteSeq);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        QFilter filter;
        String key = e.getProperty().getName();
        DynamicObjectCollection docSendEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)docSendEntry)) {
            return;
        }
        DynamicObject dataEntity = (DynamicObject)docSendEntry.get(e.getRow());
        switch (key) {
            case "inventoryorgid": {
                filter = this.getInvOrgFilter();
                break;
            }
            case "erpstockid": {
                filter = this.getErpStockFilter(dataEntity);
                break;
            }
            default: {
                filter = null;
            }
        }
        F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        DynamicObjectCollection docSendEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)docSendEntry)) {
            return;
        }
        DynamicObject doSendEntry = (DynamicObject)docSendEntry.get(rowIndex);
        switch (key = e.getProperty().getName()) {
            case "inventoryorgid": {
                this.stockOrgChanged(doSendEntry, rowIndex);
                break;
            }
            case "erpstockid": {
                this.stockChanged(doSendEntry, rowIndex);
                break;
            }
            case "distributionmode": {
                long deliveryModeId = DynamicObjectUtils.getPkValue((DynamicObject)doSendEntry, (String)"distributionmode");
                Boolean isDelivery = this.isDelivery(deliveryModeId);
                this.getModel().setValue("isdelivery", (Object)isDelivery, rowIndex);
                this.getModel().setValue("deliverytime", null, rowIndex);
                this.getView().setEnable(isDelivery, rowIndex, new String[]{"deliverytime"});
                break;
            }
            case "isdelivery": {
                this.updateModeWithoutRule(doSendEntry, rowIndex);
                break;
            }
        }
    }

    private void createNewSendEntity(DynamicObject dataEntity, DynamicObject doPromoteRule, DynamicObjectCollection docSendEntry, DynamicObject branch, String goodsSeq, String goodsName, DynamicObject stock, DynamicObject stockOrg, DynamicObject erpStock, DynamicObject defOwner, DynamicObject invStatus, boolean isAllowBook, String promoteType) {
        DynamicObjectCollection docGroupEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromoteRule, (String)"groupentry");
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        String groupSeqNo = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"seqno");
        if (!CollectionUtils.isEmpty((Collection)docGroupEntry)) {
            for (DynamicObject doGroupEntry : docGroupEntry) {
                String groupNo = DynamicObjectUtils.getString((DynamicObject)doGroupEntry, (String)"ggroupno") + groupSeqNo;
                BigDecimal sumQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGroupEntry, (String)"gsumitemqty");
                int pickQty = DynamicObjectUtils.getInt((DynamicObject)doGroupEntry, (String)"gpickqty");
                DynamicObjectCollection docSubItemEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGroupEntry, (String)"subgiftitementry");
                if (CollectionUtils.isEmpty((Collection)docSubItemEntry)) continue;
                for (DynamicObject doSubItemEntry : docSubItemEntry) {
                    DynamicObject doSendEntry = docSendEntry.addNew();
                    DynamicObject doSendGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgitemid");
                    DynamicObject doBarCode = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgbarcodeid");
                    DynamicObject doBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgbrandid");
                    DynamicObject doGoodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgitemclassid");
                    BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSubItemEntry, (String)"subitemqty");
                    DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgdeliverystocktype");
                    DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)doSubItemEntry, (String)"subgdeliverymode");
                    this.setPromoteFields(doSendEntry, sumQty, pickQty, groupNo, doSendGoods, doBarCode);
                    DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doSendEntry, (String)"goodsid");
                    this.setGoodsFields(doGoods, doSendEntry, doBrand, doGoodsClass, saleQty, goodsSeq, goodsName, isAllowBook, doPromoteRule, promoteType, docGoodsEntry);
                    saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendEntry, (String)"saleqty");
                    UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)doSendEntry, (BigDecimal)saleQty);
                    this.setInventoryFields(doSendEntry, invType, distributionMode, stockOrg, defOwner, branch, stock, erpStock, invStatus);
                    this.setDeliveryInfo(goodsSeq, doSendEntry);
                    this.updateGiftValue(dataEntity, doSendEntry);
                    this.updateModeWithoutRule(doSendEntry, -1);
                }
            }
        } else {
            String groupNo = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"groupno") + groupSeqNo;
            BigDecimal sumQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"sumitemqty");
            int pickQty = DynamicObjectUtils.getInt((DynamicObject)doPromoteRule, (String)"pickqty");
            DynamicObjectCollection docGiftItemEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromoteRule, (String)"giftitementry");
            if (CollectionUtils.isEmpty((Collection)docGiftItemEntry)) {
                return;
            }
            for (DynamicObject doGiftItemEntry : docGiftItemEntry) {
                DynamicObject doSendEntry = docSendEntry.addNew();
                DynamicObject doSendGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gitemid");
                DynamicObject doBarCode = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gbarcodeid");
                DynamicObject doBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gbrandid");
                DynamicObject doGoodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gitemclassid");
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGiftItemEntry, (String)"itemqty");
                DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gdeliverystocktype");
                DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)doGiftItemEntry, (String)"gdeliverymode");
                this.setPromoteFields(doSendEntry, sumQty, pickQty, groupNo, doSendGoods, doBarCode);
                DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doSendEntry, (String)"goodsid");
                this.setGoodsFields(doGoods, doSendEntry, doBrand, doGoodsClass, saleQty, goodsSeq, goodsName, isAllowBook, doPromoteRule, promoteType, docGoodsEntry);
                saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendEntry, (String)"saleqty");
                UnitTransferUtils.updateMultiQuantities((IFormView)this.getView(), (DynamicObject)doSendEntry, (BigDecimal)saleQty);
                this.setInventoryFields(doSendEntry, invType, distributionMode, stockOrg, defOwner, branch, stock, erpStock, invStatus);
                this.setDeliveryInfo(goodsSeq, doSendEntry);
                this.updateGiftValue(dataEntity, doSendEntry);
                this.updateModeWithoutRule(doSendEntry, -1);
            }
        }
    }

    private void updateGiftValue(DynamicObject dataEntity, DynamicObject doSendEntry) {
        BigDecimal giftPrice = SaleAmountHelper.getGiftPrice((DynamicObject)dataEntity, (DynamicObject)doSendEntry, (boolean)true);
        doSendEntry.set("promotegiftprice", (Object)giftPrice);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendEntry, (String)"saleqty");
        doSendEntry.set("promotegiftvalue", (Object)giftPrice.multiply(saleQty));
    }

    private void setPromoteFields(DynamicObject doSendEntry, BigDecimal sumQty, int pickQty, String groupNo, DynamicObject doGoods, DynamicObject doBarCode) {
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        String promoteNo = frmShowParameter.getCustomParam("promotionnum").toString();
        String promoteName = frmShowParameter.getCustomParam("promotionname").toString();
        String promoteSeq = frmShowParameter.getCustomParam("promoteseq").toString();
        String promoteType = frmShowParameter.getCustomParam("promotiontype").toString();
        doSendEntry.set("promotionnum", (Object)promoteNo);
        doSendEntry.set("promotionname", (Object)promoteName);
        doSendEntry.set("promoteseq", (Object)promoteSeq);
        doSendEntry.set("promotiontype", (Object)promoteType);
        String selectType = CommonUtil.formatObjectToInt((Object)sumQty) + "\u9009" + pickQty;
        doSendEntry.set("selecttype", (Object)selectType);
        doSendEntry.set("groupno", (Object)groupNo);
        doSendEntry.set("sumitemqty", (Object)sumQty);
        doSendEntry.set("pickqty", (Object)pickQty);
        doSendEntry.set("goodsid", (Object)doGoods);
        doSendEntry.set("barcode", (Object)doBarCode);
    }

    private void setGoodsFields(DynamicObject doGoods, DynamicObject doSendEntry, DynamicObject brand, DynamicObject goodsClass, BigDecimal saleQty, String goodsSeq, String goodsName, boolean isAllowBook, DynamicObject doPromoteRule, String promoteType, DynamicObjectCollection docGoodsEntry) {
        long stockUnitId;
        long assistUnitId;
        long baseUnitId;
        doSendEntry.set("brand", (Object)brand);
        doSendEntry.set("goodsseq", (Object)goodsSeq);
        doSendEntry.set("goodsname", (Object)goodsName);
        doSendEntry.set("goodsclass", (Object)goodsClass);
        long saleUnitId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"saleunit");
        if (saleUnitId > 0L) {
            DynamicObject doSaleUnit = BusinessDataServiceHelper.loadSingle((Object)saleUnitId, (String)"bd_measureunits");
            doSendEntry.set("unit", (Object)doSaleUnit);
        }
        doSendEntry.set("operationmodel", (Object)DynamicObjectUtils.getString((DynamicObject)doGoods, (String)"operationmodel"));
        doSendEntry.set("materielid", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)doGoods, (String)"material"));
        doSendEntry.set("isdelivery", (Object)DynamicObjectUtils.getBoolean((DynamicObject)doGoods, (String)"isdelivery"));
        DynamicObject doBardCode = DynamicObjectUtils.getDynamicObject((DynamicObject)doSendEntry, (String)"barcode");
        if (!ObjectUtils.isEmpty((Object)doBardCode)) {
            this.setAuxAttr(doBardCode, doSendEntry);
        }
        if ((baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"baseunit")) > 0L) {
            DynamicObject doBaseUnit = BusinessDataServiceHelper.loadSingle((Object)baseUnitId, (String)"bd_measureunits");
            doSendEntry.set("baseunit", (Object)doBaseUnit);
        }
        if ((assistUnitId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"assistunit")) > 0L) {
            DynamicObject doAssistUnit = BusinessDataServiceHelper.loadSingle((Object)assistUnitId, (String)"bd_measureunits");
            doSendEntry.set("auxunit", (Object)doAssistUnit);
        }
        if ((stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"stockunit")) > 0L) {
            DynamicObject doStockUnit = BusinessDataServiceHelper.loadSingle((Object)stockUnitId, (String)"bd_measureunits");
            doSendEntry.set("stockunit", (Object)doStockUnit);
        }
        if (StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031")) {
            String condition = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"condition");
            BigDecimal targetAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"targetamount");
            String[] goodsSeqArray = goodsSeq.split(",");
            BigDecimal sumBalAmt = SaleOrderHelper.getSumAmount((String[])goodsSeqArray, (DynamicObjectCollection)docGoodsEntry, (String)"balamount");
            if (StringUtils.equals((CharSequence)condition, (CharSequence)"A")) {
                BigDecimal qty = CommonUtil.formatObjectToDecimal((Object)sumBalAmt.divideAndRemainder(targetAmount)[0]);
                if (qty.compareTo(BigDecimal.ZERO) == 0) {
                    doSendEntry.set("saleqty", (Object)saleQty);
                } else {
                    doSendEntry.set("saleqty", (Object)saleQty.multiply(qty));
                }
            } else {
                doSendEntry.set("saleqty", (Object)saleQty);
            }
        } else {
            doSendEntry.set("saleqty", (Object)saleQty);
        }
        doSendEntry.set("isallowbook", (Object)isAllowBook);
    }

    private void setInventoryFields(DynamicObject doSendEntry, DynamicObject invType, DynamicObject distributionMode, DynamicObject stockOrg, DynamicObject defOwner, DynamicObject branch, DynamicObject stock, DynamicObject erpStock, DynamicObject invStatus) {
        doSendEntry.set("channelstocktypeid", (Object)invType);
        doSendEntry.set("keepertype", (Object)"bos_org");
        doSendEntry.set("keeperid", (Object)stockOrg);
        doSendEntry.set("ownertype", (Object)"bos_org");
        doSendEntry.set("ownerid", (Object)defOwner);
        doSendEntry.set("distributionmode", (Object)distributionMode);
        Boolean isDelivery = this.isDelivery(DynamicObjectUtils.getPkValue((DynamicObject)distributionMode));
        doSendEntry.set("isdelivery", (Object)isDelivery);
        doSendEntry.set("deliverdeliverybranchid", (Object)branch);
        doSendEntry.set("deliverstockid", (Object)stock);
        doSendEntry.set("inventoryorgid", (Object)stockOrg);
        doSendEntry.set("erpstockid", (Object)erpStock);
        doSendEntry.set("channelstockstatusid", (Object)invStatus);
    }

    private void stockOrgChanged(DynamicObject dataEntity, int rowIndex) {
        dataEntity.set("erpstockid", null);
        this.getView().updateView("erpstockid", rowIndex);
        DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
        this.stockOrgChanged(dataEntity, stockOrg, rowIndex);
    }

    private void stockOrgChanged(DynamicObject dataEntity, DynamicObject stockOrg, int rowIndex) {
        dataEntity.set("keepertype", (Object)"bos_org");
        this.getView().updateView("keepertype", rowIndex);
        dataEntity.set("keeperid", (Object)stockOrg);
        this.getView().updateView("keeperid", rowIndex);
        dataEntity.set("ownertype", (Object)"bos_org");
        this.getView().updateView("ownertype", rowIndex);
        long stockOrgId = DynamicObjectUtils.getPkValue((DynamicObject)stockOrg);
        dataEntity.set("ownerid", (Object)InventoryUtils.getDefaultOwner((long)stockOrgId));
        this.getView().updateView("ownerid", rowIndex);
    }

    public void stockChanged(DynamicObject dataEntity, int rowIndex) {
        long stockId;
        QFilter filter;
        DynamicObject invSetup;
        DynamicObject stock = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"erpstockid");
        if (ObjectUtils.isEmpty((Object)stock)) {
            return;
        }
        DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"inventoryorgid");
        if (stockOrg == null && (stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)(invSetup = BusinessDataServiceHelper.loadSingle((String)"im_warehousesetup", (String)"id, org", (QFilter[])(filter = new QFilter("warehouse.id", "=", (Object)(stockId = DynamicObjectUtils.getPkValue((DynamicObject)stock)))).toArray())), (String)"org")) != null) {
            dataEntity.set("inventoryorgid", (Object)stockOrg);
            this.getView().updateView("inventoryorgid", rowIndex);
            this.stockOrgChanged(dataEntity, stockOrg, rowIndex);
        }
    }

    private void setDeliveryInfo(String goodsSeq, DynamicObject doEntry) {
        DynamicObject doBill = this.getView().getParentView().getModel().getDataEntity();
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doBill, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        String[] goodsSeqArray = goodsSeq.split(",");
        if (goodsSeqArray.length == 0) {
            return;
        }
        String seq = goodsSeqArray[0];
        DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq)).findFirst().orElse(null);
        if (doGoodsEntry == null) {
            return;
        }
        DynamicObjectCollection docDeliveryEntry = doGoodsEntry.getDynamicObjectCollection("salesorderdelivery");
        if (CollectionUtils.isEmpty((Collection)docDeliveryEntry)) {
            return;
        }
        DynamicObject doDeliveryEntry = (DynamicObject)docDeliveryEntry.get(0);
        doEntry.set("admindivisionid", DynamicObjectUtils.get((DynamicObject)doDeliveryEntry, (String)"districtid"));
        doEntry.set("customername", DynamicObjectUtils.get((DynamicObject)doDeliveryEntry, (String)"consignee"));
        doEntry.set("customerphone", DynamicObjectUtils.get((DynamicObject)doDeliveryEntry, (String)"deliverphonenumber"));
        doEntry.set("customeraddress", DynamicObjectUtils.get((DynamicObject)doDeliveryEntry, (String)"address"));
        doEntry.set("saledepartment", DynamicObjectUtils.get((DynamicObject)doGoodsEntry, (String)"saledepartment"));
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doBill, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RESERVE.getId()) {
            doEntry.set("isbook", (Object)Boolean.TRUE);
            doEntry.set("expecttakeorderdate", DynamicObjectUtils.get((DynamicObject)doGoodsEntry, (String)"expecttakeorderdate"));
        }
    }

    private void returnToParent(List<DynamicObject> lstData) {
        ArrayList returnDatas = new ArrayList(0);
        for (DynamicObject data : lstData) {
            String deliveryData = DynamicObjectUtils.getString((DynamicObject)data, (String)"data");
            HashMap<String, String> returnData = new HashMap<String, String>(0);
            returnData.put("status", "SUCCESS");
            returnData.put("data", (String)data);
            returnData.put("salesorderdelivery", deliveryData);
            returnDatas.add(returnData);
        }
        this.getView().returnDataToParent(returnDatas);
        this.getView().close();
    }

    private void setAuxAttr(DynamicObject barCode, DynamicObject doItem) {
        DynamicObject doBarCode = BusinessDataServiceHelper.loadSingle((Object)DynamicObjectUtils.getPkValue((DynamicObject)barCode), (String)"ocdbd_item_barcode");
        DynamicObject doAuxAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)doBarCode, (String)"auxpty");
        doItem.set("auxattrid", (Object)doAuxAttr);
    }

    private boolean checkData(int[] selRow, DynamicObjectCollection docSendGoodsEntry) {
        ArrayList<Object> lstData = new ArrayList<Object>(0);
        for (int rowIndex : selRow) {
            lstData.add(docSendGoodsEntry.get(rowIndex));
        }
        if (!CollectionUtils.isEmpty(lstData)) {
            Map<Object, Long> mapCollect = lstData.stream().collect(Collectors.groupingBy(x -> x.getString("groupno"), Collectors.counting()));
            StringBuilder sbMsg = new StringBuilder();
            if (!ObjectUtils.isEmpty(mapCollect)) {
                for (Map.Entry<Object, Long> entry : mapCollect.entrySet()) {
                    BigDecimal pickQty;
                    DynamicObject doSendGoodsEntry = docSendGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("groupno"), (CharSequence)entry.getKey().toString())).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doSendGoodsEntry)) continue;
                    Object key = entry.getKey();
                    String selectType = DynamicObjectUtils.getString((DynamicObject)doSendGoodsEntry, (String)"selecttype");
                    BigDecimal qty = CommonUtil.formatObjectToDecimal((Object)mapCollect.get(key));
                    if (qty.compareTo(pickQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSendGoodsEntry, (String)"pickqty")) <= 0) continue;
                    sbMsg.append(String.format("\u4fc3\u9500\u7ec4\u53f7%s\uff0c\u53ea\u652f\u6301%s\uff0c\u5f53\u524d\u9009\u62e9\u6570\u91cf\u4e3a%s,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", key, selectType, qty));
                }
                if (sbMsg.length() > 0) {
                    NotificationUtil.showDefaultTipNotify((String)sbMsg.toString(), (IFormView)this.getView());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkInventoryInfoWithDelivery(List<DynamicObject> lstData, boolean isEntryRowClick) {
        for (DynamicObject data : lstData) {
            String operationModel = DynamicObjectUtils.getString((DynamicObject)data, (String)"operationmodel");
            boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isdelivery");
            if (!isDelivery || !StringUtils.equals((CharSequence)operationModel, (CharSequence)"1")) continue;
            Map<String, Object> params = this.getDeliveryParams(data);
            Map info = SaleOrderDeliveryInfoHelper.getDeliveryInfo(params, (boolean)true);
            if (CollectionUtils.isEmpty((Map)info)) {
                return false;
            }
            boolean isSuccess = CommonUtil.formatObjectToBoolean(info.get("isSuccess"));
            if (!isSuccess) {
                return false;
            }
            Map deliveryData = (Map)info.get("deliveryData");
            if (CollectionUtils.isEmpty((Map)deliveryData)) {
                return false;
            }
            Object returnData = deliveryData.get("data");
            if (ObjectUtils.isEmpty(returnData)) continue;
            data.set("data", (Object)JSONObject.toJSONString(returnData));
            if (!isEntryRowClick) continue;
            this.setInvFieldValue(returnData, data);
        }
        return true;
    }

    private boolean checkInventoryInfoWithoutDelivery(List<DynamicObject> lstData, boolean isEntryRowClick) {
        if (lstData.size() == 0) {
            return true;
        }
        List<JSONObject> params = this.getInventoryParams(lstData);
        if (CollectionUtils.isEmpty(params)) {
            return true;
        }
        List inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(params);
        if (CollectionUtils.isEmpty((Collection)inventoryInfo)) {
            NotificationUtil.showDefaultTipNotify((String)"\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6267\u884c\u9884\u8ba2\u3002", (IFormView)this.getView());
            return false;
        }
        StringBuilder sbMsg = new StringBuilder();
        for (JSONObject inventoryItem : inventoryInfo) {
            String invStatus = inventoryItem.getString("invstatus");
            long itemId = inventoryItem.getLong("itemid");
            DynamicObject doGoodsItem = lstData.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == itemId).findFirst().orElse(null);
            if (doGoodsItem == null) {
                return false;
            }
            if (!StringUtils.equals((CharSequence)invStatus, (CharSequence)"1")) {
                sbMsg.append(String.format("\u8d60\u54c1\u5217\u8868\u7b2c%s\u884c\uff0c\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6267\u884c\u9884\u8ba2\u3002", DynamicObjectUtils.getString((DynamicObject)doGoodsItem, (String)"seq")));
                continue;
            }
            doGoodsItem.set("data", (Object)JSONObject.toJSONString((Object)inventoryItem));
            if (!isEntryRowClick) continue;
            this.setInvFieldValue(inventoryItem, doGoodsItem);
        }
        if (sbMsg.length() > 0) {
            NotificationUtil.showDefaultTipNotify((String)sbMsg.toString(), (IFormView)this.getView());
            return false;
        }
        return true;
    }

    private Boolean isDelivery(long deliveryModeId) {
        List<Long> selfPickUpModes = Arrays.asList(926601071999218688L, 926601157210585088L, 1188335265681326080L);
        if (deliveryModeId == 0L || selfPickUpModes.contains(deliveryModeId)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private DynamicObject[] queryPromoteRule(long promoteBillId) {
        QFilter filter = new QFilter("promotebillid", "=", (Object)promoteBillId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocdpm_promote_rule");
        Object[] selectFields = entityType.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return BusinessDataServiceHelper.load((String)"ocdpm_promote_rule", (String)StringUtils.join((Object[])selectFields, (char)','), (QFilter[])filter.toArray());
    }

    private List<JSONObject> getInventoryParams(List<DynamicObject> lstData) {
        ArrayList<JSONObject> inventoryParams = new ArrayList<JSONObject>(0);
        for (DynamicObject data : lstData) {
            boolean isAmt;
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isbook");
            String operationModel = DynamicObjectUtils.getString((DynamicObject)data, (String)"operationmodel");
            DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"goodsid");
            boolean isJoint = StringUtils.equals((CharSequence)operationModel, (CharSequence)"0");
            long itemsTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doGoods, (String)"itemtypeid");
            boolean isService = itemsTypeId == 870946434386494464L;
            boolean bl = isAmt = itemsTypeId == 870946349007286272L;
            if (isBook || isJoint || isService || isAmt) continue;
            JSONObject inventoryParam = new JSONObject();
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"deliverdeliverybranchid");
            inventoryParam.put("saleOrgId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg"));
            inventoryParam.put("saleChannelID", (Object)DynamicObjectUtils.getPkValue((DynamicObject)branch));
            inventoryParam.put("itemId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"goodsid"));
            inventoryParam.put("materialId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"materielid"));
            inventoryParam.put("auxPtyID", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"auxattrid"));
            inventoryParam.put("unitId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"unit"));
            inventoryParam.put("unitQty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleqty"));
            inventoryParam.put("baseUnitID", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"baseunit"));
            inventoryParam.put("baseUnitQty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"baseunitqty"));
            inventoryParam.put("invtypeid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"channelstocktypeid"));
            inventoryParam.put("stockOrgId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"inventoryorgid"));
            inventoryParam.put("warehouseId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"erpstockid"));
            inventoryParam.put("distributionModeId", (Object)926601071999218688L);
            inventoryParam.put("adminDivisionId", (Object)DynamicObjectUtils.getString((DynamicObject)data, (String)"admindivisionid"));
            inventoryParam.put("customerKey", (Object)DynamicObjectUtils.getInt((DynamicObject)data, (String)"index"));
            inventoryParams.add(inventoryParam);
        }
        return inventoryParams;
    }

    private Map<String, Object> getDeliveryParams(DynamicObject data) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        DynamicObject doBill = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)doBill, (String)"salebranchid");
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branch, (String)"saleorg");
        params.put("saleOrgId", bizOrgId);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        params.put("saleChannelID", branchId);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"goodsid");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        params.put("itemId", goodsId);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)data, (String)"admindivisionid");
        params.put("adminDivisionId", adminDivisionId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"materielid");
        params.put("materialId", materialId);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"baseunit");
        params.put("baseUnitID", baseUnitId);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"unit");
        params.put("unitId", unitId);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleqty");
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"baseunitqty");
        params.put("unitQty", saleQty);
        params.put("baseUnitQty", baseUnitQty);
        Date deliveryDate = DynamicObjectUtils.getDate((DynamicObject)data, (String)"deliverytime");
        params.put("deliveryDate", deliveryDate);
        long auxAttrId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"auxattrid");
        params.put("auxPtyID", auxAttrId);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)doBill, (String)"bizdate");
        params.put("bizdate", bizDate);
        long invTypeId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"channelstocktypeid");
        params.put("invtypeid", invTypeId);
        return params;
    }

    private QFilter getInvOrgFilter() {
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (bizOrgId == 0L) {
            NotificationUtil.showDefaultTipNotify((String)"\u4e1a\u52a1\u7ec4\u7ec7\u5f02\u5e38\u3002", (IFormView)this.getView());
            return F7Utils.getEveFalseFilter();
        }
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        String invQueryRange = SystemParamUtil.getInvQueryRange((long)bizOrgId, (long)branchId);
        return F7Util.getStockOrgFilter((long)bizOrgId, (String)invQueryRange);
    }

    private QFilter getErpStockFilter(DynamicObject dataEntity) {
        List invOrgIds;
        long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"inventoryorgid");
        if (invOrgId == 0L) {
            QFilter filter = this.getInvOrgFilter();
            filter.and(F7Utils.getCommonStatusFilter());
            invOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])filter.toArray(), null, (int)-1);
        } else {
            invOrgIds = Collections.singletonList(invOrgId);
        }
        List lstStockId = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"IWareHouseService", (String)"getAllSetupWarehouseIDs", (Object[])new Object[]{invOrgIds});
        return new QFilter("id", "in", (Object)lstStockId);
    }

    private String getGoodsName(String[] goodsSeqArray, DynamicObjectCollection docGoodsEntry) {
        StringBuilder goodsNameStr = new StringBuilder();
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seq, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doGoodsEntry)) continue;
            if (goodsNameStr.length() > 0) {
                goodsNameStr.append(',');
            }
            goodsNameStr.append(DynamicObjectUtils.getString((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid"), (String)"name"));
        }
        return goodsNameStr.toString();
    }

    private boolean noGiftValueControlJudge(List<String> lstSeq, String callbackId) {
        boolean isNext;
        String noGiftValueControl;
        DynamicObject parentEntity = this.getView().getParentView().getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)parentEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)parentEntity, (String)"salebranchid");
        switch (noGiftValueControl = SystemParamUtil.getNoGiftValueControl((long)orgId, (long)branchId)) {
            case "2": {
                isNext = false;
                ConfirmCallBackListener listener = new ConfirmCallBackListener(callbackId, (IFormPlugin)this);
                String tip = String.format("\u7b2c%s\u884c\u8d60\u54c1\u65e0\u6cd5\u83b7\u53d6\u8d60\u54c1\u4ef7\u503c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u8d60\u9001\uff1f", StringUtils.join((Object[])lstSeq.toArray(), (String)","));
                this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, listener);
                break;
            }
            case "3": {
                isNext = false;
                String tip = String.format("\u7b2c%s\u884c\u8d60\u54c1\u65e0\u6cd5\u83b7\u53d6\u8d60\u54c1\u4ef7\u503c\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u8d60\u9001\u3002", StringUtils.join((Object[])lstSeq.toArray(), (String)","));
                NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
                break;
            }
            default: {
                isNext = true;
            }
        }
        return isNext;
    }

    private void setInvFieldValue(Object returnData, DynamicObject data) {
        long stockId;
        long stockOrgId;
        if (returnData == null) {
            return;
        }
        JSONObject resultJson = null;
        if (returnData instanceof List) {
            List result = (List)returnData;
            if (result.size() > 0) {
                resultJson = result.stream().findFirst().orElse(null);
            }
        } else {
            resultJson = (JSONObject)returnData;
        }
        if (resultJson == null) {
            return;
        }
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        long distributionModeId = resultJson.getLongValue("distributionmodeid");
        if (distributionModeId != 0L) {
            DynamicObject distributionMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
            data.set("distributionmode", (Object)distributionMode);
            this.getView().updateView("distributionmode", rowIndex);
        }
        if ((stockOrgId = resultJson.getLongValue("stockorgid")) != 0L) {
            DynamicObject stockOrg = BusinessDataServiceHelper.loadSingle((Object)stockOrgId, (String)"bos_org");
            data.set("inventoryorgid", (Object)stockOrg);
            this.getView().updateView("inventoryorgid", rowIndex);
            this.stockOrgChanged(data, rowIndex);
        }
        if ((stockId = resultJson.getLongValue("warehouseid")) != 0L) {
            DynamicObject erpStock = BusinessDataServiceHelper.loadSingle((Object)stockId, (String)"bd_warehouse");
            data.set("erpstockid", (Object)erpStock);
            this.getView().updateView("erpstockid", rowIndex);
        }
    }

    private void updateModeWithoutRule(DynamicObject data, int rowIndex) {
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isdelivery");
        if (rowIndex >= 0) {
            this.getModel().beginInit();
            if (isDelivery) {
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)926596489101228032L, (int)rowIndex);
            } else {
                DynamicObjectUtils.setBaseDataByPkValue((IDataModel)this.getModel(), (String)"distributionmode", (Object)926601071999218688L, (int)rowIndex);
            }
            this.getModel().endInit();
            this.getView().updateView("distributionmode", rowIndex);
        } else {
            long distributionModeId = isDelivery ? 926596489101228032L : 926601071999218688L;
            long oldDistModeId = DynamicObjectUtils.getPkValue((DynamicObject)data, (String)"distributionmode");
            if (oldDistModeId == 0L) {
                DynamicObject distMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
                data.set("distributionmode", (Object)distMode);
            }
        }
    }
}

