/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderCheckHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SalesOrderDrawFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(SalesOrderDrawFormPlugin.class);
    private static final String[] F7FIELD_KEYS = new String[]{"saler", "salegroup", "billtype"};
    private static final String[] ENTRY_TYPE_LIST = new String[]{"LSWKD", "YDWKD"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        String type = customParams.getOrDefault("type", "");
        this.getModel().setValue("type", (Object)type);
        Long branchId = customParams.getOrDefault("branchid", 0L);
        this.getModel().setValue("branchid", (Object)branchId);
        Long orgId = customParams.getOrDefault("orgid", 0L);
        this.getModel().setValue("orgid", (Object)orgId);
        Boolean isRedRush = customParams.getOrDefault("isredrush", Boolean.FALSE);
        this.getModel().setValue("isredrush", (Object)isRedRush);
        if (type.equals("CHANGE")) {
            String changeItemType = customParams.getOrDefault("changeitemtype", "");
            this.getModel().setValue("changeitemtype", (Object)changeItemType);
            String makeUpBalanceMode = customParams.getOrDefault("makeupbalancemode", "");
            this.getModel().setValue("makeupbalancemode", (Object)makeUpBalanceMode);
        }
        String targetPageId = customParams.getOrDefault("TargetBillPageId", "");
        this.getModel().setValue("TargetBillPageId", (Object)targetPageId);
        this.initBillType();
        if (type.equals("CANCELORDER")) {
            this.resetCaption("returnreason", "\u9000\u8ba2\u539f\u56e0");
        }
    }

    public void afterBindData(EventObject e) {
        String text;
        String type;
        super.afterBindData(e);
        switch (type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"))) {
            case "RETURNSALE": {
                text = "\u9000\u8d27\u6570\u91cf";
                break;
            }
            case "CVTSALE": {
                text = "\u8f6c\u9500\u6570\u91cf";
                break;
            }
            case "CANCELORDER": {
                text = "\u9000\u8ba2\u6570\u91cf";
                break;
            }
            case "CHANGE": {
                text = "\u6362\u8d27\u6570\u91cf";
                break;
            }
            default: {
                text = "\u9009\u5355\u6570\u91cf";
            }
        }
        LocaleString caption = new LocaleString(text);
        DecimalEdit changeQtyEdit = (DecimalEdit)this.getView().getControl("changeqty");
        changeQtyEdit.setCaption(caption);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_query", "btn_confirm"});
        for (String f7FieldKey : F7FIELD_KEYS) {
            BasedataEdit edit = (BasedataEdit)this.getControl(f7FieldKey);
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        QFilter filter = null;
        switch (key) {
            case "saler": {
                long branchId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("branchid"));
                if (branchId <= 0L) {
                    e.setCancel(true);
                    return;
                }
                filter = F7Util.getSalerFilter((long)branchId);
                break;
            }
            case "salegroup": {
                DynamicObject saleMan = (DynamicObject)this.getModel().getValue("saler");
                filter = F7Util.getSaleDeptFilter((DynamicObject)saleMan);
                break;
            }
            case "billtype": {
                String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
                filter = F7Util.getBillTypeFilter((String)type);
                break;
            }
        }
        F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, filter);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        DecimalEdit qty;
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof DecimalEdit && StringUtils.equals((CharSequence)(qty = (DecimalEdit)source).getKey(), (CharSequence)"changeqty")) {
            this.beforeChangeQtyPostBack(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"returnwarehouse")) {
            this.returnStockChanged(changeSet);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        switch (ctrl.getKey()) {
            case "btn_confirm": {
                this.returnDataToParent();
                break;
            }
            case "btn_query": {
                this.query();
                break;
            }
        }
    }

    private void returnStockChanged(ChangeData[] changeSet) {
        long retStockId;
        List retOrgIds;
        ChangeData changeData = changeSet[0];
        if (CommonUtil.checkChanged((ChangeData)changeData)) {
            return;
        }
        DynamicObject retStock = (DynamicObject)changeData.getNewValue();
        if (retStock != null && !CollectionUtils.isEmpty((Collection)(retOrgIds = InventoryUtils.getInvOrgIdsByStock((long)(retStockId = DynamicObjectUtils.getPkValue((DynamicObject)retStock)))))) {
            int index = changeData.getRowIndex();
            this.getModel().setItemValueByID("returnorg", retOrgIds.get(0), index);
        }
    }

    private void beforeChangeQtyPostBack(BeforeFieldPostBackEvent e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        String type = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"type");
        int index = e.getRowIndex();
        DynamicObject entryEntity = (DynamicObject)entryEntities.get(index);
        BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
        BigDecimal newQty = CommonUtil.formatObjectToDecimal((Object)e.getValue());
        String tip = "";
        String strMustRetQty = mustRetQty.stripTrailingZeros().toPlainString();
        if (StringUtils.equals((CharSequence)type, (CharSequence)"CVTSALE")) {
            if (newQty.compareTo(BigDecimal.ZERO) <= 0 || newQty.abs().compareTo(mustRetQty) > 0) {
                tip = String.format("\u8f6c\u9500\u6570\u91cf\u4e3a\u6b63\u6570\uff0c\u4e14\u4e0d\u80fd\u8d85\u8fc7%s\u3002", strMustRetQty);
            }
        } else {
            String text;
            switch (type) {
                case "RETURNSALE": {
                    text = "\u9000\u8d27";
                    break;
                }
                case "CANCELORDER": {
                    text = "\u9000\u8ba2";
                    break;
                }
                case "CHANGE": {
                    text = "\u6362\u8d27";
                    break;
                }
                default: {
                    text = "";
                }
            }
            if (newQty.compareTo(BigDecimal.ZERO) >= 0 || newQty.abs().compareTo(mustRetQty) > 0) {
                tip = String.format("%s\u6570\u91cf\u4e3a\u8d1f\u6570\uff0c\u4e14\u4e0d\u80fd\u8d85\u8fc7%s\u3002", text, strMustRetQty);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)this.getView());
            e.setCancel(true);
            this.getView().updateView("changeqty", index);
        }
    }

    private void initBillType() {
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        switch (type) {
            case "DGD": {
                this.getModel().setValue("billtype", (Object)BillTypeEnum.STORE.getId());
                break;
            }
            case "YDWKD": 
            case "CANCELORDER": {
                this.getModel().setValue("billtype", (Object)BillTypeEnum.RESERVE.getId());
                break;
            }
        }
    }

    private void returnDataToParent() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            Map<String, Object> rltMatchMap;
            boolean isCtrlWithReturnRule;
            ArrayList<String> messages;
            String makeupBalanceMode;
            String changeType;
            String type;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
            DynamicObjectCollection selectedEntryEntity = new DynamicObjectCollection();
            for (int selectRow : selectRows) {
                selectedEntryEntity.add(entryEntity.get(selectRow));
            }
            if (CollectionUtils.isEmpty((Collection)selectedEntryEntity)) {
                return;
            }
            String targetPageId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"TargetBillPageId");
            boolean isRedRush = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isredrush");
            if (!this.checkSelectedData(isRedRush, type = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"type"), changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype"), makeupBalanceMode = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"makeupbalancemode"), selectedEntryEntity, messages = new ArrayList<String>())) {
                int size = messages.size();
                if (size == 1) {
                    NotificationUtil.showDefaultTipNotify((String)((String)messages.get(0)), (IFormView)this.getView());
                } else if (size > 1) {
                    FormShowParameter parameter = FormShowUtils.showOperationResult(messages);
                    this.getView().showForm(parameter);
                }
                return;
            }
            HashSet<Long> sourceBillIds = new HashSet<Long>(0);
            for (DynamicObject selectedEntry : selectedEntryEntity) {
                long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)selectedEntry, (String)"id");
                if (sourceBillId <= 0L) continue;
                sourceBillIds.add(sourceBillId);
            }
            if (sourceBillIds.size() > 0) {
                long billId = 0L;
                if (this.getView().getParentView() != null) {
                    billId = CommonUtil.formatObejctToLong((Object)this.getView().getParentView().getModel().getDataEntity().getPkValue());
                }
                for (Long sourceBillId : sourceBillIds) {
                    JSONObject relatedJson = SaleOrderCheckHelper.checkRelatedBillUnAudit((long)sourceBillId, (long)billId);
                    if (relatedJson.getBoolean("success").booleanValue()) continue;
                    NotificationUtil.showDefaultTipNotify((String)relatedJson.getString("message"), (IFormView)this.getView());
                    return;
                }
            }
            long orgId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"orgid");
            long branchId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"branchid");
            if (StringUtils.equals((CharSequence)type, (CharSequence)"RETURNSALE") && (isCtrlWithReturnRule = SystemParamUtil.getIsCtrlWithReturnRule((long)orgId, (long)branchId)) && (rltMatchMap = this.getDrawPageDistMode(selectedEntryEntity, false, isRedRush)).size() > 0 && !CommonUtil.formatObjectToBoolean((Object)rltMatchMap.get("success"))) {
                NotificationUtil.showDefaultTipNotify((String)rltMatchMap.get("msg").toString(), (IFormView)this.getView());
                return;
            }
            List<Map<String, Object>> list = this.getReturnData(dataEntity, selectedEntryEntity, targetPageId, isRedRush, changeType, orgId);
            if (!CollectionUtils.isEmpty(list)) {
                this.getView().returnDataToParent(list);
                this.getView().close();
            }
        } else {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u3002", (IFormView)this.getView());
        }
    }

    private void query() {
        QFilter filter = this.getFilter();
        LOG.info("\u9009\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a" + CommonUtil.formatStringToEmpty((Object)filter));
        DynamicObjectCollection data = this.getData(filter);
        this.fillData(data);
    }

    private void fillData(DynamicObjectCollection data) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            String type;
            switch (type = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"type")) {
                case "SXD": {
                    this.fillArData(data, entryEntity);
                    break;
                }
                case "LSWKD": 
                case "YDWKD": {
                    this.fillEntryData(data, entryEntity);
                    break;
                }
                default: {
                    this.fillDeliveryData(data, entryEntity);
                }
            }
        }
        this.getView().updateView("entryentity");
    }

    private void fillArData(DynamicObjectCollection data, DynamicObjectCollection entryEntity) {
        for (DynamicObject item : data) {
            DynamicObject entryItem = entryEntity.addNew();
            this.fillCommonData(item, entryItem);
            this.fillEntryId(item, entryItem);
            this.fillArAmtData(item, entryItem);
            this.fillSaleManData(item, entryItem);
        }
    }

    private void fillArAmtData(DynamicObject item, DynamicObject entryItem) {
        BigDecimal notSettleAmount;
        BigDecimal alrSettleAmount;
        int amtPrecision = DynamicObjectUtils.getInt((DynamicObject)item, (String)"finentity.settlecurrid.amtprecision");
        String sign = DynamicObjectUtils.getString((DynamicObject)item, (String)"finentity.settlecurrid.sign");
        BigDecimal settleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.settleamount");
        if (settleAmount.compareTo(BigDecimal.ZERO) != 0) {
            String strSettleAmount = String.format("%s%f", sign, settleAmount.setScale(amtPrecision, 4));
            entryItem.set("settleamount", (Object)strSettleAmount);
        }
        if ((alrSettleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.alrsettleamount")).compareTo(BigDecimal.ZERO) != 0) {
            String strAlrSettleAmount = String.format("%s%f", sign, alrSettleAmount.setScale(amtPrecision, 4));
            entryItem.set("alrsettleamount", (Object)strAlrSettleAmount);
        }
        if ((notSettleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"finentity.notsettleamount")).compareTo(BigDecimal.ZERO) != 0) {
            String strNotSettleAmount = String.format("%s%f", sign, notSettleAmount.setScale(amtPrecision, 4));
            entryItem.set("notsettleamount", (Object)strNotSettleAmount);
        }
    }

    private void fillSaleManData(DynamicObject item, DynamicObject entryItem) {
        String saleMan = DynamicObjectUtils.getString((DynamicObject)item, (String)"saler.username");
        entryItem.set("goodssaler", (Object)saleMan);
    }

    private void fillEntryData(DynamicObjectCollection data, DynamicObjectCollection entryEntity) {
        for (DynamicObject item : data) {
            DynamicObject entryItem = entryEntity.addNew();
            this.fillCommonData(item, entryItem);
            this.fillEntryData(item, entryItem);
            this.fillEntryAmtData(item, entryItem);
            this.fillEntrySaleManData(item, entryItem);
        }
    }

    private void fillEntryData(DynamicObject item, DynamicObject entryItem) {
        this.fillEntryId(item, entryItem);
        String goods = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.goodsid.name");
        entryItem.set("goodsid", (Object)goods);
        String barCode = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.barcode.barcode");
        entryItem.set("barcode", (Object)barCode);
        String goodsClass = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.goodsclass.name");
        entryItem.set("goodsclass", (Object)goodsClass);
        BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.mustretqty");
        BigDecimal newSaleQty = this.formatQty(entryItem, mustRetQty);
        entryItem.set("saleqty", (Object)newSaleQty);
        entryItem.set("changeqty", (Object)newSaleQty);
        String unit = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.unit.name");
        entryItem.set("unit", (Object)unit);
    }

    private void fillEntryAmtData(DynamicObject item, DynamicObject entryItem) {
        BigDecimal deposit;
        BigDecimal balPrice;
        String sign = DynamicObjectUtils.getString((DynamicObject)item, (String)"currencyid.sign");
        int pricePrecision = DynamicObjectUtils.getInt((DynamicObject)item, (String)"currencyid.priceprecision");
        int amtPrecision = DynamicObjectUtils.getInt((DynamicObject)item, (String)"currencyid.amtprecision");
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.retailprice");
        if (retailPrice.compareTo(BigDecimal.ZERO) != 0) {
            String strRetailPrice = String.format("%s%f", sign, retailPrice.setScale(pricePrecision, 4));
            entryItem.set("retailprice", (Object)strRetailPrice);
        }
        if ((balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.discountprice")).compareTo(BigDecimal.ZERO) != 0) {
            String strBalPrice = String.format("%s%f", sign, balPrice.setScale(pricePrecision, 4));
            entryItem.set("discountprice", (Object)strBalPrice);
        }
        if ((deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.deposit")).compareTo(BigDecimal.ZERO) != 0) {
            String strDepositPrice = String.format("%s%f", sign, deposit.setScale(pricePrecision, 4));
            entryItem.set("deposit", (Object)strDepositPrice);
        }
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"goodsentryentity.isbook");
        entryItem.set("isbook", (Object)isBook);
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        if (Arrays.asList(ENTRY_TYPE_LIST).contains(type) || StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE")) {
            BigDecimal noReceiveExpectFinalAmt;
            BigDecimal noReceiveFinalAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.norecefinalamount");
            if (noReceiveFinalAmt.compareTo(BigDecimal.ZERO) != 0) {
                String strNoReceiveFinalAmt = String.format("%s%f", sign, noReceiveFinalAmt.setScale(amtPrecision, 4));
                entryItem.set("norecefinalamount", (Object)strNoReceiveFinalAmt);
            }
            if ((noReceiveExpectFinalAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.noreceexpectfinalamount")).compareTo(BigDecimal.ZERO) != 0) {
                String strNoReceiveExpectFinalAmt = String.format("%s%f", sign, noReceiveExpectFinalAmt.setScale(amtPrecision, 4));
                entryItem.set("noreceexpectfinalamount", (Object)strNoReceiveExpectFinalAmt);
            }
            if (!StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE")) {
                BigDecimal receExpectFinalAmt;
                BigDecimal expectFinalAmt;
                BigDecimal receivedFinalPayment;
                BigDecimal finalPayment;
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.balamount");
                if (balAmount.compareTo(BigDecimal.ZERO) != 0) {
                    String strBalAmount = String.format("%s%f", sign, balAmount.setScale(amtPrecision, 4));
                    entryItem.set("balamount", (Object)strBalAmount);
                }
                if ((finalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.finalpayment")).compareTo(BigDecimal.ZERO) != 0) {
                    String strFinalPayment = String.format("%s%f", sign, finalPayment.setScale(amtPrecision, 4));
                    entryItem.set("finalpayment", (Object)strFinalPayment);
                }
                if ((receivedFinalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.receivedfinalpayment")).compareTo(BigDecimal.ZERO) != 0) {
                    String strReceivedFinalPayment = String.format("%s%f", sign, receivedFinalPayment.setScale(amtPrecision, 4));
                    entryItem.set("receivedfinalpayment", (Object)strReceivedFinalPayment);
                }
                if ((expectFinalAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.expectfinalamount")).compareTo(BigDecimal.ZERO) != 0) {
                    String strExpectFinalAmt = String.format("%s%f", sign, expectFinalAmt.setScale(amtPrecision, 4));
                    entryItem.set("expectfinalamount", (Object)strExpectFinalAmt);
                }
                if ((receExpectFinalAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.receexpectfinalamount")).compareTo(BigDecimal.ZERO) != 0) {
                    String strReceExpectFinalAmt = String.format("%s%f", sign, receExpectFinalAmt.setScale(amtPrecision, 4));
                    entryItem.set("receexpectfinalamount", (Object)strReceExpectFinalAmt);
                }
            }
        }
    }

    private void fillEntrySaleManData(DynamicObject item, DynamicObject entryItem) {
        String saleMan = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.goodssaler.username");
        entryItem.set("goodssaler", (Object)saleMan);
        String saleDept = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.saledepartment.name");
        entryItem.set("saledepartment", (Object)saleDept);
    }

    private void fillDeliveryData(DynamicObjectCollection data, DynamicObjectCollection entryEntity) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean isRedRush = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isredrush");
        String type = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"type");
        for (DynamicObject item : data) {
            DynamicObject entryItem = entryEntity.addNew();
            this.fillCommonData(item, entryItem);
            if (!isRedRush && !StringUtils.equals((CharSequence)type, (CharSequence)"DGD")) {
                this.fillDeliveryData(item, entryItem);
                this.fillEntryAmtData(item, entryItem);
                this.fillEntrySaleManData(item, entryItem);
                continue;
            }
            this.fillSaleManData(item, entryItem);
        }
    }

    private void fillDeliveryData(DynamicObject item, DynamicObject entryItem) {
        this.fillEntryId(item, entryItem);
        long detailId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.id");
        entryItem.set("subentryid", (Object)detailId);
        String goods = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.delivergoodsid.name");
        entryItem.set("goodsid", (Object)goods);
        String barCode = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverbarcodeid.barcode");
        entryItem.set("barcode", (Object)barCode);
        String goodsClass = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.delivergoodsclass.name");
        entryItem.set("goodsclass", (Object)goodsClass);
        BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliveryavareturnqty");
        BigDecimal newSaleQty = this.formatQty(entryItem, mustRetQty);
        entryItem.set("saleqty", (Object)newSaleQty);
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        BigDecimal changeQty = StringUtils.equals((CharSequence)type, (CharSequence)"CVTSALE") ? newSaleQty : newSaleQty.negate();
        entryItem.set("changeqty", (Object)changeQty);
        String unit = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverunitid.name");
        entryItem.set("unit", (Object)unit);
        long deliveryModeId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverymode.id");
        entryItem.set("deliverymodeid", (Object)deliveryModeId);
        String deliveryMode = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverymode.name");
        entryItem.set("deliverymode", (Object)deliveryMode);
        long deliveryStatusId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverystatus.id");
        entryItem.set("deliverystatusid", (Object)deliveryStatusId);
        String deliveryStatus = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverystatus.name");
        entryItem.set("deliverystatus", (Object)deliveryStatus);
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.deliverisdelivery");
        entryItem.set("isdelivery", (Object)isDelivery);
        String signStatus = DynamicObjectUtils.getString((DynamicObject)item, (String)"goodsentryentity.salesorderdelivery.signstatus");
        entryItem.set("signstatus", (Object)signStatus);
        boolean isPushdown = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"goodsentryentity.ispushdown");
        entryItem.set("ispushdown", (Object)isPushdown);
    }

    private void fillCommonData(DynamicObject item, DynamicObject entryItem) {
        long billId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"id");
        entryItem.set("id", (Object)billId);
        String billNo = DynamicObjectUtils.getString((DynamicObject)item, (String)"billno");
        entryItem.set("billno", (Object)billNo);
        String sourceBillId = DynamicObjectUtils.getString((DynamicObject)item, (String)"sourcebillid");
        entryItem.set("sourcebillid", (Object)sourceBillId);
        long billTypeId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"basebilltype.id");
        entryItem.set("basebilltypeid", (Object)billTypeId);
        String billType = DynamicObjectUtils.getString((DynamicObject)item, (String)"basebilltype.name");
        entryItem.set("basebilltype", (Object)billType);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)item, (String)"bizdate");
        entryItem.set("bizdate", (Object)bizDate);
        String memberid = DynamicObjectUtils.getString((DynamicObject)item, (String)"member.id");
        entryItem.set("memberid", (Object)memberid);
        String member = DynamicObjectUtils.getString((DynamicObject)item, (String)"member.name");
        entryItem.set("member", (Object)member);
        String mobile = DynamicObjectUtils.getString((DynamicObject)item, (String)"customerphone");
        entryItem.set("customerphone", (Object)mobile);
        String customer = DynamicObjectUtils.getString((DynamicObject)item, (String)"customerid.name");
        entryItem.set("customerid", (Object)customer);
    }

    private void fillEntryId(DynamicObject item, DynamicObject entryItem) {
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        String entryKey = "goodsentryentity.id";
        if (StringUtils.equals((CharSequence)type, (CharSequence)"SXD")) {
            entryKey = "finentity.id";
        }
        long entryId = DynamicObjectUtils.getLong((DynamicObject)item, (String)entryKey);
        entryItem.set("entryid", (Object)entryId);
    }

    private void getDrawPageReturnData(DynamicObject entryItem, Map<String, Object> map) {
        map.put("id", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"id"));
        map.put("basebilltypeid", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"basebilltypeid"));
        map.put("entryid", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"entryid"));
        map.put("subentryid", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"subentryid"));
        map.put("TargetBillEntityId", this.getTargetBillEntityId());
        map.put("changeqty", DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"changeqty"));
        map.put("saleqty", DynamicObjectUtils.getBigDecimal((DynamicObject)entryItem, (String)"saleqty"));
        map.put("deliverymode", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"deliverymodeid"));
        map.put("deliverystatus", DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"deliverystatusid"));
        map.put("deliverystocktype", DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"deliverystocktype"));
        map.put("returnorg", DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"returnorg"));
        map.put("returnwarehouse", DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"returnwarehouse"));
        map.put("returntype", DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"returntype"));
        map.put("returnreason", DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"returnreason"));
        map.put("seq", DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"seq"));
        map.put("signstatus", DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"signstatus"));
    }

    private Map<String, Object> getDrawPageDistMode(DynamicObjectCollection entryEntities, boolean isRefund, boolean isRedRush) {
        int size = entryEntities.size();
        Map<String, Object> rltMatchMap = new HashMap<String, Object>(0);
        HashMap deliveryModeAndStatusMap = new HashMap(0);
        if (isRedRush) {
            ArrayList<Long> pkIds = new ArrayList<Long>(size);
            for (DynamicObject entryItem : entryEntities) {
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"isbook");
                if (isBook) continue;
                pkIds.add(DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"id"));
            }
            String selectFields = "id, goodsentryentity.salesorderdelivery.deliverymode.id, goodsentryentity.salesorderdelivery.deliverymode.name, goodsentryentity.salesorderdelivery.deliverystatus.id, goodsentryentity.salesorderdelivery.deliverystatus.name";
            QFilter filter = new QFilter("id", "in", pkIds);
            DynamicObjectCollection deliveryEntities = QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray());
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) {
                rltMatchMap.put("success", Boolean.FALSE);
                rltMatchMap.put("msg", "\u539f\u5355\u4e0d\u5b58\u5728\u3002");
                return rltMatchMap;
            }
            for (DynamicObject deliveryEntity : deliveryEntities) {
                String deliveryModeId = deliveryEntity.getString("goodsentryentity.salesorderdelivery.deliverymode.id");
                String deliveryStatusId = deliveryEntity.getString("goodsentryentity.salesorderdelivery.deliverystatus.id");
                String modeAndStatusKey = deliveryModeId + "_" + deliveryStatusId;
                HashMap<String, DynamicObject> modeAndStatusMap = new HashMap<String, DynamicObject>(2);
                DynamicObject deliveryMode = BusinessDataServiceHelper.loadSingle((Object)deliveryModeId, (String)"ocdbd_distributionmode");
                DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)deliveryStatusId, (String)"ococic_deliverstatus");
                modeAndStatusMap.put("deliverymode", deliveryMode);
                modeAndStatusMap.put("deliverystatus", deliveryStatus);
                deliveryModeAndStatusMap.put(modeAndStatusKey, modeAndStatusMap);
            }
        } else {
            for (DynamicObject entryEntity : entryEntities) {
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
                if (isBook) continue;
                String deliveryModeId = entryEntity.getString("deliverymodeid");
                String deliveryStatusId = entryEntity.getString("deliverystatusid");
                String modeAndStatusKey = deliveryModeId + "_" + deliveryStatusId;
                HashMap<String, DynamicObject> modeAndStatusMap = new HashMap<String, DynamicObject>(2);
                DynamicObject deliveryMode = BusinessDataServiceHelper.loadSingle((Object)deliveryModeId, (String)"ocdbd_distributionmode");
                DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)deliveryStatusId, (String)"ococic_deliverstatus");
                modeAndStatusMap.put("deliverymode", deliveryMode);
                modeAndStatusMap.put("deliverystatus", deliveryStatus);
                deliveryModeAndStatusMap.put(modeAndStatusKey, modeAndStatusMap);
            }
        }
        if (deliveryModeAndStatusMap.size() > 0) {
            rltMatchMap = SaleOrderReturnRuleHelper.matchReturnRuleByModeAndStatus(deliveryModeAndStatusMap, (String)"deliverystatus", (boolean)isRefund);
        }
        return rltMatchMap;
    }

    private DynamicObjectCollection getData(QFilter filter) {
        DynamicObjectCollection data;
        String type;
        switch (type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"))) {
            case "SXD": {
                data = this.getFinData(filter);
                break;
            }
            case "LSWKD": 
            case "YDWKD": {
                data = this.getEntryData(filter);
                break;
            }
            case "DGD": {
                data = this.getRedRushData(filter);
                break;
            }
            case "CVTSALE": 
            case "CANCELORDER": 
            case "CHANGE": {
                data = this.getDeliveryData(filter);
                break;
            }
            case "RETURNSALE": {
                boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("isredrush"));
                if (!isRedRush) {
                    data = this.getDeliveryData(filter);
                    break;
                }
                data = this.getRedRushData(filter);
                break;
            }
            default: {
                data = null;
            }
        }
        return data;
    }

    private DynamicObjectCollection getData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filters, (String)this.getOrderByFields());
    }

    private DynamicObjectCollection getRedRushData(QFilter filter) {
        String selectFields = this.getHeadSelectFields();
        return this.getData(selectFields, filter.toArray());
    }

    private DynamicObjectCollection getFinData(QFilter filter) {
        String selectFields = this.getHeadSelectFields() + ", finentity.id, finentity.settlecurrid.sign, finentity.settlecurrid.amtprecision, finentity.settleamount, finentity.alrsettleamount, finentity.notsettleamount";
        return this.getData(selectFields, filter.toArray());
    }

    private DynamicObjectCollection getEntryData(QFilter filter) {
        String selectFields = this.getHeadSelectFields() + ", " + this.getEntrySelectFields() + ", goodsentryentity.finalpayment, goodsentryentity.receivedfinalpayment, goodsentryentity.norecefinalamount, goodsentryentity.expectfinalamount, goodsentryentity.receexpectfinalamount, goodsentryentity.noreceexpectfinalamount";
        return this.getData(selectFields, filter.toArray());
    }

    private DynamicObjectCollection getDeliveryData(QFilter filter) {
        String selectFields = this.getHeadSelectFields() + ", " + this.getEntrySelectFields() + ", goodsentryentity.salesorderdelivery.id, goodsentryentity.salesorderdelivery.delivergoodsid.name, goodsentryentity.salesorderdelivery.deliverbarcodeid.barcode, goodsentryentity.salesorderdelivery.delivergoodsclass.name, goodsentryentity.salesorderdelivery.deliveryavareturnqty, goodsentryentity.salesorderdelivery.deliverunitid.name, goodsentryentity.salesorderdelivery.deliverunitid.precisionaccount, goodsentryentity.salesorderdelivery.deliverunitid.precision, goodsentryentity.salesorderdelivery.deliverymode.id, goodsentryentity.salesorderdelivery.deliverymode.name, goodsentryentity.salesorderdelivery.deliverystatus.id, goodsentryentity.salesorderdelivery.deliverystatus.name, goodsentryentity.salesorderdelivery.deliverisdelivery, goodsentryentity.salesorderdelivery.signstatus";
        return this.getData(selectFields, filter.toArray());
    }

    private QFilter getFilter() {
        QFilter filter = this.getConditionFilter();
        return filter.and(this.getCustomFilter());
    }

    private QFilter getConditionFilter() {
        boolean isExcludeInit;
        long salerGroupId;
        long saleManId;
        long customerId;
        Date date;
        String telePhone;
        String vipName;
        String billNo;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long branchId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"branchid");
        QFilter filter = new QFilter("salebranchid.id", "=", (Object)branchId);
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"billtype");
        if (!ObjectUtils.isEmpty((Object)billType)) {
            String billTypeNumber = DynamicObjectUtils.getString((DynamicObject)billType, (String)"number");
            filter.and("basebilltype.id", "=", (Object)BillTypeEnum.getIdByNumber((String)billTypeNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"tarbillno")))) {
            filter.and(QFilter.like((String)"billno", (String)billNo.trim()));
        }
        if (StringUtils.isNotBlank((CharSequence)(vipName = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"vipname")))) {
            filter.and("member.name", "=", (Object)vipName.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)(telePhone = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"telephone")))) {
            ArrayList<String> mobileList = new ArrayList<String>();
            mobileList.add(telePhone);
            if (telePhone.contains("-")) {
                int index = telePhone.indexOf(45);
                mobileList.add(telePhone.substring(index + 1).trim());
            }
            filter.and("customerphone", "in", mobileList);
        }
        if ((date = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"date")) != null) {
            filter.and("bizdate", "=", (Object)date);
        }
        if ((customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"customer")) > 0L) {
            filter.and("customerid.id", "=", (Object)customerId);
        }
        if ((saleManId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saler")) > 0L) {
            String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
            if (StringUtils.isBlank((CharSequence)type) || StringUtils.equals((CharSequence)type, (CharSequence)"SXD")) {
                filter.and("saler.id", "=", (Object)saleManId);
            } else {
                filter.and("goodsentryentity.goodssaler.id", "=", (Object)saleManId);
            }
        }
        if ((salerGroupId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salegroup")) > 0L) {
            filter.and("goodsentryentity.saledepartment.id", "=", (Object)salerGroupId);
        }
        if (isExcludeInit = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isexcludeinit")) {
            filter.and("isinitbill", "=", (Object)Boolean.FALSE);
        }
        return filter;
    }

    private QFilter getCustomFilter() {
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        QFilter filter = null;
        switch (type) {
            case "DGD": {
                filter = this.getSumChangeQtyFilter();
                filter.and("salestatus", "=", (Object)"A");
                filter.and("billstatus", "=", (Object)"C");
                filter.and("closestatus", "=", (Object)"A");
                break;
            }
            case "LSWKD": {
                filter = new QFilter("basebilltype.id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.CVTSALE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                filter.and("goodsentryentity.norecefinalamount", ">", (Object)BigDecimal.ZERO);
                filter.and("goodsentryentity.isbook", "=", (Object)Boolean.FALSE);
                break;
            }
            case "YDWKD": {
                filter = this.getCommonStatusFilter();
                filter.and("notconfirm", "=", (Object)Boolean.FALSE);
                filter.and("goodsentryentity.noreceexpectfinalamount", ">", (Object)BigDecimal.ZERO);
                break;
            }
            case "SXD": {
                filter = this.getCommonStatusFilter();
                filter.and("basebilltype.id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.RESERVE.getId(), BillTypeEnum.CVTSALE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                filter.and("finentity.setllementid.id", "=", (Object)15L);
                filter.and("finentity.notsettleamount", ">", (Object)BigDecimal.ZERO);
                break;
            }
            case "CVTSALE": {
                filter = this.getCommonStatusFilter();
                filter.and("closestatus", "=", (Object)"A");
                filter.and("goodsentryentity.rowclosestatus", "!=", (Object)"B");
                filter.and("basebilltype.id", "in", Arrays.asList(BillTypeEnum.RESERVE.getId(), BillTypeEnum.RETAIL.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
                filter.and("notconfirm", "=", (Object)Boolean.FALSE);
                filter.and("goodsentryentity.isbook", "=", (Object)Boolean.TRUE);
                filter.and("goodsentryentity.mustretqty", ">", (Object)BigDecimal.ZERO);
                break;
            }
            case "RETURNSALE": {
                filter = this.getReturnFilter();
                filter.and(this.getCommonFilter());
                break;
            }
            case "CANCELORDER": {
                filter = this.getReturnFilter();
                filter.and(this.getCommonStatusFilter());
                filter.and("goodsentryentity.mustretqty", ">", (Object)BigDecimal.ZERO);
                break;
            }
            case "CHANGE": {
                filter = this.getCommonFilter();
                filter.and("goodsentryentity.isbook", "=", (Object)Boolean.FALSE);
                filter.and("goodsentryentity.ispresent", "=", (Object)Boolean.FALSE);
                break;
            }
        }
        return filter;
    }

    private QFilter getSumChangeQtyFilter() {
        QFilter filter = new QFilter("sumretqty", "=", (Object)BigDecimal.ZERO);
        filter.and("sumtosalesqty", "=", (Object)BigDecimal.ZERO);
        return filter;
    }

    private QFilter getCommonStatusFilter() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        return filter;
    }

    private QFilter getReturnFilter() {
        QFilter filter = new QFilter("closestatus", "=", (Object)"A");
        boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("isredrush"));
        if (isRedRush) {
            filter.and(this.getSumChangeQtyFilter());
        } else {
            filter.and("goodsentryentity.ispresent", "=", (Object)Boolean.FALSE);
        }
        return filter;
    }

    private QFilter getCommonFilter() {
        QFilter filter = this.getCommonStatusFilter();
        filter.and("basebilltype.id", "in", Arrays.asList(BillTypeEnum.RETAIL.getId(), BillTypeEnum.CVTSALE.getId(), BillTypeEnum.GUIDE.getId(), BillTypeEnum.GROUP.getId()));
        boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("isredrush"));
        if (!isRedRush) {
            filter.and("goodsentryentity.mustretqty", ">", (Object)BigDecimal.ZERO);
        }
        return filter;
    }

    private boolean checkSelectedData(boolean isRedRush, String type, String changeType, String makeupBalanceMode, DynamicObjectCollection selectedEntity, List<String> messages) {
        boolean result = this.checkMustInput(selectedEntity, messages, type, changeType, isRedRush);
        if (!result) {
            return false;
        }
        result = this.checkFieldUnique(selectedEntity, messages, type);
        if (!result) {
            return false;
        }
        result = this.checkPay(selectedEntity, messages, type, isRedRush);
        if (!result) {
            return false;
        }
        result = this.checkPartReturnChange(type, changeType, makeupBalanceMode, selectedEntity, messages);
        if (!result) {
            return false;
        }
        result = this.checkReturnData(type, selectedEntity, messages);
        return result;
    }

    private boolean checkMustInput(DynamicObjectCollection selectedEntity, List<String> messages, String type, String changeType, boolean isRedRush) {
        boolean result = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"CHANGE") || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"RETURNSALE") || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"CANCELORDER")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"CHANGE") && StringUtils.isEmpty((CharSequence)changeType)) {
                messages.add("\u8bf7\u9009\u62e9\u4e00\u79cd\u6362\u8d27\u7c7b\u578b\uff08\u540c\u578b\u53f7\u6362\u8d27\u3001\u5f02\u578b\u53f7\u6362\u8d27\u3001\u8865\u5dee\uff09\u3002");
                result = false;
                return result;
            }
            long orgId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("orgid"));
            long branchId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("branchid"));
            boolean isReturnReasonMustInput = SystemParamUtil.getIsReturnReasonMustInput((long)orgId, (long)branchId);
            for (DynamicObject selectEntry : selectedEntity) {
                DynamicObject reason;
                if (isRedRush) {
                    long billId = selectEntry.getLong("Id");
                    Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{billId});
                    HashSet retailBillIdSet = (HashSet)targetBills.get("ocococ_retailbill");
                    HashSet orderBillIdSet = (HashSet)targetBills.get("ocococ_orderbill");
                    if (!(retailBillIdSet != null && retailBillIdSet.size() != 0 || orderBillIdSet != null && orderBillIdSet.size() != 0)) {
                        String billNo = DynamicObjectUtils.getString((DynamicObject)selectEntry, (String)"billno");
                        messages.add(String.format("\u96f6\u552e\u5f00\u5355\uff1a%s \u672a\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u4e0b\u63a8\u751f\u6210\u3002", billNo));
                        result = false;
                        break;
                    }
                } else {
                    boolean isPushdown = DynamicObjectUtils.getBoolean((DynamicObject)selectEntry, (String)"ispushdown");
                    if (!isPushdown) {
                        String billNo = DynamicObjectUtils.getString((DynamicObject)selectEntry, (String)"billno");
                        messages.add(String.format("\u96f6\u552e\u5f00\u5355\uff1a%s \u672a\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u5148\u4e0b\u63a8\u751f\u6210\u3002", billNo));
                        result = false;
                        break;
                    }
                }
                if (!isReturnReasonMustInput || (reason = DynamicObjectUtils.getDynamicObject((DynamicObject)selectEntry, (String)"returnreason")) != null) continue;
                messages.add("\u8bf7\u5f55\u5165\u9000\u8d27\u539f\u56e0\u3002");
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean checkPartReturnChange(String type, String changeType, String makeupBalanceMode, DynamicObjectCollection selectedEntities, List<String> messages) {
        boolean result = true;
        if (StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE") || StringUtils.equals((CharSequence)type, (CharSequence)"RETURNSALE")) {
            for (DynamicObject selectedEntity : selectedEntities) {
                boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)selectedEntity, (String)"isbook");
                if (isBook) continue;
                String signStatus = DynamicObjectUtils.getString((DynamicObject)selectedEntity, (String)"signstatus");
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)selectedEntity, (String)"saleqty");
                BigDecimal changeQty = DynamicObjectUtils.getBigDecimal((DynamicObject)selectedEntity, (String)"changeqty");
                if (!StringUtils.equalsIgnoreCase((CharSequence)signStatus, (CharSequence)"D") && saleQty.compareTo(changeQty.abs()) != 0) {
                    messages.add("\u5546\u54c1\u672a\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u90e8\u5206\u9000\u8d27\u3001\u6362\u8d27\u3002");
                    result = false;
                    break;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)signStatus, (CharSequence)"D") && StringUtils.equals((CharSequence)changeType, (CharSequence)"1")) {
                    messages.add("\u5546\u54c1\u672a\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u540c\u578b\u53f7\u6362\u8d27\u3002");
                    result = false;
                    break;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)signStatus, (CharSequence)"D") && StringUtils.equals((CharSequence)changeType, (CharSequence)"3") && StringUtils.equals((CharSequence)makeupBalanceMode, (CharSequence)"0")) {
                    messages.add("\u5546\u54c1\u672a\u7b7e\u6536\uff0c\u4e0d\u5141\u8bb8\u6b8b\u6b21\u8865\u5dee\u3002");
                    result = false;
                    break;
                }
                if (!StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE")) continue;
                String noReceiveFinalAmt = DynamicObjectUtils.getString((DynamicObject)selectedEntity, (String)"norecefinalamount");
                if (StringUtils.isNotBlank((CharSequence)noReceiveFinalAmt)) {
                    messages.add("\u5546\u54c1\u5b58\u5728\u5f85\u6536\u5c3e\u6b3e\uff0c\u4e0d\u5141\u8bb8\u6362\u8d27\u3002");
                    result = false;
                    break;
                }
                String noReceiveExpectFinalAmt = DynamicObjectUtils.getString((DynamicObject)selectedEntity, (String)"noreceexpectfinalamount");
                if (!StringUtils.isNotBlank((CharSequence)noReceiveExpectFinalAmt)) continue;
                messages.add("\u5546\u54c1\u5b58\u5728\u9884\u8ba2\u5f85\u6536\u5c3e\u6b3e\uff0c\u4e0d\u5141\u8bb8\u6362\u8d27\u3002");
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean checkFieldUnique(DynamicObjectCollection selectedEntity, List<String> messages, String type) {
        Set lstSelectDataId;
        boolean result = true;
        if ((StringUtils.equals((CharSequence)type, (CharSequence)"RETURNSALE") || StringUtils.equals((CharSequence)type, (CharSequence)"CVTSALE") || StringUtils.equals((CharSequence)type, (CharSequence)"CANCELORDER") || StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE")) && (lstSelectDataId = selectedEntity.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"Id")).collect(Collectors.toSet())).size() != 1) {
            String text;
            result = false;
            switch (type) {
                case "RETURNSALE": {
                    text = "\u9000\u8d27";
                    break;
                }
                case "CVTSALE": {
                    text = "\u8f6c\u9500\u552e";
                    break;
                }
                case "CANCELORDER": {
                    text = "\u9000\u8ba2";
                    break;
                }
                case "CHANGE": {
                    text = "\u6362\u8d27";
                    break;
                }
                default: {
                    text = "\u64cd\u4f5c";
                }
            }
            messages.add(String.format("\u4e0d\u652f\u6301\u591a\u5f20\u6e90\u5355\u540c\u65f6%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", text));
        }
        if ((lstSelectDataId = selectedEntity.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"memberid")).collect(Collectors.toSet())).size() != 1) {
            result = false;
            messages.add("\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u4f1a\u5458\u7684\u6e90\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002");
        }
        return result;
    }

    private boolean checkPay(DynamicObjectCollection selectedEntity, List<String> messages, String type, boolean isRedRush) {
        QFilter filter;
        String selectFields;
        DynamicObjectCollection finEntity;
        if (!(StringUtils.equals((CharSequence)type, (CharSequence)"RETURNSALE") || StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE") || StringUtils.equals((CharSequence)type, (CharSequence)"CANCELORDER"))) {
            return true;
        }
        HashSet<Long> ids = new HashSet<Long>(2);
        long billId = ((DynamicObject)selectedEntity.get(0)).getLong("Id");
        ids.add(billId);
        long sourceBillId = ((DynamicObject)selectedEntity.get(0)).getLong("sourcebillid");
        if (sourceBillId > 0L) {
            ids.add(billId);
        }
        if (!CollectionUtils.isEmpty((Collection)(finEntity = QueryServiceHelper.query((String)"ocpos_saleorder", (String)(selectFields = "finentity.setllementid"), (QFilter[])(filter = new QFilter("id", "in", ids)).toArray())))) {
            for (DynamicObject finEntry : finEntity) {
                long settlementId = finEntry.getLong("finentity.setllementid");
                if (settlementId != PaymentModeEnum.installmentpay.getKey()) continue;
                messages.add("\u5355\u636e\u5b58\u5728\u5206\u671f\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\u3001\u9000\u8ba2\u548c\u6362\u8d27\u3002");
                return false;
            }
        }
        return true;
    }

    private boolean checkReturnData(String type, DynamicObjectCollection selectedEntities, List<String> messages) {
        boolean result;
        boolean isCheckPoint;
        long branchId;
        boolean isNotReturn;
        boolean bl = isNotReturn = !StringUtils.equals((CharSequence)type, (CharSequence)"RETURNSALE") && !StringUtils.equals((CharSequence)type, (CharSequence)"CANCELORDER");
        if (isNotReturn) {
            return true;
        }
        long orgId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("orgid"));
        String cashCouponReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)(branchId = CommonUtil.formatObejctToLong((Object)this.getModel().getValue("branchid"))), (String)"cashcouponreturnmode");
        boolean isCheckCoupon = StringUtils.equals((CharSequence)cashCouponReturnMode, (CharSequence)"3") || StringUtils.equals((CharSequence)cashCouponReturnMode, (CharSequence)"4");
        String pointReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"pointreturnmode");
        boolean bl2 = isCheckPoint = StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)"3") || StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)"4");
        if (!isCheckCoupon && !isCheckPoint) {
            return true;
        }
        boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("isredrush"));
        DataSet selectedData = this.getSelectedData(selectedEntities);
        String selectFields = this.getSelectFieldsAboutReturn();
        QFilter additionFilter = new QFilter("goodsentryentity.coupondiscount", ">", (Object)BigDecimal.ZERO);
        additionFilter.or("goodsentryentity.integraldistamount", ">", (Object)BigDecimal.ZERO);
        if (!isRedRush) {
            Set lstBillEntryId = selectedEntities.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"entryid")).collect(Collectors.toSet());
            QFilter filter = new QFilter("goodsentryentity.id", "in", lstBillEntryId);
            filter.and(additionFilter);
            DataSet bills = QueryServiceHelper.queryDataSet((String)"billData", (String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray(), null);
            DataSet data = selectedData.join(bills).on("entryid", "goodsentryentity.id").select(new String[]{"seq", "integraldistamount", "coupondiscount"}).finish();
            if (data == null || data.isEmpty()) {
                return true;
            }
            result = this.getDataAboutReturn(data, isCheckCoupon, isCheckPoint, messages);
        } else {
            Set lstBillId = selectedEntities.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", lstBillId);
            filter.and(additionFilter);
            DataSet bills = QueryServiceHelper.queryDataSet((String)"billData", (String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray(), null);
            DataSet data = selectedData.join(bills).on("id", "id").select(new String[]{"billno", "goodsentryentity.id", "integraldistamount", "coupondiscount"}).finish();
            if (data == null || data.isEmpty()) {
                return true;
            }
            result = this.getDataAboutRedRush(data, isCheckCoupon, isCheckPoint, messages);
        }
        return result;
    }

    private BigDecimal formatQty(DynamicObject entryItem, BigDecimal mustRetQty) {
        BigDecimal newQty;
        int precision;
        String preAccount;
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        if (Arrays.asList(ENTRY_TYPE_LIST).contains(type)) {
            preAccount = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"goodsentryentity.unit.precisionaccount");
            precision = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"goodsentryentity.unit.precision");
        } else {
            preAccount = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"goodsentryentity.salesorderdelivery.deliverunitid.precisionaccount");
            precision = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"goodsentryentity.salesorderdelivery.deliverunitid.precision");
        }
        switch (preAccount) {
            case "2": {
                newQty = mustRetQty.setScale(precision, 1);
                break;
            }
            case "3": {
                newQty = mustRetQty.setScale(precision, 0);
                break;
            }
            default: {
                newQty = mustRetQty.setScale(precision, 4);
            }
        }
        return newQty;
    }

    private String getHeadSelectFields() {
        String selectFields = "id, billno, basebilltype.id, basebilltype.name, bizdate, member.id, member.name, customerphone, customerid.name, sourcebillid";
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getModel().getValue("isredrush"));
        selectFields = StringUtils.equals((CharSequence)type, (CharSequence)"SXD") || StringUtils.equals((CharSequence)type, (CharSequence)"DGD") || isRedRush ? selectFields + ", saler.username" : selectFields + ", currencyid.sign, currencyid.amtprecision, currencyid.priceprecision";
        return selectFields;
    }

    private String getEntrySelectFields() {
        String selectFields = "goodsentryentity.id,  goodsentryentity.retailprice, goodsentryentity.deposit,goodsentryentity.discountprice, goodsentryentity.goodssaler.username, goodsentryentity.saledepartment.name, goodsentryentity.isbook, goodsentryentity.ispushdown";
        String type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"));
        if (Arrays.asList(ENTRY_TYPE_LIST).contains(type)) {
            selectFields = selectFields + ", goodsentryentity.goodsid.name, goodsentryentity.barcode.barcode, goodsentryentity.goodsclass.name, goodsentryentity.mustretqty, goodsentryentity.unit.name, goodsentryentity.unit.precisionaccount, goodsentryentity.unit.precision, goodsentryentity.balamount";
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"CHANGE")) {
            selectFields = selectFields + ", goodsentryentity.norecefinalamount, goodsentryentity.noreceexpectfinalamount";
        }
        return selectFields;
    }

    private String getOrderByFields() {
        return "bizdate, billno";
    }

    private String getTargetBillEntityId() {
        String targetBillEntityId;
        String type;
        switch (type = CommonUtil.formatStringToEmpty((Object)this.getModel().getValue("type"))) {
            case "SXD": 
            case "LSWKD": 
            case "YDWKD": {
                targetBillEntityId = "ocpos_saleorder_final";
                break;
            }
            case "RETURNSALE": 
            case "CANCELORDER": {
                targetBillEntityId = "ocpos_saleorder_return";
                break;
            }
            case "CHANGE": {
                targetBillEntityId = "ocpos_salechange";
                break;
            }
            default: {
                targetBillEntityId = "ocpos_saleorder";
            }
        }
        return targetBillEntityId;
    }

    private String getSelectFieldsAboutReturn() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.add("goodsentryentity.id");
        selectFields.add("goodsentryentity.integraldistamount as integraldistamount");
        selectFields.add("goodsentryentity.coupondiscount as coupondiscount");
        return StringUtils.join((Object[])selectFields.toArray(), (char)',');
    }

    private boolean getDataAboutReturn(DataSet data, boolean isCheckCoupon, boolean isCheckPoint, List<String> messages) {
        boolean isRight = true;
        if (isCheckCoupon) {
            if (isCheckPoint) {
                for (Row datum : data) {
                    int seq = datum.getInteger("seq");
                    messages.add(String.format("\u7b2c%d\u884c\u6570\u636e\u5b58\u5728\u8d60\u9001\u79ef\u5206\u6216\u793c\u5238\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", seq));
                    if (!isRight) continue;
                    isRight = false;
                }
            } else {
                DataSet couponData = data.where("coupondiscount > 0");
                if (couponData == null || couponData.isEmpty()) {
                    return true;
                }
                for (Row datum : couponData) {
                    int seq = datum.getInteger("seq");
                    messages.add(String.format("\u7b2c%d\u884c\u6570\u636e\u5b58\u5728\u8d60\u9001\u793c\u5238\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", seq));
                    if (!isRight) continue;
                    isRight = false;
                }
            }
        } else {
            DataSet pointData = data.where("integraldistamount > 0");
            if (pointData == null || pointData.isEmpty()) {
                return true;
            }
            for (Row datum : pointData) {
                int seq = datum.getInteger("seq");
                messages.add(String.format("\u7b2c%d\u884c\u6570\u636e\u5b58\u5728\u8d60\u9001\u79ef\u5206\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", seq));
                if (!isRight) continue;
                isRight = false;
            }
        }
        return isRight;
    }

    private boolean getDataAboutRedRush(DataSet data, boolean isCheckCoupon, boolean isCheckPoint, List<String> messages) {
        boolean isRight = true;
        if (isCheckCoupon) {
            if (isCheckPoint) {
                ArrayList<String> billNos = new ArrayList<String>();
                for (Row datum : data) {
                    String billNo = datum.getString("billno");
                    if (!billNos.contains(billNo)) {
                        billNos.add(billNo);
                        continue;
                    }
                    messages.add(String.format("\u5355\u636e%s\u5b58\u5728\u8d60\u9001\u79ef\u5206\u6216\u793c\u5238\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", billNo));
                    if (!isRight) continue;
                    isRight = false;
                }
            } else {
                DataSet couponData = data.where("coupondiscount > 0");
                if (couponData == null || couponData.isEmpty()) {
                    return true;
                }
                ArrayList<String> billNos = new ArrayList<String>();
                for (Row datum : data) {
                    String billNo = datum.getString("billno");
                    if (!billNos.contains(billNo)) {
                        billNos.add(billNo);
                        continue;
                    }
                    messages.add(String.format("\u5355\u636e%s\u5b58\u5728\u8d60\u9001\u793c\u5238\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", billNo));
                    if (!isRight) continue;
                    isRight = false;
                }
            }
        } else {
            DataSet pointData = data.where("integraldistamount > 0");
            if (pointData == null || pointData.isEmpty()) {
                return true;
            }
            ArrayList<String> billNos = new ArrayList<String>();
            for (Row datum : data) {
                String billNo = datum.getString("billno");
                if (!billNos.contains(billNo)) {
                    billNos.add(billNo);
                    continue;
                }
                messages.add(String.format("\u5355\u636e%s\u5b58\u5728\u8d60\u9001\u79ef\u5206\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3002", billNo));
                if (!isRight) continue;
                isRight = false;
            }
        }
        return isRight;
    }

    private DataSet getSelectedData(DynamicObjectCollection selectedEntities) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("seq", (DataType)DataType.IntegerType));
        fields.add(new Field("id", (DataType)DataType.LongType));
        fields.add(new Field("billno", (DataType)DataType.StringType));
        fields.add(new Field("entryid", (DataType)DataType.LongType));
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"selectedData").createDataSetBuilder(meta);
        if (CollectionUtils.isEmpty((Collection)selectedEntities)) {
            return builder.build();
        }
        for (DynamicObject selectedEntity : selectedEntities) {
            builder.append(new Object[]{DynamicObjectUtils.getInt((DynamicObject)selectedEntity, (String)"seq"), DynamicObjectUtils.getLong((DynamicObject)selectedEntity, (String)"id"), DynamicObjectUtils.getString((DynamicObject)selectedEntity, (String)"billno"), DynamicObjectUtils.getLong((DynamicObject)selectedEntity, (String)"entryid")});
        }
        return builder.build();
    }

    private List<Map<String, Object>> getReturnData(DynamicObject dataEntity, DynamicObjectCollection entryEntity, String targetPageId, boolean isRedRush, String changeType, long orgId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject entryItem : entryEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>(26);
            map.put("TargetBillPageId", targetPageId);
            map.put("wholebillpush", isRedRush);
            map.put("changeitemtype", changeType);
            map.put("makeupbalancemode", dataEntity.getString("makeupbalancemode"));
            map.put("saleorgid", orgId);
            this.getDrawPageReturnData(entryItem, map);
            list.add(map);
        }
        return list;
    }

    private void resetCaption(String key, String caption) {
        Control ctrl = this.getView().getControl(key);
        if (ctrl instanceof FieldEdit) {
            ((FieldEdit)ctrl).setCaption(new LocaleString(caption));
        }
    }
}

