/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class ShowTicketFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Boolean isAllowSelect = CommonUtil.formatObjectToBoolean((Object)param.getCustomParam("isAllowSelect"));
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put("selchexkbox", isAllowSelect);
        this.getView().updateControlMetadata("entryentity", prop);
        this.getView().setVisible(isAllowSelect, new String[]{"operatepanel"});
    }

    public void afterCreateNewData(EventObject e) {
        List lstTicketInfo;
        FormShowParameter param = this.getView().getFormShowParameter();
        long memberId = CommonUtil.formatObejctToLong((Object)param.getCustomParam("member"));
        if (memberId <= 0L) {
            return;
        }
        String payWay = (String)param.getCustomParam("payway");
        long branchId = CommonUtil.formatObejctToLong((Object)param.getCustomParam("salebranchid"));
        List ticketData = (List)param.getCustomParam("ticketid");
        boolean isInSalesInCome = false;
        if (ticketData != null && ticketData.size() > 0) {
            isInSalesInCome = true;
            QFilter filter = new QFilter("id", "in", (Object)ticketData.toArray());
            DynamicObject[] tickets = BusinessDataServiceHelper.load((String)"ocdbd_ticketinfo", (String)"id,number,tickettypeid,ticketvalue", (QFilter[])filter.toArray());
            lstTicketInfo = Arrays.asList(tickets);
        } else {
            Map map = (Map)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketService", (String)"queryrTicketInfoByMemberId", (Object[])new Object[]{memberId});
            if (CollectionUtils.isEmpty((Map)map)) {
                return;
            }
            DynamicObject[] ticketInfos = map.values().toArray(new DynamicObject[0]);
            lstTicketInfo = SaleOrderHelper.getTicketInfosByBranch((DynamicObject[])ticketInfos, (long)branchId);
        }
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entry.clear();
        for (DynamicObject ticketInfo : lstTicketInfo) {
            DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
            if (isInSalesInCome) {
                boolean bIsInSalesInCome = DynamicObjectUtils.getBoolean((DynamicObject)ticketType, (String)"isinsalesincome");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)payWay) ? !bIsInSalesInCome : StringUtils.equals((CharSequence)"2", (CharSequence)payWay) && bIsInSalesInCome) continue;
            }
            DynamicObject row = entry.addNew();
            row.set("ticketid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)ticketInfo));
            row.set("ticketnumber", (Object)DynamicObjectUtil.getString((DynamicObject)ticketInfo, (String)"number"));
            row.set("tickettypeid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)ticketType));
            row.set("tickettype", (Object)DynamicObjectUtil.getString((DynamicObject)ticketType, (String)"name"));
            row.set("ticketmedium", (Object)DynamicObjectUtil.getString((DynamicObject)ticketType, (String)"medium"));
            row.set("ticketvalue", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)ticketInfo, (String)"ticketvalue"));
            row.set("discountrate", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)ticketType, (String)"discountrate"));
            row.set("minconsumeamount", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)ticketType, (String)"minconsumeamount"));
            row.set("currency", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"ticketcurrencyid"));
        }
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selRow = entryGrid.getSelectRows();
            if (selRow != null && selRow.length > 0) {
                ArrayList<Object> lstTicketEntry = new ArrayList<Object>(selRow.length);
                DynamicObjectCollection docEntry = this.getModel().getEntryEntity("entryentity");
                for (int row : selRow) {
                    lstTicketEntry.add(docEntry.get(row));
                }
                this.getView().returnDataToParent(lstTicketEntry);
            } else {
                this.getView().returnDataToParent(null);
            }
            this.getView().close();
        }
    }
}

