/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocdbd.common.enums.UserStatusEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class TicketSendPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_NEWENTRY = "newentry";

    public void afterCreateNewData(EventObject e) {
        List<DynamicObject> lstSelectGoods;
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        JSONObject doMember = (JSONObject)parameter.getCustomParam("member");
        DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (docEntry == null) {
            return;
        }
        docEntry.clear();
        List<DynamicObject> lstGoodsData = this.getEntryData(parameter, "goodsentryentity", "ocpos_saleorder.goodsentryentity");
        List<DynamicObject> lstTicketSendData = this.getEntryData(parameter, "ticketsendentity", "ocpos_saleorder.ticketsendentity");
        if (lstTicketSendData != null && lstTicketSendData.size() > 0) {
            Object[] memberPkValue = lstTicketSendData.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"emember")).toArray();
            QFilter filter = new QFilter("id", "in", (Object)memberPkValue);
            DynamicObject[] members = BusinessDataServiceHelper.load((String)"ocdbd_user", (String)"id,number,name,mobile", (QFilter[])filter.toArray());
            for (DynamicObject doTicketSendData : lstTicketSendData) {
                long oMemberId = DynamicObjectUtils.getPkValue((DynamicObject)doTicketSendData, (String)"emember");
                DynamicObject oTicketType = DynamicObjectUtils.getDynamicObject((DynamicObject)doTicketSendData, (String)"tickettype");
                if (oMemberId == 0L || ObjectUtils.isEmpty((Object)oTicketType)) continue;
                DynamicObject doEntry = docEntry.addNew();
                DynamicObject oMember = Arrays.stream(members).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == oMemberId).findFirst().orElse(null);
                doEntry.set("member", (Object)oMember);
                doEntry.set("tickettype", (Object)oTicketType);
                doEntry.set("qty", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doTicketSendData, (String)"qty"));
                doEntry.set("goodsseq", (Object)DynamicObjectUtils.getString((DynamicObject)doTicketSendData, (String)"goodsseq"));
                doEntry.set("goodsid", (Object)DynamicObjectUtils.getString((DynamicObject)doTicketSendData, (String)"goodsname"));
            }
        }
        String bizType = (String)parameter.getCustomParam("biztype");
        if (BizTypeEnum.CHANGE.getValue().equals(bizType)) {
            docEntry.clear();
        }
        this.getView().updateView("entryentity");
        long lMemberId = 0L;
        if (doMember != null) {
            lMemberId = (Long)doMember.get((Object)"id");
        }
        if ((lstSelectGoods = this.getEntryData(parameter, "goodsselectentity", "ocpos_saleorder.goodsentryentity")) != null && lstSelectGoods.size() > 0) {
            this.createTicketSendEntry(docEntry, lstSelectGoods, lMemberId);
        } else {
            this.createTicketSendEntry(docEntry, lstGoodsData, lMemberId);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketTypeEdit = (BasedataEdit)this.getView().getControl("tickettype");
        ticketTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit memberEdit = (BasedataEdit)this.getView().getControl("member");
        memberEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"member")) {
            DynamicObject bizOrg = (DynamicObject)this.getView().getParentView().getModel().getValue("bizorgid");
            long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)bizOrg);
            DynamicObject split = UserServiceHelper.getUserSplitByNumberOrOrgId(null, (Long)bizOrgId);
            QFilter filter = new QFilter("splitid", "=", (Object)DynamicObjectUtils.getPkValue((DynamicObject)split));
            filter.and("userstatus", "=", (Object)UserStatusEnum.NORMAL.getValue());
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            StringBuilder sbMsg = new StringBuilder();
            DynamicObjectCollection docTicketSendEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (docTicketSendEntry != null && docTicketSendEntry.size() > 0) {
                for (DynamicObject doTicketEntry : docTicketSendEntry) {
                    String seq = String.valueOf(doTicketEntry.get("seq"));
                    if (ObjectUtils.isEmpty((Object)doTicketEntry.get("member"))) {
                        sbMsg.append(String.format("\u8d60\u5238\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4f1a\u5458\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", seq));
                    }
                    if (ObjectUtils.isEmpty((Object)doTicketEntry.get("goodsid"))) {
                        sbMsg.append(String.format("\u8d60\u5238\u660e\u7ec6\u7b2c%s\u884c\uff0c\u8d60\u5238\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002\r\n", seq));
                    }
                    if (doTicketEntry.getBigDecimal("qty").compareTo(BigDecimal.ZERO) > 0) continue;
                    sbMsg.append(String.format("\u8d60\u5238\u660e\u7ec6\u7b2c%s\u884c\uff0c\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\u3002\r\n", seq));
                }
                if (StringUtils.isEmpty((CharSequence)sbMsg.toString())) {
                    this.getView().returnDataToParent((Object)docTicketSendEntry);
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(sbMsg.toString());
                }
            } else {
                this.getView().returnDataToParent((Object)docTicketSendEntry);
                this.getView().close();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowIndex;
        super.afterDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_NEWENTRY, (CharSequence)op.getOperateKey()) && (rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity")) >= 0) {
            List<DynamicObject> lstGoodsData;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            JSONObject doMember = (JSONObject)parameter.getCustomParam("member");
            if (doMember != null) {
                long lMemberId = CommonUtil.formatObejctToLong((Object)doMember.get((Object)"id"));
                this.getView().getModel().setValue("member", (Object)lMemberId, rowIndex);
            }
            if ((lstGoodsData = this.getEntryData(parameter, "goodsselectentity", "ocpos_saleorder.goodsentryentity")) == null || lstGoodsData.size() == 0) {
                lstGoodsData = this.getEntryData(parameter, "goodsentryentity", "ocpos_saleorder.goodsentryentity");
            }
            if (lstGoodsData != null && lstGoodsData.size() > 0) {
                ArrayList<String> lstSeq = new ArrayList<String>(lstGoodsData.size());
                StringBuilder sbGoodsName = new StringBuilder();
                for (DynamicObject doGoodsEntry : lstGoodsData) {
                    DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                    if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                    if (sbGoodsName.length() > 0) {
                        sbGoodsName.append(',');
                    }
                    sbGoodsName.append(DynamicObjectUtils.getString((DynamicObject)doGoods, (String)"name"));
                    lstSeq.add(DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq"));
                }
                this.getView().getModel().setValue("goodsseq", (Object)String.join((CharSequence)",", lstSeq), rowIndex);
                this.getView().getModel().setValue("goodsid", (Object)sbGoodsName.toString(), rowIndex);
            }
        }
    }

    private List<DynamicObject> getEntryData(FormShowParameter frmShowParameter, String paramName, String entryKey) {
        DynamicObjectType entryDyt;
        String entryData = frmShowParameter.getCustomParam(paramName).toString();
        Object[] objEntry = DynamicObjectSerializeUtil.deserialize((String)entryData, (DynamicObjectType)(entryDyt = (DynamicObjectType)ORM.create().getDataEntityType(entryKey)));
        if (objEntry == null || objEntry.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> lstEntry = new ArrayList<DynamicObject>(0);
        for (Object item : objEntry) {
            if (!(item instanceof DynamicObject)) continue;
            lstEntry.add((DynamicObject)item);
        }
        return lstEntry;
    }

    private void createTicketSendEntry(DynamicObjectCollection docEntry, List<DynamicObject> lstGoods, long lMemberId) {
        if (lstGoods != null && lstGoods.size() > 0) {
            ArrayList<String> lstSeq = new ArrayList<String>(lstGoods.size());
            StringBuilder sbGoodsName = new StringBuilder();
            for (DynamicObject goodsEntry : lstGoods) {
                DynamicObject doGoods = DynamicObjectUtils.getDynamicObject((DynamicObject)goodsEntry, (String)"goodsid");
                if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                if (sbGoodsName.length() > 0) {
                    sbGoodsName.append(',');
                }
                sbGoodsName.append(DynamicObjectUtils.getString((DynamicObject)doGoods, (String)"name"));
                lstSeq.add(DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"seq"));
            }
            String goodsSeq = String.join((CharSequence)",", lstSeq);
            if (docEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)x.getString("goodsseq"), (CharSequence)goodsSeq))) {
                return;
            }
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            if (lMemberId > 0L) {
                this.getView().getModel().setValue("member", (Object)lMemberId, rowIndex);
            }
            this.getView().getModel().setValue("goodsid", (Object)sbGoodsName.toString(), rowIndex);
            this.getView().getModel().setValue("goodsseq", (Object)String.join((CharSequence)",", lstSeq), rowIndex);
        }
    }
}

