/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.TicketAmountHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class UseTicketListPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit ticketEdit = (BasedataEdit)this.getView().getControl("ticketid");
        ticketEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
        if (StringUtils.equals((CharSequence)proName, (CharSequence)"ticketid")) {
            this.getView().getPageCache().remove("ticketid");
            DynamicObject doTicket = (DynamicObject)this.getView().getModel().getValue("ticketid");
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List<DynamicObject> useTicketData = this.getUseTicketEntry(frmShowParameter);
            if (doTicket != null) {
                Map mapRlt;
                Map.Entry entry;
                String goodsSeq;
                BigDecimal sumAmount;
                String ticketNo = DynamicObjectUtils.getString((DynamicObject)doTicket, (String)"number");
                if (docEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"utticket").getString("number"), (CharSequence)doTicket.getString("number")))) {
                    this.getView().showMessage(String.format("\u793c\u5238\u7f16\u53f7%s\u5df2\u5b58\u5728\u3002", ticketNo));
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                if (useTicketData != null && useTicketData.size() > 0 && useTicketData.stream().anyMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"utticket").getString("number"), (CharSequence)doTicket.getString("number")))) {
                    this.getView().showMessage(String.format("\u793c\u5238\u7f16\u53f7%s\u5df2\u5b58\u5728\u3002", ticketNo));
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                long currencyId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("currencyid"));
                DynamicObject saleOrder = this.getView().getParentView().getModel().getDataEntity();
                List<DynamicObject> goodsEntry = this.getGoodsEntry(frmShowParameter);
                if (goodsEntry == null || goodsEntry.size() == 0) {
                    return;
                }
                boolean rlt = TicketAmountHelper.currencyMatch((IFormView)this.getView(), (long)currencyId, (DynamicObject)doTicket);
                if (!rlt) {
                    return;
                }
                long ticketTypeId = DynamicObjectUtil.getPkValue((DynamicObject)doTicket.getDynamicObject("tickettypeid"));
                DynamicObject doTicketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
                if (doTicketType == null) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u5173\u8054\u7684\u793c\u5238\u7c7b\u578b\u65e0\u6548\u3002", ticketNo));
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                String newAmtPriceWay = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"newamtpriceway");
                String lowAmtCountWay = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"lowamtcountway");
                boolean singleItemAmt = DynamicObjectUtils.getBoolean((DynamicObject)doTicketType, (String)"singleitemamt");
                boolean singleItemQty = DynamicObjectUtils.getBoolean((DynamicObject)doTicketType, (String)"singleitemqty");
                if (StringUtils.equals((CharSequence)lowAmtCountWay, (CharSequence)"1")) {
                    sumAmount = StringUtils.equals((CharSequence)newAmtPriceWay, (CharSequence)"1") ? DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumamount") : DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumbalamount");
                    goodsSeq = TicketAmountHelper.getGoodsSeq(goodsEntry);
                } else {
                    goodsSeq = TicketAmountHelper.getGoodsSeq(goodsEntry, (DynamicObject)doTicketType, (String)newAmtPriceWay);
                    sumAmount = TicketAmountHelper.getApplyGoodsAmount(goodsEntry, (String)newAmtPriceWay, (String)goodsSeq);
                }
                BigDecimal minConsumeAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"minconsumeamount");
                if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                    rlt = TicketAmountHelper.isMinConsumeAmount((IFormView)this.getView(), (BigDecimal)sumAmount, (String)ticketNo, (BigDecimal)minConsumeAmount);
                }
                if (!rlt) {
                    return;
                }
                if (singleItemAmt && (entry = (Map.Entry)(mapRlt = TicketAmountHelper.isMatchSingleItemAmt(goodsEntry, (DynamicObject)doTicketType, (String)ticketNo, (String)newAmtPriceWay)).entrySet().stream().findFirst().orElse(null)) != null && !(rlt = ((Boolean)entry.getKey()).booleanValue())) {
                    this.getView().showErrorNotification((String)entry.getValue());
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                }
                if (singleItemQty && (entry = (Map.Entry)(mapRlt = TicketAmountHelper.isMatchSingleItemQty(goodsEntry, (DynamicObject)doTicketType, (String)ticketNo)).entrySet().stream().findFirst().orElse(null)) != null && !(rlt = ((Boolean)entry.getKey()).booleanValue())) {
                    this.getView().showErrorNotification((String)entry.getValue());
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                }
                if (!rlt) {
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                rlt = TicketAmountHelper.validateEndDate((IFormView)this.getView(), (DynamicObject)doTicket);
                if (!rlt) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u5df2\u8fc7\u671f\u3002", ticketNo));
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                rlt = this.isCondition(useTicketData, docEntry, sumAmount, goodsEntry, doTicketType, ticketNo, minConsumeAmount, newAmtPriceWay, singleItemAmt, singleItemQty, goodsSeq);
                if (!rlt) {
                    TicketAmountHelper.clearTicket((IFormView)this.getView());
                    return;
                }
                StringBuilder msg = new StringBuilder();
                rlt = SaleorderPromotionHelper.checkTicketSexclusive((DynamicObject)saleOrder, null, (DynamicObjectCollection)docEntry, (long)ticketTypeId, (long)0L, (StringBuilder)msg);
                if (!rlt) {
                    if (msg.length() > 0) {
                        this.getView().showErrorNotification(msg.toString());
                        TicketAmountHelper.clearTicket((IFormView)this.getView());
                    }
                    return;
                }
                docEntry.addNew();
                int rowIndex = docEntry.getRowCount() - 1;
                this.getModel().setValue("utticket", doTicket.getPkValue(), rowIndex);
                this.getModel().setValue("uttickettype", (Object)ticketTypeId, rowIndex);
                this.getModel().setValue("useamount", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doTicket, (String)"ticketvalue"), rowIndex);
                this.getModel().setValue("discountrate", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"discountrate"), rowIndex);
                this.updateTicketRecord(goodsEntry, sumAmount, rowIndex, doTicket, doTicketType, singleItemAmt, goodsSeq);
            }
            TicketAmountHelper.clearTicket((IFormView)this.getView());
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        BasedataEdit ticketBe = (BasedataEdit)this.getView().getControl("ticketid");
        if (ticketBe == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"ticketid")) {
            List lstId;
            String numberFilter = "";
            FormShowParameter frmShowParameter = this.getView().getFormShowParameter();
            if (ticketBe.getSearchFilter() != null) {
                String searchFilter = ticketBe.getSearchFilter().getValue().toString();
                if (StringUtils.isNotEmpty((CharSequence)searchFilter)) {
                    numberFilter = searchFilter.substring(searchFilter.indexOf("#") + 1);
                }
            } else {
                numberFilter = this.getView().getPageCache().get("ticketid");
            }
            long memberId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("member"));
            long branchId = CommonUtil.formatObejctToLong((Object)frmShowParameter.getCustomParam("salebranchid"));
            List<DynamicObject> lstGoodsEntry = this.getGoodsEntry(frmShowParameter);
            if (CollectionUtils.isEmpty(lstGoodsEntry)) {
                beforeF7SelectEvent.setCancel(true);
                NotificationUtil.showDefaultTipNotify((String)"\u672a\u83b7\u53d6\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u3002", (IFormView)this.getView());
                return;
            }
            ArrayList lstTicketId = new ArrayList(0);
            DynamicObjectCollection docEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            List<DynamicObject> useTicketData = this.getUseTicketEntry(frmShowParameter);
            if (!CollectionUtils.isEmpty((Collection)docEntry)) {
                docEntry.forEach(x -> lstTicketId.add(DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"utticket")));
            }
            if (useTicketData != null && useTicketData.size() > 0) {
                useTicketData.forEach(x -> lstTicketId.add(DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"utticket")));
            }
            QFilter qFilter = new QFilter("ticketstatus", "=", (Object)"P");
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("cancelstatus", "=", (Object)"A");
            Date dtNow = TimeServiceHelper.now();
            qFilter.and("starttime", "<", (Object)dtNow);
            qFilter.and("endtime", ">", (Object)dtNow);
            qFilter.and("tickettypeid.isinsalesincome", "=", (Object)Boolean.FALSE);
            qFilter.and("tickettypeid.isoutlinestore", "=", (Object)Boolean.TRUE);
            if (StringUtils.isNotEmpty((CharSequence)numberFilter)) {
                qFilter.and("number", "=", (Object)numberFilter);
            } else if (memberId > 0L) {
                qFilter.and("vipid", "=", (Object)memberId);
            } else {
                qFilter.and("'1'", "<>", (Object)"1");
            }
            if (!CollectionUtils.isEmpty(lstTicketId)) {
                qFilter.and("id", "not in", (Object)lstTicketId.toArray());
            }
            if (!CollectionUtils.isEmpty((Collection)(lstId = TicketAmountHelper.getMemberTicketInfo((QFilter)qFilter, lstGoodsEntry, (long)branchId, (long)memberId, (String)numberFilter)))) {
                this.getView().getPageCache().put("ticketid", numberFilter);
            }
            qFilter = new QFilter("id", "in", (Object)lstId.toArray());
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            DynamicObjectCollection docTicketEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (docTicketEntry == null || docTicketEntry.getRowCount() == 0) {
                this.getView().showErrorNotification("\u672a\u9009\u62e9\u4f18\u60e0\u5238\u3002");
                return;
            }
            this.getView().returnDataToParent((Object)docTicketEntry);
            this.getView().close();
        }
    }

    private void updateTicketRecord(List<DynamicObject> docGoodsEntry, BigDecimal billBalAmount, int rowIndex, DynamicObject doTicket, DynamicObject doTicketType, boolean singleItemAmt, String seqValue) {
        String goodsSeq = "";
        BigDecimal sumBalAmount = BigDecimal.ZERO;
        String usageMode = doTicketType.getString("usagemode");
        boolean isAllGoods = doTicketType.getBoolean("isallgoods");
        if (!singleItemAmt) {
            switch (usageMode) {
                case "0": {
                    BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicket, (String)"ticketvalue");
                    if (isAllGoods) {
                        goodsSeq = TicketAmountHelper.getGoodsSeq(docGoodsEntry);
                        sumBalAmount = billBalAmount;
                    } else {
                        Map mapResult = SaleOrderHelper.calcGoodsAmount(docGoodsEntry, (DynamicObject)doTicketType, (String)usageMode);
                        if (mapResult.size() > 0) {
                            goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
                            sumBalAmount = (BigDecimal)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getValue();
                        }
                    }
                    if (sumBalAmount.compareTo(ticketValue) <= 0) {
                        this.getModel().setValue("utpayamount", (Object)billBalAmount, rowIndex);
                        break;
                    }
                    this.getModel().setValue("utpayamount", (Object)ticketValue, rowIndex);
                    break;
                }
                case "1": {
                    BigDecimal discountRate = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"discountrate");
                    if (isAllGoods) {
                        sumBalAmount = billBalAmount;
                        goodsSeq = TicketAmountHelper.getGoodsSeq(docGoodsEntry);
                    } else {
                        Map mapResult = SaleOrderHelper.calcGoodsAmount(docGoodsEntry, (DynamicObject)doTicketType, (String)usageMode);
                        if (mapResult.size() > 0) {
                            goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
                            sumBalAmount = (BigDecimal)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getValue();
                        }
                    }
                    BigDecimal discountAmt = sumBalAmount.multiply(discountRate).divide(new BigDecimal(100), 2, 4);
                    this.getModel().setValue("useamount", (Object)sumBalAmount.subtract(discountAmt), rowIndex);
                    this.getModel().setValue("utpayamount", (Object)sumBalAmount.subtract(discountAmt), rowIndex);
                    break;
                }
                case "2": {
                    BigDecimal sumAmount = BigDecimal.ZERO;
                    if (isAllGoods) {
                        DynamicObject doGoodsEntry = docGoodsEntry.stream().findFirst().orElse(null);
                        if (doGoodsEntry != null) {
                            goodsSeq = TicketAmountHelper.getGoodsSeq(docGoodsEntry);
                            sumAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                        }
                    } else {
                        Map mapResult = SaleOrderHelper.calcGoodsAmount(docGoodsEntry, (DynamicObject)doTicketType, (String)usageMode);
                        if (mapResult.size() > 0) {
                            goodsSeq = (String)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getKey();
                            sumAmount = (BigDecimal)((Map.Entry)mapResult.entrySet().stream().findFirst().get()).getValue();
                        }
                    }
                    this.getModel().setValue("utpayamount", (Object)sumAmount, rowIndex);
                    this.getModel().setValue("useamount", (Object)sumAmount, rowIndex);
                    break;
                }
            }
        } else {
            goodsSeq = seqValue;
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seqValue)).findFirst().orElse(null);
            if (doGoodsEntry == null) {
                return;
            }
            switch (usageMode) {
                case "0": {
                    BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicket, (String)"ticketvalue");
                    sumBalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    if (sumBalAmount.compareTo(ticketValue) <= 0) {
                        this.getModel().setValue("utpayamount", (Object)billBalAmount, rowIndex);
                        break;
                    }
                    this.getModel().setValue("utpayamount", (Object)ticketValue, rowIndex);
                    break;
                }
                case "1": {
                    BigDecimal discountRate = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"discountrate");
                    sumBalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    BigDecimal discountAmt = sumBalAmount.multiply(discountRate).divide(new BigDecimal(100), 2, 4);
                    this.getModel().setValue("useamount", (Object)sumBalAmount.subtract(discountAmt), rowIndex);
                    this.getModel().setValue("utpayamount", (Object)sumBalAmount.subtract(discountAmt), rowIndex);
                    break;
                }
                case "2": {
                    sumBalAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                    this.getModel().setValue("utpayamount", (Object)sumBalAmount, rowIndex);
                    this.getModel().setValue("useamount", (Object)sumBalAmount, rowIndex);
                    break;
                }
            }
        }
        this.getModel().setValue("utgoodsseq", (Object)goodsSeq, rowIndex);
    }

    private boolean isCondition(List<DynamicObject> useTicketData, DynamicObjectCollection docEntry, BigDecimal sumBalAmount, List<DynamicObject> docGoodsEntry, DynamicObject doTicketType, String ticketNo, BigDecimal minConsumeAmount, String newAmtPriceWay, boolean singleItemAmt, boolean singleItemQty, String goodsSeq) {
        long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doTicketType);
        String condition = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"condition");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)condition)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)condition)) {
            if (useTicketData != null && useTicketData.size() > 0 && useTicketData.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") == ticketTypeId)) {
                this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\uff0c\u53ea\u80fd\u4f7f\u7528\u4e00\u5f20\u3002", ticketNo));
                return false;
            }
            if (docEntry != null && docEntry.size() > 0 && docEntry.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") == ticketTypeId)) {
                this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\uff0c\u53ea\u80fd\u4f7f\u7528\u4e00\u5f20\u3002", ticketNo));
                return false;
            }
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)condition)) {
            boolean rlt;
            long qty = 0L;
            long cnt = 0L;
            if (useTicketData != null && useTicketData.size() > 0) {
                cnt += useTicketData.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") == ticketTypeId).count();
            }
            if (docEntry != null && docEntry.size() > 0) {
                cnt += docEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") == ticketTypeId).count();
            }
            if (cnt == 0L) {
                return true;
            }
            if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
                this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\uff0c\u672a\u5339\u914d\u5230\u9002\u7528\u5546\u54c1\u3002", ticketNo));
                return false;
            }
            if (singleItemAmt && singleItemQty) {
                long amtCnt = TicketAmountHelper.getTicketQty(docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"1");
                long qtyCnt = TicketAmountHelper.getTicketQty(docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"2");
                qty = Math.min(amtCnt, qtyCnt);
            } else if (singleItemAmt) {
                qty = TicketAmountHelper.getTicketQty(docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"1");
            } else if (singleItemQty) {
                qty = TicketAmountHelper.getTicketQty(docGoodsEntry, (DynamicObject)doTicketType, (String)goodsSeq, (String)newAmtPriceWay, (String)"2");
            }
            if (minConsumeAmount.compareTo(BigDecimal.ZERO) > 0) {
                long minConsumeQty = CommonUtil.formatObejctToLong((Object)sumBalAmount.divideAndRemainder(minConsumeAmount)[0]);
                qty = Math.min(minConsumeQty, qty);
            }
            boolean bl = rlt = qty > cnt;
            if (!rlt) {
                if (qty == 0L) {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u4e0d\u6ee1\u8db3\u89c4\u5219\u6761\u4ef6\u7d2f\u52a0\u4f7f\u7528\uff0c\u8d2d\u4e70\u5546\u54c1\u672a\u6ee1\u8db3\u6210\u500d\u7d2f\u52a0\u89c4\u5219\u3002", ticketNo));
                } else {
                    this.getView().showErrorNotification(String.format("\u793c\u5238\u7f16\u53f7%s\u8d85\u8fc7\u7d2f\u52a0\u4f7f\u7528\u5f20\u6570\u3002", ticketNo));
                }
            }
            return rlt;
        }
        return true;
    }

    private List<DynamicObject> getGoodsEntry(FormShowParameter frmShowParameter) {
        DynamicObjectType goodsEntryDyt;
        String goodsEntryData = frmShowParameter.getCustomParam("goodsentryentity").toString();
        Object[] objGoodsEntry = DynamicObjectSerializeUtil.deserialize((String)goodsEntryData, (DynamicObjectType)(goodsEntryDyt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder.goodsentryentity")));
        if (objGoodsEntry == null || objGoodsEntry.length == 0) {
            return null;
        }
        String goodsSeq = (String)frmShowParameter.getCustomParam("seq");
        if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return null;
        }
        String[] goodsSeqArray = StringUtils.split((String)goodsSeq, (String)",");
        if (goodsSeqArray == null || goodsSeqArray.length == 0) {
            return null;
        }
        List<String> lstGoodsSeq = Arrays.asList(goodsSeqArray);
        ArrayList<DynamicObject> lstGoodEntry = new ArrayList<DynamicObject>(0);
        for (Object item : objGoodsEntry) {
            DynamicObject goodsItem;
            String seq;
            if (!(item instanceof DynamicObject) || !lstGoodsSeq.contains(seq = DynamicObjectUtils.getString((DynamicObject)(goodsItem = (DynamicObject)item), (String)"seq"))) continue;
            lstGoodEntry.add(goodsItem);
        }
        return lstGoodEntry;
    }

    private List<DynamicObject> getUseTicketEntry(FormShowParameter frmShowParameter) {
        DynamicObjectType useTicketEntryDyt;
        String useTicketEntryData = frmShowParameter.getCustomParam("useticketentity").toString();
        Object[] objUseTicketEntry = DynamicObjectSerializeUtil.deserialize((String)useTicketEntryData, (DynamicObjectType)(useTicketEntryDyt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder.useticketentity")));
        if (objUseTicketEntry == null || objUseTicketEntry.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> lstUseTicketEntry = new ArrayList<DynamicObject>(0);
        for (Object item : objUseTicketEntry) {
            if (!(item instanceof DynamicObject)) continue;
            lstUseTicketEntry.add((DynamicObject)item);
        }
        return lstUseTicketEntry;
    }
}

