/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show.choose;

import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class BookPrestoreChooseFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        long vipId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("member"));
        long branchId = CommonUtil.formatObejctToLong((Object)parameter.getCustomParam("salebranchid"));
        if (vipId > 0L && branchId > 0L) {
            DynamicObjectCollection docEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (docEntry == null) {
                return;
            }
            DynamicObjectCollection docData = this.queryData(branchId, vipId);
            if (CollectionUtils.isEmpty((Collection)docData)) {
                return;
            }
            docEntry.clear();
            for (DynamicObject data : docData) {
                DynamicObject doEntry = docEntry.addNew();
                doEntry.set("id", data.get("id"));
                doEntry.set("vipname", data.get("member.name"));
                doEntry.set("telephone", data.get("customerphone"));
                doEntry.set("depositamount", data.get("depositamount"));
                doEntry.set("depositpayamount", data.get("depositpayamount"));
                doEntry.set("saleamount", data.get("saleamount"));
                doEntry.set("billno", data.get("billno"));
                doEntry.set("bizdate", data.get("bizdate"));
                doEntry.set("cashier", data.get("cashier.username"));
            }
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnOk = (Button)this.getView().getControl("btnok");
        btnOk.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
            if (rowIndex < 0) {
                return;
            }
            DynamicObject data = this.getView().getModel().getEntryRowEntity("entryentity", rowIndex);
            this.getView().returnDataToParent((Object)data);
            this.getView().close();
        }
    }

    private DynamicObjectCollection queryData(long branchId, long vipId) {
        String selectFields = this.getSelectFields();
        QFilter filter = new QFilter("salebranchid.id", "=", (Object)branchId);
        filter.and("basebilltype.id", "=", (Object)BillTypeEnum.RESERVE.getId());
        filter.and("member.id", "=", (Object)vipId);
        filter.and("notconfirm", "=", (Object)Boolean.TRUE);
        filter.and("depositamount", ">", (Object)0);
        filter.and("closestatus", "=", (Object)CloseStatusEnum.UNCLOSE.getValue());
        filter.and("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        filter.and("billstatus", "=", (Object)EnumBillStatus.C.toString());
        return QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray(), (String)this.getOrderByFields());
    }

    private String getSelectFields() {
        return "id, billno, bizdate, member.name,customerphone,depositamount,depositpayamount,saleamount,cashier.username";
    }

    private String getOrderByFields() {
        return "bizdate, billno";
    }
}

