/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show.logistics;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocpos.business.inventory.LogisticsInfoHelper;
import kd.occ.ocpos.common.util.JsonUtil;

public class LogisticsInfoQueryFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long subEntryId = customParams.getOrDefault("subentryid", 0L);
        this.getModel().setValue("subentryid", (Object)subEntryId);
        Object data = customParams.getOrDefault("deliveryData", null);
        if (data instanceof JSONArray) {
            JSONArray logisticData = data;
            logisticData.sort(Comparator.comparing(x -> ((JSONObject)x).getDate("arrivaldate")).reversed());
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"logisticsinfo");
            if (entryEntities != null) {
                for (Object item : logisticData) {
                    JSONObject logisticsInfo = (JSONObject)item;
                    DynamicObject entryEntity = entryEntities.addNew();
                    entryEntity.set("id", (Object)logisticsInfo.getLongValue("id"));
                    Map logisticsInfoJson = (Map)JsonUtil.fromJson((String)logisticsInfo.toJSONString(), Map.class);
                    if (logisticsInfoJson.get("logisticcomp") != null) {
                        Long logisticsCompId = Long.parseLong(((Map)logisticsInfoJson.get("logisticcomp")).get("id").toString());
                        DynamicObject logisticsComp = BusinessDataServiceHelper.loadSingle((Object)logisticsCompId, (String)"bd_logisticcomp");
                        entryEntity.set("logisticcomp", (Object)logisticsComp);
                    }
                    entryEntity.set("logisticsbill", logisticsInfo.get((Object)"logisticsbill"));
                    if (logisticsInfoJson.get("driver") != null) {
                        Long driverId = Long.parseLong(((Map)logisticsInfoJson.get("driver")).get("id").toString());
                        DynamicObject driver = BusinessDataServiceHelper.loadSingle((Object)driverId, (String)"bos_user");
                        entryEntity.set("driver", (Object)driver);
                    }
                    entryEntity.set("drivertel", logisticsInfo.get((Object)"drivertel"));
                    entryEntity.set("carno", logisticsInfo.get((Object)"carno"));
                    entryEntity.set("infodescription", logisticsInfo.get((Object)"infodescription"));
                    entryEntity.set("arrivaldate", (Object)logisticsInfo.getDate("arrivaldate"));
                    entryEntity.set("lsc_signstatus", logisticsInfo.get((Object)"lsc_signstatus"));
                    entryEntity.set("receivingdate", (Object)logisticsInfo.getDate("receivingdate"));
                }
                this.getView().updateView("logisticsinfo");
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = customParams.getOrDefault("type", null);
        String caption = "\u53d1\u8d27\u65f6\u95f4";
        if (type != null && StringUtils.equals((CharSequence)type.toString(), (CharSequence)"1")) {
            caption = "\u53d6\u4ef6\u65f6\u95f4";
        }
        DateTimeEdit dateEdit = (DateTimeEdit)this.getView().getControl("arrivaldate");
        dateEdit.setCaption(new LocaleString(caption));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (StringUtils.equals((CharSequence)e.getOperateKey(), (CharSequence)"modify")) {
            int index = this.getModel().getEntryCurrentRowIndex("logisticsinfo");
            DynamicObject logisticsInfo = this.getModel().getEntryRowEntity("logisticsinfo", index);
            this.showLogisticsInfoForm(logisticsInfo);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"ocpos_logisticsinfo") && returnData instanceof JSONObject) {
            JSONObject result = (JSONObject)returnData;
            Boolean isSuccess = result.getBoolean("isSuccess");
            if (isSuccess == null) {
                return;
            }
            if (isSuccess.booleanValue()) {
                int index = this.getModel().getEntryCurrentRowIndex("logisticsinfo");
                Object logisticsInfoId = this.getModel().getValue("id", index);
                DynamicObject logisticsInfo = LogisticsInfoHelper.getLogisticsInfo((Object)logisticsInfoId);
                if (logisticsInfo != null) {
                    this.getModel().setValue("logisticcomp", logisticsInfo.get("logisticcomp"), index);
                    this.getModel().setValue("logisticsbill", logisticsInfo.get("logisticsbill"), index);
                    DynamicObject drive = logisticsInfo.getDynamicObject("driver");
                    this.getModel().setValue("driver", (Object)drive, index);
                    this.getModel().setValue("drivertel", logisticsInfo.get("drivertel"), index);
                    this.getModel().setValue("carno", logisticsInfo.get("carno"), index);
                    this.getModel().setValue("infodescription", logisticsInfo.get("infodescription"), index);
                    this.getModel().setValue("arrivaldate", logisticsInfo.get("arrivaldate"), index);
                    this.getModel().setValue("lsc_signstatus", logisticsInfo.get("lsc_signstatus"), index);
                    this.getModel().setValue("receivingdate", logisticsInfo.get("receivingdate"), index);
                }
            } else {
                String errorMsg = result.getString("errorMsg");
                this.getView().showErrMessage(errorMsg, "\u7269\u6d41\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
            }
        }
    }

    private void showLogisticsInfoForm(DynamicObject logisticInfo) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("data", logisticInfo);
        Object subEntryId = this.getModel().getValue("subentryid");
        customParams.put("subentryid", subEntryId);
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        customParams.put("type", type);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u4fee\u6539\u7269\u6d41\u4fe1\u606f", (String)"ocpos_logisticsinfo", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ocpos_logisticsinfo"));
        this.getView().showForm(parameter);
    }
}

