/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show.member;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.GetChannelConsultantDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.RegisterByPOSDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.GetChannelConsultantVO;
import kd.occ.ocbase.common.pojo.vo.member.user.RegisterByPOSVO;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.FormViewUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class RegisterMemberEditPlugin
extends AbstractFormPlugin {
    private static final long LEN_ENTERPRISE = 1069513413337666560L;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        Long orgId = customParams.getOrDefault("bizorgid", 0L);
        this.getModel().setValue("bizorgid", (Object)orgId);
        Long branchId = customParams.getOrDefault("salebranchid", 0L);
        this.getModel().setValue("salebranchid", (Object)branchId);
        Object channelArea = this.getChannelArea(branchId);
        this.getModel().setValue("districtid", channelArea);
        long vipTypeId = this.getVipTypeId();
        if (vipTypeId == 1069513413337666560L) {
            Long customerId = customParams.getOrDefault("customerid", 0L);
            this.getModel().setValue("customerid", (Object)customerId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setCustomerMustInput();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult opResult;
        super.afterDoOperation(e);
        if (StringUtils.equals((CharSequence)"register", (CharSequence)e.getOperateKey()) && (opResult = e.getOperationResult()) != null && opResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            this.setCounselor(dataEntity);
            RegisterByPOSDTO register = new RegisterByPOSDTO();
            this.setMainInfo(dataEntity, register);
            this.setDetailInfo(dataEntity, register);
            this.setOtherInfo(dataEntity, register);
            JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"registerByPOS", (Object[])new Object[]{register});
            if (!ObjectUtils.isEmpty((Object)result)) {
                boolean isSuccess = result.getBoolean("success");
                if (!isSuccess) {
                    String message = result.getString("message");
                    this.getView().showErrorNotification(message);
                } else {
                    Object data = result.get((Object)"data");
                    if (data instanceof RegisterByPOSVO) {
                        long memberId = ((RegisterByPOSVO)data).getUserId();
                        this.getView().returnDataToParent((Object)memberId);
                        this.getView().close();
                    }
                }
            } else {
                this.getView().showErrorNotification("\u4f1a\u5458\u6ce8\u518c\u5f02\u5e38\u3002");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || (long)changeSet.length <= 0L) {
            return;
        }
        boolean isNotChanged = CommonUtil.checkChanged((ChangeData)changeSet[0]);
        if (isNotChanged) {
            return;
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"viptypeid")) {
            this.setCustomerMustInput();
        }
    }

    private void setMainInfo(DynamicObject dataEntity, RegisterByPOSDTO register) {
        String name = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"name");
        register.setName(name);
        String mobile = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"mobile");
        if (mobile.contains("-")) {
            int index = mobile.indexOf(45);
            mobile = mobile.substring(index + 1);
        }
        register.setMobile(mobile);
        String sex = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"sex");
        register.setSex(Integer.parseInt(sex));
        long addressTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"addresstypeid");
        register.setAddressTypeId(Long.valueOf(addressTypeId));
        String strAdminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"districtid");
        long adminDivisionId = StringUtils.isNotBlank((CharSequence)strAdminDivisionId) ? Long.parseLong(strAdminDivisionId) : 0L;
        register.setDistrictId(Long.valueOf(adminDivisionId));
        String detailedAddress = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"detailedaddress");
        register.setDetailedAddress(detailedAddress);
    }

    private void setDetailInfo(DynamicObject dataEntity, RegisterByPOSDTO register) {
        String avatarUrl = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"avatarurl");
        register.setAvatarUrl(avatarUrl);
        Date birthday = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"birthday");
        if (StringUtils.isNotBlank((Object)birthday)) {
            register.setBirthday(DateUtil.getDateFormat((Date)birthday));
        } else {
            register.setBirthday("");
        }
        String email = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"email");
        register.setEmail(email);
        long nationalityId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"nationalityid");
        register.setNationalityId(Long.valueOf(nationalityId));
        long educationId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"educationid");
        register.setEducationId(Long.valueOf(educationId));
        long occupationId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"occupationid");
        register.setOccupationId(Long.valueOf(occupationId));
        long monthlyIncomeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"monthlyincomeid");
        register.setMonthlyIncomeId(Long.valueOf(monthlyIncomeId));
        long agentId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"agentid");
        register.setAgentId(Long.valueOf(agentId));
        long vipTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"viptypeid");
        register.setVipTypeId(Long.valueOf(vipTypeId));
        long customerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"customerid");
        register.setCustomerId(Long.valueOf(customerId));
    }

    private void setOtherInfo(DynamicObject dataEntity, RegisterByPOSDTO register) {
        DynamicObject split = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"splitid");
        String splitNum = DynamicObjectUtils.getString((DynamicObject)split, (String)"number");
        register.setSplitNumber(splitNum);
        String strUserId = RequestContext.get().getUserId();
        if (StringUtils.isNotBlank((CharSequence)strUserId)) {
            long userId = Long.parseLong(strUserId);
            register.setCreatorId(Long.valueOf(userId));
        }
        long bizOrgId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"bizorgid");
        register.setCreateOrgId(Long.valueOf(bizOrgId));
        register.setOrgId(Long.valueOf(bizOrgId));
        long saleBranchId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"salebranchid");
        register.setChannelId(Long.valueOf(saleBranchId));
        String srcAppType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcapptype");
        register.setSrcAppType(srcAppType);
        register.setSrcAppName("\u7ebf\u4e0b\u95e8\u5e97");
        long developerId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"developerid");
        register.setDeveloperId(Long.valueOf(developerId));
        long consultantId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"consultantid");
        register.setConsultantId(Long.valueOf(consultantId));
    }

    private void setCounselor(DynamicObject dataEntity) {
        long orgId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"salebranchid");
        boolean enableCounselor = SystemParamUtil.getEnableCounselor((long)orgId, (long)branchId);
        long counselorId = 0L;
        if (enableCounselor) {
            GetChannelConsultantDTO dto = new GetChannelConsultantDTO();
            dto.setChannelId(Long.valueOf(branchId));
            GetChannelConsultantVO vo = UserServiceHelper.getChannelConsultant((GetChannelConsultantDTO)dto);
            Long consultantId = vo.getConsultantId();
            if (consultantId != null) {
                counselorId = consultantId;
            }
        }
        dataEntity.set("consultantid", (Object)counselorId);
        this.getView().updateView("consultantid");
    }

    private void setCustomerMustInput() {
        long vipTypeId = this.getVipTypeId();
        FormViewUtil.setMustInput((IFormView)this.getView(), (vipTypeId == 1069513413337666560L ? 1 : 0) != 0, (String[])new String[]{"customerid"});
    }

    private long getVipTypeId() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"viptypeid");
    }

    private Object getChannelArea(Object branchId) {
        try {
            DynamicObject channel = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel");
            return channel.get("area");
        }
        catch (Exception ex) {
            return null;
        }
    }
}

