/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.saleorder.show.member;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class UpdateVipAddressFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String OP_SAVEDATA = "savedata";
    private static final String OP_RETURNDATA = "returndata";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long vipId = (Long)this.getView().getFormShowParameter().getCustomParam("member");
        if (vipId > 0L) {
            DynamicObject doVipInfo = BusinessDataServiceHelper.loadSingle((Object)vipId, (String)"ocdbd_user");
            DynamicObjectCollection docAddressData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doVipInfo, (String)"ocdbd_user_addr_entry");
            if (CollectionUtils.isEmpty((Collection)docAddressData)) {
                return;
            }
            DynamicObjectCollection docAddressEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRYENTITY);
            DataEntityPropertyCollection properties = docAddressEntry.getDynamicObjectType().getProperties();
            for (DynamicObject data : docAddressData) {
                DynamicObject doAddressEntry = docAddressEntry.addNew();
                for (IDataEntityProperty property : properties) {
                    String key = property.getName();
                    if (!DynamicObjectUtils.contain((DynamicObject)data, (String)key)) continue;
                    doAddressEntry.set(key, data.get(key));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)OP_SAVEDATA) || StringUtils.equals((CharSequence)key, (CharSequence)OP_RETURNDATA)) {
            DynamicObjectCollection docAddressEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)docAddressEntry)) {
                this.getView().close();
                return;
            }
            long vipId = (Long)this.getView().getFormShowParameter().getCustomParam("member");
            if (vipId > 0L) {
                if (StringUtils.equals((CharSequence)key, (CharSequence)OP_RETURNDATA)) {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
                    int[] indexes = entryGrid.getSelectRows();
                    if (indexes.length == 0) {
                        NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u6240\u9700\u7684\u5730\u5740\u4fe1\u606f\uff0c\u5982\u4e0d\u9700\u8fd4\u56de\u8bf7\u70b9\u51fb\u4fdd\u5b58\u6570\u636e\u3002", (IFormView)this.getView());
                        return;
                    }
                    this.doChooseAddress(indexes, docAddressEntry);
                }
                if (!this.saveAddressData(vipId, docAddressEntry)) {
                    NotificationUtil.showDefaultTipNotify((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a\u3002", (IFormView)this.getView());
                    return;
                }
                this.getView().close();
            } else {
                NotificationUtil.showDefaultTipNotify((String)"\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u4f1a\u5458\u4fe1\u606f\uff0c\u6216\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (IFormView)this.getView());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getChangeSet().length == 0) {
            return;
        }
        String key = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"isdefault")) {
            DynamicObjectCollection docAddressEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRYENTITY);
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (CommonUtil.formatObjectToBoolean((Object)e.getChangeSet()[0].getNewValue())) {
                for (int i = 0; i < docAddressEntry.getRowCount(); ++i) {
                    if (i == rowIndex) continue;
                    ((DynamicObject)docAddressEntry.get(i)).set("isdefault", (Object)Boolean.FALSE);
                }
            }
            this.getView().updateView(KEY_ENTRYENTITY);
        }
    }

    private void doChooseAddress(int[] indexes, DynamicObjectCollection docAddressEntry) {
        DynamicObject doData = (DynamicObject)docAddressEntry.get(indexes[0]);
        HashMap<String, String> returnData = new HashMap<String, String>(0);
        returnData.put("customername", DynamicObjectUtils.getString((DynamicObject)doData, (String)"contact"));
        returnData.put("customerphone", DynamicObjectUtils.getString((DynamicObject)doData, (String)"phone"));
        returnData.put("admindivisionid", DynamicObjectUtils.getString((DynamicObject)doData, (String)"districtid"));
        returnData.put("customeraddress", DynamicObjectUtils.getString((DynamicObject)doData, (String)"detailedaddress"));
        this.getView().returnDataToParent(returnData);
    }

    private boolean saveAddressData(long vipId, DynamicObjectCollection docAddressEntry) {
        DynamicObject doVipInfo = BusinessDataServiceHelper.loadSingle((Object)vipId, (String)"ocdbd_user");
        DynamicObjectCollection docAddressData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doVipInfo, (String)"ocdbd_user_addr_entry");
        if (CollectionUtils.isEmpty((Collection)docAddressData)) {
            return false;
        }
        DataEntityPropertyCollection properties = docAddressData.getDynamicObjectType().getProperties();
        for (DynamicObject data : docAddressEntry) {
            for (IDataEntityProperty property : properties) {
                String propKey = property.getName();
                DynamicObject doAddressData = docAddressData.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == DynamicObjectUtils.getLong((DynamicObject)data, (String)"id")).findFirst().orElse(null);
                if (ObjectUtils.isEmpty((Object)doAddressData) || !DynamicObjectUtils.contain((DynamicObject)data, (String)propKey)) continue;
                doAddressData.set(propKey, data.get(propKey));
            }
        }
        SaveServiceHelper.update((DynamicObject)doVipInfo);
        return true;
    }
}

