/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.system;

import java.util.Collections;
import java.util.EventObject;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OlsPersonalizedFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getModel().setValue("iscreate", (Object)"1");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object isCreate = this.getView().getModel().getValue("iscreate");
        if ("0".equals(isCreate) || isCreate == null) {
            this.initializationForm();
            this.getView().getModel().setValue("iscreate", (Object)"1");
            this.setDynamicPanelVisible(0);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("firstentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[0]);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            DynamicObjectCollection secondEntryEntity = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("secondentryentity");
            for (DynamicObject secondEntryEntityRow : secondEntryEntity) {
                DynamicObjectCollection thirdEntryEntity = secondEntryEntityRow.getDynamicObjectCollection("thirdentryentity");
                thirdEntryEntity.removeIf(thirdEntryEntityRow -> thirdEntryEntityRow.get("itembrandid") == null && thirdEntryEntityRow.get("itemlableid") == null && thirdEntryEntityRow.get("thirditemclassid") == null);
            }
            this.getView().updateView();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        String eventKey = ((Control)evt.getSource()).getKey();
        if ("firstentryentity".equals(eventKey)) {
            int index = evt.getRow();
            if (index == -1) {
                return;
            }
            String ParentEntryUid = ((DynamicObject)this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("firstentryentity").get(index)).getString("uid");
            int logoTypeFlexId = this.getlogoTypeFlexIdByParentEntryUid(ParentEntryUid);
            this.setDynamicPanelVisible(logoTypeFlexId);
        }
    }

    private int getlogoTypeFlexIdByParentEntryUid(String parentEntryUid) {
        DynamicObjectCollection mappingEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("mappingentry");
        for (DynamicObject mappingEntryRow : mappingEntry) {
            if (!StringUtils.equals((CharSequence)mappingEntryRow.getString("logotypeparententryuid"), (CharSequence)parentEntryUid)) continue;
            return mappingEntryRow.getInt("logotypeflexid");
        }
        return 0;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject classStandardId;
        String fieldKey = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        if ("classstanderedid".equals(fieldKey) && (classStandardId = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            QFilter qFilter = new QFilter("standard", "=", classStandardId.getPkValue());
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("parent", "=", (Object)0);
            DynamicObject[] itemClassArray = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id,name,number", (QFilter[])qFilter.toArray());
            this.addRowAndShowBoard(itemClassArray);
        }
    }

    private void addRowAndShowBoard(DynamicObject[] itemClassArray) {
        this.clear();
        DynamicObject dyo = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection firstEntryEntity = dyo.getDynamicObjectCollection("firstentryentity");
        int logoTypeFlexId = 0;
        for (DynamicObject itemClass : itemClassArray) {
            DynamicObject firstEntryRow = new DynamicObject(firstEntryEntity.getDynamicObjectType());
            firstEntryRow.set("firstitemclassid", (Object)itemClass);
            firstEntryRow.set("sort", (Object)(logoTypeFlexId + 1));
            String uid = UUID.randomUUID().toString().replace("-", "") + 1;
            firstEntryRow.set("uid", (Object)uid);
            firstEntryEntity.add((Object)firstEntryRow);
            DynamicObjectCollection mappingEntry = dyo.getDynamicObjectCollection("mappingentry");
            DynamicObject newDyo = new DynamicObject(mappingEntry.getDynamicObjectType());
            newDyo.set("logotypeparententryuid", (Object)uid);
            newDyo.set("logotypeflexid", (Object)logoTypeFlexId);
            mappingEntry.add((Object)newDyo);
            this.showSubForm(logoTypeFlexId, uid);
            ++logoTypeFlexId;
        }
        this.setDynamicPanelVisible(0);
        this.getView().updateView("firstentryentity");
    }

    private void clear() {
        DynamicObjectCollection mappingEntry = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("mappingentry");
        for (DynamicObject mappingEntryRow : mappingEntry) {
            Container container = (Container)this.getView().getControl("dynamicpanel");
            container.deleteControls(new String[]{"keyboard" + mappingEntryRow.getInt("logotypeflexid")});
        }
        this.getModel().deleteEntryData("mappingentry");
        this.getModel().deleteEntryData("firstentryentity");
        this.getModel().deleteEntryData("secondentryentity");
    }

    private void showSubForm(int subScript, String pageId) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey("keyboard" + subScript);
        Container container = (Container)this.getView().getControl("dynamicpanel");
        container.addControls(Collections.singletonList(flex.createControl()));
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ocpos_olssubpersonalized");
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.setPageId(pageId);
        param.getOpenStyle().setTargetKey("keyboard" + subScript);
        param.setCustomParam("parententryuid", (Object)pageId);
        this.getView().showForm(param);
    }

    private void setDynamicPanelVisible(int logoTypeFlexId) {
        int sum = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("mappingentry").size();
        if (sum == 0) {
            return;
        }
        int largeNum = ((DynamicObject)this.getView().getModel().getEntryEntity("mappingentry").get(sum - 1)).getInt("logotypeflexid");
        for (int x = 0; x <= largeNum; ++x) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"keyboard" + x});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"keyboard" + logoTypeFlexId});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("preview".equals(evt.getItemKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ocpos_olspersonalizedpre");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    private void initializationForm() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection firstEntryEntity = dataEntity.getDynamicObjectCollection("firstentryentity");
        DynamicObjectCollection mappingEntry = dataEntity.getDynamicObjectCollection("mappingentry");
        int index = 0;
        for (DynamicObject firstEntryRow : firstEntryEntity) {
            String uid = firstEntryRow.getString("uid");
            DynamicObject newDyo = new DynamicObject(mappingEntry.getDynamicObjectType());
            newDyo.set("logotypeflexid", (Object)index);
            newDyo.set("logotypeparententryuid", (Object)uid);
            mappingEntry.add((Object)newDyo);
            this.showSubForm(index, uid);
            ++index;
        }
    }
}

