/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.system;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.parameter.ParameterModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SysParamFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_ORG = "orgid";
    private static final String KEY_ORG_OLD = "oldOrgId";
    private static final String KEY_ORG_DEFAULT = "defOrgId";
    private static long currentOrgId = 0L;
    private static boolean isFirst = true;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (isFirst) {
            IAppCache cache = AppCache.get((String)"ocpos");
            FormShowParameter parameter = e.getFormShowParameter();
            Map customParams = parameter.getCustomParams();
            long defOrgId = CommonUtil.formatObejctToLong((Object)customParams.getOrDefault(KEY_ORG, RequestContext.get().getOrgId()));
            cache.put(KEY_ORG_DEFAULT, (Object)defOrgId);
            isFirst = false;
        }
    }

    public void initialize() {
        super.initialize();
        currentOrgId = RequestContext.get().getOrgId();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IAppCache cache = AppCache.get((String)"ocpos");
        Object oldOrg = cache.get(KEY_ORG_OLD, Object.class);
        long oldOrgId = oldOrg != null ? Long.parseLong(oldOrg.toString()) : currentOrgId;
        Object defOrg = cache.get(KEY_ORG_DEFAULT, Object.class);
        long defOrgId = defOrg != null ? Long.parseLong(defOrg.toString()) : currentOrgId;
        long orgId = ((ParameterModel)this.getModel()).getOrgId();
        if (orgId != defOrgId && orgId != oldOrgId) {
            this.getModel().setItemValueByID("saleorderdefcustomer", (Object)0L);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit customerEdit = (BasedataEdit)this.getView().getControl("saleorderdefcustomer");
        customerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"saleorderdefcustomer")) {
            long orgId = ((ParameterModel)this.getModel()).getOrgId();
            QFilter filter = BaseDataServiceHelper.getBaseDataProFilter((String)"bd_customer", (Long)orgId, (String)"id");
            F7Utils.addCustomF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
        }
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        IAppCache cache = AppCache.get((String)"ocpos");
        cache.put(KEY_ORG_OLD, (Object)((ParameterModel)this.getModel()).getOrgId());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IAppCache cache = AppCache.get((String)"ocpos");
        cache.remove(KEY_ORG_OLD);
        cache.remove(KEY_ORG_DEFAULT);
    }
}

