/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.system.param;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.entity.pos.PosEntity;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.DbUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class InSynchronousFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOG = LogFactory.getLog(InSynchronousFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressbar = (ProgressBar)this.getView().getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setTitle();
        this.synchronousData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String startProgress = this.getPageCache().get("startprogress");
        boolean visible = StringUtils.isBlank((CharSequence)startProgress) || StringUtils.equals((CharSequence)startProgress, (CharSequence)"1");
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"btnok", "btncancel"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)ctrl.getKey(), (CharSequence)"btnok")) {
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("type", showParameter.getCustomParam("type"));
            customParams.put("ocpos_store_sysparam", showParameter.getCustomParam("ocpos_store_sysparam"));
            customParams.put("org", showParameter.getCustomParam("org"));
            customParams.put("branch", showParameter.getCustomParam("branch"));
            FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u540c\u6b65\u6570\u636e", (String)"ocpos_synchronousdata", (ShowType)ShowType.InCurrentForm, (OperationStatus)OperationStatus.ADDNEW, customParams);
            parameter.setParentPageId(showParameter.getParentPageId());
            this.getView().showForm(parameter);
        }
    }

    public void onProgress(ProgressEvent e) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String startProgress = this.getPageCache().get("startprogress");
        if (StringUtils.isNotBlank((CharSequence)startProgress) && StringUtils.equals((CharSequence)startProgress, (CharSequence)"1")) {
            NotificationUtil.showDefaultTipNotify((String)"\u6570\u636e\u540c\u6b65\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed\u3002", (IFormView)this.getView());
            e.setCancel(true);
        }
    }

    private void setTitle() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = CommonUtil.formatStringToEmpty((Object)customParams.getOrDefault("type", "bos_org"));
        String text = StringUtils.equals((CharSequence)type, (CharSequence)"bos_org") ? "\u7ec4\u7ec7" : "\u95e8\u5e97";
        Label title = (Label)this.getView().getControl("title");
        title.setText(text);
    }

    private void synchronousData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        List dimensionIds = (List)parameter.getCustomParam("dimension");
        List srcParams = JSONObject.parseArray((String)((String)parameter.getCustomParam("param")), PosEntity.class);
        if (!CollectionUtils.isEmpty((Collection)dimensionIds) && !CollectionUtils.isEmpty((Collection)srcParams)) {
            ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
            progressBar.start();
            this.getPageCache().put("startprogress", "1");
            try (TXHandle handle = TX.requiresNew();){
                try {
                    String type = (String)parameter.getCustomParam("type");
                    Object srcOrgId = parameter.getCustomParam("org");
                    this.beginSynchronousData(progressBar, type, srcOrgId, dimensionIds, srcParams);
                    this.afterSynchronousData(progressBar);
                }
                catch (Exception ex) {
                    NotificationUtil.showErrorNotification((String)ex.getMessage(), (IFormView)this.getView());
                    handle.markRollback();
                    LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u540c\u6b65\u5931\u8d25\uff0c \u539f\u56e0\uff1a" + ex.getMessage());
                    progressBar.setPercent(100, "\u540c\u6b65\u5931\u8d25");
                    progressBar.stop();
                    this.getPageCache().put("startprogress", "0");
                }
            }
        }
    }

    private void beginSynchronousData(ProgressBar progressBar, String type, Object srcOrgId, List<Object> dimensionIds, List<PosEntity> srcParams) {
        progressBar.setPercent(0);
        List<JSONObject> sysParams = this.getSysParams(progressBar, type, srcOrgId, dimensionIds, srcParams);
        progressBar.setPercent(60, "\u6570\u636e\u540c\u6b65\u4e2d...");
        String srcParamsData = (String)this.getView().getFormShowParameter().getCustomParam("ocpos_store_sysparam");
        List entities = JSONObject.parseArray((String)srcParamsData, PosEntity.class);
        this.synchronousKeyValues(progressBar, sysParams, entities);
    }

    private void afterSynchronousData(ProgressBar progressBar) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"btnok", "btncancel"});
        progressBar.setPercent(100, "\u540c\u6b65\u6210\u529f");
        progressBar.stop();
        this.getPageCache().put("startprogress", "0");
    }

    private void replaceParamsData(JSONObject keyAndDefValue, List<PosEntity> srcParams, long pkId, Object orgId, Object branchId) {
        keyAndDefValue.put("id", (Object)pkId);
        keyAndDefValue.put("org", orgId);
        keyAndDefValue.put("branch", branchId);
        this.replaceParamsData(keyAndDefValue, srcParams);
    }

    private void replaceParamsData(JSONObject keyAndDefValue, List<PosEntity> srcParams) {
        for (PosEntity srcParam : srcParams) {
            String key = srcParam.getKey();
            if (!keyAndDefValue.containsKey((Object)key)) continue;
            keyAndDefValue.put(key, srcParam.getValue());
        }
    }

    private List<JSONObject> getSysParams(ProgressBar progressBar, String type, Object srcOrgId, List<Object> dimensionIds, List<PosEntity> srcParams) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
            return this.getOrgSysParams(progressBar, type, srcOrgId, dimensionIds, srcParams);
        }
        return this.getBranchSysParams(progressBar, type, srcOrgId, dimensionIds, srcParams);
    }

    private List<JSONObject> getOrgSysParams(ProgressBar progressBar, String type, Object srcOrgId, List<Object> dimensionIds, List<PosEntity> srcParams) {
        List<JSONObject> paramsFromDb = this.getSysParamsFromDb(type, srcOrgId, dimensionIds);
        JSONObject keyAndDefValue = DbUtil.getKeyAndDefValue((String)"ocpos_store_sysparam");
        progressBar.setPercent(20, "\u6570\u636e\u540c\u6b65\u4e2d...");
        if (CollectionUtils.isEmpty(paramsFromDb)) {
            progressBar.setPercent(40, "\u6570\u636e\u540c\u6b65\u4e2d...");
            return this.createNewParams(type, srcOrgId, dimensionIds, srcParams, keyAndDefValue);
        }
        int size = paramsFromDb.size();
        ArrayList<Long> intersection = new ArrayList<Long>(size);
        ArrayList<JSONObject> sysParams = new ArrayList<JSONObject>(size);
        ArrayList<Object> pkIds = new ArrayList<Object>(size);
        for (JSONObject item : paramsFromDb) {
            pkIds.add(item.get((Object)"id"));
            intersection.add(item.getLongValue("org"));
            this.replaceParamsData(item, srcParams);
            sysParams.add(item);
        }
        this.updateParams(srcParams, pkIds);
        progressBar.setPercent(40, "\u6570\u636e\u540c\u6b65\u4e2d...");
        List<Object> notIntersection = dimensionIds.stream().filter(x -> !intersection.contains(CommonUtil.formatObejctToLong((Object)x))).collect(Collectors.toList());
        List<JSONObject> newParams = this.createNewParams(type, srcOrgId, notIntersection, srcParams, keyAndDefValue);
        sysParams.addAll(newParams);
        return sysParams;
    }

    private List<JSONObject> getBranchSysParams(ProgressBar progressBar, String type, Object srcOrgId, List<Object> dimensionIds, List<PosEntity> srcParams) {
        List<JSONObject> paramsFromDb = this.getSysParamsFromDb(type, srcOrgId, dimensionIds);
        if (CollectionUtils.isEmpty(paramsFromDb)) {
            progressBar.setPercent(20, "\u6570\u636e\u540c\u6b65\u4e2d...");
            JSONObject keyAndDefValue = DbUtil.getKeyAndDefValue((String)"ocpos_store_sysparam");
            progressBar.setPercent(40, "\u6570\u636e\u540c\u6b65\u4e2d...");
            return this.createNewParams(type, srcOrgId, dimensionIds, srcParams, keyAndDefValue);
        }
        JSONObject keyAndDefValue = paramsFromDb.stream().filter(x -> x.getLongValue("branch") == 0L).findFirst().orElse(null);
        progressBar.setPercent(20, "\u6570\u636e\u540c\u6b65\u4e2d...");
        if (keyAndDefValue == null) {
            keyAndDefValue = DbUtil.getKeyAndDefValue((String)"ocpos_store_sysparam");
        }
        int size = paramsFromDb.size();
        ArrayList<Long> intersection = new ArrayList<Long>(size);
        ArrayList<JSONObject> sysParams = new ArrayList<JSONObject>(size);
        ArrayList<Object> pkIds = new ArrayList<Object>(size);
        for (JSONObject item : paramsFromDb) {
            long branchId = item.getLongValue("branch");
            if (branchId == 0L) continue;
            pkIds.add(item.get((Object)"id"));
            intersection.add(branchId);
            this.replaceParamsData(item, srcParams);
            sysParams.add(item);
        }
        this.updateParams(srcParams, pkIds);
        progressBar.setPercent(40, "\u6570\u636e\u540c\u6b65\u4e2d...");
        List<Object> notIntersection = dimensionIds.stream().filter(x -> !intersection.contains(CommonUtil.formatObejctToLong((Object)x))).collect(Collectors.toList());
        List<JSONObject> newParams = this.createNewParams(type, srcOrgId, notIntersection, srcParams, keyAndDefValue);
        sysParams.addAll(newParams);
        return sysParams;
    }

    private List<JSONObject> getSysParamsFromDb(String type, Object srcOrgId, List<Object> dimensionIds) {
        QFilter filter;
        if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
            filter = new QFilter("org", "in", dimensionIds);
        } else {
            filter = new QFilter("org", "=", srcOrgId);
            filter.and("branch", "in", dimensionIds);
        }
        return DbUtil.getDataFromDb((String)"SysParams", (String)"ocpos_store_sysparam", (QFilter)filter);
    }

    private List<JSONObject> createNewParams(String type, Object srcOrgId, List<Object> dimensionIds, List<PosEntity> srcParams, JSONObject keyAndDefValue) {
        if (CollectionUtils.isEmpty(dimensionIds)) {
            return new ArrayList<JSONObject>(0);
        }
        int size = dimensionIds.size();
        long[] pkIds = DB.genLongIds((String)"t_ocpos_sysparam", (int)size);
        ArrayList<JSONObject> params = new ArrayList<JSONObject>(size);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
            this.replaceParamsData(keyAndDefValue, srcParams, pkIds[0], dimensionIds.get(0), 0L);
        } else {
            this.replaceParamsData(keyAndDefValue, srcParams, pkIds[0], srcOrgId, dimensionIds.get(0));
        }
        params.add(keyAndDefValue);
        ArrayList<DynamicObject> sysParams = new ArrayList<DynamicObject>(size);
        DynamicObject sysParam = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_store_sysparam");
        for (Map.Entry entry : keyAndDefValue.entrySet()) {
            String key = (String)entry.getKey();
            if (!DynamicObjectUtils.contain((DynamicObject)sysParam, (String)key)) continue;
            sysParam.set(key, entry.getValue());
        }
        sysParams.add(sysParam);
        for (int i = 1; i < size; ++i) {
            if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
                this.replaceParamsData(keyAndDefValue, srcParams, pkIds[i], dimensionIds.get(i), 0L);
            } else {
                this.replaceParamsData(keyAndDefValue, srcParams, pkIds[i], srcOrgId, dimensionIds.get(i));
            }
            params.add(keyAndDefValue);
            sysParam = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_store_sysparam");
            for (Map.Entry entry : keyAndDefValue.entrySet()) {
                String key = (String)entry.getKey();
                if (!DynamicObjectUtils.contain((DynamicObject)sysParam, (String)key)) continue;
                sysParam.set(key, entry.getValue());
            }
            sysParams.add(sysParam);
        }
        if (!CollectionUtils.isEmpty(sysParams)) {
            SaveServiceHelper.save((DynamicObject[])sysParams.toArray(new DynamicObject[0]));
        }
        return params;
    }

    private void updateParams(List<PosEntity> srcParams, List<Object> pkIds) {
        if (CollectionUtils.isEmpty(pkIds)) {
            return;
        }
        Map<String, List<PosEntity>> data = srcParams.stream().collect(Collectors.groupingBy(PosEntity::getGroup));
        for (Map.Entry<String, List<PosEntity>> entry : data.entrySet()) {
            String group = entry.getKey();
            String tableName = "t_ocpos_sysparam";
            if (StringUtils.isNotBlank((CharSequence)group)) {
                tableName = tableName + "_" + group;
            }
            StringBuilder sql = new StringBuilder(String.format("update %s set ", tableName));
            List<PosEntity> entities = entry.getValue();
            int count = 1;
            int size = entities.size();
            ArrayList<Object> params = new ArrayList<Object>(size);
            for (PosEntity entity : entities) {
                String alias = entity.getAlias();
                if (count < size) {
                    sql.append(String.format("%s = ?, ", alias));
                } else {
                    sql.append(String.format("%s = ? ", alias));
                }
                ++count;
                Object value = entity.getValue();
                params.add(value);
            }
            sql.append(String.format("where fid in (%s)", StringUtils.join((Object[])pkIds.toArray(), (String)",")));
            this.DBSqlUpdate(DbUtil.OCC_DB, sql.toString(), params.toArray());
        }
    }

    private void synchronousKeyValues(ProgressBar progressBar, List<JSONObject> sysParams, List<PosEntity> entities) {
        if (CollectionUtils.isEmpty(sysParams)) {
            return;
        }
        int size = sysParams.size();
        int count = sysParams.get(0).size();
        int total = count * size;
        long[] pkIds = DB.genLongIds((String)"t_ocpos_sysparams", (int)total);
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(size);
        ArrayList<Object[]> createParams = new ArrayList<Object[]>(size);
        int index = 0;
        for (JSONObject sysParam : sysParams) {
            Object orgId = sysParam.get((Object)"forgid");
            Object branchId = sysParam.get((Object)"fbranchid");
            ArrayList<Object> deleteParam = new ArrayList<Object>(2);
            deleteParam.add(orgId);
            deleteParam.add(branchId);
            deleteParams.add(deleteParam.toArray());
            for (Map.Entry entry : sysParam.entrySet()) {
                PosEntity posEntity;
                String alias = (String)entry.getKey();
                if (StringUtils.equals((CharSequence)alias, (CharSequence)"fid") || StringUtils.equals((CharSequence)alias, (CharSequence)"forgid") || StringUtils.equals((CharSequence)alias, (CharSequence)"fbranchid") || (posEntity = this.getPosEntity(alias, entities)) == null) continue;
                ArrayList<Object> createParam = new ArrayList<Object>(8);
                long pkId = pkIds[index];
                createParam.add(pkId);
                createParam.add(orgId);
                createParam.add(branchId);
                createParam.add("ocpos_store_sysparam");
                createParam.add(posEntity.getKey());
                createParam.add(entry.getValue());
                createParam.add(posEntity.getName());
                createParam.add(TimeServiceHelper.now());
                createParams.add(createParam.toArray());
                ++index;
            }
        }
        progressBar.setPercent(80, "\u6570\u636e\u540c\u6b65\u4e2d...");
        this.deleteOldKeyValues(deleteParams);
        this.createNewKeyValues(createParams);
    }

    private void deleteOldKeyValues(List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String sql = "delete from t_ocpos_sysparams where forgid = ? and fbranchId = ?";
        DB.executeBatch((DBRoute)DbUtil.OCC_DB, (String)sql, params);
    }

    private void createNewKeyValues(List<Object[]> params) {
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        String sql = "insert into t_ocpos_sysparams (fid, forgid, fbranchid, fcategory, fkey, fvalue, fdescription, fmodifytime) values (?, ?, ?, ?, ?, ?, ?, ?);";
        DB.executeBatch((DBRoute)DbUtil.OCC_DB, (String)sql, params);
    }

    private PosEntity getPosEntity(String alias, List<PosEntity> entities) {
        return entities.stream().filter(x -> StringUtils.equals((CharSequence)x.getAlias(), (CharSequence)alias)).findFirst().orElse(null);
    }

    private void DBSqlUpdate(DBRoute route, String sql, Object[] params) {
        DB.update((DBRoute)route, (String)sql, (Object[])params);
    }
}

