/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.system.param;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.entity.pos.PosEntity;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.DbUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class StoreSysParamEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(StoreSysParamEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
        boolean isSaleOrg = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"03");
        if (isSaleOrg) {
            long branchId = 0L;
            JSONObject channel = this.getChannel(orgId);
            List ownerIds = OwnerUtil.getOwnerIds((String[])new String[0]);
            if (!CollectionUtils.isEmpty((Map)channel)) {
                branchId = channel.getLongValue("branch");
            }
            if (!ownerIds.contains(branchId)) {
                branchId = 0L;
            }
            long pkId = this.getPkId(orgId, branchId);
            this.reLoadPage(pkId);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{"org"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit branchEdit = (BasedataEdit)this.getView().getControl("branch");
        branchEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit olStoreDefSalerEdit = (BasedataEdit)this.getView().getControl("olstoredefaultsaler");
        olStoreDefSalerEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet == null || changeSet.length <= 0) {
            return;
        }
        if (CommonUtil.checkChanged((ChangeData)changeSet[0])) {
            return;
        }
        if (StringUtils.equals((CharSequence)"branch", (CharSequence)e.getProperty().getName())) {
            this.branchChanged(changeSet[0]);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        switch (e.getProperty().getName()) {
            case "org": {
                this.setOrgFilter(e);
                break;
            }
            case "branch": {
                this.setBranchFilter(e);
                break;
            }
            case "olstoredefaultsaler": {
                this.setOlStoreDefSalerFilter(e);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"org");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"branch");
        List<PosEntity> entities = this.getSysParamEntities(dataEntity);
        switch (e.getOperateKey()) {
            case "syndatafororg": {
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)"ocpos_store_sysparam", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                if (saveResult != null && saveResult.isSuccess()) {
                    this.synchronousKeyValues(orgId, branchId, entities);
                    this.synchronousData("bos_org", orgId, branchId, entities);
                    break;
                }
                this.getView().showOperationResult(saveResult);
                break;
            }
            case "syndataforbranch": {
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)"ocpos_store_sysparam", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
                if (saveResult != null && saveResult.isSuccess()) {
                    this.synchronousKeyValues(orgId, branchId, entities);
                    this.synchronousData("ocdbd_channel", orgId, branchId, entities);
                    break;
                }
                this.getView().showOperationResult(saveResult);
                break;
            }
            case "save": {
                OperationResult saveResult = e.getOperationResult();
                if (saveResult != null && saveResult.isSuccess()) {
                    this.synchronousKeyValues(orgId, branchId, entities);
                    break;
                }
                this.getView().showOperationResult(saveResult);
                break;
            }
        }
    }

    private void branchChanged(ChangeData changeData) {
        DynamicObject branch = (DynamicObject)changeData.getNewValue();
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)org);
        long pkId = this.getPkId(orgId, branchId);
        this.reLoadPage(pkId);
    }

    private void setOrgFilter(BeforeF7SelectEvent e) {
        BasedataProp property = (BasedataProp)this.getModel().getDataEntityType().getProperty("org");
        QFilter filter = PermissionFilterUtil.getMainOrgFilter((BasedataProp)property, (String)"ocpos_store_sysparam", (String)"ocpos");
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void setBranchFilter(BeforeF7SelectEvent e) {
        QFilter filter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            filter = new QFilter("saleorg", "=", org.getPkValue());
            filter.and("id", "in", (Object)OwnerUtil.getOwnerIds((String[])new String[0]));
        } else {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (IFormView)this.getView());
            filter = F7Utils.getEveFalseFilter();
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void setOlStoreDefSalerFilter(BeforeF7SelectEvent e) {
        QFilter filter;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            filter = F7Utils.getEveFalseFilter();
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u5f55\u5165\u9500\u552e\u7ec4\u7ec7\u3002", (IFormView)this.getView());
        } else {
            DynamicObject branch = (DynamicObject)this.getModel().getValue("branch");
            if (branch == null) {
                filter = new QFilter("owner.saleorg", "=", org.getPkValue());
                filter.and("owner.enable", "=", (Object)"1");
                filter.and("owner.status", "=", (Object)"C");
                filter.and("owner.isstore", "=", (Object)Boolean.TRUE);
            } else {
                filter = new QFilter("owner", "=", branch.getPkValue());
            }
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
    }

    private void reLoadPage(Object pkId) {
        if (!QueryServiceHelper.exists((String)"ocpos_store_sysparam", (Object)pkId)) {
            throw new KDBizException("\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86\u3002");
        }
        BillModel model = (BillModel)this.getModel();
        model.setPKValue(pkId);
        model.load(pkId);
        this.getView().updateView();
    }

    private void createNewParam(JSONObject newParam) {
        DynamicObject newSysParam = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_store_sysparam");
        for (Map.Entry entry : newParam.entrySet()) {
            String key = (String)entry.getKey();
            if (!DynamicObjectUtils.contain((DynamicObject)newSysParam, (String)key)) continue;
            newSysParam.set(key, entry.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newSysParam});
    }

    private void synchronousKeyValues(long orgId, long branchId, List<PosEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                this.deleteOldKeyValues(orgId, branchId);
                this.createNemKeyValues(orgId, branchId, entities);
            }
            catch (Exception ex) {
                handle.markRollback();
                LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u540c\u6b65keyValue\u8868\u5f02\u5e38\uff1a" + ex.getMessage());
            }
        }
    }

    private void synchronousData(String type, long orgId, long branchId, List<PosEntity> entities) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("type", type);
        customParams.put("ocpos_store_sysparam", JSONObject.toJSONString(entities));
        customParams.put("org", orgId);
        customParams.put("branch", branchId);
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"\u540c\u6b65\u6570\u636e", (String)"ocpos_synchronousdata", (ShowType)ShowType.Modal, (OperationStatus)OperationStatus.ADDNEW, customParams);
        this.getView().showForm(parameter);
    }

    private void deleteOldKeyValues(long orgId, long branchId) {
        String sql = "delete from t_ocpos_sysparams where forgid = ? and fbranchId = ?";
        Object[] params = new Object[]{orgId, branchId};
        DB.execute((DBRoute)DbUtil.OCC_DB, (String)sql, (Object[])params);
    }

    private void createNemKeyValues(long orgId, long branchId, List<PosEntity> entities) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(entities.size());
        String sql = "insert into t_ocpos_sysparams (fid, forgid, fbranchid, fcategory, fkey, fvalue, fdescription, fmodifytime) values (?, ?, ?, ?, ?, ?, ?, ?);";
        long[] pkIds = DB.genLongIds((String)"t_ocpos_sysparams", (int)entities.size());
        int index = 0;
        for (PosEntity entity : entities) {
            ArrayList<Object> param = new ArrayList<Object>(8);
            param.add(pkIds[index++]);
            param.add(orgId);
            param.add(branchId);
            param.add("ocpos_store_sysparam");
            param.add(entity.getKey());
            param.add(entity.getValue());
            param.add(entity.getName());
            param.add(TimeServiceHelper.now());
            params.add(param.toArray());
        }
        DB.executeBatch((DBRoute)DbUtil.OCC_DB, (String)sql, params);
    }

    private long getPkId(long orgId, long branchId) {
        long pkId = 0L;
        List<JSONObject> sysParamsFormDb = this.getSysParamsFormDb(orgId);
        LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570sysParamsFormDb\uff1a" + JSONObject.toJSONString(sysParamsFormDb));
        if (!CollectionUtils.isEmpty(sysParamsFormDb)) {
            if (branchId > 0L) {
                pkId = sysParamsFormDb.stream().filter(p -> p.getLongValue("branch") == branchId).map(q -> q.getLongValue("id")).findFirst().orElse(0L);
                LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u7ec4\u7ec7id\uff1a" + orgId + ",\u95e8\u5e97id\uff1a" + branchId + ",\u73b0\u6709pkid\uff1a" + pkId);
                if (pkId == 0L) {
                    JSONObject orgParam = sysParamsFormDb.stream().filter(x -> x.getLongValue("branch") == 0L).findFirst().orElse(null);
                    pkId = this.getBranchSysParamIdByOrg(orgParam, branchId);
                }
            } else {
                pkId = sysParamsFormDb.stream().filter(p -> p.getLongValue("branch") == 0L).map(q -> q.getLongValue("id")).findFirst().orElse(0L);
                LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u7ec4\u7ec7id\uff1a" + orgId + ",\u73b0\u6709pkid\uff1a" + pkId);
            }
        }
        if (pkId == 0L) {
            pkId = this.getDefSysParamPkId(orgId, branchId);
        }
        return pkId;
    }

    private long getDefSysParamPkId(long orgId, long branchId) {
        JSONObject aliasAndDefValue = DbUtil.getKeyAndDefValue((String)"ocpos_store_sysparam");
        try {
            long pkId = DB.genLongId((String)"t_ocpos_sysparam");
            LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u7ec4\u7ec7id\uff1a" + orgId + ",\u95e8\u5e97id\uff1a" + branchId + ",\u65b0\u589epkid(\u7f3a\u7701)\uff1a" + pkId);
            aliasAndDefValue.put("id", (Object)pkId);
            aliasAndDefValue.put("org", (Object)orgId);
            aliasAndDefValue.put("branch", (Object)branchId);
            this.createNewParam(aliasAndDefValue);
            return pkId;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private long getBranchSysParamIdByOrg(JSONObject orgParam, long branchId) {
        try {
            if (orgParam == null) {
                return 0L;
            }
            long pkId = DB.genLongId((String)"t_ocpos_sysparam");
            LOG.info("\u95e8\u5e97\u7cfb\u7edf\u53c2\u6570\u95e8\u5e97id\uff1a" + branchId + ",\u65b0\u589epkid\uff1a" + pkId);
            orgParam.put("id", (Object)pkId);
            orgParam.put("branch", (Object)branchId);
            this.createNewParam(orgParam);
            return pkId;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private JSONObject getChannel(long orgId) {
        Object[] params = new Object[]{orgId};
        String sql = "select tc.fid as id, tc.fsaleorgid as saleorg from t_ocdbd_channel tc inner join t_ocdbd_channel_x tcx on tcx.fid = tc.fid where tc.fenable = '1' and tc.fstatus = 'C' and tc.fisstore = '1' and tcx.fisdefaultstore = '1' and tc.fsaleorgid = ?";
        return (JSONObject)DB.query((DBRoute)DbUtil.OCC_DB, (String)sql, (Object[])params, rh -> {
            JSONObject data = new JSONObject();
            if (rh.next()) {
                data.put("branch", (Object)rh.getLong("id"));
                data.put("org", (Object)rh.getLong("saleorg"));
            }
            return data;
        });
    }

    private List<JSONObject> getSysParamsFormDb(long orgId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        return DbUtil.getDataFromDb((String)"SysParams_Org", (String)"ocpos_store_sysparam", (QFilter)filter);
    }

    private List<PosEntity> getSysParamEntities(DynamicObject dataEntity) {
        ArrayList<PosEntity> entities = new ArrayList<PosEntity>();
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String alias;
            String key = property.getName();
            if (key.contains("_id") || StringUtils.equals((CharSequence)key, (CharSequence)"id") || StringUtils.equals((CharSequence)key, (CharSequence)"org") || StringUtils.equals((CharSequence)key, (CharSequence)"branch") || StringUtils.isBlank((CharSequence)(alias = property.getAlias().toLowerCase()))) continue;
            String name = property.getDisplayName().getLocaleValue();
            String group = property.getTableGroup();
            group = group == null ? "" : group;
            JSONObject value = CommonUtils.getValue((DynamicObject)dataEntity, (IDataEntityProperty)property, (String)key, (String)"defcurrency");
            PosEntity entity = new PosEntity(key, alias, value.get((Object)"id"), value.get((Object)"name"), name, group);
            entities.add(entity);
        }
        return entities;
    }
}

