/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.formplugin.system.param;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.Tips;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.business.helper.OrgHelper;
import kd.occ.ocbase.common.entity.pos.PosEntity;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.FormShowUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.OwnerUtil;

public class SynchronousDataFormPlugin
extends AbstractFormPlugin {
    private static final String POS_IN_SYNCHRONOUS = "ocpos_insynchronous";
    protected static final String KEY_DIMENSION = "dimension";
    private static final String KEY_DIMENSION_TYPE = "dimensiontype";
    private static final String KEY_DIMENSION_ENTITY = "dimensionentity";
    private static final String KEY_D_INDEX = "d_index";
    private static final String KEY_D_TOTAL = "d_total";
    private static final String BTN_D_PREVIOUS = "d_previous";
    private static final String BTN_D_LAST = "d_last";
    protected static final String KEY_PARAM = "param";
    private static final String KEY_PARAM_ENTITY = "paramentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_D_PREVIOUS, BTN_D_LAST, "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        Object orgId = parameter.getCustomParam("org");
        Object branchId = parameter.getCustomParam("branch");
        this.fillData(type, orgId, branchId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        String text = this.getText(type);
        Label title = (Label)this.getView().getControl("title");
        title.setText(text);
        LocaleString content = this.getTipsContent(type, text);
        title.addTips(new Tips("text", null, content, false, null));
        ItemClassEdit dimensionEdit = (ItemClassEdit)this.getView().getControl(KEY_DIMENSION);
        dimensionEdit.setCaption(new LocaleString(text));
        this.setEnable();
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String type = (String)parameter.getCustomParam("type");
        Object orgId = parameter.getCustomParam("org");
        Object branchId = parameter.getCustomParam("branch");
        int dIndex = CommonUtil.formatObjectToInt((Object)this.getModel().getValue(KEY_D_INDEX));
        switch (ctrl.getKey()) {
            case "d_previous": {
                if (dIndex <= 1) break;
                int newIndex = dIndex - 1;
                this.fillDimensionData(type, orgId, branchId, newIndex);
                this.setEnable();
                break;
            }
            case "d_last": {
                int newIndex = dIndex + 1;
                this.fillDimensionData(type, orgId, branchId, newIndex);
                this.setEnable();
                break;
            }
            case "btnok": {
                String srcParamsData = (String)parameter.getCustomParam("ocpos_store_sysparam");
                Map<String, Object> customParams = this.getCustomParams(type, orgId, branchId, srcParamsData);
                this.synchronousData(parameter, type, customParams);
                break;
            }
        }
    }

    private void fillData(String type, Object orgId, Object branchId) {
        this.fillDimensionData(type, orgId, branchId, 0, 100, true);
        this.fillParamData();
    }

    private void fillDimensionData(String type, Object orgId, Object branchId, int index) {
        this.getModel().setValue(KEY_D_INDEX, (Object)index);
        int start = (index - 1) * 100;
        int end = index * 100;
        this.fillDimensionData(type, orgId, branchId, start, end, false);
    }

    private void fillDimensionData(String type, Object orgId, Object branchId, int start, int end, boolean isNew) {
        int[] indexes;
        List<Long> dimensionData = this.getDimensionData(type, orgId, branchId, start, end, isNew);
        if (CollectionUtils.isEmpty(dimensionData)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(KEY_DIMENSION_ENTITY);
        for (int index : indexes = this.getModel().batchCreateNewEntryRow(KEY_DIMENSION_ENTITY, dimensionData.size())) {
            this.getModel().setValue(KEY_DIMENSION_TYPE, (Object)type, index);
            this.getModel().setItemValueByID(KEY_DIMENSION, (Object)dimensionData.get(index), index);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_DIMENSION_ENTITY);
    }

    private void fillParamData() {
        String srcParamsData = (String)this.getView().getFormShowParameter().getCustomParam("ocpos_store_sysparam");
        List entities = JSONObject.parseArray((String)srcParamsData, PosEntity.class);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData(KEY_PARAM_ENTITY);
        int[] indexes = this.getModel().batchCreateNewEntryRow(KEY_PARAM_ENTITY, entities.size());
        int deleteIndex = 0;
        boolean isNeedDelete = false;
        for (int index : indexes) {
            PosEntity entity = (PosEntity)entities.get(index);
            String key = entity.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"defcurrency")) {
                isNeedDelete = true;
                deleteIndex = index;
                continue;
            }
            this.getModel().setValue("key", (Object)key, index);
            this.getModel().setValue("number", (Object)entity.getName(), index);
            this.getModel().setValue("name", entity.getDisplayValue(), index);
            this.getModel().setValue("alias", (Object)entity.getAlias(), index);
            this.getModel().setValue("group", (Object)entity.getGroup(), index);
        }
        if (isNeedDelete) {
            this.getModel().deleteEntryRow(KEY_PARAM_ENTITY, deleteIndex);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_PARAM_ENTITY);
    }

    private void setDimensionTotalCount(DBRoute route, String sqlFormat, Object[] params) {
        String sql = String.format(sqlFormat, "count(1) as d_total");
        int totalCount = (Integer)DB.query((DBRoute)route, (String)sql, (Object[])params, rh -> {
            int count = 0;
            if (rh.next()) {
                count = rh.getInt(KEY_D_TOTAL);
            }
            return count;
        });
        int totalPage = CommonUtil.formatObjectToInt((Object)Math.ceil((double)totalCount / 100.0));
        if (totalPage == 0) {
            totalPage = 1;
        }
        this.getModel().setValue(KEY_D_TOTAL, (Object)totalPage);
    }

    private void setEnable() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        int dIndex = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)KEY_D_INDEX);
        int dTotal = DynamicObjectUtils.getInt((DynamicObject)dataEntity, (String)KEY_D_TOTAL);
        if (dIndex == 1) {
            if (dTotal != 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_D_PREVIOUS});
                this.getView().setEnable(Boolean.TRUE, new String[]{BTN_D_LAST});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_D_PREVIOUS, BTN_D_LAST});
            }
        } else if (dIndex == dTotal) {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_D_PREVIOUS});
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_D_LAST});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_D_PREVIOUS, BTN_D_LAST});
        }
    }

    private void synchronousData(FormShowParameter showParameter, String type, Map<String, Object> customParams) {
        EntryGrid dimensionGrid = (EntryGrid)this.getView().getControl(KEY_DIMENSION_ENTITY);
        int[] dimensionSelectRows = dimensionGrid.getSelectRows();
        if (dimensionSelectRows == null || dimensionSelectRows.length <= 0) {
            String dimensionType = StringUtils.equals((CharSequence)type, (CharSequence)"bos_org") ? "\u9500\u552e\u7ec4\u7ec7" : "\u95e8\u5e97";
            NotificationUtil.showDefaultTipNotify((String)String.format("\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684%s\u3002", dimensionType), (IFormView)this.getView());
            return;
        }
        EntryGrid paramGrid = (EntryGrid)this.getView().getControl(KEY_PARAM_ENTITY);
        int[] selectRows = paramGrid.getSelectRows();
        if (selectRows == null || selectRows.length <= 0) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u7684\u53c2\u6570\u3002", (IFormView)this.getView());
            return;
        }
        ArrayList<Long> dimensionIds = new ArrayList<Long>(dimensionSelectRows.length);
        for (int row : dimensionSelectRows) {
            DynamicObject dimension = (DynamicObject)this.getModel().getValue(KEY_DIMENSION, row);
            dimensionIds.add(DynamicObjectUtils.getPkValue((DynamicObject)dimension));
        }
        String srcParamsData = (String)this.getView().getFormShowParameter().getCustomParam("ocpos_store_sysparam");
        List entities = JSONObject.parseArray((String)srcParamsData, PosEntity.class);
        ArrayList<PosEntity> srcParams = new ArrayList<PosEntity>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject paramEntity = this.getModel().getEntryRowEntity(KEY_PARAM_ENTITY, selectRow);
            String key = DynamicObjectUtils.getString((DynamicObject)paramEntity, (String)"key");
            PosEntity srcParam = this.getPosEntity(key, entities);
            srcParams.add(srcParam);
        }
        customParams.put(KEY_DIMENSION, dimensionIds);
        customParams.put(KEY_PARAM, JSONObject.toJSONString(srcParams));
        FormShowParameter parameter = FormShowUtils.openNewForm((String)"", (String)POS_IN_SYNCHRONOUS, (ShowType)ShowType.InCurrentForm, (OperationStatus)OperationStatus.ADDNEW, customParams);
        parameter.setParentPageId(showParameter.getParentPageId());
        this.getView().showForm(parameter);
    }

    private List<Long> getDimensionData(String type, Object orgId, Object branchId, int start, int end, boolean isNew) {
        if (StringUtils.equals((CharSequence)type, (CharSequence)"bos_org")) {
            return this.getOrgData(orgId, start, end, isNew);
        }
        return this.getBranchData(orgId, branchId, start, end, isNew);
    }

    private List<Long> getOrgData(Object orgId, int start, int end, boolean isNew) {
        List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)"ocpos_store_sysparam", (String)OrgHelper.getOrgViewType());
        hasPermissionOrg.removeIf(next -> 9999999999999L == next);
        return hasPermissionOrg;
    }

    private List<Long> getBranchData(Object orgId, Object branchId, int start, int end, boolean isNew) {
        return OwnerUtil.getOwnerIds((String[])new String[0]);
    }

    private LocaleString getTipsContent(String type, String text) {
        String content = StringUtils.equals((CharSequence)type, (CharSequence)"bos_org") ? String.format("\u4e2a%s", text) : String.format("\u5bb6%s", text);
        return new LocaleString(String.format("\u4e00\u6b21\u6700\u591a\u4ec5\u80fd\u540c\u6b65100%s\u3002", content));
    }

    private Map<String, Object> getCustomParams(String type, Object orgId, Object branchId, String srcParamData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("type", type);
        customParams.put("org", orgId);
        customParams.put("branch", branchId);
        customParams.put("ocpos_store_sysparam", srcParamData);
        return customParams;
    }

    private String getText(String type) {
        ItemClassTypeEdit typeEdit = (ItemClassTypeEdit)this.getView().getControl(KEY_DIMENSION_TYPE);
        List comboItems = ((ItemClassTypeProp)typeEdit.getProperty()).getComboItems();
        if (CollectionUtils.isEmpty((Collection)comboItems)) {
            return "";
        }
        return comboItems.stream().filter(x -> StringUtils.equals((CharSequence)x.getValue(), (CharSequence)type)).map(x -> x.getName().getLocaleValue()).findFirst().orElse("");
    }

    private String getOrgSqlFormat() {
        return "select %s from t_org_structure ts inner join t_org_org too on too.fid = ts.forgid and too.fenable = '1' inner join t_org_viewschema tv on tv.fid = ts.fviewid and tv.fnumber = '03' where ts.forgid <> ? and ts.fisfreeze = '0'";
    }

    private String getBranchSqlFormat() {
        return "select %s from t_ocdbd_channel where fenable = '1' and fstatus = 'C' and fisstore = '1' and fsaleorgid = ? and fid <> ?";
    }

    private PosEntity getPosEntity(String key, List<PosEntity> entities) {
        return entities.stream().filter(x -> StringUtils.equals((CharSequence)x.getKey(), (CharSequence)key)).findFirst().orElse(null);
    }
}

