/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.formplugin.point;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileUtils;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocdbd.common.result.OcdbdResultCode;
import kd.occ.ocric.business.point.PointRightsServiceHelper;
import kd.occ.ocric.business.point.vo.UpdatePointVO;
import kd.occ.ocric.common.enums.PointRightsResultEnum;
import org.apache.commons.lang.StringUtils;

public class PointInitImportPlugin
extends BatchImportPlugin {
    private static final String CHINA_MOBILE_CODE = "+86";

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        ArrayList<UpdatePointVO> pointVoList = new ArrayList<UpdatePointVO>();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            JSONObject dataObject = data.getData();
            String validMsg = this.Checkdata(dataObject, pointVoList);
            if (!StringUtils.isNotBlank((String)validMsg)) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), validMsg).fail();
            it.remove();
        }
        ApiResult result = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                result = super.save(rowdatas, logger);
                if (result != null && result.getSuccess() && pointVoList.size() > 0) {
                    for (UpdatePointVO updatePointVO : pointVoList) {
                        PointRightsServiceHelper.increaseAvailablePoint((UpdatePointVO)updatePointVO);
                    }
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
        return result;
    }

    public String Checkdata(JSONObject data, List<UpdatePointVO> pointVoList) {
        String mobile = data.getString("mobile");
        if (!MobileUtils.isValidMobile((String)mobile)) {
            return OcdbdResultCode.REGISTER_MOBILE_IS_INVALID.getMessage();
        }
        String checkMobile = UserServiceHelper.mergeCountryCodeAndMobile((String)CHINA_MOBILE_CODE, (String)mobile);
        data.put("mobile", (Object)checkMobile);
        data.put("billno", (Object)CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)1));
        Map org = (Map)data.get((Object)"org");
        String orgNumber = (String)org.get("number");
        QFilter orgFilter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject orgObject = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])orgFilter.toArray());
        if (orgObject == null) {
            return OcdbdResultCode.NOT_ORG.getMessage();
        }
        Long orgId = (Long)orgObject.getPkValue();
        QFilter qFilter = new QFilter("memberid.mobile", "=", (Object)checkMobile);
        qFilter.and("memberid.org", "=", (Object)orgId);
        qFilter.and("typeid", "=", (Object)965136725867305984L);
        DynamicObject ricaccount = BusinessDataServiceHelper.loadSingle((String)"ocdbd_ricaccount", (String)"id,memberid,typeid", (QFilter[])qFilter.toArray());
        if (ricaccount == null) {
            return PointRightsResultEnum.ERROR_EXIST_MOBILE.getMessage();
        }
        UpdatePointVO ponitVo = new UpdatePointVO();
        String message = this.setPonit(ponitVo, data, ricaccount, orgId);
        if (StringUtils.isBlank((String)message)) {
            pointVoList.add(ponitVo);
        }
        return message;
    }

    private String setPonit(UpdatePointVO ponitVo, JSONObject data, DynamicObject ricaccount, Long orgId) {
        int qty = Integer.parseInt(data.getString("qty"));
        ponitVo.setMemberId(((Long)ricaccount.getDynamicObject("memberid").getPkValue()).longValue());
        ponitVo.setTransactionTime(DateUtil.getDateTimeFormat((Date)new Date()));
        Map pointbiztype = (Map)data.get((Object)"pointbiztype");
        String biztypeNumber = (String)pointbiztype.get("number");
        QFilter biztypeFilter = new QFilter("number", "=", (Object)biztypeNumber);
        DynamicObject pointbiztypeObject = BusinessDataServiceHelper.loadSingle((String)"ocdbd_mpointbiztype", (String)"id", (QFilter[])biztypeFilter.toArray());
        if (pointbiztypeObject == null) {
            return PointRightsResultEnum.NOT_EXIST_BIZTYPE.getMessage();
        }
        Long pointBizTypeId = (Long)pointbiztypeObject.getPkValue();
        ponitVo.setPointBizTypeId(pointBizTypeId.longValue());
        Map pointtype = (Map)data.get((Object)"pointtype");
        String typeNumber = (String)pointtype.get("number");
        QFilter pointtypeFilter = new QFilter("number", "=", (Object)typeNumber);
        DynamicObject pointtypeObject = BusinessDataServiceHelper.loadSingle((String)"ocdbd_mpointtype", (String)"id", (QFilter[])pointtypeFilter.toArray());
        if (pointtypeObject == null) {
            return PointRightsResultEnum.NOT_EXIST_POINTTYPE.getMessage();
        }
        Long pointtypeId = (Long)pointtypeObject.getPkValue();
        HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>();
        pointMap.put(pointtypeId, qty);
        ponitVo.setPointMap(pointMap);
        ponitVo.setOrgId(orgId.longValue());
        String[] billNoList = (String[])data.get((Object)"billno");
        ponitVo.setSrcNo(billNoList[0]);
        return null;
    }
}

