/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.report.point;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserIdByConditionDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserIdByConditionVO;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocdbd.business.helper.UserServiceHelper;
import kd.occ.ocric.common.enums.PointRightsResultEnum;

public class PointDetailRptForm
extends AbstractReportFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(PointDetailRptForm.class);
    public static final String PARAM_NOORPHONE = "paramnoorphone";
    public static final String PARAM_POINTTYPE = "parampointtype";
    public static final String PARAM_POINTSTATUS = "parampointstatus";
    public static final String PARAM_BEGINDATE = "parambegindate";
    public static final String PARAM_ENDDATE = "paramenddate";
    public static final String F_MEMBERID = "memberid";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        String paramnoorphone = filter.getString(PARAM_NOORPHONE);
        if (StringUtils.isBlank((CharSequence)paramnoorphone)) {
            this.getView().showTipNotification(PointRightsResultEnum.ERROR_MEMBERPHONEORNO_REQUIRED.getMessage());
            return false;
        }
        StringBuilder errorSB = new StringBuilder();
        try {
            QueryUserIdByConditionDTO dto = new QueryUserIdByConditionDTO();
            dto.setCondition(paramnoorphone);
            long orgId = RequestContext.get().getOrgId();
            dto.setOrgId(Long.valueOf(orgId));
            QueryUserIdByConditionVO vo = UserServiceHelper.queryUserIdByCondition((QueryUserIdByConditionDTO)dto);
            long memberIdParam = vo.getUserId();
            this.getModel().setValue(F_MEMBERID, (Object)memberIdParam);
            filter.addFilterItem(F_MEMBERID, (Object)memberIdParam);
        }
        catch (KDBizException e) {
            errorSB.append(e.getMessage());
            errorSB.append(':');
            errorSB.append(e.getStackTraceMessage());
            LOGGER.error(errorSB.toString());
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        catch (Exception e) {
            errorSB.append(CommonResultEnum.ERROR_UNDEFINED);
            errorSB.append(':');
            errorSB.append(e.getMessage());
            LOGGER.error(errorSB.toString());
            this.getView().showErrorNotification(errorSB.toString());
            return false;
        }
        Date beginDate = filter.getDate(PARAM_BEGINDATE);
        Date endDate = filter.getDate(PARAM_ENDDATE);
        if (beginDate != null && endDate != null && !beginDate.before(endDate)) {
            this.getModel().setValue(PARAM_BEGINDATE, null);
            this.getModel().setValue(PARAM_ENDDATE, null);
            this.getView().showTipNotification(CommonResultEnum.ERROR_DATE_RANGE.getMessage());
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        Date enddate;
        Date begindate;
        FilterInfo filter = queryParam.getFilter();
        long memberId = filter.getLong(F_MEMBERID);
        QFilter qFilter = new QFilter(F_MEMBERID, "=", (Object)memberId);
        DynamicObjectCollection parampointtype = filter.getDynamicObjectCollection(PARAM_POINTTYPE);
        if (!CollectionUtils.isEmpty((Collection)parampointtype)) {
            ArrayList<Long> pointtypeIdList = new ArrayList<Long>(parampointtype.size());
            for (DynamicObject pointtype : parampointtype) {
                Long pointtypeId = (Long)pointtype.getPkValue();
                pointtypeIdList.add(pointtypeId);
            }
            qFilter.and("pointtypeid", "in", pointtypeIdList);
        }
        String parampointstatus = filter.getString(PARAM_POINTSTATUS);
        List<String> pointstatusList = null;
        if (StringUtils.isNotBlank((CharSequence)parampointstatus)) {
            parampointstatus = parampointstatus.replace(',', ' ');
            String[] pointstatusArray = parampointstatus.trim().split(" ");
            pointstatusList = Arrays.asList(pointstatusArray);
        }
        if (!CollectionUtils.isEmpty(pointstatusList)) {
            qFilter.and("status", "in", pointstatusList);
        }
        if ((begindate = filter.getDate(PARAM_BEGINDATE)) != null) {
            qFilter.and("transactiontime", ">=", (Object)begindate);
        }
        if ((enddate = filter.getDate(PARAM_ENDDATE)) != null) {
            qFilter.and("transactiontime", "<", (Object)DateUtil.dayAdd((Date)enddate, (int)1));
        }
        filter.setQFilters(Arrays.asList(qFilter.toArray()));
        queryParam.setSortInfo("transactiontime desc");
        queryParam.setFilter(filter);
        super.beforeQuery(queryParam);
    }
}

