/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.opplugin.point;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocbase.common.util.serviceresult.ResultEnumInterface;
import kd.occ.ocbase.common.util.serviceresult.ServiceResultUtil;
import kd.occ.ocdbd.common.enums.ChangeSignEnum;
import kd.occ.ocric.business.point.PointRightsServiceHelper;
import kd.occ.ocric.business.point.vo.UpdatePointVO;

public class AdjustPointOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs arg) {
        super.beginOperationTransaction(arg);
        String key = arg.getOperationKey();
        DynamicObject[] entities = arg.getDataEntities();
        if ("audit".equals(key)) {
            if (1 != entities.length) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_NOT_ONE);
            }
            DynamicObject adjustPointInfo = entities[0];
            UpdatePointVO updatePointVO = this.turn2UpdatePointVO(adjustPointInfo);
            String adjustType = adjustPointInfo.getString("adjusttype");
            if (ChangeSignEnum.isPlus((String)adjustType)) {
                PointRightsServiceHelper.increaseAvailablePoint((UpdatePointVO)updatePointVO);
            } else {
                PointRightsServiceHelper.decreaseAvailablePoint((UpdatePointVO)updatePointVO);
            }
        }
    }

    private UpdatePointVO turn2UpdatePointVO(DynamicObject adjustPointInfo) {
        UpdatePointVO updatePointVO = new UpdatePointVO();
        updatePointVO.setMemberId(adjustPointInfo.getLong("memberid_id"));
        updatePointVO.setTransactionTime(DateUtil.getDateTimeFormat((Date)adjustPointInfo.getDate("transactiontime")));
        updatePointVO.setPointBizTypeId(1047042669186082816L);
        updatePointVO.setOrgId(adjustPointInfo.getLong("org_id"));
        long pointtypeid = adjustPointInfo.getLong("pointtypeid_id");
        int pointQty = adjustPointInfo.getInt("qty");
        HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>(1);
        pointMap.put(pointtypeid, pointQty);
        updatePointVO.setPointMap(pointMap);
        updatePointVO.setComment(adjustPointInfo.getString("comment"));
        updatePointVO.setSrcBillEntityId("ocric_adjustpoint");
        updatePointVO.setSrcNo(adjustPointInfo.getString("billno"));
        updatePointVO.setSrcBillId(((Long)adjustPointInfo.getPkValue()).longValue());
        return updatePointVO;
    }
}

