/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.opplugin.point;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocbase.common.util.serviceresult.ResultEnumInterface;
import kd.occ.ocbase.common.util.serviceresult.ServiceResultUtil;
import kd.occ.ocric.business.point.PointRightsServiceHelper;
import kd.occ.ocric.business.point.vo.UpdatePointVO;

public class GivePointOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs arg) {
        super.beginOperationTransaction(arg);
        String key = arg.getOperationKey();
        DynamicObject[] entities = arg.getDataEntities();
        if ("audit".equals(key)) {
            if (1 != entities.length) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_NOT_ONE);
            }
            DynamicObject givePointInfo = entities[0];
            UpdatePointVO updatePointVO = this.turn2UpdatePointVO(givePointInfo);
            PointRightsServiceHelper.increaseAvailablePoint((UpdatePointVO)updatePointVO);
        }
    }

    private UpdatePointVO turn2UpdatePointVO(DynamicObject givePointInfo) {
        UpdatePointVO updatePointVO = new UpdatePointVO();
        updatePointVO.setMemberId(givePointInfo.getLong("memberid_id"));
        updatePointVO.setTransactionTime(DateUtil.getDateTimeFormat((Date)givePointInfo.getDate("transactiontime")));
        updatePointVO.setPointBizTypeId(1047042432216123392L);
        updatePointVO.setOrgId(givePointInfo.getLong("org_id"));
        updatePointVO.setChannelId(givePointInfo.getLong("channelid_id"));
        DynamicObjectCollection pointentry = givePointInfo.getDynamicObjectCollection("givepointentity");
        HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>(pointentry.size());
        for (DynamicObject pointInfo : pointentry) {
            pointMap.put(pointInfo.getLong("pointtypeid_id"), pointInfo.getInt("qty"));
        }
        updatePointVO.setPointMap(pointMap);
        updatePointVO.setComment(givePointInfo.getString("comment"));
        updatePointVO.setSrcBillEntityId("ocric_givepoint");
        updatePointVO.setSrcNo(givePointInfo.getString("billno"));
        updatePointVO.setSrcBillId(((Long)givePointInfo.getPkValue()).longValue());
        updatePointVO.setTransactionAmount(givePointInfo.getBigDecimal("amount"));
        updatePointVO.setTransCurrencyId(givePointInfo.getLong("currencyid_id"));
        return updatePointVO;
    }
}

