/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.business.point;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocbase.common.util.serviceresult.ResultEnumInterface;
import kd.occ.ocbase.common.util.serviceresult.ServiceResultUtil;
import kd.occ.ocdbd.common.mempoint.PointDetailVO;
import kd.occ.ocric.business.point.vo.QueryPointDetailVO;
import kd.occ.ocric.common.constants.OcricPointDetailConst;
import kd.occ.ocric.common.enums.PointRightsResultEnum;

public class PointDetailHelper {
    public static List<PointDetailVO> queryPointDetail(QueryPointDetailVO queryPointDetailVO) {
        List<String> pointStatusList;
        if (queryPointDetailVO == null) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_PARAM_EMPTY);
        }
        long memberId = queryPointDetailVO.getMemberId();
        if (memberId == 0L) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_REQUIRED);
        }
        QFilter qFilter = new QFilter("memberid", "=", (Object)memberId);
        Date beginDate = null;
        if (StringUtils.isNotBlank((CharSequence)queryPointDetailVO.getBeginDate())) {
            beginDate = DateUtil.getDateFormat((String)queryPointDetailVO.getBeginDate());
            if (null == beginDate) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_TIME_FORMAT);
            }
            qFilter.and("transactiontime", ">=", (Object)beginDate);
        }
        Date endDate = null;
        if (StringUtils.isNotBlank((CharSequence)queryPointDetailVO.getEndDate())) {
            endDate = DateUtil.getDateFormat((String)queryPointDetailVO.getEndDate());
            if (null == endDate) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_TIME_FORMAT);
            }
            endDate = DateUtil.dayAdd((Date)endDate, (int)1);
            qFilter.and("transactiontime", "<", (Object)endDate);
        }
        if (beginDate != null && endDate != null && !beginDate.before(endDate)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.ERROR_DATE_RANGE);
        }
        List<Long> pointTypeIdList = queryPointDetailVO.getPointTypeIdList();
        if (!CollectionUtils.isEmpty(pointTypeIdList)) {
            qFilter.and("pointtypeid", "in", pointTypeIdList);
        }
        if (!CollectionUtils.isEmpty(pointStatusList = queryPointDetailVO.getPointStatusList())) {
            qFilter.and("status", "in", pointStatusList);
        }
        String orderBy = "transactiontime desc";
        int pageIndex = queryPointDetailVO.getPageIndex();
        int pageSize = queryPointDetailVO.getPageSize();
        DynamicObject[] pointDetailArray = BusinessDataServiceHelper.load((String)"ocric_pointdetail", (String)OcricPointDetailConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray(), (String)orderBy, (int)pageIndex, (int)pageSize);
        ArrayList<PointDetailVO> pointDetailVOList = new ArrayList<PointDetailVO>(pointDetailArray.length);
        for (DynamicObject pointDetail : pointDetailArray) {
            PointDetailVO pointDetailVO = PointDetailHelper.turn2PointDetailVO(pointDetail);
            pointDetailVOList.add(pointDetailVO);
        }
        return pointDetailVOList;
    }

    private static PointDetailVO turn2PointDetailVO(DynamicObject pointDetail) {
        DynamicObject currency;
        DynamicObject channel;
        DynamicObject org;
        Date expirationDate;
        DynamicObject pointtype;
        PointDetailVO pointDetailVO = new PointDetailVO();
        pointDetailVO.setBillNo(pointDetail.getString("billno"));
        DynamicObject pointbiztype = pointDetail.getDynamicObject("pointbiztypeid");
        if (pointbiztype != null) {
            pointDetailVO.setPointBizTypeId(pointbiztype.getLong("id"));
            pointDetailVO.setPointBizTypeName(pointbiztype.getString("name"));
        }
        if ((pointtype = pointDetail.getDynamicObject("pointtypeid")) != null) {
            pointDetailVO.setPointTypeId(pointtype.getLong("id"));
            pointDetailVO.setPointTypeName(pointtype.getString("name"));
        }
        pointDetailVO.setPointStatus(pointDetail.getString("status"));
        pointDetailVO.setChangeSign(pointDetail.getString("changesign"));
        pointDetailVO.setQty(pointDetail.getInt("qty"));
        Date transactionTime = pointDetail.getDate("transactiontime");
        if (transactionTime != null) {
            pointDetailVO.setTransactionTime(DateUtil.getDateTimeFormat((Date)transactionTime));
        }
        if ((expirationDate = pointDetail.getDate("expirationdate")) != null) {
            pointDetailVO.setExpirationDate(DateUtil.getDateFormat((Date)expirationDate));
        }
        if ((org = pointDetail.getDynamicObject("orgid")) != null) {
            pointDetailVO.setOrgId(org.getLong("id"));
            pointDetailVO.setOrgName(org.getString("name"));
        }
        if ((channel = pointDetail.getDynamicObject("channelid")) != null) {
            pointDetailVO.setChannelId(((Long)channel.getPkValue()).longValue());
            pointDetailVO.setChannelName(channel.getString("name"));
        }
        pointDetailVO.setSrcBillId(pointDetail.getLong("srcbillid"));
        pointDetailVO.setSrcBillNo(pointDetail.getString("srcbillno"));
        DynamicObject srcbillentity = pointDetail.getDynamicObject("srcbillentityid");
        if (srcbillentity != null) {
            pointDetailVO.setSrcBillEntityId((String)srcbillentity.getPkValue());
            pointDetailVO.setSrcBillEntityName(srcbillentity.getString("name"));
        }
        if ((currency = pointDetail.getDynamicObject("currencyid")) != null) {
            pointDetailVO.setCurrencyId(((Long)currency.getPkValue()).longValue());
            pointDetailVO.setCurrencyName(currency.getString("name"));
        }
        pointDetailVO.setAmount(pointDetail.getBigDecimal("amount"));
        pointDetailVO.setComment(pointDetail.getString("comment"));
        pointDetailVO.setCreateTime(DateUtil.getDateTimeFormat((Date)pointDetail.getDate("createtime")));
        return pointDetailVO;
    }
}

