/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.business.point;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserEnableByIdsDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserEnableByIdsVO;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocbase.common.util.serviceresult.MServiceResult;
import kd.occ.ocbase.common.util.serviceresult.ResultEnumInterface;
import kd.occ.ocbase.common.util.serviceresult.ServiceResultUtil;
import kd.occ.ocdbd.business.ricaccount.RICSystemParameterHelper;
import kd.occ.ocdbd.common.constants.mempoint.OcdbdMPointtypeConst;
import kd.occ.ocdbd.common.constants.ricaccount.OcdbdRICAccountConst;
import kd.occ.ocdbd.common.constants.ricaccount.OcdbdRICAccountTypeConst;
import kd.occ.ocdbd.common.enums.AccountResultEnum;
import kd.occ.ocdbd.common.enums.ChangeSignEnum;
import kd.occ.ocdbd.common.enums.FreezeStatusEnum;
import kd.occ.ocric.business.point.vo.UpdatePointVO;
import kd.occ.ocric.common.constants.OcricAvailablePointBatchConst;
import kd.occ.ocric.common.constants.OcricPointSavingConst;
import kd.occ.ocric.common.enums.PointRightsResultEnum;
import org.apache.commons.lang3.StringUtils;

public class PointRightsServiceHelper {
    private static final String INCREASE_AVAILABLE_POINT = "A";
    private static final String DECREASE_AVAILABLE_POINT = "B";
    private static final String FREEZE_POINT = "C";
    private static final String UNFREEZE_POINT = "D";
    private static final String DECREASE_FROZEN_POINT = "E";
    private static final String DLOCK_KEY_PREFIX = "/occ/ocric/pointRightsServiceHelper/";
    private static final int DLOCK_TIME = 5000;
    private static final String[] avlPointBatchFieldsArray = OcricAvailablePointBatchConst.getAllFieldsArray();
    private static final String[] pointSavingFieldsArray = OcricPointSavingConst.getAllFieldsArray();
    private static final long[] accountTypeIdArray = new long[]{965136315454660608L, 965136725867305984L};
    private static final String[] frozenDetailFieldsArray = new String[]{"pointtypeid", "qty", "pointbatchdetail.usedqty", "pointbatchdetail.batchdate", "pointbatchdetail.pointbatchid"};

    private static String getDlockDescription() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u79ef\u5206\u8d26\u5b58\u548c\u521b\u5efa\u79ef\u5206\u660e\u7ec6\u7684\u9501\uff0c\u7c92\u5ea6\uff1a\u4f1a\u5458ID\u3002", (String)"PointRightsServiceHelper_0", (String)"occ-ocric-business", (Object[])new Object[0]);
    }

    private static void checkMember(long memberId) {
        QueryUserEnableByIdsDTO dto = new QueryUserEnableByIdsDTO();
        dto.setUserIds(Collections.singletonList(memberId));
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserEnableByIds", (Object[])new Object[]{dto});
        MServiceResult mServiceResult = (MServiceResult)result.toJavaObject(MServiceResult.class);
        String code = mServiceResult.getCode();
        if (code.equals("0")) {
            List data = (List)mServiceResult.getData();
            for (QueryUserEnableByIdsVO object : data) {
                if (!object.isEnable()) {
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.WARN_DISABLED_MEMBER);
                }
                String userStatus = object.getUserStatus();
                if (userStatus.equals(INCREASE_AVAILABLE_POINT)) {
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.WARN_NONACTIVATED_MEMBER);
                }
                if (!userStatus.equals(FREEZE_POINT)) continue;
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.WARN_CANCELLED_MEMBER);
            }
        } else {
            throw new KDBizException(new ErrorCode(code, mServiceResult.getMessage()), new Object[0]);
        }
    }

    private static long checkAccountAndReturnPointAccountId(long memberId) throws KDBizException {
        QFilter qFilter = new QFilter("memberid", "=", (Object)memberId);
        qFilter.and("typeid", "in", (Object)accountTypeIdArray);
        DynamicObjectCollection accountColl = QueryServiceHelper.query((String)"ocdbd_ricaccount", (String)OcdbdRICAccountConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)accountColl)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)AccountResultEnum.ERROR_MAINACCOUNT_NULL);
        }
        if (accountColl.size() != 2) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)AccountResultEnum.ERROR_ACCOUNT_SET);
        }
        HashSet<Long> checkType = new HashSet<Long>(2);
        long pointAccountId = 0L;
        for (DynamicObject account : accountColl) {
            long accountTypeId = account.getLong("typeid");
            checkType.add(accountTypeId);
            String enableStatus = account.getString("enable");
            boolean disable = EnableStatusEnum.isDisable((String)enableStatus);
            if (disable && OcdbdRICAccountTypeConst.isMainAccount((Long)accountTypeId)) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)AccountResultEnum.WARN_DISABLED_MAIN_ACCOUNT);
            }
            if (disable) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)AccountResultEnum.WARN_DISABLED_RIGHTS_ACCOUNT);
            }
            if (!OcdbdRICAccountTypeConst.isPointAccount((Long)accountTypeId)) continue;
            pointAccountId = account.getLong("id");
        }
        if (checkType.size() != 2 || pointAccountId == 0L) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)AccountResultEnum.ERROR_ACCOUNT_SET);
        }
        return pointAccountId;
    }

    private static void preparationWork(UpdatePointVO updatePointVO) {
        PointRightsServiceHelper.checkUpdatePointParam(updatePointVO);
        long memberId = updatePointVO.getMemberId();
        PointRightsServiceHelper.checkMember(memberId);
        long pointAccountId = PointRightsServiceHelper.checkAccountAndReturnPointAccountId(memberId);
        updatePointVO.setPointAccountId(pointAccountId);
        PointRightsServiceHelper.checkPointType(updatePointVO.getPointMap());
    }

    private static void checkPointType(Map<Long, Integer> pointMap) {
        QFilter qFilter = new QFilter("id", "in", pointMap.keySet());
        qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection pointTypeColl = QueryServiceHelper.query((String)"ocdbd_mpointtype", (String)OcdbdMPointtypeConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
        if (pointTypeColl.size() != pointMap.size()) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_QUERYPOINTTYPE_ILLEGAL);
        }
    }

    private static DynamicObject[] findPointSaving(UpdatePointVO updatePointVO) {
        QFilter qFilter = new QFilter("memberid", "=", (Object)updatePointVO.getMemberId());
        qFilter.and("pointtypeid", "in", updatePointVO.getPointMap().keySet());
        return BusinessDataServiceHelper.load((String)"ocric_pointsaving", (String)OcricPointSavingConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
    }

    private static DynamicObject[] findAvailablePointBatch(UpdatePointVO updatePointVO, QFilter extendQFilter) {
        QFilter qFilter = new QFilter("memberid", "=", (Object)updatePointVO.getMemberId());
        qFilter.and("pointtypeid", "in", updatePointVO.getPointMap().keySet());
        if (extendQFilter != null) {
            qFilter.and(extendQFilter);
        }
        return BusinessDataServiceHelper.load((String)"ocric_avlpointbatch", (String)OcricAvailablePointBatchConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increaseAvailablePoint(UpdatePointVO updatePointVO) throws KDBizException {
        PointRightsServiceHelper.preparationWork(updatePointVO);
        long memberId = updatePointVO.getMemberId();
        Date expirationDate = PointRightsServiceHelper.getExpirationDate();
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        ArrayList<DynamicObject> pointDetailList = new ArrayList<DynamicObject>(pointTypeNum);
        HashMap<Long, DynamicObject> pointBatchMap = new HashMap<Long, DynamicObject>(pointTypeNum);
        HashMap<Long, DynamicObject> pointSavingMap = new HashMap<Long, DynamicObject>(pointTypeNum);
        PointRightsServiceHelper.prepareDate(updatePointVO, pointDetailList, pointBatchMap, pointSavingMap, expirationDate);
        DLock dlock = DLock.createReentrant((String)(DLOCK_KEY_PREFIX + memberId), (String)PointRightsServiceHelper.getDlockDescription());
        if (dlock.tryLock(5000L)) {
            try {
                QFilter extendQFilter;
                DynamicObject[] pointBatchColl;
                DynamicObject[] pointSavingColl = PointRightsServiceHelper.findPointSaving(updatePointVO);
                if (pointSavingColl != null && pointSavingColl.length > 0) {
                    PointRightsServiceHelper.increasePointSavingQty(pointSavingColl, pointSavingMap, pointMap);
                }
                if ((pointBatchColl = PointRightsServiceHelper.findAvailablePointBatch(updatePointVO, extendQFilter = new QFilter("expirationdate", "=", (Object)expirationDate))) != null && pointBatchColl.length > 0) {
                    PointRightsServiceHelper.increasePointBatchQty(pointBatchColl, pointBatchMap, pointMap);
                }
                PointRightsServiceHelper.saveData(pointSavingMap.values().toArray(new DynamicObject[0]), pointBatchMap.values().toArray(new DynamicObject[0]), pointDetailList.toArray(new DynamicObject[0]));
            }
            finally {
                dlock.unlock();
            }
        } else {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.WARN_LOCK_FAIL);
        }
    }

    private static void prepareDate(UpdatePointVO updatePointVO, List<DynamicObject> pointDetailList, Map<Long, DynamicObject> pointBatchMap, Map<Long, DynamicObject> pointSavingMap, Date expirationDate) {
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        String[] pointDetailNumberArray = CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)pointTypeNum);
        int i = 0;
        for (Map.Entry<Long, Integer> pointMapEntry : pointMap.entrySet()) {
            Long pointTypeId = pointMapEntry.getKey();
            Integer qty = pointMapEntry.getValue();
            DynamicObject pointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, INCREASE_AVAILABLE_POINT, pointDetailNumberArray[i]);
            PointRightsServiceHelper.setChangeSignAndStatus(pointDetail, FreezeStatusEnum.AVAILABLE, ChangeSignEnum.PLUS);
            pointDetail.set("expirationdate", (Object)expirationDate);
            pointDetailList.add(pointDetail);
            ++i;
            DynamicObject pointSaving = PointRightsServiceHelper.preparePointSaving(updatePointVO, pointTypeId, qty);
            pointSavingMap.put(pointTypeId, pointSaving);
            DynamicObject pointBatch = PointRightsServiceHelper.preparePointBatch(updatePointVO, pointTypeId, qty, expirationDate);
            pointBatchMap.put(pointTypeId, pointBatch);
        }
    }

    private static void increasePointBatchQty(DynamicObject[] pointBatchColl, Map<Long, DynamicObject> pointBatchMap, Map<Long, Integer> pointMap) {
        for (DynamicObject pointBatch : pointBatchColl) {
            long pointTypeId = pointBatch.getLong("pointtypeid_id");
            Integer qty = pointMap.get(pointTypeId);
            int currQty = pointBatch.getInt("qty");
            pointBatch.set("qty", (Object)(currQty += qty.intValue()));
            DynamicObject targetPointBatch = pointBatchMap.get(pointTypeId);
            DynamicObjectUtils.copyProperties((DynamicObject)targetPointBatch, (DynamicObject)pointBatch, (String[])avlPointBatchFieldsArray);
            targetPointBatch.getDataEntityState().setPkSnapshotSet(pointBatch.getDataEntityState().getPkSnapshotSet());
        }
    }

    private static void increasePointSavingQty(DynamicObject[] pointSavingColl, Map<Long, DynamicObject> pointSavingMap, Map<Long, Integer> pointMap) {
        for (DynamicObject pointSaving : pointSavingColl) {
            long pointTypeId = pointSaving.getLong("pointtypeid_id");
            Integer qty = pointMap.get(pointTypeId);
            int currQty = pointSaving.getInt("qty");
            pointSaving.set("qty", (Object)(currQty += qty.intValue()));
            DynamicObject targetPointSaving = pointSavingMap.get(pointTypeId);
            DynamicObjectUtils.copyProperties((DynamicObject)targetPointSaving, (DynamicObject)pointSaving, (String[])pointSavingFieldsArray);
            targetPointSaving.getDataEntityState().setPkSnapshotSet(pointSaving.getDataEntityState().getPkSnapshotSet());
        }
    }

    private static void setChangeSignAndStatus(DynamicObject pointDetail, FreezeStatusEnum freezeStatusEnum, ChangeSignEnum changeSignEnum) {
        pointDetail.set("status", (Object)freezeStatusEnum.getValue());
        pointDetail.set("changesign", (Object)changeSignEnum.getValue());
    }

    private static DynamicObject preparePointDetail(UpdatePointVO updatePointVO, Long pointTypeId, Integer qty, String detailType, String number) {
        DynamicObject pointDetail = BusinessDataServiceHelper.newDynamicObject((String)"ocric_pointdetail");
        pointDetail.set("memberid", (Object)updatePointVO.getMemberId());
        pointDetail.set("pointaccountid", (Object)updatePointVO.getPointAccountId());
        pointDetail.set("pointbiztypeid", (Object)updatePointVO.getPointBizTypeId());
        pointDetail.set("transactiontime", (Object)DateUtil.getDateTimeFormat((String)updatePointVO.getTransactionTime()));
        pointDetail.set("orgid", (Object)updatePointVO.getOrgId());
        pointDetail.set("channelid", (Object)updatePointVO.getChannelId());
        pointDetail.set("pointtypeid", (Object)pointTypeId);
        pointDetail.set("qty", (Object)qty);
        pointDetail.set("detailtype", (Object)detailType);
        pointDetail.set("billno", (Object)number);
        pointDetail.set("srcbillentityid", (Object)updatePointVO.getSrcBillEntityId());
        pointDetail.set("srcbillid", (Object)updatePointVO.getSrcBillId());
        pointDetail.set("srcbillno", (Object)updatePointVO.getSrcNo());
        pointDetail.set("comment", (Object)updatePointVO.getComment());
        pointDetail.set("amount", (Object)updatePointVO.getTransactionAmount());
        pointDetail.set("currencyid", (Object)updatePointVO.getTransCurrencyId());
        pointDetail.set("createtime", (Object)new Date());
        return pointDetail;
    }

    private static DynamicObject preparePointBatch(UpdatePointVO updatePointVO, Long pointTypeId, Integer qty, Date expirationDate) {
        DynamicObject pointBatch = BusinessDataServiceHelper.newDynamicObject((String)"ocric_avlpointbatch");
        pointBatch.set("memberid", (Object)updatePointVO.getMemberId());
        pointBatch.set("pointaccountid", (Object)updatePointVO.getPointAccountId());
        pointBatch.set("pointtypeid", (Object)pointTypeId);
        pointBatch.set("qty", (Object)qty);
        pointBatch.set("expirationdate", (Object)expirationDate);
        return pointBatch;
    }

    private static DynamicObject preparePointSaving(UpdatePointVO updatePointVO, Long pointTypeId, Integer qty) {
        DynamicObject pointSaving = BusinessDataServiceHelper.newDynamicObject((String)"ocric_pointsaving");
        pointSaving.set("memberid", (Object)updatePointVO.getMemberId());
        pointSaving.set("pointaccountid", (Object)updatePointVO.getPointAccountId());
        pointSaving.set("pointtypeid", (Object)pointTypeId);
        pointSaving.set("qty", (Object)qty);
        return pointSaving;
    }

    private static DynamicObject constructDefaultPointDetailInfo(UpdatePointVO updatePointVO) {
        DynamicObject pointDetail = BusinessDataServiceHelper.newDynamicObject((String)"ocric_pointdetail");
        pointDetail.set("memberid", (Object)updatePointVO.getMemberId());
        pointDetail.set("pointaccountid", (Object)updatePointVO.getPointAccountId());
        pointDetail.set("pointbiztypeid", (Object)updatePointVO.getPointBizTypeId());
        pointDetail.set("transactiontime", (Object)DateUtil.getDateTimeFormat((String)updatePointVO.getTransactionTime()));
        pointDetail.set("orgid", (Object)updatePointVO.getOrgId());
        pointDetail.set("channelid", (Object)updatePointVO.getChannelId());
        pointDetail.set("srcbillentityid", (Object)updatePointVO.getSrcBillEntityId());
        pointDetail.set("srcbillid", (Object)updatePointVO.getSrcBillId());
        pointDetail.set("srcbillno", (Object)updatePointVO.getSrcNo());
        pointDetail.set("comment", (Object)updatePointVO.getComment());
        pointDetail.set("amount", (Object)updatePointVO.getTransactionAmount());
        pointDetail.set("currencyid", (Object)updatePointVO.getTransCurrencyId());
        pointDetail.set("createtime", (Object)new Date());
        return pointDetail;
    }

    private static Date getExpirationDate() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        return RICSystemParameterHelper.getPointExpirationDateParam((long)rootOrgId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decreaseAvailablePoint(UpdatePointVO updatePointVO) throws KDBizException {
        block5: {
            PointRightsServiceHelper.preparationWork(updatePointVO);
            long memberId = updatePointVO.getMemberId();
            Map<Long, Integer> pointMap = updatePointVO.getPointMap();
            int pointTypeNum = pointMap.size();
            Map<String, DynamicObject> pointDetailMap = PointRightsServiceHelper.createDecreaseAvailablePointDetail(updatePointVO);
            DLock dlock = DLock.createReentrant((String)(DLOCK_KEY_PREFIX + memberId), (String)PointRightsServiceHelper.getDlockDescription());
            if (dlock.tryLock(5000L)) {
                try {
                    DynamicObject[] pointSavingColl = PointRightsServiceHelper.findPointSaving(updatePointVO);
                    if (pointSavingColl != null && pointSavingColl.length == pointTypeNum) {
                        PointRightsServiceHelper.decreasePointSavingQty(pointSavingColl, pointMap, "qty");
                        DynamicObject[] pointBatchColl = PointRightsServiceHelper.findCanDecreaseBatch(updatePointVO);
                        List<DynamicObject> updateBatch = PointRightsServiceHelper.recordBatchAndReturnDecreaseBatch(pointBatchColl, pointDetailMap, pointMap);
                        PointRightsServiceHelper.saveData(pointSavingColl, updateBatch.toArray(new DynamicObject[0]), pointDetailMap.values().toArray(new DynamicObject[0]));
                        break block5;
                    }
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_LACK);
                }
                finally {
                    dlock.unlock();
                }
            }
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.WARN_LOCK_FAIL);
        }
    }

    private static Map<String, DynamicObject> createDecreaseAvailablePointDetail(UpdatePointVO updatePointVO) {
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        String[] pointDetailNumberArray = CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)pointTypeNum);
        int i = 0;
        HashMap<String, DynamicObject> pointDetailMap = new HashMap<String, DynamicObject>(pointTypeNum);
        for (Map.Entry<Long, Integer> pointMapEntry : pointMap.entrySet()) {
            Long pointTypeId = pointMapEntry.getKey();
            Integer qty = pointMapEntry.getValue();
            DynamicObject pointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, DECREASE_AVAILABLE_POINT, pointDetailNumberArray[i]);
            PointRightsServiceHelper.setChangeSignAndStatus(pointDetail, FreezeStatusEnum.AVAILABLE, ChangeSignEnum.MINUS);
            pointDetailMap.put(pointTypeId + FreezeStatusEnum.AVAILABLE.getValue(), pointDetail);
            ++i;
        }
        return pointDetailMap;
    }

    private static List<DynamicObject> recordBatchAndReturnDecreaseBatch(DynamicObject[] pointBatchColl, Map<String, DynamicObject> pointDetailMap, Map<Long, Integer> pointMap) {
        ArrayList<DynamicObject> updateBatch = new ArrayList<DynamicObject>(pointBatchColl.length);
        Map<Long, List<DynamicObject>> pointBatchMap = Arrays.stream(pointBatchColl).collect(Collectors.groupingBy(pointBatch -> pointBatch.getLong("pointtypeid_id")));
        for (Map.Entry<Long, Integer> pointMapEntry : pointMap.entrySet()) {
            Long pointTypeId = pointMapEntry.getKey();
            Integer qty = pointMapEntry.getValue();
            DynamicObject pointDetail = pointDetailMap.get(pointTypeId + FreezeStatusEnum.AVAILABLE.getValue());
            DynamicObjectCollection pointBatchDetail = pointDetail.getDynamicObjectCollection("pointbatchdetail");
            List<DynamicObject> pointBatchList = pointBatchMap.get(pointTypeId);
            if (CollectionUtils.isEmpty(pointBatchList)) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINTBATCH_EXIST);
            }
            pointBatchList.sort(Comparator.comparing(o -> o.getDate("expirationdate")));
            for (DynamicObject pointBatch2 : pointBatchList) {
                if (qty <= 0) break;
                DynamicObject recordBatch = pointBatchDetail.addNew();
                recordBatch.set("pointbatchid", pointBatch2.getPkValue());
                recordBatch.set("batchdate", (Object)pointBatch2.getDate("expirationdate"));
                int currQty = pointBatch2.getInt("qty");
                if (qty >= currQty) {
                    recordBatch.set("usedqty", (Object)pointBatch2.getInt("qty"));
                    pointBatch2.set("qty", (Object)0);
                } else {
                    recordBatch.set("usedqty", (Object)qty);
                    pointBatch2.set("qty", (Object)(currQty - qty));
                }
                updateBatch.add(pointBatch2);
                qty = qty - currQty;
            }
            if (qty <= 0) continue;
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINTBATCH);
        }
        return updateBatch;
    }

    private static void decreasePointSavingQty(DynamicObject[] pointSavingColl, Map<Long, Integer> pointMap, String qtyField) {
        for (DynamicObject pointSaving : pointSavingColl) {
            long pointTypeId = pointSaving.getLong("pointtypeid_id");
            Integer qty = pointMap.get(pointTypeId);
            if (qty == null || qty <= 0) continue;
            int currQty = pointSaving.getInt(qtyField);
            if ((currQty -= qty.intValue()) < 0) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_LACK);
            }
            pointSaving.set(qtyField, (Object)currQty);
        }
    }

    private static void saveData(DynamicObject[] pointSavingColl, DynamicObject[] pointBatchColl, DynamicObject[] pointDetailColl) {
        try (TXHandle h1 = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])pointSavingColl);
                if (pointBatchColl != null) {
                    SaveServiceHelper.save((DynamicObject[])pointBatchColl);
                }
                SaveServiceHelper.save((DynamicObject[])pointDetailColl);
            }
            catch (KDBizException e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    private static QFilter findDetailRecordQFilter(UpdatePointVO updatePointVO, String[] detailTypeColl) {
        QFilter qFilter = new QFilter("memberid", "=", (Object)updatePointVO.getMemberId());
        qFilter.and("pointtypeid", "in", updatePointVO.getPointMap().keySet());
        qFilter.and("srcbillno", "=", (Object)updatePointVO.getSrcNo());
        qFilter.and("detailtype", "in", (Object)detailTypeColl);
        return qFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freezePoint(UpdatePointVO updatePointVO) throws KDBizException {
        block6: {
            PointRightsServiceHelper.preparationWork(updatePointVO);
            long memberId = updatePointVO.getMemberId();
            Map<Long, Integer> pointMap = updatePointVO.getPointMap();
            int pointTypeNum = pointMap.size();
            Map<String, DynamicObject> pointDetailMap = PointRightsServiceHelper.createFreezePointDeatil(updatePointVO);
            DLock dlock = DLock.createReentrant((String)(DLOCK_KEY_PREFIX + memberId), (String)PointRightsServiceHelper.getDlockDescription());
            if (dlock.tryLock(5000L)) {
                try {
                    QFilter detailRecordQFilter = PointRightsServiceHelper.findDetailRecordQFilter(updatePointVO, new String[]{FREEZE_POINT});
                    DynamicObjectCollection detailColl = QueryServiceHelper.query((String)"ocric_pointdetail", (String)"id", (QFilter[])detailRecordQFilter.toArray());
                    if (!CollectionUtils.isEmpty((Collection)detailColl)) {
                        throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_REPEAT_FREEZE);
                    }
                    DynamicObject[] pointSavingColl = PointRightsServiceHelper.findPointSaving(updatePointVO);
                    if (pointSavingColl != null && pointSavingColl.length == pointTypeNum) {
                        PointRightsServiceHelper.freezePointSavingQty(pointSavingColl, pointMap);
                        DynamicObject[] pointBatchColl = PointRightsServiceHelper.findCanDecreaseBatch(updatePointVO);
                        List<DynamicObject> updateBatch = PointRightsServiceHelper.recordBatchAndReturnDecreaseBatch(pointBatchColl, pointDetailMap, pointMap);
                        PointRightsServiceHelper.saveData(pointSavingColl, updateBatch.toArray(new DynamicObject[0]), pointDetailMap.values().toArray(new DynamicObject[0]));
                        break block6;
                    }
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_LACK);
                }
                finally {
                    dlock.unlock();
                }
            }
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.WARN_LOCK_FAIL);
        }
    }

    private static Map<String, DynamicObject> createFreezePointDeatil(UpdatePointVO updatePointVO) {
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        String[] pointDetailNumberArray = CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)(pointTypeNum * 2));
        int i = 0;
        HashMap<String, DynamicObject> pointDetailMap = new HashMap<String, DynamicObject>(pointTypeNum * 2);
        for (Map.Entry<Long, Integer> pointMapEntry : pointMap.entrySet()) {
            Long pointTypeId = pointMapEntry.getKey();
            Integer qty = pointMapEntry.getValue();
            DynamicObject availablePointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, FREEZE_POINT, pointDetailNumberArray[i]);
            PointRightsServiceHelper.setChangeSignAndStatus(availablePointDetail, FreezeStatusEnum.AVAILABLE, ChangeSignEnum.MINUS);
            pointDetailMap.put(pointTypeId + FreezeStatusEnum.AVAILABLE.getValue(), availablePointDetail);
            DynamicObject freezePointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, FREEZE_POINT, pointDetailNumberArray[++i]);
            PointRightsServiceHelper.setChangeSignAndStatus(freezePointDetail, FreezeStatusEnum.FREEZE, ChangeSignEnum.PLUS);
            pointDetailMap.put(pointTypeId + FreezeStatusEnum.FREEZE.getValue(), freezePointDetail);
            ++i;
        }
        return pointDetailMap;
    }

    private static void freezePointSavingQty(DynamicObject[] pointSavingColl, Map<Long, Integer> pointMap) {
        for (DynamicObject pointSaving : pointSavingColl) {
            long pointTypeId = pointSaving.getLong("pointtypeid_id");
            Integer qty = pointMap.get(pointTypeId);
            int currQty = pointSaving.getInt("qty");
            if ((currQty -= qty.intValue()) < 0) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_LACK);
            }
            pointSaving.set("qty", (Object)currQty);
            int currFrozenQty = pointSaving.getInt("frozenqty");
            pointSaving.set("frozenqty", (Object)(currFrozenQty + qty));
        }
    }

    private static DynamicObject[] findCanDecreaseBatch(UpdatePointVO updatePointVO) {
        QFilter extendQFilter = new QFilter("qty", ">", (Object)0);
        extendQFilter.and("expirationdate", ">=", (Object)DateUtil.getNowDate());
        return PointRightsServiceHelper.findAvailablePointBatch(updatePointVO, extendQFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unfreezePoint(UpdatePointVO updatePointVO) throws KDBizException {
        block6: {
            PointRightsServiceHelper.preparationWork(updatePointVO);
            long memberId = updatePointVO.getMemberId();
            Map<Long, Integer> pointMap = updatePointVO.getPointMap();
            int pointTypeNum = pointMap.size();
            DynamicObject[] pointDetailColl = PointRightsServiceHelper.findFreezePointDetail(updatePointVO);
            HashMap<Long, DynamicObject> pointBatchMap = new HashMap<Long, DynamicObject>(pointTypeNum * 4);
            ArrayList<DynamicObject> pointDetailList = new ArrayList<DynamicObject>(pointTypeNum * 3);
            PointRightsServiceHelper.createUnfreezePointDetailAndGetPointBatch(updatePointVO, pointBatchMap, pointDetailList, pointDetailColl);
            DLock dlock = DLock.createReentrant((String)(DLOCK_KEY_PREFIX + memberId), (String)PointRightsServiceHelper.getDlockDescription());
            if (dlock.tryLock(5000L)) {
                try {
                    PointRightsServiceHelper.checkUnfroze(updatePointVO);
                    DynamicObject[] pointSavingColl = PointRightsServiceHelper.findPointSaving(updatePointVO);
                    if (pointSavingColl != null && pointSavingColl.length == pointTypeNum) {
                        PointRightsServiceHelper.unfreezePointSavingQty(pointSavingColl, pointMap);
                        QFilter qFilter = new QFilter("id", "in", pointBatchMap.keySet());
                        DynamicObject[] pointBatchColl = BusinessDataServiceHelper.load((String)"ocric_avlpointbatch", (String)OcricAvailablePointBatchConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
                        if (pointBatchColl == null || pointDetailColl.length != pointBatchMap.size()) {
                            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_NOT_FOUND_POINTBATCH);
                        }
                        PointRightsServiceHelper.batchQtyReturn(pointBatchColl, pointBatchMap);
                        PointRightsServiceHelper.saveData(pointSavingColl, pointBatchColl, pointDetailList.toArray(new DynamicObject[0]));
                        break block6;
                    }
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_FROZENPOINT_LACK);
                }
                finally {
                    dlock.unlock();
                }
            }
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.WARN_LOCK_FAIL);
        }
    }

    private static void batchQtyReturn(DynamicObject[] pointBatchColl, Map<Long, DynamicObject> pointBatchMap) {
        for (DynamicObject targetPointBatch : pointBatchColl) {
            int targetQty = targetPointBatch.getInt("qty");
            DynamicObject pointBatchDetail = pointBatchMap.get(targetPointBatch.getLong("id"));
            int currQty = pointBatchDetail.getInt("usedqty");
            targetPointBatch.set("qty", (Object)(targetQty += currQty));
        }
    }

    private static void unfreezePointSavingQty(DynamicObject[] pointSavingColl, Map<Long, Integer> pointMap) {
        for (DynamicObject pointSaving : pointSavingColl) {
            long pointTypeId = pointSaving.getLong("pointtypeid_id");
            Integer qty = pointMap.get(pointTypeId);
            int currQty = pointSaving.getInt("qty");
            pointSaving.set("qty", (Object)(currQty += qty.intValue()));
            int currFrozenQty = pointSaving.getInt("frozenqty");
            if ((currFrozenQty -= qty.intValue()) < 0) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_FROZENPOINT_LACK);
            }
            pointSaving.set("frozenqty", (Object)currFrozenQty);
        }
    }

    private static void checkUnfroze(UpdatePointVO updatePointVO) {
        QFilter detailRecordQFilter = PointRightsServiceHelper.findDetailRecordQFilter(updatePointVO, new String[]{UNFREEZE_POINT});
        DynamicObjectCollection detailRecord = QueryServiceHelper.query((String)"ocric_pointdetail", (String)"id", (QFilter[])detailRecordQFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)detailRecord)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_REPEAT_UNFREEZE);
        }
    }

    private static void createUnfreezePointDetailAndGetPointBatch(UpdatePointVO updatePointVO, Map<Long, DynamicObject> pointBatchMap, List<DynamicObject> pointDetailList, DynamicObject[] pointDetailColl) {
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        String[] pointDetailNumberArray = CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)(pointTypeNum * 3));
        int i = 0;
        for (DynamicObject pointDetail : pointDetailColl) {
            long pointTypeId = pointDetail.getLong("pointtypeid_id");
            DynamicObjectCollection pointBatchDetailColl = pointDetail.getDynamicObjectCollection("pointbatchdetail");
            int overdueQty = 0;
            for (DynamicObject pointBatchDetail : pointBatchDetailColl) {
                Date batchDate = pointBatchDetail.getDate("batchdate");
                if (batchDate.before(DateUtil.getNowDate())) {
                    overdueQty += pointBatchDetail.getInt("usedqty");
                    continue;
                }
                pointBatchMap.put(pointBatchDetail.getLong("pointbatchid"), pointBatchDetail);
            }
            if (overdueQty > 0) {
                DynamicObject overduePointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, overdueQty, UNFREEZE_POINT, pointDetailNumberArray[i]);
                PointRightsServiceHelper.setChangeSignAndStatus(overduePointDetail, FreezeStatusEnum.FREEZE, ChangeSignEnum.MINUS);
                overduePointDetail.set("pointbiztypeid", (Object)1102856500642312192L);
                ++i;
                pointDetailList.add(overduePointDetail);
                pointMap.put(pointTypeId, pointDetail.getInt("qty") - overdueQty);
            }
            int qty = pointMap.get(pointTypeId);
            DynamicObject availablePointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, UNFREEZE_POINT, pointDetailNumberArray[i]);
            PointRightsServiceHelper.setChangeSignAndStatus(availablePointDetail, FreezeStatusEnum.AVAILABLE, ChangeSignEnum.PLUS);
            pointDetailList.add(availablePointDetail);
            DynamicObject freezePointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, UNFREEZE_POINT, pointDetailNumberArray[++i]);
            PointRightsServiceHelper.setChangeSignAndStatus(freezePointDetail, FreezeStatusEnum.FREEZE, ChangeSignEnum.MINUS);
            ++i;
            pointDetailList.add(freezePointDetail);
        }
    }

    private static DynamicObject[] findFreezePointDetail(UpdatePointVO updatePointVO) {
        QFilter detailRecordQFilter = PointRightsServiceHelper.findDetailRecordQFilter(updatePointVO, new String[]{FREEZE_POINT});
        detailRecordQFilter.and("changesign", "=", (Object)ChangeSignEnum.MINUS.getValue());
        detailRecordQFilter.and("status", "=", (Object)FreezeStatusEnum.AVAILABLE.getValue());
        DynamicObject[] pointDetailColl = BusinessDataServiceHelper.load((String)"ocric_pointdetail", (String)String.join((CharSequence)",", frozenDetailFieldsArray), (QFilter[])detailRecordQFilter.toArray());
        if (pointDetailColl == null || pointDetailColl.length < 1) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_NOT_FOUND_FREEZEDETAIL);
        }
        if (pointDetailColl.length != updatePointVO.getPointMap().size()) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_UNFREEZE_POINTTYPE);
        }
        return pointDetailColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decreaseFrozenPoint(UpdatePointVO updatePointVO) throws KDBizException {
        block5: {
            PointRightsServiceHelper.preparationWork(updatePointVO);
            long memberId = updatePointVO.getMemberId();
            Map<Long, Integer> pointMap = updatePointVO.getPointMap();
            int pointTypeNum = pointMap.size();
            Map<Long, DynamicObject> pointDetailMap = PointRightsServiceHelper.createDecreaseFrozenPointDetail(updatePointVO);
            DLock dlock = DLock.createReentrant((String)(DLOCK_KEY_PREFIX + memberId), (String)PointRightsServiceHelper.getDlockDescription());
            if (dlock.tryLock(5000L)) {
                try {
                    DynamicObject[] pointSavingColl = PointRightsServiceHelper.findPointSaving(updatePointVO);
                    if (pointSavingColl != null && pointSavingColl.length == pointTypeNum) {
                        PointRightsServiceHelper.decreasePointSavingQty(pointSavingColl, pointMap, "frozenqty");
                        PointRightsServiceHelper.saveData(pointSavingColl, null, pointDetailMap.values().toArray(new DynamicObject[0]));
                        break block5;
                    }
                    throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_LACK);
                }
                finally {
                    dlock.unlock();
                }
            }
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)CommonResultEnum.WARN_LOCK_FAIL);
        }
    }

    private static Map<Long, DynamicObject> createDecreaseFrozenPointDetail(UpdatePointVO updatePointVO) {
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        int pointTypeNum = pointMap.size();
        String[] pointDetailNumberArray = CodeRuleUtil.batchCreateNumber((String)"ocric_pointdetail", (int)pointTypeNum);
        int i = 0;
        HashMap<Long, DynamicObject> pointDetailMap = new HashMap<Long, DynamicObject>(pointTypeNum);
        for (Map.Entry<Long, Integer> pointMapEntry : pointMap.entrySet()) {
            Long pointTypeId = pointMapEntry.getKey();
            Integer qty = pointMapEntry.getValue();
            DynamicObject pointDetail = PointRightsServiceHelper.preparePointDetail(updatePointVO, pointTypeId, qty, DECREASE_FROZEN_POINT, pointDetailNumberArray[i]);
            PointRightsServiceHelper.setChangeSignAndStatus(pointDetail, FreezeStatusEnum.FREEZE, ChangeSignEnum.MINUS);
            pointDetailMap.put(pointTypeId, pointDetail);
            ++i;
        }
        return pointDetailMap;
    }

    private static void checkUpdatePointParam(UpdatePointVO updatePointVO) throws KDBizException {
        long memberId = updatePointVO.getMemberId();
        if (memberId == 0L) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_REQUIRED);
        }
        Map<Long, Integer> pointMap = updatePointVO.getPointMap();
        if (CollectionUtils.isEmpty(pointMap)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINT_REQUIRED);
        }
        for (int qty : pointMap.values()) {
            if (qty >= 1) continue;
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINTQTYLESSONE);
        }
        if (0L == updatePointVO.getPointBizTypeId()) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_POINTBIZTYPID_REQUIRED);
        }
        if (0L == updatePointVO.getOrgId()) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_ORGID_REQUIRED);
        }
        if (StringUtils.isBlank((CharSequence)updatePointVO.getSrcNo())) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_SRCNO_REQUIRED);
        }
    }
}

