/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocric.business.point;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserEnableByIdsDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.QueryUserEnableByIdsVO;
import kd.occ.ocbase.common.util.serviceresult.CommonResultEnum;
import kd.occ.ocbase.common.util.serviceresult.MServiceResult;
import kd.occ.ocbase.common.util.serviceresult.ResultEnumInterface;
import kd.occ.ocbase.common.util.serviceresult.ServiceResultUtil;
import kd.occ.ocdbd.common.constants.mempoint.OcdbdMPointtypeConst;
import kd.occ.ocdbd.common.constants.ricaccount.OcdbdRICAccountConst;
import kd.occ.ocdbd.common.constants.ricaccount.OcdbdRICAccountTypeConst;
import kd.occ.ocdbd.common.enums.AccountResultEnum;
import kd.occ.ocdbd.common.mempoint.PointSavingVO;
import kd.occ.ocric.business.point.vo.QueryPointSavingVO;
import kd.occ.ocric.common.constants.OcricPointSavingConst;
import kd.occ.ocric.common.enums.PointRightsResultEnum;

public class PointSavingHelper {
    private static final long[] accountTypeIdArray = new long[]{965136315454660608L, 965136725867305984L};

    public static MServiceResult<Object> queryPointSavingByMemberIdList(List<Long> memberIdList, List<Long> pointTypeIdList) {
        if (CollectionUtils.isEmpty(memberIdList)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_REQUIRED);
        }
        MServiceResult result = new MServiceResult();
        PointSavingHelper.checkInvalid(memberIdList, (MServiceResult<Object>)result);
        Map<Long, List<PointSavingVO>> memberIdPointSavingVOMap = PointSavingHelper.queryPointSavingDataByMemberIdList(memberIdList, pointTypeIdList);
        result.setData(memberIdPointSavingVOMap);
        return result;
    }

    public static Map<Long, List<PointSavingVO>> queryPointSavingDataByMemberIdList(List<Long> memberIdList, List<Long> pointTypeIdList) {
        DynamicObject[] pointTypeArray = PointSavingHelper.getPointType(pointTypeIdList);
        QFilter qFilter = new QFilter("memberid", "in", memberIdList);
        DynamicObjectCollection existPointSavingInfo = QueryServiceHelper.query((String)"ocric_pointsaving", (String)OcricPointSavingConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> memberIdAndPointMap = existPointSavingInfo.stream().collect(Collectors.groupingBy(pointSaving -> pointSaving.getLong("memberid")));
        return PointSavingHelper.turn2VO(memberIdList, pointTypeArray, memberIdAndPointMap);
    }

    private static Map<Long, List<PointSavingVO>> turn2VO(List<Long> memberIdList, DynamicObject[] pointTypeArray, Map<Long, List<DynamicObject>> memberIdAndPointMap) {
        HashMap<Long, List<PointSavingVO>> memberIdPointSavingVOMap = new HashMap<Long, List<PointSavingVO>>(memberIdList.size());
        for (Long memberId : memberIdList) {
            Map<Long, PointSavingVO> pointVOMap = PointSavingHelper.createDefaultPointVO(pointTypeArray);
            List<DynamicObject> existPointList = memberIdAndPointMap.get(memberId);
            if (existPointList != null) {
                PointSavingHelper.updeteVOByExistPoint(existPointList, pointVOMap);
            }
            memberIdPointSavingVOMap.put(memberId, new ArrayList<PointSavingVO>(pointVOMap.values()));
        }
        return memberIdPointSavingVOMap;
    }

    private static void updeteVOByExistPoint(List<DynamicObject> existPointList, Map<Long, PointSavingVO> pointVOMap) {
        for (DynamicObject pointSaving : existPointList) {
            long pointTypeId = pointSaving.getLong("pointtypeid");
            PointSavingVO pointSavingVO = pointVOMap.get(pointTypeId);
            if (pointSavingVO == null) continue;
            pointSavingVO.setAvailableQty(pointSaving.getInt("qty"));
            pointSavingVO.setFrozenQty(pointSaving.getInt("frozenqty"));
        }
    }

    private static Map<Long, PointSavingVO> createDefaultPointVO(DynamicObject[] pointTypeArray) {
        HashMap<Long, PointSavingVO> pointVOMap = new HashMap<Long, PointSavingVO>(pointTypeArray.length);
        for (DynamicObject pointType : pointTypeArray) {
            PointSavingVO pointSavingVO = new PointSavingVO();
            Long pointTypeId = pointType.getLong("id");
            pointSavingVO.setPointTypeId(pointTypeId);
            String pointName = pointType.getString("name");
            pointSavingVO.setPointTypeName(pointName);
            pointSavingVO.setAvailableQty(0);
            pointSavingVO.setFrozenQty(0);
            pointVOMap.put(pointTypeId, pointSavingVO);
        }
        return pointVOMap;
    }

    private static DynamicObject[] getPointType(List<Long> pointTypeIdList) {
        QFilter[] qFilterArray = null;
        if (!CollectionUtils.isEmpty(pointTypeIdList)) {
            QFilter qFilter = new QFilter("id", "in", pointTypeIdList);
            qFilterArray = qFilter.toArray();
        }
        DynamicObject[] pointTypeArray = BusinessDataServiceHelper.load((String)"ocdbd_mpointtype", (String)OcdbdMPointtypeConst.ALL_FIELDS_STRING, qFilterArray);
        return pointTypeArray;
    }

    private static void checkMemberInvalid(List<Long> memberIdList, Map<Long, String> errorMessageMap) {
        QueryUserEnableByIdsDTO dto = new QueryUserEnableByIdsDTO();
        dto.setUserIds(memberIdList);
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserEnableByIds", (Object[])new Object[]{dto});
        MServiceResult mServiceResult = (MServiceResult)result.toJavaObject(MServiceResult.class);
        String code = mServiceResult.getCode();
        if (code != null && code.equals("0")) {
            List data = (List)mServiceResult.getData();
            for (QueryUserEnableByIdsVO object : data) {
                long memberId = object.getUserId();
                String userStatus = object.getUserStatus();
                if (!object.isEnable()) {
                    errorMessageMap.put(memberId, PointRightsResultEnum.WARN_DISABLED_MEMBER.getMessage());
                    continue;
                }
                if (userStatus.equals("A")) {
                    errorMessageMap.put(memberId, PointRightsResultEnum.WARN_NONACTIVATED_MEMBER.getMessage());
                    continue;
                }
                if (!userStatus.equals("C")) continue;
                errorMessageMap.put(memberId, PointRightsResultEnum.WARN_CANCELLED_MEMBER.getMessage());
            }
        } else {
            throw new KDBizException(mServiceResult.getMessage());
        }
    }

    private static void checkInvalid(List<Long> memberIdList, MServiceResult<Object> result) {
        if (CollectionUtils.isEmpty(memberIdList)) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_REQUIRED);
        }
        memberIdList.forEach(memberId -> {
            if (memberId == 0L) {
                throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_ILLEGAL);
            }
        });
        HashMap<Long, String> errorMessageMap = new HashMap<Long, String>(memberIdList.size());
        PointSavingHelper.checkMemberInvalid(memberIdList, errorMessageMap);
        PointSavingHelper.checkAccountInvalid(memberIdList, errorMessageMap);
        if (errorMessageMap.isEmpty()) {
            result.setCode(CommonResultEnum.SUCCESS.getCode());
            result.setMessage(CommonResultEnum.SUCCESS.getMessage());
        } else {
            result.setCode("-1");
            result.setMessage(JSONObject.toJSONString(errorMessageMap));
        }
    }

    private static void checkAccountInvalid(List<Long> memberIdList, Map<Long, String> errorMessageMap) {
        QFilter qFilter = new QFilter("memberid", "in", memberIdList);
        qFilter.and("typeid", "in", (Object)accountTypeIdArray);
        DynamicObjectCollection accountColl = QueryServiceHelper.query((String)"ocdbd_ricaccount", (String)OcdbdRICAccountConst.ALL_FIELDS_STRING, (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> memberIdAndAccountMap = accountColl.stream().collect(Collectors.groupingBy(account -> account.getLong("memberid")));
        if (memberIdAndAccountMap.size() != memberIdList.size()) {
            for (Long l : memberIdList) {
                if (memberIdAndAccountMap.containsKey(l)) continue;
                errorMessageMap.put(l, AccountResultEnum.ERROR_MAINACCOUNT_NULL.getMessage());
            }
        }
        for (Map.Entry entry : memberIdAndAccountMap.entrySet()) {
            Long memberId = (Long)entry.getKey();
            if (errorMessageMap.containsKey(memberId)) continue;
            List accountList = (List)entry.getValue();
            if (accountList.size() != 2) {
                errorMessageMap.put(memberId, AccountResultEnum.ERROR_ACCOUNT_SET.getMessage());
                continue;
            }
            HashSet<Long> checkType = new HashSet<Long>(2);
            for (DynamicObject account2 : accountList) {
                long accountTypeId = account2.getLong("typeid");
                checkType.add(accountTypeId);
                String enableStatus = account2.getString("enable");
                boolean disable = EnableStatusEnum.isDisable((String)enableStatus);
                if (disable && OcdbdRICAccountTypeConst.isMainAccount((Long)accountTypeId)) {
                    errorMessageMap.put(memberId, AccountResultEnum.WARN_DISABLED_MAIN_ACCOUNT.getMessage());
                    continue;
                }
                if (!disable) continue;
                errorMessageMap.put(memberId, AccountResultEnum.WARN_DISABLED_RIGHTS_ACCOUNT.getMessage());
            }
            if (checkType.size() == 2) continue;
            errorMessageMap.put(memberId, AccountResultEnum.ERROR_ACCOUNT_SET.getMessage());
        }
    }

    public static MServiceResult<Object> queryPointSaving(QueryPointSavingVO queryPointSavingVO) {
        long memberId = queryPointSavingVO.getMemberId();
        if (memberId == 0L) {
            throw ServiceResultUtil.getKDBizExceptionByEnum((ResultEnumInterface)PointRightsResultEnum.ERROR_MEMBERID_REQUIRED);
        }
        MServiceResult result = new MServiceResult();
        List<Long> memberIdList = Collections.singletonList(memberId);
        PointSavingHelper.checkInvalid(memberIdList, (MServiceResult<Object>)result);
        Map<Long, List<PointSavingVO>> memberIdAndPointMap = PointSavingHelper.queryPointSavingDataByMemberIdList(memberIdList, queryPointSavingVO.getPointTypeIdList());
        result.setData(memberIdAndPointMap.get(memberId));
        return result;
    }
}

