/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class ItemHelper {
    public static DynamicObjectCollection getItemInfo(List<Long> itemIds) {
        QFilter qFilter = new QFilter("id", "in", itemIds);
        String selectFields = "id,number,name,modelnum,thumbnail";
        return QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static DynamicObjectCollection getSpuInfo(List<Long> spuIds) {
        QFilter qFilter = new QFilter("id", "in", spuIds);
        String selectFields = "id,number,name,thumbnail";
        return QueryServiceHelper.query((String)"ocdbd_spu", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    public static List<TreeNode> getItemClassTreeNodeList() {
        HashMap level2Map;
        QFilter filter = new QFilter("applyplatform", "=", (Object)"0");
        DynamicObject classStandardEntity = QueryServiceHelper.queryOne((String)"ocdbd_classstdapply", (String)"id,applyplatform,classstandardid", (QFilter[])filter.toArray());
        if (classStandardEntity == null) {
            return new ArrayList<TreeNode>();
        }
        filter = new QFilter("standard", "=", (Object)DynamicObjectUtils.getLong((DynamicObject)classStandardEntity, (String)"classstandardid"));
        filter.and(new QFilter("level", "<=", (Object)3));
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        DynamicObjectCollection itemClassList = QueryServiceHelper.query((String)"mdr_item_class", (String)"id,standard,number,name,parent,level", (QFilter[])filter.toArray(), (String)"number asc");
        if (itemClassList == null || itemClassList.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        Map levelItemClassesMap = itemClassList.stream().collect(Collectors.groupingBy(r -> r.getString("level"), Collectors.toList()));
        List level1ItemClasses = levelItemClassesMap.get("1");
        List level2ItemClasses = levelItemClassesMap.get("2");
        List level3ItemClasses = levelItemClassesMap.get("3");
        HashMap level3Map = level3ItemClasses != null ? level3ItemClasses.stream().map(r -> new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"))).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        Map<Object, Object> map = level2Map = level2ItemClasses != null ? level2ItemClasses.stream().map(r -> {
            TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
            if (level3Map.containsKey(treeNode.getId())) {
                treeNode.addChildren((List)level3Map.get(treeNode.getId()));
            }
            return treeNode;
        }).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        if (level1ItemClasses != null) {
            return level1ItemClasses.stream().map(r -> {
                TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
                if (level2Map.containsKey(treeNode.getId())) {
                    treeNode.addChildren((List)level2Map.get(treeNode.getId()));
                }
                return treeNode;
            }).collect(Collectors.toList());
        }
        return new ArrayList<TreeNode>();
    }
}

