/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.channel.ChannelSupplyRelation;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;

public class ItemPriceHelper {
    private static final String marketItemSelectField = String.join((CharSequence)",", "id", "name", "number", "modelnum", "thumbnail", "picture1", "picture2", "picture3", "picture4", "picture5", "orderunit", "orderunit.id", "orderunit.name", "orderunit.precision", "enable", "conversionfor", "itembrands", "material", "material.isuseauxpty", "material.taxrate.id", "material.taxrate", "material.taxrate.taxrate", "assistunit", "assistunit.id", "assistunit.name", "baseunit.id", "baseunit.name", "barcodenumber", "isspecifykneadprice", "kneadprice");

    public static DynamicObject getChannelAuthByFilter(Long supplier) {
        QFilter filter = new QFilter("id", "=", (Object)supplier);
        filter.and("enable", "=", (Object)Checked.YES.toString());
        return QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)String.join((CharSequence)",", "id", "saleorg", "salechannel", "supplyrelation"), (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection getMarketableGoods(List<Long> itemIds) {
        QFilter filter = new QFilter("id", "in", itemIds);
        return QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)marketItemSelectField, (QFilter[])filter.toArray());
    }

    public static Map<Long, BigDecimal> getItemPriceMap(List<Long> itemIds) {
        Map<Long, BigDecimal> priceMap = new HashMap<Long, BigDecimal>(0);
        if (itemIds == null || itemIds.size() == 0) {
            return priceMap;
        }
        DynamicObject loginInfo = B2BUserHelper.getLoginCustomerEntity((boolean)true);
        long supplierId = loginInfo.getLong("supplierid");
        long orderChannelId = loginInfo.getLong("channel");
        DynamicObject currentChannel = BusinessDataServiceHelper.loadSingle((Object)orderChannelId, (String)"ocdbd_channel");
        long currencyId = currentChannel != null ? currentChannel.getLong("currency_id") : 0L;
        long priceChannelId = currentChannel != null ? currentChannel.getLong("pricechannel_id") : 0L;
        DynamicObject channelAuth = ItemPriceHelper.getChannelAuthByFilter(supplierId);
        if (channelAuth != null && orderChannelId != 0L) {
            long saleOrgId = channelAuth.getLong("saleorg");
            long saleChannelId = channelAuth.getLong("salechannel");
            priceMap = ItemPriceHelper.getItemPriceMap(itemIds, saleChannelId, saleOrgId, currencyId, priceChannelId);
        }
        return priceMap;
    }

    public static Map<Long, BigDecimal> getItemPriceMap(List<Long> itemIds, long saleChannelId, long saleOrgId, long currencyId, long priceChannelId) {
        DynamicObjectCollection items = ItemPriceHelper.getMarketableGoods(itemIds);
        HashMap<Long, BigDecimal> priceRlt = new HashMap<Long, BigDecimal>(0);
        HashMap<Long, String> itemIdPriceUqMap = new HashMap<Long, String>();
        Map<String, PriceFetchResult> priceMap = ItemPriceHelper.batchGetPrice(itemIdPriceUqMap, items, saleChannelId, saleOrgId, currencyId, priceChannelId);
        DynamicObject settleCurrency = BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency");
        for (DynamicObject item : items) {
            PriceFetchResult priceFetchResult = priceMap.get(itemIdPriceUqMap.get(item.getLong("id")));
            BigDecimal taxRate = item.getBigDecimal("material.taxrate.taxrate");
            taxRate = taxRate == null ? BigDecimal.ZERO : taxRate;
            BigDecimal qty = BigDecimal.ONE;
            BigDecimal price = BigDecimal.ZERO;
            if (priceFetchResult != null) {
                HashMap priceDetailMap = OrderHelper.getPriceMap((PriceFetchResult)priceFetchResult, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
                BigDecimal bigDecimal = price = priceDetailMap != null ? (BigDecimal)priceDetailMap.get("actualtaxprice") : BigDecimal.ZERO;
            }
            if (SysParamsUtil.isItemPricePermitZero() && price.compareTo(BigDecimal.ZERO) == 0) continue;
            priceRlt.put(item.getLong("id"), price);
        }
        return priceRlt;
    }

    private static Map<String, PriceFetchResult> batchGetPrice(Map<Long, String> itemIdPriceUqMap, DynamicObjectCollection items, long saleChannelId, long saleOrgId, long currencyId, long priceChannelId) {
        ArrayList<PriceFetchParam> priceFetchParamList = new ArrayList<PriceFetchParam>(items.size());
        for (DynamicObject item : items) {
            long unitId = item.getLong("orderunit.id");
            PriceFetchParam priceFetchParam = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)priceChannelId, (long)item.getLong("id"), (long)0L, (long)unitId, (long)currencyId);
            priceFetchParam.setOwnerId(saleChannelId);
            priceFetchParam.setChannelSupplyRelation(saleChannelId > 0L ? ChannelSupplyRelation.SUPPLY_CHANNEL : ChannelSupplyRelation.SUPPLY_ORG);
            priceFetchParamList.add(priceFetchParam);
            itemIdPriceUqMap.put(item.getLong("id"), priceFetchParam.getParamUniKey());
        }
        return PriceServiceUtil.batchGetItemPrice(priceFetchParamList);
    }
}

