/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocrpos.common.model.nav.NavItem;

public class NavigationServiceHelper {
    private static DynamicObjectCollection getNavigationByFrameworkId(Long frameworkId) {
        QFilter qFilter = new QFilter("frameworkdefine", "=", (Object)frameworkId);
        qFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        String selectFields = String.join((CharSequence)",", "id", "name", "number", "parent", "frameworkdefine", "pagetype", "lightpage", "showmodel", "entityobject", "openlink", "showtype");
        return QueryServiceHelper.query((String)"ocrpos_mall_navbar", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"showseq");
    }

    public static List<NavItem> getNavigationMapByFrameworkId(Long frameworkId) {
        DynamicObjectCollection navColl = NavigationServiceHelper.getNavigationByFrameworkId(frameworkId);
        if (navColl == null || navColl.size() == 0) {
            return null;
        }
        List oneNavigationLst = navColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"parent") == 0L).collect(Collectors.toList());
        if (oneNavigationLst.size() == 0) {
            return null;
        }
        ArrayList<NavItem> dataList = new ArrayList<NavItem>(0);
        for (DynamicObject oneNavigation : oneNavigationLst) {
            NavItem mainNav = NavigationServiceHelper.getNavItem(oneNavigation, true);
            dataList.add(mainNav);
            long parentId = DynamicObjectUtils.getLong((DynamicObject)oneNavigation, (String)"id");
            List secondNavigationLst = navColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"parent") == parentId).collect(Collectors.toList());
            if (secondNavigationLst.size() == 0) continue;
            ArrayList<NavItem> childDataList = new ArrayList<NavItem>(0);
            for (DynamicObject secondNavigation : secondNavigationLst) {
                NavItem subNavItem = NavigationServiceHelper.getNavItem(secondNavigation, false);
                childDataList.add(subNavItem);
            }
            mainNav.setChild(childDataList);
        }
        return dataList;
    }

    public static DynamicObject getTplNavigationByFrameworkId(Long frameworkId) {
        QFilter qFilter = new QFilter("frameworkdefine", "=", (Object)frameworkId);
        qFilter.and("ismallfx", "=", (Object)true);
        String selectFields = "id";
        return QueryServiceHelper.queryOne((String)"ocrpos_mall_navbar", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private static NavItem getNavItem(DynamicObject data, boolean isMain) {
        NavItem navItem = new NavItem();
        navItem.setId(String.valueOf(data.getPkValue()));
        navItem.setPageType(data.getString("pagetype"));
        navItem.setShowType(data.getString("showtype"));
        navItem.setLink(NavigationServiceHelper.getLink(data));
        navItem.setShowModel(NavigationServiceHelper.getShowModel(data));
        navItem.setName(data.getString("name"));
        navItem.setMain(isMain);
        return navItem;
    }

    private static String getLink(DynamicObject data) {
        String pageType = data.getString("pagetype");
        if (kd.occ.ocbase.common.util.StringUtils.isEmpty((String)pageType)) {
            pageType = "a";
        }
        if (pageType.equalsIgnoreCase("a")) {
            return String.valueOf(data.getLong("lightpage"));
        }
        if (pageType.equalsIgnoreCase("b")) {
            return data.getString("entityobject");
        }
        return data.getString("openlink");
    }

    private static String getShowModel(DynamicObject data) {
        String pageType = data.getString("pagetype");
        if (pageType.equalsIgnoreCase("b")) {
            String showModel = data.getString("showmodel");
            if (StringUtils.equalsIgnoreCase((CharSequence)showModel, (CharSequence)"a")) {
                return "a";
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)showModel, (CharSequence)"b")) {
                return "b";
            }
        }
        return null;
    }
}

