/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocrpos.business.helper.FrameworkServiceHelper;
import kd.occ.ocrpos.business.helper.ItemPriceHelper;
import kd.occ.ocrpos.common.MallFormShowParameter;
import kd.occ.ocrpos.common.OpenItemParameter;

public class MallFormOpener {
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String MainContentPanel = "maincontent";

    public static final void show(IFormView view, MallFormShowParameter mallFormShowParameter, Map<String, Object> customParams) {
        if (StringUtils.isEmpty((String)mallFormShowParameter.getLink()) && StringUtils.isEmpty((String)mallFormShowParameter.getSrcFormParameterStr())) {
            return;
        }
        if (mallFormShowParameter.getShowType().equalsIgnoreCase("c")) {
            MallFormOpener.showInContainer(view, mallFormShowParameter, customParams);
        } else if (mallFormShowParameter.getShowType().equalsIgnoreCase("a")) {
            MallFormOpener.showInNewWindow(view, mallFormShowParameter, customParams);
        }
    }

    public static final void show(IFormView view, MallFormShowParameter mallFormShowParameter) {
        MallFormOpener.show(view, mallFormShowParameter, null);
    }

    private static void showInNewWindow(IFormView view, MallFormShowParameter mallFormShowParameter, Map<String, Object> customParams) {
        if (mallFormShowParameter.getPageType().equalsIgnoreCase("c")) {
            view.openUrl(mallFormShowParameter.getLink());
            return;
        }
        String frameworkFormId = FrameworkServiceHelper.getEnabledFrameworkFormId();
        FormShowParameter param = new FormShowParameter();
        if (customParams != null) {
            param.setCustomParams(customParams);
        }
        param.setFormId(frameworkFormId);
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        param.getOpenStyle().setTargetKey("_blank");
        if (mallFormShowParameter.getPageType().equalsIgnoreCase("b")) {
            param.setCustomParam("targetFormId", (Object)mallFormShowParameter.getLink());
        } else if (mallFormShowParameter.getPageType().equalsIgnoreCase("a")) {
            param.setCustomParam("targetFormId", (Object)"ocrpos_lightpage");
            param.setCustomParam("lightPageId", (Object)mallFormShowParameter.getLink());
        }
        if (StringUtils.isNotEmpty((String)mallFormShowParameter.getCaption())) {
            param.setCaption(mallFormShowParameter.getCaption());
        }
        view.showForm(param);
    }

    private static void showInContainer(IFormView view, MallFormShowParameter mallFormShowParameter, Map<String, Object> customParams) {
        HashMap uiData = new HashMap();
        HashMap<String, String> widthdata = new HashMap<String, String>();
        widthdata.put(RequestContext.get().getLang().toString(), "1176px");
        uiData.put("w", widthdata);
        FormShowParameter param = null;
        if (StringUtils.isNotEmpty((String)mallFormShowParameter.getSrcFormParameterStr())) {
            param = FormShowParameter.fromJsonString((String)mallFormShowParameter.getSrcFormParameterStr());
        } else {
            param = MallFormOpener.getFormShowParameter(mallFormShowParameter);
            if (customParams != null) {
                param.setCustomParams(customParams);
            }
            if (mallFormShowParameter.getPageType().equalsIgnoreCase("a")) {
                param.setFormId("ocrpos_lightpage");
                param.setCustomParam("lightPageId", (Object)mallFormShowParameter.getLink());
                widthdata.put(RequestContext.get().getLang().toString(), "100%");
            }
        }
        view.updateControlMetadata(MainContentPanel, uiData);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(StringUtils.isEmpty((String)mallFormShowParameter.getTargetKey()) ? MainContentPanel : mallFormShowParameter.getTargetKey());
        view.showForm(param);
    }

    private static FormShowParameter getFormShowParameter(MallFormShowParameter mallFormShowParameter) {
        FormShowParameter formShowParameter = null;
        if (mallFormShowParameter.getPageType().equalsIgnoreCase("b")) {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)mallFormShowParameter.getLink())};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_FORMMETA, (String)"modeltype", (QFilter[])filters);
            String modelType = "";
            if (dynamicObject != null && ((modelType = dynamicObject.getString("modeltype")).equalsIgnoreCase("BillFormModel") || modelType.equalsIgnoreCase("BaseFormModel"))) {
                if (mallFormShowParameter.getShowModel().equalsIgnoreCase("b")) {
                    formShowParameter = ShowFormHelper.createShowListForm((String)mallFormShowParameter.getLink(), (boolean)true, (int)0, (boolean)false);
                } else {
                    BillShowParameter billShowParameter = new BillShowParameter();
                    billShowParameter.setFormId(mallFormShowParameter.getLink());
                    formShowParameter = billShowParameter;
                }
            }
        }
        if (formShowParameter == null) {
            formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(mallFormShowParameter.getLink());
        }
        return formShowParameter;
    }

    public static final void show(IFormView view, OpenItemParameter openItemParameter) {
        if (openItemParameter.getItemId() == 0L) {
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        param.getOpenStyle().setTargetKey("_blank");
        long currentChannelId = B2BUserHelper.getLoginChannelId();
        long supplierId = B2BUserHelper.getLoginSupplyRelationId();
        DynamicObject channelAuth = ItemPriceHelper.getChannelAuthByFilter(supplierId);
        switch (openItemParameter.getItemType().toLowerCase(Locale.ENGLISH)) {
            case "a": {
                param.setFormId("b2b_mall");
                param.setCustomParam("targetFormId", (Object)"ocbmall_itemdetail");
                param.setCustomParam("itemid", (Object)openItemParameter.getItemId().toString());
                if (channelAuth != null && currentChannelId != 0L) {
                    long saleOrgId = channelAuth.getLong("saleorg");
                    long saleChannelId = channelAuth.getLong("salechannel");
                    param.setCustomParam("saleorgid", (Object)saleOrgId);
                    param.setCustomParam("salechannelid", (Object)saleChannelId);
                }
                param.setCustomParam("orderchannelid", (Object)currentChannelId);
                param.setCustomParam("qty", (Object)1);
                break;
            }
            case "b": {
                param.setFormId("b2b_mall");
                param.setCustomParam("targetFormId", (Object)"ocbmall_spudetail");
                param.setCustomParam("spuid", (Object)openItemParameter.getItemId().toString());
                break;
            }
        }
        view.showForm(param);
    }

    private static DynamicObject getChannelAuth(Long supplierId) {
        return MallFormOpener.getChannelAuthByFilter(supplierId);
    }

    private static DynamicObject getChannelAuthByFilter(Long supplier) {
        QFilter filter = new QFilter("id", "=", (Object)supplier);
        filter.and("enable", "=", (Object)Checked.YES.toString());
        return QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)String.join((CharSequence)",", "id", "saleorg", "salechannel", "supplyrelation"), (QFilter[])filter.toArray());
    }

    public static final void showInB2BPortal(IFormView view, MallFormShowParameter mallFormShowParameter) {
        MallFormOpener.showInB2BPortal(view, mallFormShowParameter, null);
    }

    public static final void showInB2BPortal(IFormView view, MallFormShowParameter mallFormShowParameter, Map<String, Object> customParams) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("b2b_main");
        if (customParams == null) {
            customParams = new HashMap<String, Object>(0);
        }
        customParams.put("targetFormId", mallFormShowParameter.getLink());
        customParams.put("showModel", "b".equalsIgnoreCase(mallFormShowParameter.getShowModel()) ? "list" : "");
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(showParameter);
    }
}

