/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.component;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocrpos.business.helper.ItemHelper;
import kd.occ.ocrpos.business.helper.ItemPriceHelper;
import kd.occ.ocrpos.common.MallFormOpener;
import kd.occ.ocrpos.common.OpenItemParameter;
import kd.occ.ocrpos.formplugin.LightPageBasePlugin;

public class ColumnItemShowPlugin
extends LightPageBasePlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private static final String SF_EntryEntity = "entryentity";
    private static final String SF_ColumnTitle = "columntitle";
    private static final String SF_FontSize = "fontsize";
    private static final String SF_FontColor = "fontcolor";
    private static final String SF_DataSrc = "datasrc";
    private static final String SF_SubEntryEntity = "subentryentity";
    private static final String SF_ItemTitle = "itemtitle";
    private static final String SF_Item = "item_id";
    private static final String SF_Spu = "spu_id";
    private static final String SF_ItemPicture = "itempicture";
    private static final String SF_ItemDesc = "itemdesc";
    private static final String Title = "title";
    private static final String MainTitle = "maintitle";
    private static final String TitleFontSize = "titlefontsize";
    private static final String TitleFontColor = "titlefontcolor";
    private static final String ItemImg = "item_img";
    private static final String ItemTitle = "item_title";
    private static final String ItemDesc = "item_desc";
    private static final String ItemPrice = "item_price";
    private static final String ItemNumber = "item_number";
    private static final String ModelNum = "modelnum";
    private static final String ItemDataSrc = "item_datasrc";
    private static final String ItemId = "item_id";
    private static final String Dataentry = "dataentry";
    private static final String[] cardIds = new String[]{"dataentry1", "dataentry2", "dataentry3"};

    public void registerListener(EventObject e) {
        for (String cardId : cardIds) {
            CardEntry cardEntry = (CardEntry)this.getControl(cardId);
            cardEntry.addRowClickListener((RowClickEventListener)this);
            cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.bindSettingData();
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.indexOf(Dataentry) == 0) {
            int entryIndex = Integer.parseInt(key.replace(Dataentry, ""));
            int row = evt.getRow();
            DynamicObject itemRowData = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(key).get(row);
            OpenItemParameter openItemParameter = new OpenItemParameter();
            openItemParameter.setItemType(itemRowData.getString(ItemDataSrc + entryIndex));
            openItemParameter.setItemId(itemRowData.getLong("item_id" + entryIndex));
            MallFormOpener.show(this.getView(), openItemParameter);
        }
    }

    private void bindSettingData() {
        JSONObject settingData = this.getLightPageData();
        this.bindMainTitle(settingData);
        List mailColumnDataLst = (List)settingData.get((Object)SF_EntryEntity);
        if (mailColumnDataLst == null || mailColumnDataLst.size() == 0) {
            return;
        }
        int index = 1;
        IDataModel model = this.getModel();
        ArrayList<Long> spuIds = new ArrayList<Long>(0);
        ArrayList<Long> itemIds = new ArrayList<Long>(0);
        for (Map mailColumnData : mailColumnDataLst) {
            String dataSrc = StringUtils.getStringValue(mailColumnData.get(SF_DataSrc));
            List columnItemDataList = (List)mailColumnData.get(SF_SubEntryEntity);
            for (Map columnItemData : columnItemDataList) {
                if (dataSrc.equalsIgnoreCase("a")) {
                    String item = StringUtils.getStringValue(columnItemData.get("item_id"));
                    long itemId = item != null ? CommonUtils.stringToLong((Object)item) : 0L;
                    if (itemId <= 0L) continue;
                    itemIds.add(itemId);
                    continue;
                }
                String spu = StringUtils.getStringValue(columnItemData.get(SF_Spu));
                long spuId = spu != null ? CommonUtils.stringToLong((Object)spu) : 0L;
                if (spuId <= 0L) continue;
                spuIds.add(spuId);
            }
        }
        DynamicObjectCollection itemColl = null;
        DynamicObjectCollection spuColl = null;
        Map<Long, BigDecimal> priceMap = null;
        if (itemIds.size() > 0) {
            itemColl = ItemHelper.getItemInfo(itemIds);
            priceMap = ItemPriceHelper.getItemPriceMap(itemIds);
        }
        if (spuIds.size() > 0) {
            spuColl = ItemHelper.getSpuInfo(spuIds);
        }
        for (Map mailColumnData : mailColumnDataLst) {
            String columnTitle = StringUtils.getStringValue(mailColumnData.get(SF_ColumnTitle));
            String columnFontSize = StringUtils.getStringValue(mailColumnData.get(SF_FontSize));
            String columnFontColor = StringUtils.getStringValue(mailColumnData.get(SF_FontColor));
            String dataSrc = StringUtils.getStringValue(mailColumnData.get(SF_DataSrc)).toLowerCase();
            model.setValue(Title + index, (Object)columnTitle);
            this.setStyle(Title + index, columnFontSize, columnFontColor);
            List columnItemDataList = (List)mailColumnData.get(SF_SubEntryEntity);
            this.bindColumnItemData(index, dataSrc, columnItemDataList, priceMap, itemColl, spuColl);
            ++index;
        }
    }

    private void bindMainTitle(JSONObject settingData) {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)MainTitle)) {
            String mainTitle = settingData.getString(MainTitle);
            String titleFontSize = settingData.getString(TitleFontSize);
            String titleFontColor = settingData.getString(TitleFontColor);
            this.getModel().setValue(MainTitle, (Object)mainTitle);
            this.setStyle(MainTitle, titleFontSize, titleFontColor);
        }
    }

    private void bindColumnItemData(int index, String datasrc, List<Map<String, Object>> columnItemDataList, Map<Long, BigDecimal> priceMap, DynamicObjectCollection itemColl, DynamicObjectCollection spuColl) {
        if (columnItemDataList == null || columnItemDataList.size() == 0) {
            return;
        }
        String showDataEntry = Dataentry + index;
        this.getModel().batchCreateNewEntryRow(showDataEntry, columnItemDataList.size());
        DynamicObjectCollection showRowDataCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(showDataEntry);
        String titleField = ItemTitle + index;
        String imgField = ItemImg + index;
        String itemNumberField = ItemNumber + index;
        String modelNumField = ModelNum + index;
        String descField = ItemDesc + index;
        String priceField = ItemPrice + index;
        String dataSrcField = ItemDataSrc + index;
        String itemIdField = "item_id" + index;
        int itemRow = 0;
        for (Map<String, Object> columnItemData : columnItemDataList) {
            String imgUrl;
            String imgName;
            long itemId;
            String itemTitle = StringUtils.getStringValue((Object)columnItemData.get(SF_ItemTitle));
            String item = StringUtils.getStringValue((Object)columnItemData.get("item_id"));
            String spu = StringUtils.getStringValue((Object)columnItemData.get(SF_Spu));
            DynamicObject showRowData = (DynamicObject)showRowDataCollection.get(itemRow++);
            if (datasrc.equalsIgnoreCase("a")) {
                itemId = item != null ? Long.parseLong(item) : 0L;
                DynamicObject itemInfo = itemColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == itemId).findFirst().orElse(null);
                if (itemInfo != null) {
                    imgName = DynamicObjectUtils.getString((DynamicObject)itemInfo, (String)"thumbnail");
                    if (StringUtils.isNotEmpty((String)imgName)) {
                        imgUrl = UrlService.getImageFullUrl((String)imgName);
                        showRowData.set(imgField, (Object)imgUrl);
                    }
                    String itemNumber = DynamicObjectUtils.getString((DynamicObject)itemInfo, (String)"number");
                    showRowData.set(itemNumberField, (Object)itemNumber);
                    String modelNum = DynamicObjectUtils.getString((DynamicObject)itemInfo, (String)ModelNum);
                    showRowData.set(modelNumField, (Object)modelNum);
                }
            } else {
                itemId = spu != null ? Long.parseLong(spu) : 0L;
                DynamicObject spuInfo = spuColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == itemId).findFirst().orElse(null);
                if (spuInfo != null) {
                    imgName = DynamicObjectUtils.getString((DynamicObject)spuInfo, (String)"thumbnail");
                    if (StringUtils.isNotEmpty((String)imgName)) {
                        imgUrl = UrlService.getImageFullUrl((String)imgName);
                        showRowData.set(imgField, (Object)imgUrl);
                    }
                    String spuNumber = DynamicObjectUtils.getString((DynamicObject)spuInfo, (String)"number");
                    showRowData.set(itemNumberField, (Object)spuNumber);
                }
            }
            showRowData.set(titleField, (Object)itemTitle);
            if (datasrc.equalsIgnoreCase("a") && priceMap != null && priceMap.get(itemId) != null) {
                showRowData.set(priceField, (Object)priceMap.get(itemId));
            }
            showRowData.set(dataSrcField, (Object)datasrc);
            showRowData.set(itemIdField, (Object)itemId);
        }
    }
}

