/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.itemclass.ItemClassUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocrpos.common.moduledata.AbstractModuleDataPlugin;
import kd.occ.ocrpos.formplugin.LightPageBasePlugin;

public class LeftCategoryAndScrolling
extends LightPageBasePlugin {
    private static final String KEY_category = "category";
    private static final String SEARCHTYPE = "searchtype";
    private static final String KEY_treenodeclick = "treeNodeClick";
    private static final String KEY_classvalue = "value";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        JSONObject object = this.getLightPageData();
        CustomControl category = (CustomControl)this.getControl(KEY_category);
        String dataWay = object.getString("dataway");
        if (dataWay.equalsIgnoreCase("a")) {
            this.manualGetItemClassData(object, category);
        } else {
            this.autoGetItemClassData(object, category);
        }
    }

    public void customEvent(CustomEventArgs e) {
        JSONObject categoryValue;
        super.customEvent(e);
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if (eventName.equalsIgnoreCase(KEY_treenodeclick) && (categoryValue = (JSONObject)JSON.parseObject((String)eventArgs, JSONObject.class)) != null && categoryValue.get((Object)KEY_classvalue) != null) {
            String classId = categoryValue.getString(KEY_classvalue);
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            if ((parentView = parentView.getParentView()) == null) {
                return;
            }
            String searchType = CommonUtils.convertObjectToString((Object)parentView.getModel().getValue(SEARCHTYPE));
            FormShowParameter fsp = new FormShowParameter();
            fsp.getOpenStyle().setShowType(ShowType.NewWindow);
            fsp.getOpenStyle().setTargetKey("_blank");
            fsp.setFormId("b2b_mall");
            if (searchType.equals("B")) {
                fsp.setCustomParam("targetFormId", (Object)"ocbmall_spulist");
            } else {
                fsp.setCustomParam("targetFormId", (Object)"ocbmall_quickorder");
            }
            fsp.setCustomParam("classid", (Object)classId);
            this.getView().showForm(fsp);
        }
    }

    private void manualGetItemClassData(JSONObject object, CustomControl category) {
        HashMap level2Map;
        List<Object> itemClassNodes = new ArrayList(0);
        if (object == null || category == null) {
            return;
        }
        JSONArray entryArray = object.getJSONArray("itemclassentity");
        if (entryArray == null || entryArray.size() == 0) {
            return;
        }
        ArrayList<Long> itemClassIdsColl = new ArrayList<Long>(0);
        for (Object oEntryItem : entryArray) {
            LinkedHashMap entryItem = (LinkedHashMap)oEntryItem;
            itemClassIdsColl.add(CommonUtils.stringToLong(entryItem.get(String.join((CharSequence)"_", "itemclass", "id"))));
        }
        if (itemClassIdsColl.size() == 0) {
            return;
        }
        Set itemClassIdSet = ItemClassUtil.queryAllSubItemClasses(itemClassIdsColl);
        HashSet itemClassIds = new HashSet(0);
        itemClassIdSet.forEach(x -> itemClassIds.add(CommonUtils.stringToLong((Object)x)));
        itemClassIdsColl.forEach(x -> itemClassIds.add(CommonUtils.stringToLong((Object)x)));
        String selectFields = "id,standard,number,name,parent,level";
        String orderByStr = "number asc";
        QFilter qFilter = new QFilter("id", "in", itemClassIds);
        DynamicObjectCollection itemClassColl = QueryServiceHelper.query((String)"mdr_item_class", (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderByStr);
        Map levelItemClassesMap = itemClassColl.stream().collect(Collectors.groupingBy(r -> r.getString("level"), Collectors.toList()));
        List level1ItemClasses = levelItemClassesMap.get("1");
        List level2ItemClasses = levelItemClassesMap.get("2");
        List level3ItemClasses = levelItemClassesMap.get("3");
        HashMap level3Map = level3ItemClasses != null ? level3ItemClasses.stream().map(r -> new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"))).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        Map<Object, Object> map = level2Map = level2ItemClasses != null ? level2ItemClasses.stream().map(r -> {
            TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
            if (level3Map.containsKey(treeNode.getId())) {
                treeNode.addChildren((List)level3Map.get(treeNode.getId()));
            }
            return treeNode;
        }).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        if (level1ItemClasses != null) {
            itemClassNodes = level1ItemClasses.stream().map(r -> {
                TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
                if (level2Map.containsKey(treeNode.getId())) {
                    treeNode.addChildren((List)level2Map.get(treeNode.getId()));
                }
                return treeNode;
            }).collect(Collectors.toList());
        }
        category.setData(itemClassNodes);
    }

    private void autoGetItemClassData(JSONObject object, CustomControl category) {
        if (object == null || category == null) {
            return;
        }
        long moduledataId = object.getLongValue(String.join((CharSequence)"_", "moduledata", "id"));
        if (moduledataId == 0L) {
            return;
        }
        DynamicObject moduleDataDyn = BusinessDataServiceHelper.loadSingle((Object)moduledataId, (String)"ocrpos_moduledata");
        String modulePlugin = DynamicObjectUtils.getString((DynamicObject)moduleDataDyn, (String)"plugin");
        if (StringUtils.isEmpty((String)modulePlugin)) {
            return;
        }
        Object objService = TypesContainer.getOrRegisterSingletonInstance((String)modulePlugin);
        if (objService instanceof AbstractModuleDataPlugin) {
            AbstractModuleDataPlugin moduleDataPlugin = (AbstractModuleDataPlugin)objService;
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("lightpageId", this.getLightPageId());
            Map<String, Object> moduleData = moduleDataPlugin.buildModuleData(params);
            if (moduleData != null) {
                category.setData(moduleData.get(KEY_category));
            }
        } else {
            throw new KDBizException("\u63d2\u4ef6\u9700\u8981\u5b9e\u73b0AbstractModuleDataPlugin\u7c7b\u7684buildModuleData\u65b9\u6cd5");
        }
    }
}

