/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.component;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.CarouselFigure;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.url.UrlService;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocrpos.common.MallFormOpener;
import kd.occ.ocrpos.common.MallFormShowParameter;
import kd.occ.ocrpos.common.util.PageUtil;
import kd.occ.ocrpos.formplugin.LightPageBasePlugin;

public class ScrollingPlugin
extends LightPageBasePlugin {
    private static final int max_scroll_imgs = 5;
    private static final String SF_dataway = "dataway";
    private static final String SF_pagetype = "pagetype";
    private static final String SF_openurl = "openurl";
    private static final String SF_lightpage = "lightpage";
    private static final String SF_entityobject = "entityobject";
    private static final String SF_picture = "picture";
    private static final String F_pagetype = "pagetype";
    private static final String F_openurl = "openurl";
    private static final String EF_openurlentry = "openurlentry";
    private static final String F_ScrollingControl = "scrolling_img";

    public void initialize() {
        this.addClickListeners(new String[]{F_ScrollingControl});
    }

    public void afterBindData(EventObject e) {
        this.bindScrollImg();
    }

    private void bindScrollImg() {
        JSONObject object = this.getLightPageData();
        ArrayList<String> images = new ArrayList<String>(2);
        if (object != null) {
            DynamicObjectCollection openUrlEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(EF_openurlentry);
            for (int i = 1; i <= 5; ++i) {
                String picture = SF_picture + i;
                if (!object.containsKey((Object)picture) || !StringUtils.isNotEmpty((String)object.getString(picture))) continue;
                images.add(UrlService.getImageFullUrl((String)object.getString(picture)));
                DynamicObject openUrlRowData = openUrlEntry.addNew();
                String pagetype = object.getString("pagetype" + i);
                openUrlRowData.set("pagetype", (Object)pagetype);
                openUrlRowData.set("openurl", (Object)PageUtil.getOpenPageUrl(pagetype, object.getString("openurl" + i), object.getString(SF_entityobject + i + "_id"), object.getString(SF_lightpage + i + "_id")));
            }
        }
        String[] a = new String[images.size()];
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(F_ScrollingControl, "updatecarousel", new Object[]{images.toArray(a)});
    }

    public void click(EventObject evt) {
        String key;
        ClickEvent event = (ClickEvent)evt;
        if (event.getSource() instanceof CarouselFigure && (key = ((CarouselFigure)evt.getSource()).getKey()).equalsIgnoreCase(F_ScrollingControl)) {
            int index = Integer.parseInt(event.getParamsMap().get("imageUrl").toString());
            DynamicObjectCollection openUrlEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(EF_openurlentry);
            if (openUrlEntry != null && openUrlEntry.size() > index) {
                DynamicObject openUrlData = (DynamicObject)openUrlEntry.get(index);
                String openUrl = openUrlData.getString("openurl");
                if (StringUtils.isEmpty((String)openUrl) || openUrl.equals("0")) {
                    return;
                }
                MallFormShowParameter mallFormShowParameter = new MallFormShowParameter();
                mallFormShowParameter.setPageType(openUrlData.getString("pagetype"));
                mallFormShowParameter.setLink(openUrl);
                mallFormShowParameter.setShowType("a");
                MallFormOpener.show(this.getView(), mallFormShowParameter);
            }
        }
    }
}

