/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocrpos.business.helper.ItemHelper;
import kd.occ.ocrpos.business.helper.ItemPriceHelper;
import kd.occ.ocrpos.common.MallFormOpener;
import kd.occ.ocrpos.common.OpenItemParameter;
import kd.occ.ocrpos.formplugin.LightPageBasePlugin;

public class SingleRowItemShowPlugin
extends LightPageBasePlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private static final int Max_Items = 5;
    private static final String Title = "title";
    private static final String Item_Img = "itemimg";
    private static final String Item_Title = "itemtitle";
    private static final String Item_Number = "itemnumber";
    private static final String Item_ModelNum = "modelnum";
    private static final String Item_Desc = "itemdesc";
    private static final String Item_Price = "itemprice";
    private static final String Item_Id = "itemid";
    private static final String Spu_Id = "spuid";
    private static final String Data_Src = "datasrc";
    private static final String PictureSrc = "picturesrc";
    private static final String Right_Entity = "rightentity";
    private static final String SF_Item = "item";
    private static final String SF_Spu = "spu";
    private static final String SF_Picture = "picture";
    private static final String SF_PictureSrc = "picturesrc";
    private static final String SF_MainTitle = "maintitle";
    private static final String SF_Itemtitle = "itemtitle";
    private static final String SF_Itemdesc = "itemdesc";
    private static final String SF_Itemprice = "itemprice";
    private static final String SF_OpenUrl = "openurl";
    private static final String SF_TitleFontSize = "titlefontsize";
    private static final String SF_TitleFontColor = "titlefontcolor";
    private static final String SF_ItemFontColor = "itemfontcolor";
    private static final String SF_ItemFontSize = "itemfontsize";
    private static final String SF_Datasrc = "datasrc";
    private static final String SF_EntryEntity = "entryentity";

    public void registerListener(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl(Right_Entity);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setRightData();
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase(Right_Entity)) {
            int row = evt.getRow();
            DynamicObject itemRowData = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection(Right_Entity).get(row);
            OpenItemParameter openItemParameter = new OpenItemParameter();
            openItemParameter.setItemType(itemRowData.getString("datasrc"));
            openItemParameter.setItemId(itemRowData.getLong(Item_Id));
            MallFormOpener.show(this.getView(), openItemParameter);
        }
    }

    private void setRightData() {
        DynamicObjectType entityDataType = this.getModel().getDataEntity().getDynamicObjectCollection(Right_Entity).getDynamicObjectType();
        JSONObject lightPageData = this.getLightPageData();
        List<Map<String, Object>> settingDataList = this.getSettingData(lightPageData);
        this.setMainTitle(lightPageData);
        if (settingDataList.size() > 0) {
            this.getModel().batchCreateNewEntryRow(Right_Entity, settingDataList.size());
            DynamicObjectCollection entryCollection = this.getModel().getDataEntity().getDynamicObjectCollection(Right_Entity);
            ArrayList<Long> itemIds = new ArrayList<Long>(0);
            String dataSrc = CommonUtils.convertObjectToString((Object)lightPageData.get((Object)"datasrc"));
            for (Map<String, Object> settingRowData : settingDataList) {
                long itemId = CommonUtils.stringToLong((Object)settingRowData.get(Item_Id));
                if (itemId <= 0L) continue;
                itemIds.add(itemId);
            }
            Map<Long, BigDecimal> priceMap = null;
            DynamicObjectCollection items = null;
            if (dataSrc.equalsIgnoreCase("a")) {
                items = ItemHelper.getItemInfo(itemIds);
                priceMap = ItemPriceHelper.getItemPriceMap(itemIds);
            } else if (dataSrc.equalsIgnoreCase("b")) {
                items = ItemHelper.getSpuInfo(itemIds);
            }
            for (int i = 0; i < settingDataList.size(); ++i) {
                DynamicObject item;
                Map<String, Object> settingRowData = settingDataList.get(i);
                DynamicObject showRowData = (DynamicObject)entryCollection.get(i);
                long itemId = CommonUtils.stringToLong((Object)settingRowData.get(Item_Id));
                showRowData.set(Item_Id, (Object)itemId);
                showRowData.set("datasrc", settingRowData.get("datasrc"));
                if (items != null && (item = (DynamicObject)items.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == itemId).findFirst().orElse(null)) != null) {
                    String thumbnail = DynamicObjectUtils.getString((DynamicObject)item, (String)"thumbnail");
                    if (StringUtils.isNotEmpty((String)thumbnail)) {
                        showRowData.set(Item_Img, (Object)thumbnail);
                    }
                    showRowData.set(Item_Number, (Object)DynamicObjectUtils.getString((DynamicObject)item, (String)"number"));
                    if (dataSrc.equalsIgnoreCase("a")) {
                        showRowData.set(Item_ModelNum, (Object)DynamicObjectUtils.getString((DynamicObject)item, (String)Item_ModelNum));
                    }
                }
                showRowData.set("itemtitle", (Object)String.valueOf(settingRowData.get("itemtitle")));
                showRowData.set("itemdesc", settingRowData.get("itemdesc"));
                if (!dataSrc.equalsIgnoreCase("a") || priceMap == null || priceMap.get(itemId) == null) continue;
                showRowData.set("itemprice", (Object)priceMap.get(itemId));
            }
        }
    }

    private void setMainTitle(JSONObject lightPageData) {
        if (lightPageData == null) {
            return;
        }
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)Title)) {
            String mainTitle = lightPageData.getString(SF_MainTitle);
            String titleFontSize = lightPageData.getString(SF_TitleFontSize);
            String titleFontColor = lightPageData.getString(SF_TitleFontColor);
            this.getModel().setValue(Title, (Object)mainTitle);
            this.setStyle(Title, titleFontSize, titleFontColor);
        }
    }

    private List<Map<String, Object>> getSettingData(JSONObject lightPageData) {
        JSONArray entryArray;
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(5);
        if (lightPageData != null && (entryArray = lightPageData.getJSONArray(SF_EntryEntity)) != null && entryArray.size() > 0) {
            int maxItems = 5;
            if (entryArray.size() < maxItems) {
                maxItems = entryArray.size();
            }
            String dataSrc = CommonUtils.convertObjectToString((Object)lightPageData.get((Object)"datasrc"));
            for (int i = 0; i < maxItems; ++i) {
                String itemTitle;
                LinkedHashMap jEntryItem = (LinkedHashMap)entryArray.get(i);
                HashMap<String, Object> rowData = new HashMap<String, Object>(0);
                String itemTitleKey = "itemtitle";
                String pictureSrcKey = "picturesrc";
                String itemIdKey = String.join((CharSequence)"_", SF_Item, "id");
                String spuIdKey = String.join((CharSequence)"_", SF_Spu, "id");
                long itemId = dataSrc.equalsIgnoreCase("a") ? CommonUtils.stringToLong(jEntryItem.get(itemIdKey)) : CommonUtils.stringToLong(jEntryItem.get(spuIdKey));
                String string = itemTitle = jEntryItem.containsKey(itemTitleKey) ? CommonUtils.convertObjectToString(jEntryItem.get(itemTitleKey)) : null;
                if (StringUtils.isEmpty((String)itemTitle) && itemId == 0L) continue;
                String pictureSrc = jEntryItem.containsKey(pictureSrcKey) ? CommonUtils.convertObjectToString(jEntryItem.get(pictureSrcKey)) : null;
                rowData.put("itemtitle", itemTitle);
                rowData.put("datasrc", dataSrc.toLowerCase());
                rowData.put(Item_Id, itemId);
                rowData.put("picturesrc", pictureSrc);
                if (itemId > 0L && (StringUtils.isEmpty((String)Item_Img) || StringUtils.isEmpty((String)"itemtitle"))) {
                    rowData.put("queryData", Boolean.TRUE);
                }
                dataList.add(rowData);
            }
        }
        return dataList;
    }
}

