/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.comset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocrpos.formplugin.comset.ComSetTemplatePlugin;

public class IcScrollSetPlugin
extends ComSetTemplatePlugin
implements BeforeF7SelectListener {
    private static final String KEY_PAGETYPE = "pagetype";
    private static final String KEY_PICTURE = "picture";
    private static final String KEY_LIGHTPAGE = "lightpage";
    private static final String KEY_ENTITYOBJECT = "entityobject";
    private static final String KEY_OPENURL = "openurl";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseEdit = (BasedataEdit)this.getView().getControl("itemclass");
        if (baseEdit != null) {
            baseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (data == null || StringUtils.isEmpty((CharSequence)data)) {
            return;
        }
        JSONObject dataObj = JSONObject.parseObject((String)data);
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        JSONArray entryArray = dataObj.getJSONArray("itemclassentity");
        DynamicObjectCollection itemClassEntryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itemclassentity");
        if (itemClassEntryColl == null) {
            return;
        }
        itemClassEntryColl.clear();
        HashSet<Long> itemClassIds = new HashSet<Long>(0);
        this.getBaseDataID(entryArray, itemClassIds);
        HashMap<Object, DynamicObject> itemClassMap = new HashMap(0);
        MainEntityType itemClassEntityType = EntityMetadataCache.getDataEntityType((String)"mdr_item_class");
        if (itemClassIds.size() > 0) {
            itemClassMap = BusinessDataServiceHelper.loadFromCache((Object[])itemClassIds.toArray(), (DynamicObjectType)itemClassEntityType);
        }
        this.bindData(itemClassEntryColl, dataObj, entryArray, itemClassMap);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"dataway")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"itemclassentity");
            entryEntity.clear();
            this.getView().updateView("itemclassentity");
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propertyName = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"itemclass")) {
            QFilter qFilter = new QFilter("level", "=", (Object)1);
            F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)qFilter);
        }
    }

    private void bindData(DynamicObjectCollection entryColl, JSONObject dataObj, JSONArray entryArray, Map<Object, DynamicObject> itemClassMap) {
        IDataModel dataModel = this.getView().getModel();
        if (dataObj != null) {
            dataModel.setValue("classlevel", dataObj.get((Object)"classlevel"));
            for (int i = 1; i <= 5; ++i) {
                String pageType = KEY_PAGETYPE + i;
                String picture = KEY_PICTURE + i;
                String lightPage = KEY_LIGHTPAGE + i;
                String entityObject = KEY_ENTITYOBJECT + i;
                String openUrl = KEY_OPENURL + i;
                dataModel.setValue(pageType, dataObj.get((Object)pageType));
                dataModel.setValue(picture, dataObj.get((Object)picture));
                dataModel.setValue(lightPage, dataObj.get((Object)String.join((CharSequence)"_", lightPage, "id")));
                dataModel.setValue(entityObject, dataObj.get((Object)String.join((CharSequence)"_", entityObject, "id")));
                dataModel.setValue(openUrl, dataObj.get((Object)openUrl));
            }
        }
        if (entryColl != null && entryArray != null) {
            for (Object itemObj : entryArray) {
                JSONObject entryItem = (JSONObject)itemObj;
                DynamicObject newEntry = (DynamicObject)entryColl.getDynamicObjectType().createInstance();
                newEntry.set("itemfontsize", entryItem.get((Object)"itemfontsize"));
                newEntry.set("itemfontcolor", entryItem.get((Object)"itemfontcolor"));
                long itemClassId = CommonUtils.stringToLong((Object)entryItem.get((Object)String.join((CharSequence)"_", "itemclass", "id")));
                if (itemClassId > 0L) {
                    newEntry.set("itemclass", (Object)itemClassMap.get(itemClassId));
                }
                entryColl.add((Object)newEntry);
            }
            BusinessDataServiceHelper.loadRefence((Object[])entryColl.toArray(), (IDataEntityType)entryColl.getDynamicObjectType());
            this.getView().updateView("itemclassentity");
        }
    }

    private void getBaseDataID(JSONArray entryArray, Set<Long> itemClassIds) {
        if (entryArray == null || entryArray.size() == 0) {
            return;
        }
        for (Object itemObj : entryArray) {
            JSONObject entryItem = (JSONObject)itemObj;
            if (entryItem == null) continue;
            itemClassIds.add(CommonUtils.stringToLong((Object)entryItem.get((Object)String.join((CharSequence)"_", "itemclass", "id"))));
        }
    }
}

