/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.fxdefine;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class MallFrameworkDefinePlugin
extends AbstractBasePlugIn {
    private static final String KEY_THEME = "key";
    private static final String KEY_COLOR = "color";
    private static final String KEY_COLORVALUE = "colorValue";
    private static final String KEY_ISSELECTED = "isSelected";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject[] themes = this.getEnableThemeListSort();
        this.initTheme(themes);
    }

    public void customEvent(CustomEventArgs e) {
        if ("fdthemeselect".equals(e.getKey())) {
            this.switchTheme(e.getEventArgs());
        }
    }

    private void initTheme(DynamicObject[] themes) {
        if (themes != null && themes.length != 0) {
            String selectedNum;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject uiTheme = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"uitheme");
            if (uiTheme == null) {
                long currUserId = RequestContext.get().getCurrUserId();
                Map themeMap = UserServiceHelper.getUserThemeNumAndVerNew((Long)currUserId);
                selectedNum = CommonUtils.convertObjectToString(themeMap.get("number"));
            } else {
                selectedNum = DynamicObjectUtils.getString((DynamicObject)uiTheme, (String)"number");
            }
            CustomControl customControl = (CustomControl)this.getControl("fdthemeselect");
            ArrayList list = new ArrayList(themes.length);
            for (DynamicObject theme : themes) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                String number = theme.getString("number");
                LocaleString name = new LocaleString(theme.get("name").toString());
                String color = theme.getString(KEY_COLOR);
                map.put("id", number);
                map.put("description", name);
                map.put(KEY_COLORVALUE, color);
                boolean isSelect = false;
                if (selectedNum.equals(number)) {
                    isSelect = true;
                }
                map.put(KEY_ISSELECTED, isSelect);
                list.add(map);
            }
            customControl.setData(list);
        }
    }

    private void switchTheme(String args) {
        Map map;
        if (!StringUtils.isEmpty((CharSequence)args) && (map = (Map)SerializationUtils.fromJsonString((String)args, Map.class)).get(KEY_THEME) != null) {
            String themeValue = map.get(KEY_THEME).toString();
            DynamicObject[] themes = this.getEnableThemeListSort();
            CustomControl customControl = (CustomControl)this.getControl("fdthemeselect");
            ArrayList list = new ArrayList(themes.length);
            for (DynamicObject theme : themes) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                String number = theme.getString("number");
                LocaleString name = new LocaleString(theme.get("name").toString());
                String color = theme.getString(KEY_COLOR);
                dataMap.put("id", number);
                dataMap.put("description", name);
                dataMap.put(KEY_COLORVALUE, color);
                boolean isSelect = false;
                if (themeValue.equals(number)) {
                    isSelect = true;
                    this.getView().getModel().setValue("themename", (Object)name);
                    this.getView().getModel().setValue("themenumber", (Object)number);
                    this.getView().getModel().setValue("uitheme", (Object)DynamicObjectUtils.getPkValue((DynamicObject)theme));
                }
                dataMap.put(KEY_ISSELECTED, isSelect);
                list.add(dataMap);
            }
            customControl.setData(list);
        }
    }

    protected DynamicObject[] getEnableThemeListSort() {
        QFilter[] themeFilters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        return BusinessDataServiceHelper.load((String)"bas_uitheme", (String)"id,number,name,version,thumbnail,color,background,content,isdefault", (QFilter[])themeFilters, (String)"createtime");
    }

    private void saveNav() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pkValue = dataEntity.getPkValue();
        QFilter filter = new QFilter("frameworkdefine", "=", pkValue);
        filter.and("ismallfx", "=", (Object)Boolean.TRUE);
        DynamicObject queryNavSet = QueryServiceHelper.queryOne((String)"ocrpos_mall_navbar", (String)"id", (QFilter[])filter.toArray());
        DynamicObject mallNavSet = queryNavSet == null ? BusinessDataServiceHelper.newDynamicObject((String)"ocrpos_mall_navbar") : BusinessDataServiceHelper.loadSingle((Object)queryNavSet.get("id"), (String)"ocrpos_mall_navbar");
        mallNavSet.set("name", (Object)DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"name"));
        mallNavSet.set("number", (Object)DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"number"));
        mallNavSet.set("ismallfx", (Object)true);
        mallNavSet.set("frameworkdefine", pkValue);
        mallNavSet.set("status", (Object)StatusEnum.AUDIT.getValue());
        mallNavSet.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mallNavSet});
    }
}

