/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.lightpageset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.UUID;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;

public class LightPageSetPlugin
extends AbstractBasePlugIn
implements RowClickEventListener {
    private static final String KEY_CHILDPAGEID = "childpageid";
    private static final String KEY_ROWINDEX = "rowindex";
    private static final String OP_LIGHTPAGE = "lightpage";
    private static final String FS_RIGHT = "fs_right";
    private static final String P_ocrpos_com_blank_page = "ocrpos_com_blank_page";
    protected static final Log logger = LogFactory.getLog(LightPageSetPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"moduletype")) {
            this.getView().getPageCache().put(KEY_ROWINDEX, null);
            this.showModulePage();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"save")) {
            this.saveConfig();
            this.savePublishData();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)OP_LIGHTPAGE)) {
            // empty if block
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)entryGrid.getKey(), (CharSequence)"entryentity")) {
            this.showModulePage();
        }
    }

    private void showModulePage() {
        int cacheRowIndex;
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        if (this.getView().getPageCache().get(KEY_ROWINDEX) != null && rowIndex == (cacheRowIndex = Integer.parseInt(this.getView().getPageCache().get(KEY_ROWINDEX)))) {
            return;
        }
        DynamicObject currEntry = this.getView().getModel().getEntryRowEntity("entryentity", rowIndex);
        DynamicObject moduleType = DynamicObjectUtils.getDynamicObject((DynamicObject)currEntry, (String)"moduletype");
        if (moduleType == null) {
            this.saveConfig();
            this.showBlankPage();
            return;
        }
        DynamicObject moduleSetObj = DynamicObjectUtils.getDynamicObject((DynamicObject)moduleType, (String)"modulesetobj");
        if (moduleSetObj == null) {
            this.saveConfig();
            this.showBlankPage();
            return;
        }
        this.saveConfig();
        String formId = DynamicObjectUtils.getString((DynamicObject)moduleSetObj, (String)"number");
        String dataJson = DynamicObjectUtils.getString((DynamicObject)currEntry, (String)"moduledata_tag");
        this.showForm(formId, rowIndex, dataJson, DynamicObjectUtils.getPkValue((DynamicObject)moduleType));
    }

    private void showBlankPage() {
        int cacheRowIndex;
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex("entryentity");
        if (this.getView().getPageCache().get(KEY_ROWINDEX) != null && rowIndex == (cacheRowIndex = Integer.parseInt(this.getView().getPageCache().get(KEY_ROWINDEX)))) {
            return;
        }
        this.showForm(P_ocrpos_com_blank_page, rowIndex, null, 0L);
    }

    private void showForm(String formId, int rowIndex, String dataJson, long moduleTypeId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(FS_RIGHT);
        String pageId = UUID.randomUUID().toString().replace("-", "") + 1;
        this.getView().getPageCache().put(KEY_CHILDPAGEID, pageId);
        this.getView().getPageCache().put(KEY_ROWINDEX, CommonUtils.convertObjectToString((Object)rowIndex));
        showParameter.setPageId(pageId);
        showParameter.setCustomParam("data", (Object)dataJson);
        showParameter.setCustomParam("moduletype", (Object)moduleTypeId);
        this.getView().showForm(showParameter);
    }

    private void saveConfig() {
        try {
            String oRowIndex = this.getPageCache().get(KEY_ROWINDEX);
            String childPageId = this.getPageCache().get(KEY_CHILDPAGEID);
            if (StringUtils.isNotBlank((CharSequence)childPageId)) {
                IFormView childView = this.getView().getView(childPageId);
                if (childView == null) {
                    return;
                }
                if (oRowIndex == null || StringUtils.isEmpty((CharSequence)oRowIndex)) {
                    return;
                }
                int rowIndex = Integer.parseInt(oRowIndex);
                DynamicObject dataEntity = childView.getModel().getDataEntity(true);
                JSONObject data = new JSONObject();
                DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
                for (IDataEntityProperty property : properties) {
                    if (property instanceof BasedataProp) continue;
                    if (property instanceof EntryProp) {
                        DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)property.getName());
                        if (entryColl == null || entryColl.size() == 0) continue;
                        JSONArray entryArray = new JSONArray();
                        DataEntityPropertyCollection entryProperties = entryColl.getDynamicObjectType().getProperties();
                        for (DynamicObject entry : entryColl) {
                            JSONObject entryItem = new JSONObject();
                            for (IDataEntityProperty entryProperty : entryProperties) {
                                if (entryProperty instanceof BasedataProp) continue;
                                if (entryProperty instanceof SubEntryProp) {
                                    DynamicObjectCollection subEntryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)entryProperty.getName());
                                    if (subEntryColl == null || subEntryColl.size() == 0) continue;
                                    JSONArray subEntryArray = new JSONArray();
                                    DataEntityPropertyCollection subEntryProperties = subEntryColl.getDynamicObjectType().getProperties();
                                    for (DynamicObject subEntry : subEntryColl) {
                                        JSONObject subEntryItem = new JSONObject();
                                        for (IDataEntityProperty subEntryProperty : subEntryProperties) {
                                            if (subEntryProperty instanceof BasedataProp) continue;
                                            subEntryItem.put(subEntryProperty.getName(), subEntry.get(subEntryProperty.getName()));
                                        }
                                        subEntryArray.add((Object)subEntryItem);
                                    }
                                    entryItem.put(entryProperty.getName(), (Object)subEntryArray);
                                    continue;
                                }
                                entryItem.put(entryProperty.getName(), entry.get(entryProperty.getName()));
                            }
                            entryArray.add((Object)entryItem);
                        }
                        data.put(property.getName(), (Object)entryArray);
                        continue;
                    }
                    data.put(property.getName(), dataEntity.get(property.getName()));
                }
                this.getView().getModel().setValue("moduledata_tag", (Object)data, rowIndex);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.getView().showMessage("\u5207\u6362\u592a\u9891\u7e41\u4e86\uff0c\u8bf7\u7b49\u9875\u9762\u52a0\u8f7d\u5b8c\u540e\u518d\u5207\u6362");
        }
    }

    private void savePublishData() {
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"entryentity");
        DynamicObjectCollection pubEntryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"pubentity");
        if (entryColl == null || pubEntryColl == null) {
            return;
        }
        for (DynamicObject entryItem : entryColl) {
            int seq = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"seq");
            boolean bIsEnable = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"isenable");
            if (bIsEnable) {
                DynamicObject pubEntryItem = pubEntryColl.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == seq).findFirst().orElse(null);
                if (pubEntryItem == null) {
                    pubEntryItem = pubEntryColl.addNew();
                }
                pubEntryItem.set("shopwindowseq", (Object)seq);
                pubEntryItem.set("shopwindow_p", entryItem.get("shopwindow"));
                pubEntryItem.set("moduletype_p", entryItem.get("moduletype"));
                pubEntryItem.set("moduledata_p", entryItem.get("moduledata"));
                pubEntryItem.set("moduledata_p_tag", entryItem.get("moduledata_tag"));
                continue;
            }
            pubEntryColl.removeIf(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"shopwindowseq") == seq);
        }
        this.getView().updateView("pubentity");
    }
}

