/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.moduledata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocrpos.common.moduledata.AbstractModuleDataPlugin;

public class ItemClassDataPlugin
extends AbstractModuleDataPlugin {
    public static final String KEY_category = "category";

    @Override
    public Map<String, Object> buildModuleData(Map<String, Object> params) {
        HashMap<String, Object> data = new HashMap<String, Object>(0);
        List<TreeNode> itemClassTreeNodeList = this.getItemClassTreeNodeList();
        data.put(KEY_category, itemClassTreeNodeList);
        return data;
    }

    private List<TreeNode> getItemClassTreeNodeList() {
        HashMap level2Map;
        long saleOrgId = 0L;
        long saleChannelId = 0L;
        HashSet<Long> itemClassIds = new HashSet<Long>(0);
        String selectFields = "id,applyplatform,classstandardid";
        QFilter filter = new QFilter("applyplatform", "=", (Object)"0");
        DynamicObject classStandardEntity = QueryServiceHelper.queryOne((String)"ocdbd_classstdapply", (String)selectFields, (QFilter[])filter.toArray());
        if (classStandardEntity == null) {
            return new ArrayList<TreeNode>();
        }
        long orderChannelId = B2BUserHelper.getLoginChannelId();
        long supplyRelationId = B2BUserHelper.getLoginSupplyRelationId();
        long classStandardId = DynamicObjectUtils.getLong((DynamicObject)classStandardEntity, (String)"classstandardid");
        DynamicObject supplyRelation = BusinessDataServiceHelper.loadSingle((Object)supplyRelationId, (String)"ocdbd_channel_authorize");
        if (supplyRelation != null) {
            saleOrgId = supplyRelation.getLong("saleorg_id");
            saleChannelId = supplyRelation.getLong("salechannel_id");
        }
        QFilter qFilter = this.getItemStatusQFilter(saleOrgId);
        List filterList = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)saleChannelId, (long)orderChannelId);
        if (qFilter != null) {
            filterList.add(qFilter);
        }
        filterList.add(new QFilter("itemclassentity.goodsclasssid", ">", (Object)0L));
        selectFields = "id,itemclassentity.goodsclasssid as goodsclasssid";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ItemClassDataPlugin.class.getName(), (String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])filterList.toArray(new QFilter[0]), null);
        dataSet.forEach(r -> itemClassIds.add(r.getLong("goodsclasssid")));
        if (itemClassIds.size() == 0) {
            return new ArrayList<TreeNode>();
        }
        Set<Long> itemClassIdSet = this.queryAllParentItemClassIds(itemClassIds, classStandardId);
        filter = new QFilter("standard", "=", (Object)classStandardId);
        filter.and(new QFilter("id", "in", itemClassIdSet));
        filter.and(new QFilter("level", "<=", (Object)3));
        filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        selectFields = "id,standard,number,name,parent,level";
        String orderByStr = "number asc";
        DynamicObjectCollection itemClassList = QueryServiceHelper.query((String)"mdr_item_class", (String)selectFields, (QFilter[])filter.toArray(), (String)orderByStr);
        if (itemClassList == null || itemClassList.isEmpty()) {
            return new ArrayList<TreeNode>();
        }
        Map levelItemClassesMap = itemClassList.stream().collect(Collectors.groupingBy(r -> r.getString("level"), Collectors.toList()));
        List level1ItemClasses = levelItemClassesMap.get("1");
        List level2ItemClasses = levelItemClassesMap.get("2");
        List level3ItemClasses = levelItemClassesMap.get("3");
        HashMap level3Map = level3ItemClasses != null ? level3ItemClasses.stream().map(r -> new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"))).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        Map<Object, Object> map = level2Map = level2ItemClasses != null ? level2ItemClasses.stream().map(r -> {
            TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
            if (level3Map.containsKey(treeNode.getId())) {
                treeNode.addChildren((List)level3Map.get(treeNode.getId()));
            }
            return treeNode;
        }).collect(Collectors.groupingBy(TreeNode::getParentid, Collectors.toList())) : new HashMap();
        if (level1ItemClasses != null) {
            return level1ItemClasses.stream().map(r -> {
                TreeNode treeNode = new TreeNode(r.getString("parent"), r.getString("id"), r.getString("name"));
                if (level2Map.containsKey(treeNode.getId())) {
                    treeNode.addChildren((List)level2Map.get(treeNode.getId()));
                }
                return treeNode;
            }).collect(Collectors.toList());
        }
        return new ArrayList<TreeNode>();
    }

    private Set<Long> queryAllParentItemClassIds(Set<Long> itemClassIds, long classStandardId) {
        QFilter qFilter = new QFilter("standard", "=", (Object)classStandardId);
        qFilter.and(new QFilter("level", "<=", (Object)3));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        DynamicObjectCollection itemClassColl = QueryServiceHelper.query((String)"mdr_item_class", (String)"id,parent", (QFilter[])qFilter.toArray());
        HashSet<Long> classIds = new HashSet<Long>(0);
        for (long itemClassId : itemClassIds) {
            this.getParentItemClassIds(itemClassColl, classIds, itemClassId);
        }
        return classIds;
    }

    private void getParentItemClassIds(DynamicObjectCollection itemClassColl, Set<Long> classIds, long itemClassId) {
        long parentId;
        classIds.add(itemClassId);
        DynamicObject itemClass = itemClassColl.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id") == itemClassId).findFirst().orElse(null);
        if (itemClass != null && (parentId = DynamicObjectUtils.getLong((DynamicObject)itemClass, (String)"parent")) > 0L) {
            this.getParentItemClassIds(itemClassColl, classIds, parentId);
        }
    }

    private QFilter getItemStatusQFilter(long saleOrgId) {
        QFilter qFilter = null;
        String itemStatusControl = SysParamsUtil.getItemStatusControl();
        boolean isMallControl = itemStatusControl.contains("0");
        if (isMallControl) {
            qFilter = ItemNSaleControlUtil.getItemOrgStatusFilter((long)saleOrgId);
        }
        return qFilter;
    }
}

