/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.std;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.message.service.pa.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.occ.ocbase.business.b2b.B2BUserHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocrpos.business.helper.FrameworkServiceHelper;
import kd.occ.ocrpos.business.helper.MallUserHelper;
import kd.occ.ocrpos.business.helper.NavigationServiceHelper;
import kd.occ.ocrpos.common.MallFormOpener;
import kd.occ.ocrpos.common.MallFormShowParameter;
import kd.occ.ocrpos.common.model.nav.NavItem;
import kd.occ.ocrpos.formplugin.std.DefaultMallBasePlugin;

public class DefaultFrameworkPlugin
extends DefaultMallBasePlugin
implements SearchEnterListener {
    private static final String SEARCHCLICKPANEL = "searchclickpanel";
    private static final String BTN_ShopCar = "btn_shopcar";
    private static final String Search = "search";
    private static final String BTN_MyOrder = "btn_myorder";
    private static final String KEY_FIRSTNAV = "firstnav";
    private static final String KEY_SECNAV = "secnav";
    private static final String KEY_SUPPLYRELCONTROL = "supplyrelcontrol";
    private static final String CUSTOMER_CONTROL_KEY = "key";
    private static final String KEY_SWITCH_SUPPLY = "switchsupply";
    private static final String KEY_ISSELECTED = "isSelected";
    private static final String SEARCHTYPE = "searchtype";
    private static final String SUPPLYREL = "supplyrel";
    private static final String USERNAME = "username";
    private static final String BTN_logout = "btn_logout";
    private static final String IMG_HOME = "home";
    private static final String LBL_HOME = "lblhome";
    private static final String LBL_BOTTOM = "lblbottom";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_ShopCar, SEARCHCLICKPANEL, BTN_MyOrder});
        Search search = (Search)this.getView().getControl(Search);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label lblHome = (Label)this.getControl(LBL_HOME);
        lblHome.addClickListener((ClickListener)this);
        Vector imgHome = (Vector)this.getView().getControl(IMG_HOME);
        imgHome.addClickListener((ClickListener)this);
        Label logout = (Label)this.getControl(BTN_logout);
        logout.addClickListener((ClickListener)this);
        this.addVectorClickListener(KEY_SWITCH_SUPPLY);
    }

    public void beforeBindData(EventObject e) {
        this.setTheme();
        this.bindSettingInfo();
        this.initUser();
        this.initSupplyRel();
        this.initSearchType();
        this.bindBottom();
        B2BUserHelper.setMallShopCarBadgeInfo((IFormView)this.getView(), (boolean)true);
    }

    public void afterBindData(EventObject e) {
        String targetFormId;
        this.openFirstPage();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.size() > 0 && (targetFormId = CommonUtils.convertObjectToString(customParams.get("targetFormId"))).equals("ocbmall_shopcar")) {
            this.setNavVisible(Boolean.FALSE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        switch (propertyName) {
            case "searchtype": {
                String searchType = CommonUtils.convertObjectToString((Object)e.getChangeSet()[0].getNewValue());
                this.updateEmptyTip(searchType);
                break;
            }
            case "supplyrel": {
                DynamicObject supplyRel = (DynamicObject)e.getChangeSet()[0].getNewValue();
                long supplyRelId = 0L;
                long orderChannelId = 0L;
                if (supplyRel != null) {
                    supplyRelId = supplyRel.getLong("id");
                    orderChannelId = DynamicObjectUtils.getPkValue((DynamicObject)supplyRel, (String)"orderchannel");
                }
                B2BUserHelper.updateLoginInfo((long)orderChannelId, (long)supplyRelId);
            }
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        String controlKey = "";
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        switch (controlKey) {
            case "btn_shopcar": {
                HashMap<String, Object> customMap = new HashMap<String, Object>(16);
                customMap.put("show_type", ShowType.InCurrentForm.getValue());
                MallFormShowParameter mallFormShowParameter = new MallFormShowParameter();
                mallFormShowParameter.setShowType("a");
                mallFormShowParameter.setLink("ocbmall_shopcar");
                mallFormShowParameter.setCaption("B2B\u5546\u57ce - \u8d2d\u7269\u8f66");
                mallFormShowParameter.setPageType("b");
                mallFormShowParameter.setShowModel("a");
                MallFormOpener.show(this.getView(), mallFormShowParameter, customMap);
                break;
            }
            case "searchclickpanel": {
                Search search = (Search)this.getView().getControl(Search);
                this.doSearch(search.getSearchKey());
                this.setNavVisible(Boolean.TRUE);
                break;
            }
            case "btn_myorder": {
                MallFormShowParameter mallFormShowParameter = new MallFormShowParameter();
                mallFormShowParameter.setShowModel("b");
                mallFormShowParameter.setLink("ocbsoc_saleorder_dp");
                MallFormOpener.showInB2BPortal(this.getView(), mallFormShowParameter);
                this.setNavVisible(Boolean.TRUE);
                break;
            }
            case "home": 
            case "lblhome": {
                this.showHomePage();
                this.clearNavClickStyle();
                this.setNavVisible(Boolean.TRUE);
                break;
            }
            case "btn_logout": {
                this.loginOut();
            }
            case "switchsupply": {
                this.showSwitchSupply();
                break;
            }
            default: {
                this.setNavVisible(Boolean.TRUE);
            }
        }
    }

    private void loginOut() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, String> mpURL = new HashMap<String, String>();
        String redirect = "redirect=index.html?formId=b2b_mall";
        String logoutUrl = "auth/logout.do";
        mpURL.put("url", String.join((CharSequence)"?", logoutUrl, redirect));
        mpURL.put("openStyle", "0");
        proxy.addAction("openUrl", mpURL);
    }

    private void initUser() {
        DynamicObject userInfo = UserUtil.getUserInfo();
        if (userInfo != null) {
            this.getView().getModel().setValue(USERNAME, (Object)userInfo.getString("name"));
        }
    }

    private void setNavVisible(Boolean isVisible) {
        String cacheFrameworkId = this.getPageCache().get("frameworkId");
        if (StringUtils.isEmpty((String)cacheFrameworkId)) {
            return;
        }
        Long frameworkId = Long.valueOf(cacheFrameworkId);
        List<NavItem> navList = NavigationServiceHelper.getNavigationMapByFrameworkId(frameworkId);
        if (isVisible == Boolean.TRUE) {
            if (navList == null || navList.size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FIRSTNAV, KEY_SECNAV});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FIRSTNAV});
            if (navList.get(0).getChild() == null || navList.get(0).getChild().size() == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_SECNAV});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_SECNAV});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FIRSTNAV, KEY_SECNAV});
        }
    }

    private void initSupplyRel() {
        DynamicObject loginInfo = B2BUserHelper.getLoginCustomerEntity((boolean)true);
        if (loginInfo != null) {
            long supplyRelId = DynamicObjectUtils.getLong((DynamicObject)loginInfo, (String)String.join((CharSequence)".", String.join((CharSequence)".", "supplierid", "id")));
            this.bindSupplyRel(supplyRelId);
        } else {
            this.bindSupplyRel();
        }
    }

    private void initSearchType() {
        boolean enableItemSpu;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String searchType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)SEARCHTYPE);
        String selectedNum = StringUtils.isEmpty((String)searchType) ? ((enableItemSpu = SysParamsUtil.getEnableItemSpu()) ? "B" : "A") : searchType;
        this.getView().getModel().setValue(SEARCHTYPE, (Object)selectedNum);
        this.updateEmptyTip(selectedNum);
    }

    private void bindSettingInfo() {
        DynamicObject frameworkObj = FrameworkServiceHelper.getEnabledFramework();
        this.bindLogo(frameworkObj);
        this.getPageCache().put("frameworkId", Long.toString(frameworkObj.getLong("id")));
        this.bindBg();
    }

    private void bindLogo(DynamicObject frameworkObj) {
        String logo = frameworkObj.getString("malllogo");
        logo = StringUtils.isNotEmpty((String)logo) ? UrlService.getImageFullUrl((String)logo) : "kingdee/drp/mall/img/logo.png";
        Image image = (Image)this.getView().getControl("logo");
        image.setUrl(logo);
    }

    private void bindBg() {
        Container p = (Container)this.getView().getControl("pmaincontent");
        p.setBackgroundImg("kingdee/drp/mall/img/bg.png");
    }

    private void bindBottom() {
        Label lblBottom = (Label)this.getView().getControl(LBL_BOTTOM);
        lblBottom.setText(String.format("\u00a9%d\u91d1\u8776\u8f6f\u4ef6\uff08\u4e2d\u56fd\uff09\u6709\u9650\u516c\u53f8", DateUtil.getNowYear()));
    }

    private void openFirstPage() {
        String targetFormid = this.getTargetFormId();
        String srcFormShowParameterStr = (String)this.getView().getFormShowParameter().getCustomParam("srcFormShowParameter");
        if (StringUtils.isNotEmpty((String)targetFormid)) {
            this.showFormInMainContent(targetFormid, this.getView().getFormShowParameter().getCustomParams());
        } else if (StringUtils.isNotEmpty((String)srcFormShowParameterStr)) {
            MallFormShowParameter firstPage = new MallFormShowParameter();
            firstPage.setSrcFormParameterStr(srcFormShowParameterStr);
            firstPage.setShowModel("c");
            MallFormOpener.show(this.getView(), firstPage);
        } else {
            this.showHomePage();
        }
    }

    private void showHomePage() {
        String formId = this.getFirstOpenPage();
        if (StringUtil.isNotEmpty((String)formId)) {
            MallFormShowParameter firstPage = new MallFormShowParameter();
            firstPage.setPageType(this.getFirstPageType());
            firstPage.setLink(formId);
            MallFormOpener.show(this.getView(), firstPage);
        }
    }

    public void search(SearchEnterEvent evt) {
        this.doSearch(evt.getText());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (actionId.equals("ocrpos_switchsupply")) {
            this.closeCallBackSwitchSupply(returnData);
        }
    }

    private void doSearch(String searchtext) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("searchtext", searchtext);
        MallFormShowParameter mallFormShowParameter = new MallFormShowParameter();
        mallFormShowParameter.setShowType("c");
        String searchType = CommonUtils.convertObjectToString((Object)this.getView().getModel().getValue(SEARCHTYPE));
        if (searchType.equals("B")) {
            mallFormShowParameter.setLink("ocbmall_spulist");
        } else {
            mallFormShowParameter.setLink("ocbmall_quickorder");
        }
        mallFormShowParameter.setPageType("b");
        mallFormShowParameter.setShowModel("a");
        MallFormOpener.show(this.getView(), mallFormShowParameter, customParam);
    }

    private void clearNavClickStyle() {
        String navbarKey = this.getModel().getDataEntity().getString("nav_m_last");
        HashMap uiParam = new HashMap(0);
        String borderColor = "#FFFFFF";
        HashMap<String, String> b = new HashMap<String, String>(0);
        b.put("b", "2px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>(0);
        style.put("b", b);
        uiParam.put("s", style);
        this.getView().updateControlMetadata(navbarKey, uiParam);
    }

    private void showSwitchSupply() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"ocdbd_channel_authorize", (boolean)false, (int)0, (boolean)true);
        parameter.setFormId("ocrpos_switchsupply");
        parameter.setCaption("\u5207\u6362\u4f9b\u8d27\u5173\u7cfb");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ocrpos_switchsupply");
        parameter.setCloseCallBack(closeCallBack);
        this.setSwitchSupplyFilters(parameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setSwitchSupplyFilters(ListShowParameter parameter) {
        List qFilters = parameter.getListFilterParameter().getQFilters();
        List orderChannelIds = CUserHelper.getAuthorizedChannelIdList();
        QFilter qFilter = new QFilter("orderchannel", "in", (Object)orderChannelIds);
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilters.add(qFilter);
    }

    private void updateEmptyTip(String searchType) {
        HashMap fieldMap = new HashMap(1);
        HashMap<String, String> itemMap = new HashMap<String, String>(3);
        if (searchType.equals("B")) {
            itemMap.put("zh_CN", "\u8bf7\u8f93\u5165SPU\u540d\u79f0\u3001\u7f16\u7801");
            itemMap.put("en_US", "\u8bf7\u8f93\u5165SPU\u540d\u79f0\u3001\u7f16\u7801");
            itemMap.put("zh_TW", "\u8acb\u8f38\u5165SPU\u540d\u7a31\u3001\u7de8\u78bc");
        } else {
            itemMap.put("zh_CN", "\u8bf7\u8f93\u5165\u5546\u54c1\u540d\u79f0\u3001\u7f16\u7801\u3001\u6761\u5f62\u7801");
            itemMap.put("en_US", "\u8bf7\u8f93\u5165\u5546\u54c1\u540d\u79f0\u3001\u7f16\u7801\u3001\u6761\u5f62\u7801");
            itemMap.put("zh_TW", "\u8acb\u8f38\u5165\u5546\u54c1\u540d\u7a31\u3001\u7de8\u78bc\u3001\u689d\u78bc");
        }
        fieldMap.put("emptytip", itemMap);
        this.getView().updateControlMetadata(Search, fieldMap);
    }

    private DynamicObjectCollection getSupplyRelData() {
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        if (channelIds.size() > 0) {
            return MallUserHelper.getChannelAuthByOrderChannelId(channelIds);
        }
        return null;
    }

    private void bindSupplyRel() {
        DynamicObjectCollection supplyRelColl = this.getSupplyRelData();
        if (supplyRelColl == null || supplyRelColl.size() == 0) {
            return;
        }
        long supplyRelId = ((DynamicObject)supplyRelColl.get(0)).getLong("id");
        this.bindSupplyRel(supplyRelId);
    }

    private void bindSupplyRel(long supplyId) {
        if (supplyId == 0L) {
            return;
        }
        this.getModel().setValue(SUPPLYREL, (Object)supplyId);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject supplyRel = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)SUPPLYREL);
        if (supplyRel != null) {
            String supplyRelName = DynamicObjectUtils.getString((DynamicObject)supplyRel, (String)"name");
            DynamicObject orderChannel = DynamicObjectUtils.getDynamicObject((DynamicObject)supplyRel, (String)"orderchannel");
            String orderChannelName = orderChannel.getString("name");
            String description = String.format("%s\uff08%s\uff09", orderChannelName, "\u4f9b\u8d27\u65b9\uff1a" + supplyRelName);
            this.getModel().setValue("supplyrelname", (Object)description);
        }
    }

    private void closeCallBackSwitchSupply(Object returnData) {
        long supplyId = CommonUtils.stringToLong((Object)returnData);
        if (supplyId == 0L) {
            return;
        }
        this.bindSupplyRel(supplyId);
    }

    private void addVectorClickListener(String key) {
        Vector vector = (Vector)this.getControl(key);
        if (vector != null) {
            vector.addClickListener((ClickListener)this);
        }
    }
}

