/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.std;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.util.JSONUtils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocrpos.common.model.nav.NavItem;
import kd.occ.ocrpos.formplugin.std.DefaultMallBasePlugin;

public class DefaultNavBasePlugin
extends DefaultMallBasePlugin {
    public final void showNav(List<Container> controlItems, List<NavItem> dataList) {
        int navDataListSize = dataList.size();
        int controlSize = controlItems.size();
        ArrayList<String> keys = new ArrayList<String>(0);
        if (navDataListSize < controlSize) {
            for (int i = navDataListSize; i < controlSize; ++i) {
                keys.add(controlItems.get(i).getKey());
            }
        }
        if (navDataListSize == 0) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, keys.toArray(new String[0]));
        keys.clear();
        String firstPage = null;
        String firstPageType = null;
        for (int i = 0; i < dataList.size(); ++i) {
            ((Label)this.getView().getControl(controlItems.get(i).getKey() + "_title")).setText(dataList.get(i).getName());
            this.setNavValue(controlItems.get(i).getKey(), dataList.get(i));
            keys.add(controlItems.get(i).getKey());
            if (!dataList.get(i).isDefaultOpen() && (firstPage != null || !StringUtils.isNotEmpty((String)dataList.get(i).getLink()))) continue;
            firstPage = dataList.get(i).getLink();
            firstPageType = dataList.get(i).getPageType();
        }
        this.setFirstOpenPage(firstPage);
        this.setFirstPageType(firstPageType);
        this.getView().setVisible(Boolean.TRUE, keys.toArray(new String[keys.size()]));
    }

    public final List<Container> getMainNavItems() {
        return this.getSpecNavItems("nav_first_panel", "nav_m_");
    }

    public final List<Container> getSecNavItems() {
        return this.getSpecNavItems("nav_sec_panel", "nav_s_");
    }

    public final List<Label> getSecNavCtrlItems() {
        return this.getSecNavItems("nav_sec_panel", "nav_s_");
    }

    private List<Container> getSpecNavItems(String navPanel, String navKeyPattlen) {
        Container sourceContainer = (Container)this.getView().getControl(navPanel);
        List items = sourceContainer.getItems();
        ArrayList<Container> navItems = new ArrayList<Container>();
        for (Control item : items) {
            if (item.getKey().indexOf(navKeyPattlen) < 0 || !(item instanceof Container)) continue;
            navItems.add((Container)item);
        }
        return navItems;
    }

    private List<Label> getSecNavItems(String navPanel, String navKeyPattlen) {
        Container sourceContainer = (Container)this.getView().getControl(navPanel);
        List items = sourceContainer.getItems();
        ArrayList<Label> navItems = new ArrayList<Label>();
        for (Control item : items) {
            if (!item.getKey().contains(navKeyPattlen) || !(item instanceof Container)) continue;
            Container secondContainer = (Container)item;
            List secItems = secondContainer.getItems();
            for (Control secItem : secItems) {
                if (!secItem.getKey().contains(navKeyPattlen) || !(secItem instanceof Label)) continue;
                navItems.add((Label)secItem);
            }
        }
        return navItems;
    }

    public final String getNavValueKey(String navItemKey) {
        return navItemKey + "_value";
    }

    private void setLinkTitle(String key, String name) {
        HashMap<String, LocaleString> item = new HashMap<String, LocaleString>();
        item.put("text", new LocaleString(name));
        this.getView().updateControlMetadata(key, item);
    }

    public final void setNavValue(String navKey, NavItem value) {
        try {
            this.getModel().setValue(this.getNavValueKey(navKey), (Object)JSONUtils.toString((Object)value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final NavItem getNavValue(String navKey) {
        String valueStr = this.getModel().getDataEntity().getString(this.getNavValueKey(navKey));
        try {
            return (NavItem)JSONUtils.cast((String)valueStr, NavItem.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void setClickedStyle(String key, boolean isClick) {
        HashMap uiParam = new HashMap(0);
        String borderColor = "#FFFFFF";
        if (isClick) {
            borderColor = "themeColor";
        }
        HashMap<String, String> b = new HashMap<String, String>(0);
        b.put("b", "3px_solid_" + borderColor);
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>(0);
        style.put("b", b);
        uiParam.put("s", style);
        this.getView().updateControlMetadata(key, uiParam);
    }
}

