/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.std;

import java.util.EventObject;
import java.util.List;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocrpos.business.helper.NavigationServiceHelper;
import kd.occ.ocrpos.common.MallFormOpener;
import kd.occ.ocrpos.common.MallFormShowParameter;
import kd.occ.ocrpos.common.model.nav.NavItem;
import kd.occ.ocrpos.formplugin.std.DefaultNavBasePlugin;

public class DefaultNavPlugin
extends DefaultNavBasePlugin {
    public void initialize() {
        this.addClickListeners((String[])this.getMainNavItems().stream().map(Control::getKey).toArray(String[]::new));
        this.addClickListeners((String[])this.getSecNavCtrlItems().stream().map(Control::getKey).toArray(String[]::new));
    }

    public void beforeBindData(EventObject e) {
        this.bindNavigationbar();
    }

    private void bindNavigationbar() {
        String cacheFrameworkId = this.getPageCache().get("frameworkId");
        if (StringUtils.isEmpty((String)cacheFrameworkId)) {
            return;
        }
        Long frameworkId = Long.valueOf(cacheFrameworkId);
        this.bindMainNav(frameworkId);
    }

    private void bindMainNav(Long frameworkId) {
        List<NavItem> navList = NavigationServiceHelper.getNavigationMapByFrameworkId(frameworkId);
        if (navList == null || navList.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"firstnav"});
            return;
        }
        this.showNav(this.getMainNavItems(), navList);
        this.bindSubNav(navList.get(0).getChild());
    }

    private void bindSubNav(List<NavItem> subNavList) {
        if (subNavList == null || subNavList.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"secnav"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"secnav"});
        this.showNav(this.getSecNavItems(), subNavList);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        String ver = "";
        if (source instanceof Control) {
            ver = ((Control)source).getKey();
            if (source instanceof Label) {
                ver = ver.replace("_title", "");
            }
        }
        if (kd.bos.util.StringUtils.isEmpty((String)ver)) {
            return;
        }
        String mLastClick = this.getModel().getDataEntity().getString("nav_m_last");
        if (StringUtils.isNotEmpty((String)mLastClick)) {
            super.setClickedStyle(mLastClick, false);
        }
        NavItem navItem = this.getNavValue(ver);
        if (!ver.contains("_title")) {
            ver = String.join((CharSequence)"", ver, "_title");
        }
        super.setClickedStyle(ver, true);
        this.getModel().setValue("nav_m_last", (Object)ver);
        if (navItem.isMain()) {
            this.bindSubNav(navItem.getChild());
        }
        MallFormShowParameter mallFormShowParameter = new MallFormShowParameter();
        mallFormShowParameter.setLink(navItem.getLink());
        mallFormShowParameter.setPageType(navItem.getPageType());
        mallFormShowParameter.setShowType(navItem.getShowType());
        mallFormShowParameter.setShowModel(navItem.getShowModel());
        MallFormOpener.show(this.getView(), mallFormShowParameter);
    }
}

