/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocrpos.formplugin.switchsupply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class SwitchSupplyPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    private static final String BUTTON_KEY = "buttonKey";
    private static final String KEY_ENTRYENTITY = "billlistap";
    private static final String DOUBLE_CLICK = "doubleClick";
    private static final String BUTTON_OK = "btnok";
    private static final String BUTTON_CLOSE = "btnclose";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (listShowParameter != null) {
            listShowParameter.getListFilterParameter().setOrderBy("orderchannel.name asc");
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setBasedataCoreQFilters(new ArrayList(0));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
        BillList billList = (BillList)this.getView().getControl(KEY_ENTRYENTITY);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.getPageCache().put(BUTTON_KEY, DOUBLE_CLICK);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button btn = (Button)source;
            String btnKey = btn.getKey();
            if (BUTTON_CLOSE.equals(btnKey)) {
                this.getPageCache().remove(BUTTON_KEY);
            } else {
                this.getPageCache().put(BUTTON_KEY, btnKey);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String btnKey = this.getPageCache().get(BUTTON_KEY);
        if (btnKey == null) {
            this.getView().returnDataToParent(null);
        } else {
            ListSelectedRowCollection selectedRows = ((AbstractListView)e.getSource()).getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().returnDataToParent(null);
            } else {
                Object supplyId = selectedRows.get(0).getPrimaryKeyValue();
                boolean bExists = QueryServiceHelper.exists((String)"ocdbd_channel_authorize", (Object)supplyId);
                if (!bExists) {
                    e.setCancel(true);
                    this.getView().showErrorNotification("\u4f9b\u8d27\u5173\u7cfb\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u5e76\u91cd\u65b0\u9009\u62e9\u3002");
                    return;
                }
                this.getView().returnDataToParent(supplyId);
            }
        }
    }
}

