/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.channel;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobExtPlugin;

public class ChannelMobEdit
extends OcbaseFormMobExtPlugin
implements BeforeF7SelectListener {
    private static final String[] SALEORGENTRYFIELD = new String[]{"saleorginfonum", "department", "saler"};
    private static final String[] CLASSENTRYFIELD = new String[]{"classstandard", "channelclass"};
    private static final String ONCLICKCOMPLETE = "onclickcomplete";

    public String[] getPageHeadField() {
        return new String[]{"logo", "name", "number", "status", "regstatus", "enable", "channeltype", "channelproperty", "saleorg", "customer", "grade", "parent", "creditcode", "balancechannel", "orderchannel", "paychannel", "dispatchchannel", "relatedperson", "invcontrolmode", "area", "address", "phone", "fax", "contact", "contactphone"};
    }

    public String getSourceFormId() {
        return "ocdbd_channel";
    }

    public void registerListener(EventObject e) {
        this.addF7Listener(this, new String[]{"channelclass", "parent", "balancechannel", "orderchannel", "paychannel", "dispatchchannel"});
        super.registerListener(e);
    }

    protected void initData(long id) {
        super.initData(id);
        if (this.getBillData() != null) {
            DynamicObjectCollection saleOrgEntryPageData = this.getModel().getEntryEntity("slaeorginfo");
            DynamicObjectCollection saleOrgEntry = this.getBillData().getDynamicObjectCollection("slaeorginfo");
            if (saleOrgEntry != null && !saleOrgEntry.isEmpty()) {
                for (DynamicObject saleOrg : saleOrgEntry) {
                    DynamicObject saleOrgPageData = saleOrgEntryPageData.addNew();
                    saleOrgPageData.set("entryid", (Object)saleOrg.getLong("id"));
                    this.setData(saleOrg, saleOrgPageData, SALEORGENTRYFIELD);
                    MobExtendHelper.setOrmExtToMobExt((DynamicObject)saleOrgPageData, (DynamicObject)saleOrg, (String)this.getView().getEntityId(), (String)"ocdbd_channel");
                }
            }
            DynamicObjectCollection channelClassEntryPageData = this.getModel().getEntryEntity("channelclassentity");
            DynamicObjectCollection channelClassEntry = this.getBillData().getDynamicObjectCollection("channelclassentity");
            if (channelClassEntry != null && !channelClassEntry.isEmpty()) {
                for (DynamicObject channelClass : channelClassEntry) {
                    DynamicObject channelClassPageData = channelClassEntryPageData.addNew();
                    channelClassPageData.set("classentryid", (Object)channelClass.getLong("id"));
                    this.setData(channelClass, channelClassPageData, CLASSENTRYFIELD);
                    MobExtendHelper.setOrmExtToMobExt((DynamicObject)channelClassPageData, (DynamicObject)channelClass, (String)this.getView().getEntityId(), (String)"ocbsoc_returnorder");
                }
            }
        }
        if (this.getBillData() != null && !"A".equals(this.getBillData().getString("status"))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "channelclass": {
                DynamicObject classStandard = (DynamicObject)this.getModel().getValue("classstandard", evt.getRow());
                QFilter filter = new QFilter("classstandard", "=", (Object)(classStandard != null ? classStandard.getLong("id") : 0L));
                filter.and("isleaf", "=", (Object)Checked.YES.toString());
                evt.getFormShowParameter().setHasRight(true);
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)filter);
                break;
            }
            case "parent": 
            case "balancechannel": 
            case "orderchannel": 
            case "paychannel": 
            case "dispatchchannel": {
                List channelIds = CUserHelper.getAuthorizedChannelIdList();
                QFilter filter = new QFilter("id", "in", (Object)channelIds);
                F7Utils.addF7Filter((BeforeF7SelectEvent)evt, (QFilter)filter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String key;
        switch (key = evt.getOperateKey()) {
            case "save": {
                DynamicObject channel = this.saveChannel(false, key);
                if (channel == null) break;
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                break;
            }
            case "onclickcomplete": {
                this.oneClickComplete(false);
                break;
            }
            case "submit": {
                this.submit(false);
                break;
            }
            case "unsubmit": 
            case "enable": 
            case "disable": 
            case "audit": 
            case "unaudit": {
                OperateOption operateOption = CommonUtils.getMutexOperateOption();
                long channelId = (Long)this.getModel().getValue("id");
                OperationResult result = OperationServiceHelper.executeOperate((String)key, (String)"ocdbd_channel", (Object[])new Object[]{channelId}, (OperateOption)operateOption);
                if (!result.isSuccess()) {
                    throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
                }
                DynamicObject channelInfo = BusinessDataServiceHelper.loadSingle((Object)channelId, (String)this.getSourceFormId());
                this.getModel().setValue("status", channelInfo.get("status"));
                this.getModel().setValue("enable", channelInfo.get("enable"));
                if (key.equals("submit")) {
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                if (!key.equals("unaudit") && !key.equals("unsubmit")) break;
                this.getView().setStatus(OperationStatus.EDIT);
                break;
            }
        }
        super.afterDoOperation(evt);
    }

    private void submit(boolean ignorewarn) {
        DynamicObject channel = this.saveChannel(ignorewarn, "submit");
        if (channel == null) {
            return;
        }
        long channelId = (Long)this.getModel().getValue("id");
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ocdbd_channel", (Object[])new Object[]{channelId}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        this.getView().setStatus(OperationStatus.VIEW);
        DynamicObject channelInfo = BusinessDataServiceHelper.loadSingle((Object)channelId, (String)this.getSourceFormId());
        this.getModel().setValue("status", channelInfo.get("status"));
        this.getModel().setValue("enable", channelInfo.get("enable"));
        this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f");
    }

    private void oneClickComplete(boolean ignorewarn) {
        DynamicObject channel = this.saveChannel(ignorewarn, ONCLICKCOMPLETE);
        if (channel == null) {
            return;
        }
        long channelId = (Long)this.getModel().getValue("id");
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)"submit", (String)"ocdbd_channel", (Object[])new Object[]{channelId}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        this.getView().setStatus(OperationStatus.VIEW);
        result = OperationServiceHelper.executeOperate((String)"audit", (String)"ocdbd_channel", (Object[])new Object[]{channelId}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        DynamicObject channelInfo = BusinessDataServiceHelper.loadSingle((Object)channelId, (String)this.getSourceFormId());
        this.getModel().setValue("status", channelInfo.get("status"));
        this.getModel().setValue("enable", channelInfo.get("enable"));
        this.getView().showSuccessNotification("\u4e00\u952e\u5b8c\u6210\u6210\u529f");
    }

    private DynamicObject saveChannel(boolean ignorewarn, String opKey) {
        long id = (Long)this.getModel().getValue("id");
        DynamicObject channel = null;
        if (id > 0L) {
            channel = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocdbd_channel");
            if (channel == null) {
                throw new KDBizException("\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\u3002");
            }
        } else {
            channel = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_channel");
            channel.set("creator_id", (Object)UserUtil.getCurrUserId());
        }
        this.getPageDataToOrmData(channel);
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        operateOption.setVariableValue("ignorewarn", String.valueOf(ignorewarn));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(ignorewarn));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ocdbd_channel", (DynamicObject[])new DynamicObject[]{channel}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List errorInfo = result.getAllErrorOrValidateInfo();
            if (errorInfo != null && !errorInfo.isEmpty()) {
                for (IOperateInfo opInfo : errorInfo) {
                    if (!(opInfo instanceof OperateErrorInfo) || !ErrorLevel.Warning.name().equals(((OperateErrorInfo)opInfo).getErrorLevel())) continue;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(opKey, (IFormPlugin)this);
                    this.getView().showConfirm(opInfo.getMessage() + ",\u662f\u5426\u7ee7\u7eed\u3002", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    return null;
                }
            }
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        this.getModel().setValue("id", (Object)channel.getLong("id"));
        return channel;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean isYes = messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes);
        if (!isYes) {
            return;
        }
        switch (callBackId) {
            case "save": {
                DynamicObject channel = this.saveChannel(true, "save");
                if (channel == null) break;
                this.getView().showSuccessNotification("\u4fdd\u5b58\u6210\u529f");
                break;
            }
            case "submit": {
                this.submit(true);
                break;
            }
            case "onclickcomplete": {
                this.oneClickComplete(true);
                break;
            }
        }
        super.confirmCallBack(messageBoxClosedEvent);
    }

    private void getPageDataToOrmData(DynamicObject channel) {
        this.setData(this.getModel().getDataEntity(), channel, this.getPageHeadField());
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)channel, (String)this.getView().getEntityId(), (String)"ocdbd_channel");
        DynamicObjectCollection slaeorgInfoPageData = this.getModel().getEntryEntity("slaeorginfo");
        DynamicObjectCollection slaeorgInfo = channel.getDynamicObjectCollection("slaeorginfo");
        if (slaeorgInfoPageData != null && !slaeorgInfoPageData.isEmpty()) {
            List ormEntryIds = slaeorgInfo.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Map ormEntryMap = slaeorgInfo.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (r1, r2) -> r1));
            for (DynamicObject itemPageData : slaeorgInfoPageData) {
                long entryid = itemPageData.getLong("entryid");
                DynamicObject item = null;
                if (entryid != 0L) {
                    item = (DynamicObject)ormEntryMap.get(entryid);
                    ormEntryIds.remove(entryid);
                } else {
                    item = slaeorgInfo.addNew();
                }
                this.setData(itemPageData, item, SALEORGENTRYFIELD);
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)itemPageData, (DynamicObject)item, (String)this.getView().getEntityId(), (String)"ocdbd_channel");
            }
            slaeorgInfo.removeIf(r -> ormEntryIds.contains(r.getLong("id")));
        }
        DynamicObjectCollection channelclassPageData = this.getModel().getEntryEntity("channelclassentity");
        DynamicObjectCollection channelclass = channel.getDynamicObjectCollection("channelclassentity");
        if (channelclassPageData != null && !channelclassPageData.isEmpty()) {
            List ormEntryIds = channelclass.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            Map ormEntryMap = channelclass.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity(), (r1, r2) -> r1));
            for (DynamicObject itemPageData : channelclassPageData) {
                long entryid = itemPageData.getLong("classentryid");
                DynamicObject item = null;
                if (entryid != 0L) {
                    item = (DynamicObject)ormEntryMap.get(entryid);
                    ormEntryIds.remove(entryid);
                } else {
                    item = channelclass.addNew();
                }
                this.setData(itemPageData, item, CLASSENTRYFIELD);
                MobExtendHelper.setMobExtToOrmExt((DynamicObject)itemPageData, (DynamicObject)item, (String)this.getView().getEntityId(), (String)"ocdbd_channel");
            }
            channelclass.removeIf(r -> ormEntryIds.contains(r.getLong("id")));
        }
    }
}

