/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.channel;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileSearch;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;
import kd.occ.ocepfp.common.util.StringUtil;

public class ChannelPlugin
extends OcbaseFormMobPlugin
implements MobileSearchTextChangeListener,
MobileSearchCancelListener,
BeforeF7SelectListener,
EntryGridBindDataListener {
    public static final String OCSAA_CHANNEL = "ocsaa_channel";
    public static final String OCDMA_SALEORDER_LIST = "ocdma_saleorder_list";
    private static final String SEARCH_AP = "search";
    private static final String ENTRYENTITY_AP = "entryentity";
    private static final String ORDER_QUERY_BTN = "orderquery";
    private static final String BALANCE_QUERY_BTN = "balancequery";
    private static final String CUSTOMER_ORDER_BTN = "customerorder";
    private static final String RETURN_ORDER_BTN = "returnorder";
    private static final String SUPPLYRELATION_BASEDATA = "supplyrelation";
    private static final String ENTRY_ROW_CLICK = "entryrowclick";
    private static final String OP_applychannel = "applychannel";
    private static final String CHANNELPANEL = "channelpanel";
    public static final String OPERATE_BTN_KEY = "OPERATE_BTN_KEY";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSTOMER_ORDER_BTN, RETURN_ORDER_BTN, BALANCE_QUERY_BTN, ORDER_QUERY_BTN, CHANNELPANEL});
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH_AP);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchCancelListener((MobileSearchCancelListener)this);
        this.addF7Listener(this, new String[]{SUPPLYRELATION_BASEDATA});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "supplyrelation": {
                int rowIndex = this.getCurrentRowIndex(ENTRYENTITY_AP);
                List<QFilter> qFilter = null;
                switch (this.getPageCache().get(OPERATE_BTN_KEY)) {
                    case "entryrowclick": {
                        qFilter = this.getSupplyRelationFilterWithChannel(rowIndex);
                        break;
                    }
                    case "customerorder": 
                    case "returnorder": {
                        qFilter = this.getSupplyRelationFilter(rowIndex);
                        break;
                    }
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, qFilter);
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SUPPLYRELATION_BASEDATA));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String key = e.getActionId();
        Object returnData = e.getReturnData();
        block4 : switch (key) {
            case "supplyrelation": {
                ListSelectedRowCollection returnRowCollection = (ListSelectedRowCollection)returnData;
                if (returnRowCollection.size() == 0) break;
                long supplyRelationId = (Long)returnRowCollection.get(0).getPrimaryKeyValue();
                switch (this.getPageCache().get(OPERATE_BTN_KEY)) {
                    case "customerorder": {
                        this.jumpToCustomerOrder(supplyRelationId);
                        break block4;
                    }
                    case "returnorder": {
                        this.jumpToReturnOrder(supplyRelationId);
                        break block4;
                    }
                }
                break;
            }
            case "channelpanel": {
                this.getView().updateView();
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.initChannelInfo(1);
        super.beforeBindData(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY_AP);
        HashMap<String, Object> customParam = new HashMap<String, Object>(2);
        switch (key) {
            case "orderquery": {
                customParam.put("fromFormId", OCSAA_CHANNEL);
                customParam.put("channelId", this.getOrderChannelId(index));
                this.showMobileForm(OCDMA_SALEORDER_LIST, customParam);
                break;
            }
            case "balancequery": {
                customParam.put("channelId", this.getOrderChannelId(index));
                this.showMobileForm("ocdma_amountindex", customParam);
                break;
            }
            case "customerorder": {
                this.getPageCache().put(OPERATE_BTN_KEY, CUSTOMER_ORDER_BTN);
                DynamicObjectCollection supplyRelationCollection = this.getSupplyRelationCollection(index);
                if (supplyRelationCollection.size() == 0) {
                    this.getView().showTipNotification("\u5f53\u524d\u6e20\u9053\u65e0\u5bf9\u5e94\u7684\u4f9b\u8d27\u5173\u7cfb");
                    break;
                }
                if (supplyRelationCollection.size() == 1) {
                    this.jumpToCustomerOrder(((DynamicObject)supplyRelationCollection.get(0)).getLong("id"));
                    break;
                }
                BasedataEdit bizItem = (BasedataEdit)this.getControl(SUPPLYRELATION_BASEDATA);
                if (bizItem == null) break;
                bizItem.click();
                break;
            }
            case "returnorder": {
                this.getPageCache().put(OPERATE_BTN_KEY, RETURN_ORDER_BTN);
                DynamicObjectCollection supplyRelationCollection = this.getSupplyRelationCollection(index);
                if (supplyRelationCollection.isEmpty()) {
                    this.getView().showTipNotification("\u5f53\u524d\u6e20\u9053\u65e0\u5bf9\u5e94\u7684\u4f9b\u8d27\u5173\u7cfb");
                    break;
                }
                if (supplyRelationCollection.size() == 1) {
                    this.jumpToReturnOrder(((DynamicObject)supplyRelationCollection.get(0)).getLong("id"));
                    break;
                }
                BasedataEdit bizItem = (BasedataEdit)this.getControl(SUPPLYRELATION_BASEDATA);
                if (bizItem == null) break;
                bizItem.click();
                break;
            }
            case "channelpanel": {
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId("ocsaa_channelmobedit");
                mobileFormShowParameter.setCustomParam("id", (Object)this.getModel().getValue("channel_id").toString());
                mobileFormShowParameter.setStatus(OperationStatus.EDIT);
                mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CHANNELPANEL));
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
        }
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.getView().updateView();
    }

    public void cancel() {
        this.getView().updateView();
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY_AP);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    private void initChannelInfo(int pageIndex) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        List<Object> channelIds = this.getChannelIds();
        CardEntry itemList = (CardEntry)this.getView().getControl(ENTRYENTITY_AP);
        AbstractGrid.GridState entryState = itemList.getEntryState();
        Integer pageRows = entryState.getPageRows();
        int rowCount = channelIds.size();
        int pageCount = rowCount / pageRows + (rowCount % pageRows > 0 ? 1 : 0);
        if (pageIndex > pageCount) {
            return;
        }
        int startIndex = (pageIndex - 1) * pageRows;
        if (startIndex > channelIds.size()) {
            return;
        }
        int endIndex = pageIndex * pageRows;
        endIndex = Math.min(endIndex, channelIds.size());
        List<Object> searchIds = channelIds.subList(startIndex, endIndex);
        qFilterList.add(new QFilter("id", "in", searchIds));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"id", "logo", "name", "channeltype.name", "area", "address", "currency", "status", "regstatus", "enable"}), (QFilter[])qFilterList.toArray(new QFilter[0]));
        this.createNewEntryRows(searchIds, dynamicObjects, pageIndex);
    }

    private List<Object> getChannelIds() {
        List channelIds;
        QFilter filter = null;
        String channelids = (String)this.getView().getFormShowParameter().getCustomParam("channelids");
        if (StringUtils.isNotNull((String)channelids)) {
            filter = new QFilter("id", "in", (Object)StringUtils.convertToLong((String[])channelids.split(",")));
        } else {
            List authorizedChannelIds = CUserHelper.getAuthorizedChannelIdList((boolean)false);
            filter = new QFilter("id", "in", (Object)authorizedChannelIds);
        }
        MobileSearch search = (MobileSearch)this.getView().getControl(SEARCH_AP);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{String.join((CharSequence)",", "name", "number")}));
        }
        if ((channelIds = QueryServiceHelper.queryPrimaryKeys((String)"ocdbd_channel", (QFilter[])filter.toArray(), null, (int)1000)) == null) {
            return new ArrayList<Object>();
        }
        return channelIds;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        super.entryGridBindData(e);
        List<Object> channelIds = this.getChannelIds();
        Map entryGridData = e.getData();
        int pageIndex = (Integer)entryGridData.get("pageindex");
        int pageRows = (Integer)entryGridData.get("pagerows");
        int itemCount = channelIds.size();
        int rowCount = (Integer)entryGridData.get("rowcount");
        this.getModel().getEntryEntity(ENTRYENTITY_AP);
        if (rowCount == 0 && itemCount != 0) {
            e.getData().put("pageindex", 1);
            this.initChannelInfo(1);
        } else {
            this.initChannelInfo(pageIndex + 1);
        }
        int pageCount = itemCount / pageRows + (itemCount % pageRows > 0 ? 1 : 0);
        List rows = e.getRows();
        for (RowDataEntity row : rows) {
            this.setNumFmtInfo(row);
        }
        e.getData().put("rowcount", itemCount);
        e.getData().put("datacount", itemCount);
        e.getData().put("pagecount", pageCount);
    }

    private void setNumFmtInfo(RowDataEntity rowObj) {
        CardEntry itemList = (CardEntry)this.getView().getControl(ENTRYENTITY_AP);
        EntryProp entryProp = (EntryProp)this.getModel().getProperty(itemList.getEntryKey());
        HashSet<String> ctlNumber = new HashSet<String>();
        for (IDataEntityProperty entryproperty : entryProp.getItemType().getProperties()) {
            String key;
            DynamicObject o;
            if (!(entryproperty instanceof CurrencyProp) && !(entryproperty instanceof UnitProp) || (o = (DynamicObject)entryproperty.getValueFast((Object)rowObj.getDataEntity())) == null || !ctlNumber.add(key = itemList.getKey() + "." + entryproperty.getClass().getName() + "." + o.get("number"))) continue;
            itemList.setNumFmtInfo(entryproperty, o);
        }
    }

    private void createNewEntryRows(List<Object> searchIds, DynamicObject[] dynamicObjects, int pageIndex) {
        if (dynamicObjects.length == 0) {
            return;
        }
        if (pageIndex == 1) {
            DynamicObjectCollection itemListCollection = this.getModel().getEntryEntity(ENTRYENTITY_AP);
            itemListCollection.clear();
        }
        HashMap<Long, Set<String>> orderCountMap = new HashMap<Long, Set<String>>();
        HashMap<Long, BigDecimal> orderQtyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> orderAmountMap = new HashMap<Long, BigDecimal>();
        this.getTodayOrder(searchIds, orderCountMap, orderQtyMap, orderAmountMap);
        ArrayList<DynamicObject> channelInfoList = new ArrayList<DynamicObject>(dynamicObjects.length);
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get(ENTRYENTITY_AP);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dataObject = new DynamicObject((DynamicObjectType)entityType);
            long channelId = dynamicObject.getLong("id");
            dataObject.set("channel_id", (Object)channelId);
            dataObject.set("logo", dynamicObject.get("logo"));
            dataObject.set("status", dynamicObject.get("status"));
            dataObject.set("regstatus", dynamicObject.get("regstatus"));
            dataObject.set("enable", dynamicObject.get("enable"));
            String adminId = dynamicObject.getString("area");
            String area = "";
            if (StringUtil.isNotNull((String)adminId)) {
                area = area + ChannelPlugin.getAdminDivisionName(adminId);
            }
            area = area + dynamicObject.getString("address");
            dataObject.set("area", (Object)area);
            DynamicObject currency = dynamicObject.getDynamicObject("currency");
            dataObject.set("currency_id", (Object)currency);
            dataObject.set("marketbalance", (Object)this.getMarketBalance(channelId));
            dataObject.set("prepaymentaccount", (Object)this.getPrepaymentAccount(channelId));
            dataObject.set("rebateaccount", (Object)this.getRebateAccount(channelId));
            dataObject.set("marketavailablebalance", (Object)this.getMarketAvailableBalance(channelId));
            dataObject.set("ordercount", (Object)(orderCountMap.get(channelId) == null ? 0 : ((Set)orderCountMap.get(channelId)).size()));
            dataObject.set("orderqty", orderQtyMap.get(channelId));
            dataObject.set("orderamount", orderAmountMap.get(channelId));
            channelInfoList.add(dataObject);
        }
        BusinessDataServiceHelper.loadRefence((Object[])channelInfoList.toArray(), (IDataEntityType)this.getModel().getEntryEntity(ENTRYENTITY_AP).getDynamicObjectType());
        DynamicObjectCollection itemListCollection = this.getModel().getEntryEntity(ENTRYENTITY_AP);
        if (pageIndex == 1 && !itemListCollection.isEmpty()) {
            do {
                itemListCollection.remove(0);
            } while (!itemListCollection.isEmpty());
        }
        itemListCollection.addAll(channelInfoList);
        this.getModel().updateEntryCache(itemListCollection);
    }

    private void getTodayOrder(List<Object> channelIds, Map<Long, Set<String>> orderCountMap, Map<Long, BigDecimal> orderQtyMap, Map<Long, BigDecimal> orderAmountMap) {
        if (channelIds != null && !channelIds.isEmpty()) {
            String selectFields = String.join((CharSequence)",", "billno", "orderchannelid", "sumtaxamount", "sumqty");
            QFilter filter = new QFilter("billstatus", "!=", (Object)Status.SAVED.toString());
            filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
            filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            filter.and("orderchannelid", "in", channelIds);
            DynamicObjectCollection orderInfoList = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])filter.toArray());
            if (orderInfoList != null && !orderInfoList.isEmpty()) {
                for (DynamicObject orderInfo : orderInfoList) {
                    long orderChannelId = orderInfo.getLong("orderchannelid");
                    String billNo = orderInfo.getString("billno");
                    BigDecimal qty = orderInfo.getBigDecimal("sumqty");
                    BigDecimal taxamount = orderInfo.getBigDecimal("sumtaxamount");
                    if (orderCountMap.containsKey(orderChannelId)) {
                        orderCountMap.get(orderChannelId).add(billNo);
                    } else {
                        HashSet<String> billNoSet = new HashSet<String>();
                        billNoSet.add(billNo);
                        orderCountMap.put(orderChannelId, billNoSet);
                    }
                    if (orderQtyMap.containsKey(orderChannelId)) {
                        orderQtyMap.put(orderChannelId, orderQtyMap.get(orderChannelId).add(qty));
                    } else {
                        orderQtyMap.put(orderChannelId, qty);
                    }
                    if (orderAmountMap.containsKey(orderChannelId)) {
                        orderAmountMap.put(orderChannelId, orderAmountMap.get(orderChannelId).add(taxamount));
                        continue;
                    }
                    orderAmountMap.put(orderChannelId, taxamount);
                }
            }
        }
    }

    private static String getAdminDivisionName(String adminId) {
        String adminName = "";
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(adminId));
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dynamicObjects = orm.query("bd_admindivision", "id,fullname", filters, "id asc");
        if (!dynamicObjects.isEmpty()) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            adminName = dynamicObject.getString("fullname").replace("_", "");
        }
        return adminName;
    }

    private BigDecimal getPrepaymentAccount(long channelId) {
        return (BigDecimal)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getPrepaymentAccount", (Object[])new Object[]{0L, channelId});
    }

    private BigDecimal getRebateAccount(long channelId) {
        return (BigDecimal)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"OrderService", (String)"getRebateAccount", (Object[])new Object[]{0L, channelId});
    }

    private BigDecimal getMarketBalance(long channelId) {
        return (BigDecimal)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PortalService", (String)"getMarketBalance", (Object[])new Object[]{channelId});
    }

    private BigDecimal getMarketAvailableBalance(long channelId) {
        return (BigDecimal)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PortalService", (String)"getMarketAvailableBalance", (Object[])new Object[]{channelId});
    }

    private long getOrderChannelId(int index) {
        return (Long)this.getEntryF7PKValue(ENTRYENTITY_AP, "channel", index);
    }

    private DynamicObjectCollection getSupplyRelationCollection(int index) {
        List<QFilter> qFilterList = this.getSupplyRelationFilter(index);
        return QueryServiceHelper.query((String)"ocdbd_channel_authorize", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
    }

    private List<QFilter> getSupplyRelationFilter(int index) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
        qFilterList.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilterList.add(new QFilter("orderchannel", "=", (Object)this.getOrderChannelId(index)));
        return qFilterList;
    }

    private List<QFilter> getSupplyRelationFilterWithChannel(int index) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(3);
        qFilterList.add(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        qFilterList.add(new QFilter("orderchannel", "=", (Object)this.getOrderChannelId(index)));
        qFilterList.add(new QFilter(SUPPLYRELATION_BASEDATA, "=", (Object)"B"));
        return qFilterList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (OP_applychannel.equals(key)) {
            this.openApplyChannelForm();
        }
    }

    private void openApplyChannelForm() {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId("ocsaa_channelreqmob");
        mobileFormShowParameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void jumpToCustomerOrder(long supplyRelationId) {
        this.showMobileForm("ocsaa_customerorder_add", "supplierid", String.valueOf(supplyRelationId));
    }

    private void jumpToReturnOrder(long supplyRelationId) {
        this.showMobileForm("ocbsoc_returnmobedit", "supplierid", String.valueOf(supplyRelationId));
    }
}

