/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.channel;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.customcontrol.CustomGeoMapHelper;
import kd.occ.ocbase.business.mobextends.MobExtendHelper;
import kd.occ.ocbase.common.customcontrol.custommap.CustomGeoMapPoint;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.channel.ChannelProperty;
import kd.occ.ocbase.common.enums.channel.ChannelTypeId;
import kd.occ.ocbase.common.enums.channel.SaleControlMode;
import kd.occ.ocbase.common.enums.channel.SystemPresetChannelFuction;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.ChannelUtil;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.OperationResultUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobExtPlugin;

public class ChannelReqMobEdit
extends OcbaseFormMobExtPlugin
implements BeforeF7SelectListener {
    private static final String TIP = "tip";
    private static final String OP_AUTHSUCCESS = "authsuccess";
    private static final String OP_SUBMIT = "submit";

    public String[] getPageHeadField() {
        return new String[]{"name", "number", "group", "channelproperty", "channeltype", "parent", "saleorg", "saler", "department", "relatedperson", "logo", "area", "address", "contact", "contactphone", "status", "enable", "channelfunctions", "reqdate", "currency", "grade", "creditcode", "registerstatus", "authstatus", "customer", "channel", "salecontrolmode", "longitude", "latitude", "isstore", "salechannel", "isregister", "username", "phone", "email", "botpstatus"};
    }

    public String getSourceFormId() {
        return "ocdbd_channelreq";
    }

    public void registerListener(EventObject e) {
        this.addF7Listener(this, new String[]{"group"});
        super.registerListener(e);
    }

    protected void initNewData() {
        String billNo = CodeRuleUtil.readCodeRule((String)"ocdbd_channelreq");
        this.getModel().setValue("number", (Object)billNo);
        this.getModel().setValue("reqdate", (Object)TimeServiceHelper.now());
        this.getModel().setValue("salecontrolmode", (Object)SaleControlMode.XIAOLIANGKAIDAN);
        this.getModel().setValue("channelfunctions", (Object)ChannelUtil.getCustomerFunctionIds((SystemPresetChannelFuction[])new SystemPresetChannelFuction[]{SystemPresetChannelFuction.PURCHASE, SystemPresetChannelFuction.STORAGE, SystemPresetChannelFuction.BALANCE}));
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)UserUtil.getCurrUserId(), (String)"bos_user");
        if (user != null) {
            DynamicObject channelReq = this.getModel().getDataEntity();
            channelReq.set("saler", (Object)user);
            for (DynamicObject dept : user.getDynamicObjectCollection("entryentity")) {
                if (dept.getBoolean("ispartjob")) continue;
                channelReq.set("department", (Object)dept.getDynamicObject("dpt"));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String channelReqMobType;
        super.afterCreateNewData(e);
        this.initFieldsSetting();
        if (this.billData != null && !"A".equals(this.billData.getString("status"))) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ("A".equals(channelReqMobType = SysParamsUtil.getChannelReqMobileType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OP_AUTHSUCCESS});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OP_SUBMIT});
        }
    }

    private void initFieldsSetting() {
        String[] channelTypeIds;
        RequestContext requestContext = RequestContext.get();
        String userType = requestContext.getUserType();
        if ("4".equals(userType)) {
            this.setDisVisible(new String[]{"saleorg"});
            this.setUnEnable(new String[]{"parent"});
            long parent = this.getAgencyChannel();
            this.getModel().setItemValueByID("parent", (Object)parent);
            DynamicObject parentChannel = this.getF7Value("parent");
            if (parentChannel != null) {
                Object saleOrg = parentChannel.get("saleorg");
                if (saleOrg != null) {
                    this.setValue("saleorg", saleOrg);
                } else {
                    this.getView().showErrorNotification("\u4e0a\u7ea7\u6e20\u9053\u7684\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a\u3002");
                }
            }
            this.setValue("channelproperty", ChannelProperty.INDIRECT_CHANNEL);
            channelTypeIds = new String[]{ChannelTypeId.FENXIAOMENDIAN.toString(), ChannelTypeId.FENXIAOSHANGJIANMENDIAN.toString()};
        } else {
            channelTypeIds = new String[]{ChannelTypeId.FENXIAOSHANG.toString(), ChannelTypeId.FENXIAOMENDIAN.toString(), ChannelTypeId.FENXIAOSHANGJIANMENDIAN.toString()};
            this.setParentQFilter();
        }
        this.setChannelTypeQFilter(channelTypeIds);
    }

    private void setChannelTypeQFilter(String[] channelTypeIds) {
        QFilter qFilter = new QFilter("typeid", "in", (Object)channelTypeIds);
        this.setF7Filter("channeltype", qFilter);
    }

    private void setParentQFilter() {
        QFilter parentChannelQFilter = this.getParentChannelQFilter();
        this.setF7Filter("parent", parentChannelQFilter);
    }

    private long getAgencyChannel() {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        return CUserHelper.getAgencyChannelId((long)currUserId);
    }

    private QFilter getParentChannelQFilter() {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        List authorizedChannelIdList = CUserHelper.getAuthorizedChannelIdList((long)currUserId);
        return new QFilter("id", "in", (Object)authorizedChannelIdList);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "group": {
                QFilter filter = new QFilter("classstandard", "=", (Object)836014120472951808L);
                filter.and("isleaf", "=", (Object)Checked.YES.toString());
                e.getFormShowParameter().setHasRight(true);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)filter);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        switch (opKey = args.getOperateKey()) {
            case "getlocation": {
                CustomGeoMapHelper customGeoMapHelper = new CustomGeoMapHelper();
                customGeoMapHelper.getLocationWithMap(this.getView(), (IFormPlugin)this, "getlocation");
                break;
            }
            case "authsuccess": {
                this.authSuccess(false);
                break;
            }
            case "submit": {
                this.submit(false);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private void submit(boolean ignorewarn) {
        DynamicObject channelReq = this.saveChannelReq(ignorewarn, OP_SUBMIT);
        if (channelReq == null) {
            return;
        }
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_SUBMIT, (String)"ocdbd_channelreq", (Object[])new Object[]{channelReq.getLong("id")}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            return;
        }
        this.getView().showSuccessNotification("\u63d0\u4ea4\u6210\u529f");
        this.getView().setStatus(OperationStatus.VIEW);
    }

    private void authSuccess(boolean ignorewarn) {
        DynamicObject channelReq = this.saveChannelReq(ignorewarn, OP_AUTHSUCCESS);
        if (channelReq == null) {
            return;
        }
        long channelReqId = channelReq.getLong("id");
        this.getModel().setValue("id", (Object)channelReqId);
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        OperationResult result = OperationServiceHelper.executeOperate((String)OP_SUBMIT, (String)"ocdbd_channelreq", (Object[])new Object[]{channelReqId}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            return;
        }
        this.getView().setStatus(OperationStatus.VIEW);
        result = OperationServiceHelper.executeOperate((String)"audit", (String)"ocdbd_channelreq", (Object[])new Object[]{channelReqId}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            return;
        }
        result = OperationServiceHelper.executeOperate((String)OP_AUTHSUCCESS, (String)"ocdbd_channelreq", (Object[])new Object[]{channelReq.getLong("id")}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
            return;
        }
        this.getView().showSuccessNotification("\u8ba4\u8bc1\u6210\u529f");
    }

    private DynamicObject saveChannelReq(boolean ignorewarn, String opKey) {
        long id = (Long)this.getModel().getValue("id");
        DynamicObject channelReq = null;
        if (id > 0L) {
            channelReq = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ocdbd_channelreq");
            if (channelReq == null) {
                throw new KDBizException("\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\u3002");
            }
        } else {
            channelReq = BusinessDataServiceHelper.newDynamicObject((String)"ocdbd_channelreq");
            channelReq.set("creator", (Object)UserUtil.getCurrUserId());
        }
        this.getPageDataToOrmData(channelReq);
        OperateOption operateOption = CommonUtils.getMutexOperateOption();
        operateOption.setVariableValue("ignorewarn", String.valueOf(ignorewarn));
        operateOption.setVariableValue("ignoreinteraction", String.valueOf(ignorewarn));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"ocdbd_channelreq", (DynamicObject[])new DynamicObject[]{channelReq}, (OperateOption)operateOption);
        if (!result.isSuccess()) {
            List errorInfo = result.getAllErrorOrValidateInfo();
            if (errorInfo != null && !errorInfo.isEmpty()) {
                for (IOperateInfo opInfo : errorInfo) {
                    if (!(opInfo instanceof OperateErrorInfo) || !ErrorLevel.Warning.name().equals(((OperateErrorInfo)opInfo).getErrorLevel())) continue;
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(opKey, (IFormPlugin)this);
                    this.getView().showConfirm(opInfo.getMessage() + ",\u662f\u5426\u7ee7\u7eed\u3002", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    return null;
                }
            }
            throw new KDBizException(OperationResultUtil.getErrorInfoMsg((OperationResult)result));
        }
        this.getModel().setValue("id", (Object)channelReq.getLong("id"));
        return channelReq;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean isYes = messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes);
        if (!isYes) {
            return;
        }
        switch (callBackId) {
            case "submit": {
                this.submit(true);
                break;
            }
            case "authsuccess": {
                this.authSuccess(true);
                break;
            }
        }
        super.confirmCallBack(messageBoxClosedEvent);
    }

    private void getPageDataToOrmData(DynamicObject channelReq) {
        this.setData(this.getModel().getDataEntity(), channelReq, this.getPageHeadField());
        MobExtendHelper.setMobExtToOrmExt((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)channelReq, (String)this.getView().getEntityId(), (String)"ocdbd_channelreq");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "getlocation": {
                CustomGeoMapPoint point = (CustomGeoMapPoint)closedCallBackEvent.getReturnData();
                if (point == null) {
                    return;
                }
                String address = String.join((CharSequence)"", point.getAddress(), point.getTitle());
                this.getModel().setValue("address", (Object)address);
                this.getModel().setValue("latitude", (Object)point.getLatitude());
                this.getModel().setValue("longitude", (Object)point.getLongitude());
                this.getModel().setValue("area", (Object)this.findAdminDivisionId(point));
                this.setVisible(new String[]{"address", "area"});
                break;
            }
            case "tip": {
                this.getView().close();
                break;
            }
        }
    }

    private long findAdminDivisionId(CustomGeoMapPoint point) {
        String city = point.getCity();
        String name = StringUtils.isNotEmpty((String)city) ? city : point.getProvince();
        QFilter filter = new QFilter("name", "=", (Object)name);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_admindivision", (String)"id", (QFilter[])filter.toArray());
        return CollectionUtils.isEmpty((Collection)query) ? 0L : ((DynamicObject)query.get(0)).getLong("id");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "channeltype": {
                this.handlerChannelTypeChange();
                break;
            }
            case "parent": {
                this.handlerParentChange();
                break;
            }
        }
        super.propertyChanged(e);
    }

    private void handlerParentChange() {
        DynamicObject parent = this.getF7Value("parent");
        if (parent == null) {
            this.setValue("channelproperty", ChannelProperty.DIRECT_CHANNEL);
            this.setValue("salechannel", null);
            this.setValue("saleorg", null);
            this.setEnable(new String[]{"saleorg"});
        } else {
            this.setValue("channelproperty", ChannelProperty.INDIRECT_CHANNEL);
            this.setValue("salechannel", parent);
            Object saleOrg = parent.get("saleorg");
            this.setValue("saleorg", saleOrg);
            this.setUnEnable(new String[]{"saleorg"});
        }
    }

    private void handlerChannelTypeChange() {
        DynamicObject channelType = this.getF7Value("channeltype");
        ChannelTypeId customerTypeId = ChannelTypeId.ChannelTypeId((String)channelType.getString("typeid"));
        if (customerTypeId != null) {
            switch (customerTypeId) {
                case FENXIAOSHANG: {
                    this.setValue("isstore", Boolean.FALSE);
                    break;
                }
                case FENXIAOMENDIAN: 
                case FENXIAOSHANGJIANMENDIAN: {
                    this.setValue("isstore", Boolean.TRUE);
                    break;
                }
            }
        }
    }
}

