/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.channel;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.QMatches;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocbase.formplugin.base.OcbaseFormMobPlugin;

public class ChannelReqMobList
extends OcbaseFormMobPlugin
implements MobileSearchTextChangeListener,
ListRowClickListener {
    private static final String SEARCH = "search";
    private static final String BILLLISTAP = "billlistap";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String SEARCHDATESPAN = "searchdatespan";
    private static final String OP_APPLY_CHANNEL = "applychannel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileSearch search = (MobileSearch)this.getControl(SEARCH);
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter()});
    }

    private QFilter getBillFilter() {
        QFilter filter = new QFilter("creator", "=", (Object)UserUtil.getCurrUserId());
        MobileSearch search = (MobileSearch)this.getControl(SEARCH);
        String searchText = search.getText();
        if (searchText != null && !"".equals(searchText.trim())) {
            filter = filter.and(QMatches.ftlike((String[])new String[]{searchText}, (String[])new String[]{"name,number"}));
        }
        this.setDateFilter(filter);
        return filter;
    }

    private void setDateFilter(QFilter filter) {
        Date startDate = (Date)this.getValue(STARTDATE);
        Date endDate = (Date)this.getValue(ENDDATE);
        if (startDate != null && endDate != null) {
            filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)startDate));
            filter.and("reqdate", "<=", (Object)DateUtil.getDayLast((Date)endDate));
            return;
        }
        Object searchDateSpan = this.getValue(SEARCHDATESPAN);
        String selectDate = "F";
        if (!CommonUtils.isNull((Object)searchDateSpan)) {
            selectDate = searchDateSpan.toString();
        }
        switch (selectDate) {
            case "A": {
                filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfWeek()));
                break;
            }
            case "B": {
                filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                break;
            }
            case "C": {
                filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().minusDays(90L))));
                break;
            }
            case "D": {
                filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfYear((Date)new Date())));
                break;
            }
            default: {
                filter.and("reqdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("reqdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "startdate": 
            case "enddate": 
            case "searchdatespan": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter()});
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        Object pkId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId("ocsaa_channelreqmob");
        mobileFormShowParameter.setCustomParam("id", (Object)(pkId + ""));
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_APPLY_CHANNEL));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
        super.listRowClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (OP_APPLY_CHANNEL.equals(key)) {
            this.openApplyChannelForm();
        }
    }

    private void openApplyChannelForm() {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId("ocsaa_channelreqmob");
        mobileFormShowParameter.setStatus(OperationStatus.ADDNEW);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OP_APPLY_CHANNEL));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void click(MobileSearchTextChangeEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "search": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter()});
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "applychannel": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                MobileControlUtils.BillListRefresh((BillList)billList, (QFilter[])new QFilter[]{this.getBillFilter()});
                break;
            }
        }
    }
}

