/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.home;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.CarouselFigure;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.status.Status;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocsaa.formplugin.OcsaaFormMobPlugin;

public class Home
extends OcsaaFormMobPlugin {
    public static final String OCSAA_HOME = "ocsaa_home";
    public static final String OCDMA_SALEORDER_LIST = "ocdma_saleorder_list";
    private static final String CHANNEL_COUNT = "channel_count";
    private static final String KEY_CHANNEL = "channel";
    private static final String CHANNEL_COUNT_NUM = "channel_count_num";
    private static final String QUICK_CUSTOMERORDER = "customerorder";
    private static final String QUICK_MYORDER = "myorder";
    private static final String CAROUSELFIGUREAP = "carouselfigureap";
    private static final String CHANNELORDERPANEL = "channelorderpanel";
    private static final String CHANNELNOORDERPANEL = "channelnoorderpanel";
    private static final String CHANNELORDER = "channelorder";
    private static final String CHANNELNOORDER = "channelnoorder";
    private static final String ORDERCOUNT = "ordercount";
    private static final String ORDERQTY = "orderqty";
    private static final String ORDERAMOUNT = "orderamount";
    private static final String QUICK_SALERPTDETAIL = "salerptdetail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{QUICK_CUSTOMERORDER, CHANNEL_COUNT, QUICK_MYORDER, CHANNELORDERPANEL, CHANNELNOORDERPANEL, QUICK_SALERPTDETAIL});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "customerorder": 
            case "channel_count": {
                IFormView parentView = this.getView().getParentView();
                if (parentView == null) break;
                parentView.invokeOperation(KEY_CHANNEL);
                this.getView().sendFormAction(parentView);
                break;
            }
            case "myorder": {
                this.showMobileForm(OCDMA_SALEORDER_LIST, "fromFormId", OCSAA_HOME);
                break;
            }
            case "channelorderpanel": {
                String channelIds = this.getView().getPageCache().get("orderchannelset");
                channelIds = channelIds.replace("[", "").replace("]", "").replace(" ", "");
                if (!StringUtils.isNotNull((String)channelIds)) break;
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId("ocsaa_channel");
                mobileFormShowParameter.setCustomParam("channelids", (Object)channelIds);
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "channelnoorderpanel": {
                String nochannelIds = this.getView().getPageCache().get("noorderchannelset");
                nochannelIds = nochannelIds.replace("[", "").replace("]", "").replace(" ", "");
                if (!StringUtils.isNotNull((String)nochannelIds)) break;
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                mobileFormShowParameter.setFormId("ocsaa_channel");
                mobileFormShowParameter.setCustomParam("channelids", (Object)nochannelIds);
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
                break;
            }
            case "salerptdetail": {
                this.jumpToChannelSaleRpt();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCarousel();
        this.initChannelCount();
        this.initBacklog();
        this.initOrderCount();
        this.initChannelSaleData();
    }

    private void initCarousel() {
        CarouselFigure carouselFigure = (CarouselFigure)this.getControl(CAROUSELFIGUREAP);
        carouselFigure.setBasdataNumber("ocsaa_banner");
        carouselFigure.updateValue();
    }

    private void initBacklog() {
    }

    private void initChannelCount() {
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        if (channelIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u53ef\u7528\u7684\u7528\u6237\u6e20\u9053\uff0c\u8bf7\u5148\u8bbe\u7f6e\u53ef\u7528\u7684\u6e20\u9053\u3002", (String)"Home_0", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
        }
        Label control = (Label)this.getControl(CHANNEL_COUNT_NUM);
        control.setText(String.valueOf(channelIds.size()));
    }

    private void initOrderCount() {
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        if (channelIds != null && !channelIds.isEmpty()) {
            String selectFields = String.join((CharSequence)",", "billno", "orderchannelid", "sumtaxamount", "sumqty");
            QFilter filter = new QFilter("billstatus", "!=", (Object)Status.SAVED.toString());
            this.getDateFilter(filter);
            filter.and("orderchannelid", "in", (Object)channelIds);
            DynamicObjectCollection orderInfoList = QueryServiceHelper.query((String)"ocbsoc_saleorder", (String)selectFields, (QFilter[])filter.toArray());
            HashSet<String> billNoSet = new HashSet<String>();
            HashSet<Long> orderChannelSet = new HashSet<Long>();
            BigDecimal orderCount = BigDecimal.ZERO;
            BigDecimal orderAmount = BigDecimal.ZERO;
            if (orderInfoList != null && !orderInfoList.isEmpty()) {
                for (DynamicObject orderInfo : orderInfoList) {
                    billNoSet.add(orderInfo.getString("billno"));
                    orderChannelSet.add(orderInfo.getLong("orderchannelid"));
                    orderCount = orderCount.add(orderInfo.getBigDecimal("sumqty"));
                    orderAmount = orderAmount.add(orderInfo.getBigDecimal("sumtaxamount"));
                }
            }
            Label channelorder = (Label)this.getControl(CHANNELORDER);
            channelorder.setText(String.valueOf(orderChannelSet.size()));
            Label nochannelorder = (Label)this.getControl(CHANNELNOORDER);
            nochannelorder.setText(String.valueOf(channelIds.size() - orderChannelSet.size()));
            Label orderCountLabel = (Label)this.getControl(ORDERCOUNT);
            orderCountLabel.setText(String.valueOf(billNoSet.size()));
            Label orderQtyLabel = (Label)this.getControl(ORDERQTY);
            orderQtyLabel.setText(orderCount.stripTrailingZeros().toPlainString());
            Label orderAmountLabel = (Label)this.getControl(ORDERAMOUNT);
            orderAmountLabel.setText(orderAmount.stripTrailingZeros().toPlainString());
            this.getView().getPageCache().put("orderchannelset", Arrays.toString(orderChannelSet.toArray()));
            channelIds.removeAll(orderChannelSet);
            this.getView().getPageCache().put("noorderchannelset", Arrays.toString(channelIds.toArray()));
        }
    }

    private void initChannelSaleData() {
        Date firstToday = DateUtil.getDayFirst((Date)DateUtil.getNowDate());
        Date lastToday = DateUtil.getDayLast((Date)DateUtil.getNowDate());
        Date firstDayOfWeek = DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfWeek());
        Date lastDayOfWeek = DateUtil.getDayLast((Date)DateUtil.getLastDayOfWeek());
        Date firstDayOfMonth = DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth());
        Date lastDayOfMonth = DateUtil.getDayLast((Date)DateUtil.getLastDayOfMonth());
        Date startDate = firstDayOfMonth;
        Date endDate = lastDayOfMonth;
        if (startDate.compareTo(firstDayOfWeek) > 0) {
            startDate = firstDayOfWeek;
        }
        if (endDate.compareTo(lastDayOfWeek) < 0) {
            endDate = lastDayOfWeek;
        }
        BigDecimal todayamount = BigDecimal.ZERO;
        BigDecimal todayqty = BigDecimal.ZERO;
        BigDecimal weekamount = BigDecimal.ZERO;
        BigDecimal weekqty = BigDecimal.ZERO;
        BigDecimal monthamount = BigDecimal.ZERO;
        BigDecimal monthqty = BigDecimal.ZERO;
        QFilter filter = new QFilter(KEY_CHANNEL, "in", (Object)CUserHelper.getAuthorizedChannelIdList());
        filter.and("billstatus", "=", (Object)"C");
        filter.and("bizdate", ">=", (Object)startDate);
        filter.and("bizdate", "<", (Object)endDate);
        String selectFields = "bizdate,entryentity.qty,entryentity.amount";
        DynamicObjectCollection saleVolumes = QueryServiceHelper.query((String)"occbo_salevolume", (String)selectFields, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)saleVolumes)) {
            for (DynamicObject saleVolume : saleVolumes) {
                BigDecimal qty = saleVolume.getBigDecimal("entryentity.qty");
                BigDecimal amount = saleVolume.getBigDecimal("entryentity.amount");
                Date bizDate = saleVolume.getDate("bizdate");
                if (bizDate.compareTo(firstToday) >= 0 && bizDate.compareTo(lastToday) <= 0) {
                    todayqty = todayqty.add(qty);
                    todayamount = todayamount.add(amount);
                }
                if (bizDate.compareTo(firstDayOfWeek) >= 0 && bizDate.compareTo(lastDayOfWeek) <= 0) {
                    weekqty = weekqty.add(qty);
                    weekamount = weekamount.add(amount);
                }
                if (bizDate.compareTo(firstDayOfMonth) < 0 || bizDate.compareTo(lastDayOfMonth) > 0) continue;
                monthqty = monthqty.add(qty);
                monthamount = monthamount.add(amount);
            }
        }
        Label channelsaleqty_label = (Label)this.getControl("channelsaleqty");
        channelsaleqty_label.setText(todayqty.stripTrailingZeros().toPlainString());
        Label channelsaleamount_label = (Label)this.getControl("channelsaleamount");
        channelsaleamount_label.setText(this.formatAmount(todayamount));
        Label weeksaleqty_label = (Label)this.getControl("weeksaleqty");
        weeksaleqty_label.setText(weekqty.stripTrailingZeros().toPlainString());
        Label weeksaleamount_label = (Label)this.getControl("weeksaleamount");
        weeksaleamount_label.setText(this.formatAmount(weekamount));
        Label monthsaleqty_label = (Label)this.getControl("monthsaleqty");
        monthsaleqty_label.setText(monthqty.stripTrailingZeros().toPlainString());
        Label monthsaleamount_label = (Label)this.getControl("monthsaleamount");
        monthsaleamount_label.setText(this.formatAmount(monthamount));
    }

    private String formatAmount(BigDecimal amount) {
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(amount);
    }

    private void getDateFilter(QFilter filter) {
        String dateSelect;
        switch (dateSelect = (String)this.getModel().getValue("dateselect")) {
            case "B": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.asDate((LocalDateTime)LocalDateTime.now().plusDays(1L))));
                break;
            }
            case "D": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfWeek()));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getLastDayOfWeek()));
                break;
            }
            case "E": {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getFirstDayOfMonth()));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getLastDayOfMonth()));
                break;
            }
            default: {
                filter.and("orderdate", ">=", (Object)DateUtil.getDayFirst((Date)DateUtil.getNowDate()));
                filter.and("orderdate", "<", (Object)DateUtil.getDayLast((Date)DateUtil.getNowDate()));
            }
        }
    }

    private void jumpToChannelSaleRpt() {
        this.showMobileForm("ocdma_salevolumerpt", "fromFormId", OCSAA_HOME);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "dateselect": {
                this.initOrderCount();
                break;
            }
            case "saledateselect": {
                this.initChannelSaleData();
                break;
            }
        }
        super.propertyChanged(e);
    }
}

