/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.helper.CUserHelper;
import kd.occ.ocbase.common.util.DateUtil;

public class HomeChart
extends AbstractMobFormPlugin {
    private static final String POINT_LINE_CHART = "pointlinechartap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSaleChart();
    }

    private void initSaleChart() {
        Map<String, Object> chartParam = this.getChartParam();
        Map<String, Object> chartData = this.getChartData(chartParam);
        if (chartData == null) {
            return;
        }
        PointLineChart pointLineChart = (PointLineChart)this.getControl(POINT_LINE_CHART);
        this.drawXAxis(pointLineChart, chartData);
        this.drawYAxis(pointLineChart);
        this.drawLine(pointLineChart, chartData);
        this.setPointLineChartStyle(pointLineChart);
        pointLineChart.refresh();
    }

    private Map<String, Object> getChartParam() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        Date endDate = DateUtil.getDayLast((Date)DateUtil.getNowDate());
        Date bingeDate = DateUtil.dayAdd((Date)endDate, (int)-14);
        paramMap.put("endDate", endDate);
        paramMap.put("beginDate", bingeDate);
        return paramMap;
    }

    private void drawXAxis(PointLineChart pointLineChart, Map<String, Object> chartData) {
        Axis axisX = pointLineChart.createXAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"HomeChart_0", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), AxisType.category);
        this.setXAxisStyle(axisX);
        String[] category = (String[])chartData.get("category");
        axisX.setCategorys(category);
    }

    private void drawYAxis(PointLineChart pointLineChart) {
        this.createYAxis(pointLineChart, ResManager.loadKDString((String)"\u4e07", (String)"HomeChart_1", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), Position.left);
        this.createYAxis(pointLineChart, ResManager.loadKDString((String)"\u4e2a", (String)"HomeChart_2", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), Position.right);
    }

    private void drawLine(PointLineChart pointLineChart, Map<String, Object> chartData) {
        Number[] orderAmount = (Number[])chartData.get("orderAmount");
        this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u8ba2\u5355\u91d1\u989d", (String)"HomeChart_3", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), "#88BFFF", orderAmount, 0);
        Number[] orderCount = (Number[])chartData.get("orderCount");
        this.createLineSeries(pointLineChart, ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf", (String)"HomeChart_4", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]), "#F8CC57", orderCount, 1);
    }

    private void createYAxis(PointLineChart pointLineChart, String name, Position position) {
        Axis axis = pointLineChart.createYAxis(name, AxisType.value);
        this.setYAxisStyle(axis);
        axis.setPosition(position);
    }

    private List<String> getRunningDays(Date beginDate, Date endDate) {
        List lastHalfMonthDate = DateUtil.getEveryDay((Date)beginDate, (Date)endDate);
        ArrayList<String> runningDays = new ArrayList<String>(16);
        lastHalfMonthDate.forEach(date -> runningDays.add(DateUtil.getDateFormat((Date)date)));
        return runningDays;
    }

    private QFilter getGraphFilter(Date beginDate, Date endDate) {
        List channelIds = CUserHelper.getAuthorizedChannelIdList();
        if (channelIds != null && channelIds.size() > 0) {
            QFilter qFilter = new QFilter("orderchannelid", "in", (Object)channelIds);
            qFilter.and("changestatus", "!=", (Object)"B");
            qFilter.and("orderdate", ">=", (Object)beginDate);
            qFilter.and("orderdate", "<=", (Object)endDate);
            qFilter.and("billstatus", "not in", (Object)new String[]{StatusEnum.DRAFT.getValue(), StatusEnum.SUBMIT.getValue()});
            return qFilter;
        }
        return null;
    }

    private Map<String, Object[]> getBaseData(Date beginDate, Date endDate) {
        HashMap<String, Object[]> dataMap = new HashMap<String, Object[]>(16);
        ORM orm = ORM.create();
        QFilter qFilter = this.getGraphFilter(beginDate, endDate);
        if (qFilter != null) {
            try (DataSet set = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), "ocbsoc_saleorder", "id,CONCAT(CONCAT(YEAR(orderdate),'-'),CONCAT(CONCAT(MONTH(orderdate),'-'),DAYOFMONTH(orderdate))) as orderdate,sumitemamount", new QFilter[]{this.getGraphFilter(beginDate, endDate)}).groupBy(new String[]{"orderdate"}).count("ordercount").sum("sumitemamount", "orderamount").finish();){
                for (Row row : set) {
                    Object[] resultArray = new Object[]{row.getBigDecimal("orderamount"), row.getInteger("ordercount")};
                    String orderDate = this.resetDateFomate(row.getString("orderdate"));
                    dataMap.put(orderDate, resultArray);
                }
            }
            return dataMap;
        }
        return null;
    }

    private String resetDateFomate(String orderDate) {
        Date dateFormat = DateUtil.getDateFormat((String)orderDate);
        return DateUtil.getDateFormat((Date)dateFormat);
    }

    private Map<String, Object> getChartData(Map<String, Object> chartParam) {
        Date beginDate = (Date)chartParam.get("beginDate");
        Date endDate = (Date)chartParam.get("endDate");
        if (beginDate != null && endDate != null && beginDate.before(endDate)) {
            List<String> runningDays = this.getRunningDays(beginDate, endDate);
            Map<String, Object[]> baseData = this.getBaseData(beginDate, endDate);
            return this.dataProcessing(runningDays, baseData);
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u6b63\u786e\u7684\u67e5\u8be2\u533a\u95f4\uff0c\u65e0\u6cd5\u7ed8\u5236\u9500\u552e\u56fe\u8868\u3002", (String)"HomeChart_5", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
        return null;
    }

    private Map<String, Object> dataProcessing(List<String> runningDays, Map<String, Object[]> baseData) {
        HashMap<String, Object> chartData = new HashMap<String, Object>(5);
        chartData.put("category", runningDays.toArray(new String[0]));
        if (baseData != null) {
            ArrayList<BigDecimal> orderAmountList = new ArrayList<BigDecimal>(runningDays.size());
            ArrayList<Integer> orderCountList = new ArrayList<Integer>(runningDays.size());
            for (String date : runningDays) {
                Object[] values = baseData.get(date);
                if (values != null) {
                    BigDecimal orderAmount = (BigDecimal)values[0];
                    BigDecimal roundOrderAmount = orderAmount.divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
                    orderAmountList.add(roundOrderAmount);
                    Integer orderCount = (Integer)values[1];
                    orderCountList.add(orderCount);
                    continue;
                }
                orderAmountList.add(BigDecimal.ZERO);
                orderCountList.add(0);
            }
            chartData.put("orderCount", orderCountList.toArray(new Number[0]));
            chartData.put("orderAmount", orderAmountList.toArray(new Number[0]));
        } else {
            chartData.put("orderCount", new Number[runningDays.size()]);
            chartData.put("orderAmount", new Number[runningDays.size()]);
        }
        return chartData;
    }

    private void setPointLineChartStyle(PointLineChart pointLineChart) {
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        pointLineChart.setMargin(Position.right, "28px");
        pointLineChart.setShowTooltip(true);
    }

    private void setYAxisStyle(Axis axisY1) {
        Map<String, Object> lineStyle = this.getDottedLineStyle();
        HashMap<String, Map<String, Object>> splitLine = new HashMap<String, Map<String, Object>>(1);
        splitLine.put("lineStyle", lineStyle);
        axisY1.setPropValue("splitLine", splitLine);
    }

    private void setXAxisStyle(Axis axisX) {
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>(2);
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.TRUE);
        axisX.setPropValue("axisTick", axisTick);
        HashMap<String, Map<String, Object>> axisPointer = new HashMap<String, Map<String, Object>>(1);
        Map<String, Object> lineStyle = this.getDottedLineStyle();
        axisPointer.put("lineStyle", lineStyle);
        axisX.setPropValue("axisPointer", axisPointer);
        axisX.setPropValue("boundaryGap", (Object)Boolean.FALSE);
    }

    private LineSeries createLineSeries(PointLineChart pointLineChart, String name, String color, Number[] data, int index) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        Label label = new Label();
        label.setShow(true);
        label.setColor("#000000");
        expireSeries.setLabel(label);
        expireSeries.setItemColor(color);
        expireSeries.setAnimationDuration(2000);
        expireSeries.setData(data);
        expireSeries.setYAxisIndex(index);
        return expireSeries;
    }

    private Map<String, Object> getDottedLineStyle() {
        HashMap<String, Object> lineStyle = new HashMap<String, Object>(2);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        return lineStyle;
    }
}

