/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocsaa.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.occ.ocbase.business.b2b.ChannelHelper;
import kd.occ.ocbase.business.b2b.OrderHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.util.BigDecimalUtil;
import kd.occ.ocbase.common.util.CodeRuleUtil;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemNSaleControlUtil;
import kd.occ.ocbase.common.util.MobileControlUtils;
import kd.occ.ocbase.common.util.OperationUtil;
import kd.occ.ocbase.common.util.OrderQuantityUtil;
import kd.occ.ocbase.common.util.OrgUtil;
import kd.occ.ocbase.common.util.StringUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;
import kd.occ.ocsaa.formplugin.OcsaaFormMobPlugin;

public class ReturnApplyEdit
extends OcsaaFormMobPlugin
implements BeforeF7SelectListener {
    private static final String BTNSUBMIT = "btnsubmit";
    private static final String add_entry = "addentry";
    private static final String delete_entry = "deleteentry";
    private static final String op_reduce = "reduce";
    private static final String op_add = "add";
    private static final String op_selectaddress = "selectaddress";
    private static final Long combineItemTypeId = 870945697287898112L;
    private static final String OCBSOC_LIST = "ocdma_saleorder_list";
    private static final String page_channel = "ocsaa_channel";
    private static final String page_list = "ocsaa_retorder_req_list";
    private static final String EF_entryid = "entryid";
    private static final String page_retorder_index = "ocsaa_retorder_req_index";
    private static final String TO_PAGE = "toPage";
    private static final String RETORDER_INDEX_SELECT = "retapply";
    private static final String JOINRETURNBASEQTY = "joinreturnbaseqty";
    private static final String TOTALRETURNBASEQTY = "totalreturnbaseqty";
    private static final String SPLITKEY = "&";
    private DynamicObject order = null;

    private DynamicObject getOrder() {
        Object orderId = this.getParameter("orderId");
        if (orderId != null) {
            String loadName = this.getView().getParentView() != null && OCBSOC_LIST.equals(this.getView().getParentView().getEntityId()) ? "ocbsoc_saleorder" : "ocbsoc_returnorder";
            this.order = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)loadName);
        }
        return this.order;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{add_entry, op_add, delete_entry, op_reduce});
        this.addF7Listener(this, new String[]{"itemid", "consigneeaddress"});
    }

    public void afterCreateNewData(EventObject e) {
        String source;
        String string = OCBSOC_LIST.equals(this.getView().getParentView().getEntityId()) ? OCBSOC_LIST : (source = page_list.equals(this.getView().getParentView().getEntityId()) ? page_list : page_channel);
        if (this.isView()) {
            this.initViewData();
            this.initHeaderData("");
        }
        if (this.isAddNew() || this.isEdit()) {
            this.initBaseData(source);
            this.initHeaderData(source);
            this.setModelEntry(source);
        }
    }

    private void setModelEntry(String source) {
        String qty;
        if (page_channel.equals(source)) {
            return;
        }
        this.order = this.getOrder();
        IDataModel model = this.getModel();
        DynamicObjectCollection itemEntry = this.order.getDynamicObjectCollection("itementry");
        String string = qty = OCBSOC_LIST.equals(source) ? "reqqty" : "qty";
        if (itemEntry != null && itemEntry.size() > 0) {
            int[] rowIndexes = model.batchCreateNewEntryRow("itementry", itemEntry.size());
            model.setValue("entrycount", (Object)itemEntry.size());
            for (int i = 0; i < itemEntry.size(); ++i) {
                DynamicObject material;
                DynamicObject item = (DynamicObject)itemEntry.get(i);
                int rowIndex = rowIndexes[i];
                DynamicObject newEntry = this.getRowInfo("itementry", rowIndex);
                newEntry.set("itemid", item.get("itemid"));
                newEntry.set("qty", (Object)item.getInt(qty));
                newEntry.set("unit", item.get("unit"));
                newEntry.set("price", (Object)item.getBigDecimal("price"));
                newEntry.set("actualtaxprice", (Object)item.getBigDecimal("actualtaxprice"));
                if (this.getParameter("orderId") != null && OCBSOC_LIST.equals(source)) {
                    newEntry.set("srcbillentryid", item.getPkValue());
                }
                long materialId = (material = item.getDynamicObject("materialid")) != null ? material.getLong("id") : 0L;
                newEntry.set("materialid", (Object)material);
                DynamicObject unit = item.getDynamicObject("unit");
                DynamicObject baseUnit = null;
                long baseUnitId = 0L;
                BigDecimal alterBaseQty = BigDecimal.ZERO;
                DynamicObject itemDynObj = item.getDynamicObject("itemid");
                if (itemDynObj != null) {
                    newEntry.set("thumbnail", itemDynObj.get("thumbnail"));
                    baseUnit = itemDynObj.getDynamicObject("baseunit");
                    baseUnitId = baseUnit != null ? baseUnit.getLong("id") : 0L;
                    BigDecimal alterQty = item.getBigDecimal(qty);
                    if (unit != null) {
                        alterBaseQty = UnitConvertHelper.calculateDestQty((BigDecimal)alterQty, (Long)materialId, (Long)unit.getLong("id"), (Long)baseUnitId);
                    }
                    newEntry.set("baseqty", (Object)alterBaseQty);
                }
                newEntry.set("baseunit", baseUnit);
                newEntry.set("price", item.get("price"));
                newEntry.set("taxprice", item.get("taxprice"));
                newEntry.set("taxrateid", item.get("taxrateid"));
                newEntry.set("taxrate", item.get("taxrate"));
                newEntry.set("actualtaxprice", item.get("actualtaxprice"));
                newEntry.set("actualprice", item.get("actualprice"));
                newEntry.set("discountamount", item.get("discountamount"));
                newEntry.set("taxamount", item.get("taxamount"));
                newEntry.set("tax", item.get("tax"));
                newEntry.set("amount", item.get("amount"));
            }
        }
        this.calcOrderData();
        int totalQty = this.calcTotalQty();
        model.setValue("totalqty", (Object)totalQty);
        if (this.getParameter("orderId") != null && OCBSOC_LIST.equals(source)) {
            this.setDisVisible(new String[]{add_entry});
            DynamicObjectCollection itemList = this.getModel().getDataEntity(true).getDynamicObjectCollection("itementry");
            if (itemList != null && itemList.size() > 0) {
                for (int i = 0; i < itemList.size(); ++i) {
                    this.setUnEnable(i, new String[]{"itemid"});
                    this.setUnEnable(i, new String[]{"qty"});
                }
            }
        }
    }

    private void initViewData() {
        DynamicObject order = this.getOrder();
        IDataModel model = this.getModel();
        model.setValue("billno", order.get("billno"));
        model.setValue("billdate", order.get("billdate"));
        model.setValue("returnreason", order.get("returnreason"));
        model.setValue("exchangerate", order.get("exchangerate"));
        String billStatus = this.getBillStatus4View(order.get("billstatus"));
        MobileControlUtils.LabelSetValue((Label)((Label)this.getControl("billstatus")), (Object)billStatus);
        model.setValue("returnchannel", order.get("returnchannel"));
        model.setValue("saleorg", order.get("saleorg"));
        model.setValue("settlecurrencyid", order.get("settlecurrencyid"));
        model.setValue("billtype", order.get("billtype"));
        model.setValue("sumtaxamount", order.get("sumtaxamount"));
        model.setValue("remark", order.get("remark"));
        model.setValue("auditor", order.get("auditor"));
        model.setValue("auditdate", order.get("auditdate"));
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        if (itemEntry != null && itemEntry.size() > 0) {
            int[] rowIndexes = model.batchCreateNewEntryRow("itementry", itemEntry.size());
            model.setValue("entrycount", (Object)itemEntry.size());
            for (int i = 0; i < itemEntry.size(); ++i) {
                DynamicObject item = (DynamicObject)itemEntry.get(i);
                int rowIndex = rowIndexes[i];
                this.setValue("itemid", item.get("itemid"), rowIndex, false);
                this.setValue("qty", item.getInt("qty"), rowIndex, false);
                this.setValue("unit", item.get("unit"), rowIndex, false);
                this.setValue("price", item.getBigDecimal("price"), rowIndex, false);
                this.setValue("actualtaxprice", item.getBigDecimal("actualtaxprice"), rowIndex, false);
                DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
                if (itemDynObj == null) continue;
                this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex, false);
            }
        }
        int totalQty = this.calcTotalQty();
        model.setValue("totalqty", (Object)totalQty);
    }

    private void initBaseData(String fromPage) {
        Object settleCurrencyId = 0L;
        Object saleOrgId = 0L;
        Object saleChannelId = 0L;
        Object orderChannelId = 0L;
        Object settleOrgId = 0L;
        if (this.getParameter("orderId") != null) {
            this.order = this.getOrder();
            if (fromPage.equals(OCBSOC_LIST)) {
                settleCurrencyId = this.order.get("settlecurrencyid");
                saleOrgId = this.order.get("saleorgid");
                saleChannelId = this.order.get("salechannelid");
                orderChannelId = this.order.get("orderchannelid");
                settleOrgId = this.order.get("settleorgid");
            } else {
                settleCurrencyId = this.order.get("settlecurrencyid");
                saleOrgId = this.order.get("saleorg");
                saleChannelId = this.order.get("salechannel");
                orderChannelId = this.order.get("returnchannel");
                settleOrgId = this.order.get("settleorgid");
            }
        } else {
            saleOrgId = this.getParameter("supplierid");
            saleChannelId = this.getParameter("salechannelid");
            orderChannelId = this.getParameter("orderchannelid");
        }
        if (this.getParameter("salechannelid") != null) {
            this.setValue("salechannel", Long.parseLong((String)this.getParameter("salechannelid")));
        }
        this.setValue("saleorg", saleOrgId);
        this.setValue("salechannel", saleChannelId);
        this.setValue("returnchannel", orderChannelId);
        if (fromPage.equals(page_channel)) {
            DynamicObject orderChannel = (DynamicObject)this.getModel().getValue("returnchannel");
            this.setValue("settlecurrencyid", orderChannel.getLong("currency_id"));
            this.setValue("settleorgid", this.getSettleOrg(Long.parseLong(saleOrgId.toString())));
        } else {
            this.setValue("settlecurrencyid", settleCurrencyId);
            this.setValue("settleorgid", settleOrgId);
        }
        this.setValue("billtype", 1019566135634448384L);
        this.setValue("biztype", 688855385217756160L);
        this.setExRateTable();
    }

    private void setExRateTable() {
        DynamicObject settleOrg = (DynamicObject)this.getModel().getValue("settleorgid");
        if (null == settleOrg) {
            this.setValue("exchangeratetable", null);
            this.setValue("exchangerate", 1, false);
            this.setValue("basecurrencyid", null, false);
        } else {
            long exratetableId;
            DynamicObjectCollection accountingsys = QueryServiceHelper.query((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", settleOrg.getPkValue())});
            if (!CommonUtils.isNull((Object)accountingsys) && (exratetableId = ((DynamicObject)accountingsys.get(0)).getLong("exratetable")) > 0L) {
                Object orderDate;
                this.setValue("exchangeratetable", exratetableId);
                DynamicObject settleCurDynObj = this.getF7Value("settlecurrencyid");
                Object object = orderDate = this.getValue("billdate") != null ? this.getValue("billdate") : new Date();
                if (settleCurDynObj != null && orderDate != null) {
                    long settleCurId = settleCurDynObj.getLong("id");
                    long basecurrrencyId = ((DynamicObject)accountingsys.get(0)).getLong("basecurrrency");
                    this.setValue("basecurrencyid", basecurrrencyId);
                    this.setExchangeRate(settleCurId, basecurrrencyId, exratetableId, (Date)orderDate);
                }
            }
        }
    }

    private void setExchangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = this.calcExChangeRate(srcCurId, targetCurId, exRateTableId, date);
        this.setValue("exchangerate", exchangeRate);
    }

    private BigDecimal calcExChangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId.equals(targetCurId)) {
            exchangeRate = BigDecimal.valueOf(1L);
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targetCurId, (Date)date);
            if (null == exchangeRate || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                exchangeRate = BigDecimal.ONE;
            }
        }
        return exchangeRate;
    }

    private void initHeaderData(String fromPage) {
        if (this.isAddNew() || fromPage.equals(page_channel) || fromPage.equals(OCBSOC_LIST)) {
            String billNo = CodeRuleUtil.getCodeRule((String)"ocbsoc_returnorder");
            this.setValue("billno", billNo);
            IDataModel model = this.getModel();
            Object orderChanel = model.getValue("returnchannel");
            if (orderChanel != null) {
                DynamicObject receiceAddress;
                long receiveChannelId = 0L;
                DynamicObject receiveChannel = ((DynamicObject)orderChanel).getDynamicObject("orderchannel");
                long l = receiveChannelId = receiveChannel == null ? 0L : receiveChannel.getLong("id");
                if (receiveChannelId > 0L && (receiceAddress = ChannelHelper.getDefaultDeliveryAddressByChannelId((long)receiveChannelId)) != null) {
                    long receiveAddressId = receiceAddress.getLong("id");
                    this.setValue("consigneeaddress", receiveAddressId);
                }
            }
        } else if (this.isEdit()) {
            this.setValue("consigneeaddress", this.order.get("consigneeaddress"));
            this.setValue("billno", this.order.get("billno"));
            this.setValue("returnreason", this.order.get("returnreason"));
            this.setValue("id", this.order.getLong("id"));
        }
    }

    private int calcTotalQty() {
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = model.getEntryEntity("itementry");
        int totalQty = 0;
        if (itemList != null && itemList.size() > 0) {
            for (DynamicObject item : itemList) {
                totalQty += item.getInt("qty");
            }
        }
        return totalQty;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int index = this.getModel().getEntryCurrentRowIndex("itementry");
        switch (key) {
            case "add": {
                if (this.getView().getParentView() != null && OCBSOC_LIST.equals(this.getView().getParentView().getEntityId())) {
                    return;
                }
                this.add(index, "qty");
                break;
            }
            case "reduce": {
                if (this.getView().getParentView() != null && OCBSOC_LIST.equals(this.getView().getParentView().getEntityId())) {
                    return;
                }
                this.reduce(index, "qty");
            }
        }
    }

    private void add(int index, String qtyName) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyName, index);
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        this.getModel().setValue(qtyName, (Object)qty.add(orderQty), index);
    }

    private void reduce(int index, String qtyName) {
        BigDecimal qty = (BigDecimal)this.getModel().getValue(qtyName, index);
        Map<String, BigDecimal> orderQuantityRule = this.getOrderQuantity(index);
        BigDecimal orderQty = orderQuantityRule.get("qty");
        orderQty = orderQty.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : orderQty;
        BigDecimal orderMinQty = orderQuantityRule.get("minqty");
        BigDecimal newQty = qty.subtract(orderQty);
        if (newQty.compareTo(orderMinQty) < 0) {
            newQty = BigDecimal.ZERO;
        }
        this.getModel().setValue(qtyName, (Object)newQty, index);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "addentry": {
                BasedataEdit bizItem = (BasedataEdit)this.getControl("itemid");
                if (bizItem != null) {
                    bizItem.click();
                }
            }
            case "deleteentry": {
                this.calcOrderData();
                break;
            }
            case "submit": {
                if (!e.getOperationResult().isSuccess()) break;
                this.submit();
                break;
            }
            case "selectaddress": {
                BasedataEdit bizAddress = (BasedataEdit)this.getControl("consigneeaddress");
                if (bizAddress == null) break;
                bizAddress.click();
            }
        }
    }

    private void submit() {
        OperationResult submitResult;
        if (!this.validator().booleanValue()) {
            return;
        }
        DynamicObject returnOrder = null;
        returnOrder = this.getParameter("orderId") == null || OCBSOC_LIST.equals(this.getView().getParentView().getEntityId()) ? BusinessDataServiceHelper.newDynamicObject((String)"ocbsoc_returnorder") : this.getOrder();
        this.setHeaderData(returnOrder);
        this.setItemEntry(returnOrder);
        OperationResult saveResult = OperationUtil.invokeOperation((DynamicObject)returnOrder, (String)"save");
        if (saveResult.isSuccess() && (submitResult = OperationUtil.invokeOperation((DynamicObject)returnOrder, (String)"submit")).isSuccess()) {
            if (this.getParameter("orderId") != null || OCBSOC_LIST.equals(this.getView().getParentView().getEntityId())) {
                DynamicObjectCollection modelEntry = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("itementry");
                HashMap<Long, DynamicObject> modelMap = new HashMap<Long, DynamicObject>(modelEntry.size());
                for (DynamicObject temp : modelEntry) {
                    if (temp.get("srcbillentryid") == null) continue;
                    modelMap.put(temp.getLong("srcbillentryid"), temp);
                }
                DynamicObject saleOrder = this.getOrder();
                DynamicObjectCollection itemEntry = saleOrder.getDynamicObjectCollection("itementry");
                for (DynamicObject temp : itemEntry) {
                    if (modelMap.get(temp.getPkValue()) == null) continue;
                    BigDecimal baseRetQty = temp.getBigDecimal(JOINRETURNBASEQTY);
                    BigDecimal retQty = ((DynamicObject)modelMap.get(temp.getPkValue())).getBigDecimal("baseqty");
                    temp.set(JOINRETURNBASEQTY, (Object)retQty);
                    DynamicObjectCollection subEntry = temp.getDynamicObjectCollection("subentryentity");
                    if (subEntry == null || subEntry.size() == 0) continue;
                    for (DynamicObject plane : subEntry) {
                        if (plane.getLong(String.join((CharSequence)"_", "sub_itemid", "id")) != temp.getLong(String.join((CharSequence)"_", "itemid", "id"))) continue;
                        plane.set("sub_joinorderbaseqty", (Object)retQty);
                    }
                }
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
            this.toOrderList();
        }
    }

    private Boolean validator() {
        DynamicObject reason = (DynamicObject)this.getModel().getValue("returnreason");
        if (reason == null) {
            this.getView().showTipNotification("\u8bf7\u9009\u62e9\u9000\u8d27\u539f\u56e0\u3002");
            return Boolean.FALSE;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("itementry");
        if (entrys == null || entrys.size() == 0) {
            this.getView().showTipNotification("\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5546\u54c1\u660e\u7ec6\u5206\u5f55\u3002");
            return Boolean.FALSE;
        }
        int rowIndex = 0;
        for (DynamicObject entry : entrys) {
            ++rowIndex;
            Object qty = entry.get("qty");
            if (BigDecimalUtil.toBigDecimal((Object)qty).compareTo(BigDecimal.ZERO) > 0) continue;
            this.getView().showTipNotification("\u7b2c" + rowIndex + "\u884c\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a0\u3002");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void toOrderList() {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setFormId(page_retorder_index);
        mobileFormShowParameter.setCustomParam(TO_PAGE, (Object)RETORDER_INDEX_SELECT);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, page_retorder_index));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "itemid": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                if (returnData.size() == 0) {
                    Button button = (Button)this.getControl(delete_entry);
                    if (button == null) break;
                    button.click();
                    break;
                }
                this.setValue("itemid", returnData.get(0).getPrimaryKeyValue(), this.getCurrentRowIndex("itementry"));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "itemid": {
                IDataModel model = this.getModel();
                long saleOrgId = (Long)model.getValue(String.join((CharSequence)"_", "saleorg", "id"));
                long orderChannelId = (Long)model.getValue(String.join((CharSequence)"_", "returnchannel", "id"));
                List<QFilter> filters = ItemNSaleControlUtil.getItemFilterBySaleChannel((long)saleOrgId, (long)0L, (long)orderChannelId);
                if (filters == null) {
                    filters = Arrays.asList(new QFilter("id", "=", (Object)0L).toArray());
                }
                filters.add(new QFilter("itemtypeid", "!=", (Object)combineItemTypeId));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, filters);
                ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "itemid"));
                break;
            }
            case "consigneeaddress": {
                DynamicObject receiveChannel = this.getModel().getDataEntity().getDynamicObject("returnchannel");
                if (receiveChannel == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6e20\u9053\u5730\u5740\u3002", (String)"ReturnApplyEdit_0", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter addressFilter = new QFilter("orderchannel", "=", (Object)receiveChannel.getLong("id"));
                addressFilter.and("status", "=", (Object)"C");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)addressFilter);
                break;
            }
        }
    }

    private void setHeaderData(DynamicObject order) {
        IDataModel model = this.getModel();
        order.set("modifier", model.getValue("modifier"));
        order.set("modifytime", model.getValue("modifytime"));
        order.set("remark", model.getValue("remark"));
        if (this.isAddNew()) {
            order.set("creator", model.getValue("creator"));
            order.set("createtime", model.getValue("createtime"));
            order.set("billdate", (Object)new Date());
            order.set("billstatus", (Object)"A");
            order.set("saleorg", model.getValue("saleorg"));
            order.set("returnchannel", model.getValue("returnchannel"));
            order.set("billtype", model.getValue("billtype"));
            order.set("returnreason", model.getValue("returnreason"));
            order.set("consigneeaddress", model.getValue("consigneeaddress"));
            order.set("biztype", model.getValue("biztype"));
            order.set("settleorgid", model.getValue("settleorgid"));
            order.set("settlecurrencyid", model.getValue("settlecurrencyid"));
            order.set("exchangeratetable", model.getValue("exchangeratetable"));
            order.set("exchangerate", model.getValue("exchangerate"));
            order.set("exratedate", model.getValue("exratedate") != null ? model.getValue("exratedate") : new Date());
        }
        if (this.isEdit()) {
            order.set("returnreason", model.getValue("returnreason"));
        }
        BigDecimal sumtaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection itemList = model.getDataEntity(true).getDynamicObjectCollection("itementry");
        for (DynamicObject item : itemList) {
            sumtaxAmount = sumtaxAmount.add(item.getBigDecimal("actualtaxprice").multiply(item.getBigDecimal("qty")));
        }
        order.set("sumtaxamount", (Object)sumtaxAmount);
    }

    private void setItemEntry(DynamicObject order) {
        DynamicObjectCollection itemEntry = order.getDynamicObjectCollection("itementry");
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getEntryEntity("itementry");
        DynamicObject saleOrg = (DynamicObject)this.getValue("saleorg");
        long stockOrgId = OrgUtil.getInventoryOrg2Org((long)((Long)saleOrg.getPkValue()));
        DynamicObject stockOrg = null;
        if (stockOrgId > 0L) {
            stockOrg = BusinessDataServiceHelper.loadSingle((Object)stockOrgId, (String)"bos_org");
        }
        if (entrys != null && entrys.size() > 0) {
            HashMap<Long, DynamicObject> entryMap = this.initNewOrderRow(itemEntry, entrys);
            for (DynamicObject entry : entrys) {
                DynamicObject newEntry;
                long eId = entry.getLong(EF_entryid);
                if (this.isAddNew() || eId == 0L || entryMap.get(eId) == null) {
                    newEntry = itemEntry.addNew();
                    newEntry.set("ispresent", (Object)Boolean.FALSE);
                    newEntry.set("saleattrid", null);
                    newEntry.set("stocktype", null);
                } else {
                    newEntry = entryMap.get(eId);
                }
                DynamicObject itemDynObj = entry.getDynamicObject("itemid");
                newEntry.set("itemid", (Object)itemDynObj);
                DynamicObject unit = entry.getDynamicObject("unit");
                DynamicObject material = entry.getDynamicObject("materialid");
                long materialId = material != null ? material.getLong("id") : 0L;
                newEntry.set("materialid", (Object)material);
                newEntry.set("unit", (Object)unit);
                newEntry.set("qty", entry.get("qty"));
                DynamicObject baseUnit = null;
                Object assitUnit = null;
                long baseUnitId = 0L;
                BigDecimal alterBaseQty = BigDecimal.ZERO;
                if (itemDynObj != null) {
                    baseUnit = itemDynObj.getDynamicObject("baseunit");
                    baseUnitId = baseUnit != null ? baseUnit.getLong("id") : 0L;
                    BigDecimal alterQty = entry.getBigDecimal("qty");
                    if (unit != null) {
                        alterBaseQty = UnitConvertHelper.calculateDestQty((BigDecimal)alterQty, (Long)materialId, (Long)unit.getLong("id"), (Long)baseUnitId);
                    }
                    newEntry.set("baseqty", (Object)alterBaseQty);
                }
                newEntry.set("baseunit", (Object)baseUnit);
                newEntry.set("assistunitid", assitUnit);
                newEntry.set("price", entry.get("price"));
                newEntry.set("taxprice", entry.get("taxprice"));
                newEntry.set("taxrateid", entry.get("taxrateid"));
                newEntry.set("taxrate", entry.get("taxrate"));
                newEntry.set("discount", entry.get("discount"));
                newEntry.set("actualtaxprice", entry.get("actualtaxprice"));
                newEntry.set("actualprice", entry.get("actualprice"));
                newEntry.set("discountamount", entry.get("discountamount"));
                newEntry.set("taxamount", entry.get("taxamount"));
                newEntry.set("tax", entry.get("tax"));
                newEntry.set("amount", entry.get("amount"));
                if (stockOrg == null) continue;
                newEntry.set("stockorgid", (Object)stockOrg);
            }
        }
    }

    public void calQtysByQty(int rowIndex) {
        DynamicObject orderEntry = this.getRowInfo("itementry", rowIndex);
        DynamicObject item = orderEntry.getDynamicObject("itemid");
        if (item != null) {
            BigDecimal alterQty = orderEntry.getBigDecimal("qty");
            DynamicObject unitDynObj = orderEntry.getDynamicObject("unit");
            BigDecimal alterBaseQty = BigDecimal.ZERO;
            long materialId = orderEntry.getLong(String.join((CharSequence)"_", "materialid", "id"));
            long baseUnitId = orderEntry.getLong(String.join((CharSequence)"_", "baseunit", "id"));
            if (unitDynObj != null) {
                alterBaseQty = UnitConvertHelper.calculateDestQty((BigDecimal)alterQty, (Long)materialId, (Long)unitDynObj.getLong("id"), (Long)baseUnitId);
            }
            this.setValue("baseqty", alterBaseQty, rowIndex);
        }
    }

    private HashMap<Long, DynamicObject> initNewOrderRow(DynamicObjectCollection itemEntry, DynamicObjectCollection entrys) {
        HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>();
        if (this.isAddNew()) {
            itemEntry.clear();
        } else {
            ArrayList<Long> eIdList = new ArrayList<Long>();
            for (DynamicObject entry : entrys) {
                if (entry.getLong(EF_entryid) == 0L) continue;
                eIdList.add(entry.getLong(EF_entryid));
            }
            for (int i = 0; i < itemEntry.size(); ++i) {
                long entryId = (Long)((DynamicObject)itemEntry.get(i)).getPkValue();
                if (!eIdList.contains(entryId)) continue;
                entryMap.put(entryId, (DynamicObject)itemEntry.get(i));
            }
            itemEntry.clear();
            for (DynamicObject v : entryMap.values()) {
                itemEntry.add((Object)v);
            }
        }
        return entryMap;
    }

    private long getSettleOrg(long saleOrgId) {
        Map map;
        long settleorgid = 0L;
        if (saleOrgId != 0L && !CollectionUtils.isEmpty((Map)(map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)))) {
            settleorgid = Long.parseLong(map.get("id").toString());
        }
        return settleorgid;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        this.triggerChangeEvent = true;
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "itemid": {
                DynamicObject goodItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (goodItem == null) {
                    this.clearItemData(rowIndex);
                    this.calcOrderData();
                    return;
                }
                this.setItemEntityFieldInfo(rowIndex);
                this.fetchTaxPrice(rowIndex);
                this.calcOrderData();
                break;
            }
            case "qty": {
                String errorMsg;
                DynamicObject unit = (DynamicObject)this.getValue("unit", rowIndex);
                String unitName = "";
                if (unit != null) {
                    unitName = unit.getString("name");
                }
                BigDecimal itemQty = (BigDecimal)e.getChangeSet()[0].getNewValue();
                BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
                boolean isAdd = true;
                if (itemQty.compareTo(oldValue) < 0) {
                    isAdd = false;
                }
                if (!StringUtils.isEmpty((String)(errorMsg = this.getOrderQuantityMsg(rowIndex, unitName, itemQty, isAdd)))) {
                    itemQty = new BigDecimal(errorMsg.split(SPLITKEY)[1]);
                    errorMsg = errorMsg.split(SPLITKEY)[0];
                    if (this.isOrderQuantityStrongControl()) {
                        this.setValue("qty", itemQty, rowIndex);
                    }
                    this.getView().showTipNotification(errorMsg);
                    return;
                }
                if (itemQty.compareTo(BigDecimal.ZERO) < 0) {
                    this.getModel().setValue("qty", (Object)BigDecimal.ZERO, rowIndex);
                }
                this.fetchTaxPrice(rowIndex);
                this.calQtysByQty(rowIndex);
                this.calcOrderData();
                break;
            }
        }
    }

    private boolean isOrderQuantityStrongControl() {
        return SysParamsUtil.isOrderQuantityStrongControl();
    }

    private void setItemEntityFieldInfo(int rowIndex) {
        DynamicObject itemDynObj = this.getEntryF7Value("itementry", "itemid", rowIndex);
        Object materialId = null;
        Object unitId = null;
        if (itemDynObj != null) {
            materialId = itemDynObj.getDynamicObject("material") != null ? itemDynObj.getDynamicObject("material").getPkValue() : null;
            unitId = itemDynObj.getDynamicObject("orderunit") != null ? itemDynObj.getDynamicObject("orderunit").getPkValue() : null;
            this.setValue("thumbnail", itemDynObj.get("thumbnail"), rowIndex, false);
        }
        this.setValue("materialid", materialId, rowIndex, true);
        this.setValue("unit", unitId, rowIndex, false);
        DynamicObject item = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        this.setTaxrateTable(rowIndex, item.getDynamicObject("materialid"));
        this.triggerChangeEvent = true;
    }

    protected void fetchTaxPrice(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrencyid");
        long currencyId = settleCurrency.getLong("id");
        long saleOrgId = (Long)model.getValue(String.join((CharSequence)"_", "saleorg", "id"));
        long orderChannelId = (Long)model.getValue(String.join((CharSequence)"_", "returnchannel", "id"));
        DynamicObjectCollection itemList = model.getEntryEntity("itementry");
        DynamicObject item = (DynamicObject)itemList.get(rowIndex);
        long unitId = item.getLong(String.join((CharSequence)"_", "unit", "id"));
        long itemId = item.getLong(String.join((CharSequence)"_", "itemid", "id"));
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)item, (String)"qty");
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            qty = BigDecimal.ONE;
        }
        BigDecimal taxRate = item.getBigDecimal("taxrate");
        PriceFetchParam params = OrderHelper.builderPriceFetchParam((long)saleOrgId, (long)orderChannelId, (long)itemId, (long)0L, (long)unitId, (long)currencyId, (BigDecimal)qty);
        HashMap priceMap = OrderHelper.getPriceMap((PriceFetchParam)params, (DynamicObject)settleCurrency, (BigDecimal)qty, (BigDecimal)taxRate);
        this.setPrice(priceMap, rowIndex, model);
    }

    private void setPrice(HashMap<String, Object> priceMap, int rowIndex, IDataModel model) {
        model.setValue("taxprice", priceMap.get("taxprice"), rowIndex);
        model.setValue("discount", priceMap.get("discount"), rowIndex);
        model.setValue("discountamount", priceMap.get("discountamount"), rowIndex);
        model.setValue("unitdiscount", priceMap.get("unitdiscount"), rowIndex);
        model.setValue("taxamount", priceMap.get("taxamount"), rowIndex);
        model.setValue("tax", priceMap.get("tax"), rowIndex);
        model.setValue("amount", priceMap.get("amount"), rowIndex);
        model.setValue("actualtaxprice", priceMap.get("actualtaxprice"), rowIndex);
        model.setValue("actualprice", priceMap.get("actualprice"), rowIndex);
        model.setValue("price", priceMap.get("price"), rowIndex);
    }

    private void setTaxrateTable(int rowIndex, DynamicObject material) {
        DynamicObject taxrate;
        IDataModel model = this.getModel();
        if (material != null && (taxrate = material.getDynamicObject("taxrate")) != null) {
            model.setValue("taxrateid", (Object)taxrate, rowIndex);
            DynamicObject modelTaxrate = (DynamicObject)model.getValue("taxrateid", rowIndex);
            model.setValue("taxrate", modelTaxrate.get("taxrate"), rowIndex);
        }
    }

    private void clearItemData(int rowIndex) {
        this.setValue("materialid", null, rowIndex, true);
        this.setValue("unit", null, rowIndex, false);
        this.setValue("thumbnail", null, rowIndex, false);
        this.setValue("taxrateid", null, rowIndex, false);
        this.setValue("taxrate", BigDecimal.ZERO, rowIndex, false);
        this.setValue("taxprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("pricediscount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("discountamount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("unitdiscount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("taxamount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("tax", BigDecimal.ZERO, rowIndex, false);
        this.setValue("amount", BigDecimal.ZERO, rowIndex, false);
        this.setValue("actualtaxprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("actualprice", BigDecimal.ZERO, rowIndex, false);
        this.setValue("price", BigDecimal.ZERO, rowIndex, false);
    }

    private void calcOrderData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection itemList = model.getEntryEntity("itementry");
        if (itemList != null && itemList.size() > 0) {
            model.setValue("entrycount", (Object)itemList.size());
            int totalQty = this.calcTotalQty();
            BigDecimal orderAmount = BigDecimal.ZERO;
            for (DynamicObject item : itemList) {
                orderAmount = orderAmount.add(item.getBigDecimal("actualtaxprice").multiply(item.getBigDecimal("qty")));
            }
            model.setValue("totalqty", (Object)totalQty);
            model.setValue("sumtaxamount", (Object)orderAmount);
            model.setValue("payamount", (Object)orderAmount);
        } else {
            model.setValue("entrycount", (Object)0);
            model.setValue("totalqty", (Object)0);
            model.setValue("sumtaxamount", (Object)0);
            model.setValue("payamount", (Object)0);
        }
    }

    private String getSignStatus4View(Object v) {
        String signStatus = "";
        if (v == null) {
            return "null";
        }
        switch (v.toString()) {
            case "A": {
                signStatus = ResManager.loadKDString((String)"\u672a\u53d1\u8d27", (String)"ReturnApplyEdit_1", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                signStatus = ResManager.loadKDString((String)"\u5f85\u7b7e\u6536", (String)"ReturnApplyEdit_2", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                signStatus = ResManager.loadKDString((String)"\u90e8\u5206\u7b7e\u6536", (String)"ReturnApplyEdit_3", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "D": {
                signStatus = ResManager.loadKDString((String)"\u7b7e\u6536\u5b8c\u6210", (String)"ReturnApplyEdit_4", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return signStatus;
    }

    private String getBillStatus4View(Object v) {
        String billStatus = "";
        if (v == null) {
            return "null";
        }
        switch (v.toString()) {
            case "A": {
                billStatus = ResManager.loadKDString((String)"\u6682\u5b58", (String)"ReturnApplyEdit_5", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                billStatus = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"ReturnApplyEdit_6", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                billStatus = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ReturnApplyEdit_7", (String)"occ-ocsaa-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return billStatus;
    }

    protected Map<String, BigDecimal> getOrderQuantity(int index) {
        DynamicObjectCollection itemList = this.getModel().getEntryEntity("itementry");
        DynamicObject item = (DynamicObject)itemList.get(index);
        Long unitId = item.getLong(String.join((CharSequence)"_", "unit", "id"));
        Long itemId = item.getLong(String.join((CharSequence)"_", "itemid", "id"));
        Long auxPtyId = 0L;
        Long saleOrgId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "saleorg", "id"));
        Long orderChannelId = (Long)this.getModel().getValue(String.join((CharSequence)"_", "returnchannel", "id"));
        IPageCache pageCache = this.getPageCache();
        return OrderQuantityUtil.getOrderQuantityRlue((long)saleOrgId, (long)orderChannelId, (long)itemId, (long)unitId, (long)auxPtyId, (IPageCache)pageCache);
    }
}

